/*
 * Decompiled with CFR 0.152.
 */
package misk.hibernate;

import com.google.common.base.Stopwatch;
import com.google.common.util.concurrent.AbstractIdleService;
import com.google.inject.Provider;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.Column;
import javax.persistence.Table;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KAnnotatedElement;
import kotlin.reflect.KClass;
import kotlin.reflect.KProperty1;
import kotlin.reflect.full.KClasses;
import kotlin.reflect.jvm.KClassesJvm;
import misk.hibernate.AggregateListener;
import misk.hibernate.BoxedStringType;
import misk.hibernate.ByteStringType;
import misk.hibernate.HibernateEntity;
import misk.hibernate.HibernateInjectorAccess;
import misk.hibernate.HibernateKt;
import misk.hibernate.Id;
import misk.hibernate.IdType;
import misk.hibernate.JsonColumn;
import misk.hibernate.JsonColumnType;
import misk.hibernate.ListenerRegistration;
import misk.hibernate.ProtoColumn;
import misk.hibernate.ProtoColumnType;
import misk.hibernate.SecretColumn;
import misk.hibernate.SecretColumnType;
import misk.hibernate.TransacterService;
import misk.hibernate.TransformedColumnType;
import misk.hibernate.TransformedType;
import misk.jdbc.DataSourceConfig;
import misk.jdbc.DataSourceService;
import misk.jdbc.DataSourceType;
import mu.KLogger;
import mu.KotlinLogging;
import okio.ByteString;
import org.hibernate.SessionFactory;
import org.hibernate.boot.Metadata;
import org.hibernate.boot.MetadataBuilder;
import org.hibernate.boot.MetadataSources;
import org.hibernate.boot.registry.BootstrapServiceRegistry;
import org.hibernate.boot.registry.BootstrapServiceRegistryBuilder;
import org.hibernate.boot.registry.StandardServiceInitiator;
import org.hibernate.boot.registry.StandardServiceRegistry;
import org.hibernate.boot.registry.StandardServiceRegistryBuilder;
import org.hibernate.boot.spi.MetadataImplementor;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.event.service.spi.EventListenerRegistry;
import org.hibernate.integrator.spi.Integrator;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.SimpleValue;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.service.spi.SessionFactoryServiceRegistry;
import org.hibernate.usertype.UserType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@kotlin.Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u001b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u0000 12\u00020\u00012\u00020\u00022\b\u0012\u0004\u0012\u00020\u00040\u0003:\u00011BE\u0012\u000e\u0010\u0005\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00070\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u000e\b\u0002\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r\u0012\u000e\b\u0002\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\r\u00a2\u0006\u0002\u0010\u0011J\u0016\u0010!\u001a\u0004\u0018\u00010\"2\n\u0010#\u001a\u0006\u0012\u0002\b\u00030\u0006H\u0002J\b\u0010$\u001a\u00020\u0004H\u0016J\u0018\u0010%\u001a\n\u0012\u0006\b\u0001\u0012\u00020&0\u00062\u0006\u0010'\u001a\u00020(H\u0002J\u001c\u0010)\u001a\u00020*2\n\u0010+\u001a\u0006\u0012\u0002\b\u00030,2\u0006\u0010-\u001a\u00020.H\u0002J\b\u0010/\u001a\u00020*H\u0014J\b\u00100\u001a\u00020*H\u0014R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0013\u001a\u00020\u0014X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0019\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001bR\u0017\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001d\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 \u00a8\u00062"}, d2={"Lmisk/hibernate/SessionFactoryService;", "Lcom/google/common/util/concurrent/AbstractIdleService;", "Lmisk/hibernate/TransacterService;", "Lcom/google/inject/Provider;", "Lorg/hibernate/SessionFactory;", "qualifier", "Lkotlin/reflect/KClass;", "", "dataSourceService", "Lmisk/jdbc/DataSourceService;", "hibernateInjectorAccess", "Lmisk/hibernate/HibernateInjectorAccess;", "entityClasses", "", "Lmisk/hibernate/HibernateEntity;", "listenerRegistrations", "Lmisk/hibernate/ListenerRegistration;", "(Lkotlin/reflect/KClass;Lmisk/jdbc/DataSourceService;Lmisk/hibernate/HibernateInjectorAccess;Ljava/util/Set;Ljava/util/Set;)V", "_sessionFactory", "hibernateMetadata", "Lorg/hibernate/boot/Metadata;", "getHibernateMetadata", "()Lorg/hibernate/boot/Metadata;", "setHibernateMetadata", "(Lorg/hibernate/boot/Metadata;)V", "sessionFactory", "getSessionFactory", "()Lorg/hibernate/SessionFactory;", "threadInTransaction", "Ljava/lang/ThreadLocal;", "", "getThreadInTransaction", "()Ljava/lang/ThreadLocal;", "findUserType", "Lorg/hibernate/usertype/UserType;", "propertyType", "get", "kClassForName", "", "name", "", "processPropertyAnnotations", "", "persistentClass", "Ljava/lang/Class;", "property", "Lorg/hibernate/mapping/Property;", "shutDown", "startUp", "Companion", "misk-hibernate"})
@SourceDebugExtension(value={"SMAP\nSessionFactoryService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SessionFactoryService.kt\nmisk/hibernate/SessionFactoryService\n+ 2 KAnnotatedElements.kt\nkotlin/reflect/full/KAnnotatedElements\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 Logging.kt\nwisp/logging/LoggingKt\n*L\n1#1,274:1\n20#2:275\n288#3,2:276\n1603#3,9:279\n1855#3:288\n1856#3:290\n1612#3:291\n1#4:278\n1#4:289\n13#5:292\n*S KotlinDebug\n*F\n+ 1 SessionFactoryService.kt\nmisk/hibernate/SessionFactoryService\n*L\n207#1:275\n207#1:276,2\n222#1:279,9\n222#1:288\n222#1:290\n222#1:291\n222#1:289\n267#1:292\n*E\n"})
public final class SessionFactoryService
extends AbstractIdleService
implements TransacterService,
Provider<SessionFactory> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final KClass<? extends Annotation> qualifier;
    @NotNull
    private final DataSourceService dataSourceService;
    @NotNull
    private final HibernateInjectorAccess hibernateInjectorAccess;
    @NotNull
    private final Set<HibernateEntity> entityClasses;
    @NotNull
    private final Set<ListenerRegistration> listenerRegistrations;
    @Nullable
    private SessionFactory _sessionFactory;
    @NotNull
    private final ThreadLocal<Boolean> threadInTransaction;
    public Metadata hibernateMetadata;
    @NotNull
    private static final KLogger logger;

    public SessionFactoryService(@NotNull KClass<? extends Annotation> qualifier, @NotNull DataSourceService dataSourceService, @NotNull HibernateInjectorAccess hibernateInjectorAccess, @NotNull Set<HibernateEntity> entityClasses, @NotNull Set<ListenerRegistration> listenerRegistrations) {
        Intrinsics.checkNotNullParameter(qualifier, (String)"qualifier");
        Intrinsics.checkNotNullParameter((Object)dataSourceService, (String)"dataSourceService");
        Intrinsics.checkNotNullParameter((Object)hibernateInjectorAccess, (String)"hibernateInjectorAccess");
        Intrinsics.checkNotNullParameter(entityClasses, (String)"entityClasses");
        Intrinsics.checkNotNullParameter(listenerRegistrations, (String)"listenerRegistrations");
        this.qualifier = qualifier;
        this.dataSourceService = dataSourceService;
        this.hibernateInjectorAccess = hibernateInjectorAccess;
        this.entityClasses = entityClasses;
        this.listenerRegistrations = listenerRegistrations;
        this.threadInTransaction = new ThreadLocal<Boolean>(){

            @NotNull
            protected Boolean initialValue() {
                return false;
            }
        };
    }

    public /* synthetic */ SessionFactoryService(KClass kClass, DataSourceService dataSourceService, HibernateInjectorAccess hibernateInjectorAccess, Set set, Set set2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            set = SetsKt.emptySet();
        }
        if ((n & 0x10) != 0) {
            set2 = SetsKt.emptySet();
        }
        this((KClass<? extends Annotation>)kClass, dataSourceService, hibernateInjectorAccess, set, set2);
    }

    @NotNull
    public final SessionFactory getSessionFactory() {
        SessionFactory sessionFactory = this._sessionFactory;
        if (sessionFactory == null) {
            throw new IllegalStateException(("@" + this.qualifier.getSimpleName() + " Hibernate not connected: did you forget to start the service?").toString());
        }
        return sessionFactory;
    }

    @NotNull
    public final ThreadLocal<Boolean> getThreadInTransaction() {
        return this.threadInTransaction;
    }

    @NotNull
    public final Metadata getHibernateMetadata() {
        Metadata metadata = this.hibernateMetadata;
        if (metadata != null) {
            return metadata;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"hibernateMetadata");
        return null;
    }

    public final void setHibernateMetadata(@NotNull Metadata metadata) {
        Intrinsics.checkNotNullParameter((Object)metadata, (String)"<set-?>");
        this.hibernateMetadata = metadata;
    }

    protected void startUp() {
        String[] value;
        Stopwatch stopwatch = Stopwatch.createStarted();
        logger.info("Starting @" + this.qualifier.getSimpleName() + " Hibernate");
        if (!(this._sessionFactory == null)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        Integrator integrator2 = new Integrator(this){
            final /* synthetic */ SessionFactoryService this$0;
            {
                this.this$0 = $receiver;
            }

            public void integrate(@NotNull Metadata metadata, @NotNull SessionFactoryImplementor sessionFactory, @NotNull SessionFactoryServiceRegistry serviceRegistry) {
                Intrinsics.checkNotNullParameter((Object)metadata, (String)"metadata");
                Intrinsics.checkNotNullParameter((Object)sessionFactory, (String)"sessionFactory");
                Intrinsics.checkNotNullParameter((Object)serviceRegistry, (String)"serviceRegistry");
                EventListenerRegistry eventListenerRegistry = (EventListenerRegistry)serviceRegistry.getService(EventListenerRegistry.class);
                AggregateListener aggregateListener = new AggregateListener(SessionFactoryService.access$getListenerRegistrations$p(this.this$0));
                Intrinsics.checkNotNull((Object)eventListenerRegistry);
                aggregateListener.registerAll(eventListenerRegistry);
                this.this$0.setHibernateMetadata(metadata);
            }

            public void disintegrate(@NotNull SessionFactoryImplementor sessionFactory, @NotNull SessionFactoryServiceRegistry serviceRegistry) {
                Intrinsics.checkNotNullParameter((Object)sessionFactory, (String)"sessionFactory");
                Intrinsics.checkNotNullParameter((Object)serviceRegistry, (String)"serviceRegistry");
            }
        };
        BootstrapServiceRegistry bootstrapRegistryBuilder = new BootstrapServiceRegistryBuilder().applyIntegrator(integrator2).build();
        StandardServiceRegistryBuilder registryBuilder = new StandardServiceRegistryBuilder(bootstrapRegistryBuilder);
        registryBuilder.addInitiator((StandardServiceInitiator)this.hibernateInjectorAccess);
        DataSourceConfig config = this.dataSourceService.config();
        StandardServiceRegistryBuilder $this$startUp_u24lambda_u241 = registryBuilder;
        boolean bl = false;
        $this$startUp_u24lambda_u241.applySetting("hibernate.connection.datasource", (Object)this.dataSourceService.getDataSource());
        $this$startUp_u24lambda_u241.applySetting("hibernate.dialect", (Object)config.getType().getHibernateDialect());
        $this$startUp_u24lambda_u241.applySetting("hibernate.show_sql", (Object)config.getShow_sql());
        $this$startUp_u24lambda_u241.applySetting("hibernate.generate_statistics", (Object)config.getGenerate_hibernate_stats());
        $this$startUp_u24lambda_u241.applySetting("hibernate.use_sql_comments", (Object)"true");
        $this$startUp_u24lambda_u241.applySetting("hibernate.jdbc.use_get_generated_keys", (Object)"true");
        $this$startUp_u24lambda_u241.applySetting("hibernate.id.new_generator_mappings", (Object)"false");
        $this$startUp_u24lambda_u241.applySetting("hibernate.jdbc.time_zone", (Object)"UTC");
        if (config.getType() != DataSourceType.VITESS_MYSQL) {
            $this$startUp_u24lambda_u241.applySetting("hibernate.connection.provider_disables_autocommit", (Object)"true");
        }
        if (config.getQuery_timeout() != null) {
            Duration duration = config.getQuery_timeout();
            Intrinsics.checkNotNull((Object)duration);
            $this$startUp_u24lambda_u241.applySetting("javax.persistence.query.timeout", (Object)((int)duration.toMillis()));
        }
        if (config.getJdbc_statement_batch_size() != null) {
            Integer n = config.getJdbc_statement_batch_size();
            Intrinsics.checkNotNull((Object)n);
            if (!(n > 0)) {
                boolean $i$a$-require-SessionFactoryService$startUp$1$22 = false;
                String $i$a$-require-SessionFactoryService$startUp$1$22 = "Invalid jdbc_statement_batch_size: must be > 0.";
                throw new IllegalArgumentException($i$a$-require-SessionFactoryService$startUp$1$22.toString());
            }
            $this$startUp_u24lambda_u241.applySetting("hibernate.jdbc.batch_size", (Object)config.getJdbc_statement_batch_size());
        }
        StandardServiceRegistry registry = registryBuilder.build();
        MetadataSources metadataSources = new MetadataSources((ServiceRegistry)registry);
        for (HibernateEntity entityClass : this.entityClasses) {
            metadataSources.addAnnotatedClass(JvmClassMappingKt.getJavaClass(entityClass.getEntity()));
        }
        MetadataBuilder metadataDraftBuilder = metadataSources.getMetadataBuilder();
        Metadata metadata = metadataDraftBuilder.build();
        Intrinsics.checkNotNull((Object)metadata, (String)"null cannot be cast to non-null type org.hibernate.boot.spi.MetadataImplementor");
        MetadataImplementor metadataDraft = (MetadataImplementor)metadata;
        Set allPropertyTypes = new LinkedHashSet();
        for (Object object : HibernateKt.getAllProperties((Metadata)metadataDraft).entries()) {
            String string;
            Intrinsics.checkNotNull((Object)object);
            Class persistentClass = (Class)object.getKey();
            Property property = (Property)object.getValue();
            Intrinsics.checkNotNull((Object)persistentClass);
            Intrinsics.checkNotNull((Object)property);
            this.processPropertyAnnotations(persistentClass, property);
            value = property.getValue();
            if (!(value instanceof SimpleValue) || (string = ((SimpleValue)value).getTypeName()) == null) continue;
            String typeName = string;
            ((Collection)allPropertyTypes).add(this.kClassForName(typeName));
        }
        metadataDraft.getTypeConfiguration().sessionFactoryClosed(null);
        MetadataBuilder metadataBuilder = metadataSources.getMetadataBuilder();
        for (KClass propertyType : allPropertyTypes) {
            UserType userType = this.findUserType(propertyType);
            if (userType == null) continue;
            value = new String[]{KClassesJvm.getJvmName((KClass)propertyType)};
            metadataBuilder.applyBasicType(userType, value);
        }
        Metadata metadata2 = metadataBuilder.build();
        Intrinsics.checkNotNull((Object)metadata2, (String)"null cannot be cast to non-null type org.hibernate.boot.spi.MetadataImplementor");
        MetadataImplementor metadata3 = (MetadataImplementor)metadata2;
        for (Map.Entry entry : HibernateKt.getAllProperties((Metadata)metadata3).entries()) {
            Intrinsics.checkNotNull((Object)entry);
            Class persistentClass = (Class)entry.getKey();
            Property property = (Property)entry.getValue();
            Intrinsics.checkNotNull((Object)persistentClass);
            Intrinsics.checkNotNull((Object)property);
            this.processPropertyAnnotations(persistentClass, property);
        }
        this._sessionFactory = metadata3.buildSessionFactory();
        logger.info("Started @" + this.qualifier.getSimpleName() + " Hibernate in " + stopwatch);
    }

    /*
     * WARNING - void declaration
     */
    private final void processPropertyAnnotations(Class<?> persistentClass, Property property) {
        Annotation[] annotationArray = property.getValue();
        SimpleValue simpleValue = annotationArray instanceof SimpleValue ? (SimpleValue)annotationArray : null;
        if (simpleValue == null) {
            return;
        }
        SimpleValue value = simpleValue;
        Field field = HibernateKt.field(persistentClass, property);
        if (field.isAnnotationPresent(JsonColumn.class)) {
            value.setTypeName(JsonColumnType.class.getName());
            HibernateKt.setTypeParameter(value, "jsonColumnField", field);
        } else if (field.isAnnotationPresent(ProtoColumn.class)) {
            value.setTypeName(ProtoColumnType.class.getName());
            HibernateKt.setTypeParameter(value, "protoColumnField", field);
        } else if (field.isAnnotationPresent(SecretColumn.class)) {
            value.setTypeName(SecretColumnType.class.getName());
            HibernateKt.setTypeParameter(value, "key_name", field.getAnnotation(SecretColumn.class).keyName());
            HibernateKt.setTypeParameter(value, "indexable", String.valueOf(field.getAnnotation(SecretColumn.class).indexable()));
        } else {
            Class<?> clazz = field.getType();
            Intrinsics.checkNotNullExpressionValue(clazz, (String)"getType(...)");
            if (BoxedStringType.Companion.isBoxedString(JvmClassMappingKt.getKotlinClass(clazz))) {
                value.setTypeName(BoxedStringType.class.getName());
                HibernateKt.setTypeParameter(value, "boxedStringField", field);
            } else {
                Annotation[] annotationArray2 = field.getAnnotations();
                Intrinsics.checkNotNullExpressionValue((Object)annotationArray2, (String)"getAnnotations(...)");
                for (Annotation annotation : annotationArray2) {
                    void $this$mapNotNullTo$iv$iv;
                    Object object;
                    TransformedType transformerAnnotation;
                    Object v3;
                    Object it$iv;
                    Object $this$firstOrNull$iv$iv;
                    Annotation annotation2;
                    block14: {
                        Intrinsics.checkNotNull((Object)annotation);
                        annotation2 = annotation;
                        KAnnotatedElement $this$findAnnotation$iv = (KAnnotatedElement)JvmClassMappingKt.getAnnotationClass((Annotation)annotation2);
                        boolean $i$f$findAnnotation = false;
                        $this$firstOrNull$iv$iv = $this$findAnnotation$iv.getAnnotations();
                        boolean $i$f$firstOrNull = false;
                        Iterator iterator = $this$firstOrNull$iv$iv.iterator();
                        while (iterator.hasNext()) {
                            Object element$iv$iv = iterator.next();
                            it$iv = (Annotation)element$iv$iv;
                            boolean bl = false;
                            if (!(it$iv instanceof TransformedType)) continue;
                            v3 = element$iv$iv;
                            break block14;
                        }
                        v3 = null;
                    }
                    if ((TransformedType)((Annotation)v3) == null) continue;
                    value.setTypeName(TransformedColumnType.class.getName());
                    KClass transformer = Reflection.getOrCreateKotlinClass(transformerAnnotation.transformer());
                    HibernateKt.setTypeParameter(value, TransformedColumnType.Companion.getTRANSFORMER_CLASS(), transformer);
                    String tableName = persistentClass.getAnnotation(Table.class).name();
                    HibernateKt.setTypeParameter(value, TransformedColumnType.Companion.getTABLE_NAME(), tableName);
                    $this$firstOrNull$iv$iv = field.getAnnotation(Column.class).name();
                    if ($this$firstOrNull$iv$iv.length() == 0) {
                        boolean bl = false;
                        object = field.getName();
                    } else {
                        object = $this$firstOrNull$iv$iv;
                    }
                    String columnName = (String)object;
                    String string = TransformedColumnType.Companion.getCOLUMN_NAME();
                    Intrinsics.checkNotNull((Object)columnName);
                    HibernateKt.setTypeParameter(value, string, columnName);
                    HibernateKt.setTypeParameter(value, TransformedColumnType.Companion.getFIELD(), field);
                    HibernateKt.setTypeParameter(value, TransformedColumnType.Companion.getTARGET_TYPE(), Reflection.getOrCreateKotlinClass(transformerAnnotation.targetType()));
                    Collection memberProperties = KClasses.getDeclaredMemberProperties((KClass)JvmClassMappingKt.getAnnotationClass((Annotation)annotation2));
                    Iterable $this$mapNotNull$iv = memberProperties;
                    boolean $i$f$mapNotNull = false;
                    it$iv = $this$mapNotNull$iv;
                    Collection destination$iv$iv = new ArrayList();
                    boolean $i$f$mapNotNullTo = false;
                    void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                    boolean $i$f$forEach = false;
                    Iterator iterator = $this$forEach$iv$iv$iv.iterator();
                    while (iterator.hasNext()) {
                        Pair it$iv$iv;
                        Object element$iv$iv$iv;
                        Object element$iv$iv = element$iv$iv$iv = iterator.next();
                        boolean bl = false;
                        KProperty1 prop = (KProperty1)element$iv$iv;
                        boolean bl2 = false;
                        if (((prop instanceof KProperty1 ? prop : null) == null ? null : TuplesKt.to((Object)prop.getName(), (Object)prop.get((Object)annotation2))) == null) continue;
                        it$iv$iv = it$iv$iv;
                        boolean bl3 = false;
                        destination$iv$iv.add(it$iv$iv);
                    }
                    Map argMap = MapsKt.toMap((Iterable)((List)destination$iv$iv));
                    HibernateKt.setTypeParameter(value, TransformedColumnType.Companion.getARGUMENTS(), argMap);
                }
            }
        }
    }

    private final UserType findUserType(KClass<?> propertyType) {
        KClass<?> kClass = propertyType;
        return Intrinsics.areEqual(kClass, (Object)Reflection.getOrCreateKotlinClass(Id.class)) ? (UserType)new IdType() : (Intrinsics.areEqual(kClass, (Object)Reflection.getOrCreateKotlinClass(ByteString.class)) ? (UserType)ByteStringType.INSTANCE : null);
    }

    private final KClass<? extends Object> kClassForName(String name) {
        KClass kClass;
        switch (name) {
            case "boolean": {
                kClass = Reflection.getOrCreateKotlinClass(Boolean.TYPE);
                break;
            }
            case "byte": {
                kClass = Reflection.getOrCreateKotlinClass(Byte.TYPE);
                break;
            }
            case "short": {
                kClass = Reflection.getOrCreateKotlinClass(Short.TYPE);
                break;
            }
            case "int": {
                kClass = Reflection.getOrCreateKotlinClass(Integer.TYPE);
                break;
            }
            case "long": {
                kClass = Reflection.getOrCreateKotlinClass(Long.TYPE);
                break;
            }
            case "char": {
                kClass = Reflection.getOrCreateKotlinClass(Character.TYPE);
                break;
            }
            case "float": {
                kClass = Reflection.getOrCreateKotlinClass(Float.TYPE);
                break;
            }
            case "double": {
                kClass = Reflection.getOrCreateKotlinClass(Double.TYPE);
                break;
            }
            case "materialized_clob": {
                kClass = Reflection.getOrCreateKotlinClass(String.class);
                break;
            }
            default: {
                Class<?> clazz = Class.forName(name);
                Intrinsics.checkNotNullExpressionValue(clazz, (String)"forName(...)");
                kClass = JvmClassMappingKt.getKotlinClass(clazz);
            }
        }
        return kClass;
    }

    protected void shutDown() {
        Stopwatch stopwatch = Stopwatch.createStarted();
        logger.info("Stopping @" + this.qualifier.getSimpleName() + " Hibernate");
        if (!(this._sessionFactory != null)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        SessionFactory sessionFactory = this._sessionFactory;
        Intrinsics.checkNotNull((Object)sessionFactory);
        sessionFactory.close();
        logger.info("Stopped @" + this.qualifier.getSimpleName() + " Hibernate in " + stopwatch);
    }

    @NotNull
    public SessionFactory get() {
        return this.getSessionFactory();
    }

    public static final /* synthetic */ Set access$getListenerRegistrations$p(SessionFactoryService $this) {
        return $this.listenerRegistrations;
    }

    static {
        boolean $i$f$getLogger = false;
        String string = Reflection.getOrCreateKotlinClass(SessionFactoryService.class).getQualifiedName();
        Intrinsics.checkNotNull((Object)string);
        logger = KotlinLogging.INSTANCE.logger(string);
    }

    @kotlin.Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lmisk/hibernate/SessionFactoryService$Companion;", "", "()V", "logger", "Lmu/KLogger;", "misk-hibernate"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

