/*
 * Decompiled with CFR 0.152.
 */
package misk.hibernate.pagination;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import misk.hibernate.DbEntity;
import misk.hibernate.Id;
import misk.hibernate.Operator;
import misk.hibernate.Query;
import misk.hibernate.pagination.Offset;
import misk.hibernate.pagination.Paginator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0000\u0018\u0000*\u000e\b\u0000\u0010\u0001*\b\u0012\u0004\u0012\u0002H\u00010\u00022\u0014\u0012\u0004\u0012\u0002H\u0001\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00010\u00040\u0003B\u0015\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ \u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00028\u00000\u00042\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0016J\u0016\u0010\u000f\u001a\b\u0012\u0004\u0012\u00028\u00000\u00102\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0016\u0010\u0011\u001a\u00020\u000e2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00028\u00000\u0010H\u0002J\u0015\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0015R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lmisk/hibernate/pagination/IdPaginator;", "T", "Lmisk/hibernate/DbEntity;", "Lmisk/hibernate/pagination/Paginator;", "Lmisk/hibernate/Query;", "idPath", "", "operator", "Lmisk/hibernate/Operator;", "(Ljava/lang/String;Lmisk/hibernate/Operator;)V", "applyOffset", "", "query", "offset", "Lmisk/hibernate/pagination/Offset;", "decodeOffset", "Lmisk/hibernate/Id;", "encodeOffset", "id", "getOffset", "row", "(Lmisk/hibernate/DbEntity;)Lmisk/hibernate/pagination/Offset;", "misk-hibernate"})
public final class IdPaginator<T extends DbEntity<T>>
implements Paginator<T, Query<T>> {
    @NotNull
    private final String idPath;
    @NotNull
    private final Operator operator;

    public IdPaginator(@NotNull String idPath, @NotNull Operator operator) {
        Intrinsics.checkNotNullParameter((Object)idPath, (String)"idPath");
        Intrinsics.checkNotNullParameter((Object)((Object)operator), (String)"operator");
        this.idPath = idPath;
        this.operator = operator;
        if (!(this.operator == Operator.GT || this.operator == Operator.LT)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
    }

    @Override
    @NotNull
    public Offset getOffset(@NotNull T row) {
        Intrinsics.checkNotNullParameter(row, (String)"row");
        return this.encodeOffset(row.getId());
    }

    @Override
    public void applyOffset(@NotNull Query<T> query, @Nullable Offset offset) {
        Intrinsics.checkNotNullParameter(query, (String)"query");
        query.dynamicAddOrder(this.idPath, this.operator == Operator.GT);
        if (offset == null) {
            return;
        }
        query.dynamicAddConstraint(this.idPath, this.operator, this.decodeOffset(offset));
    }

    private final Offset encodeOffset(Id<T> id) {
        return new Offset(id.toString());
    }

    private final Id<T> decodeOffset(Offset offset) {
        return new Id(Long.parseLong(offset.getOffset()));
    }
}

