/*
 * Decompiled with CFR 0.152.
 */
package misk.hibernate.pagination;

import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import misk.hibernate.DbEntity;
import misk.hibernate.Query;
import misk.hibernate.Session;
import misk.hibernate.pagination.Offset;
import misk.hibernate.pagination.Page;
import misk.hibernate.pagination.Pager;
import misk.hibernate.pagination.Paginator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0000\b\u0000\u0018\u0000*\u000e\b\u0000\u0010\u0001*\b\u0012\u0004\u0012\u0002H\u00010\u0002*\u000e\b\u0001\u0010\u0003*\b\u0012\u0004\u0012\u0002H\u00010\u00042\b\u0012\u0004\u0012\u0002H\u00010\u0005B5\u0012\u0006\u0010\u0006\u001a\u00028\u0001\u0012\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\b\u0012\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\b\u0010\u000e\u001a\u00020\u000fH\u0016J\u0018\u0010\u0012\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J4\u0010\u0016\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u0018\u0012\u0004\u0012\u00020\u000f0\u0017*\b\u0012\u0004\u0012\u00028\u00000\u00042\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u000b\u001a\u00020\fH\u0002R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u00028\u0001X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0011\u00a8\u0006\u0019"}, d2={"Lmisk/hibernate/pagination/RealPager;", "T", "Lmisk/hibernate/DbEntity;", "Q", "Lmisk/hibernate/Query;", "Lmisk/hibernate/pagination/Pager;", "query", "paginator", "Lmisk/hibernate/pagination/Paginator;", "initialOffset", "Lmisk/hibernate/pagination/Offset;", "pageSize", "", "(Lmisk/hibernate/Query;Lmisk/hibernate/pagination/Paginator;Lmisk/hibernate/pagination/Offset;I)V", "hasNext", "", "nextOffset", "Lmisk/hibernate/Query;", "nextPage", "Lmisk/hibernate/pagination/Page;", "session", "Lmisk/hibernate/Session;", "listWithHasNext", "Lkotlin/Pair;", "", "misk-hibernate"})
@SourceDebugExtension(value={"SMAP\nRealPager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RealPager.kt\nmisk/hibernate/pagination/RealPager\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,51:1\n1#2:52\n*E\n"})
public final class RealPager<T extends DbEntity<T>, Q extends Query<T>>
implements Pager<T> {
    @NotNull
    private final Q query;
    @NotNull
    private final Paginator<T, Q> paginator;
    private final int pageSize;
    private boolean hasNext;
    @Nullable
    private Offset nextOffset;

    public RealPager(@NotNull Q query, @NotNull Paginator<T, ? super Q> paginator, @Nullable Offset initialOffset, int pageSize) {
        Intrinsics.checkNotNullParameter(query, (String)"query");
        Intrinsics.checkNotNullParameter(paginator, (String)"paginator");
        this.query = query;
        this.paginator = paginator;
        this.pageSize = pageSize;
        this.hasNext = true;
        this.nextOffset = initialOffset;
        if (!(this.pageSize > 0)) {
            String string = "Check failed.";
            throw new IllegalStateException(string.toString());
        }
    }

    public /* synthetic */ RealPager(Query query, Paginator paginator, Offset offset, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 4) != 0) {
            offset = null;
        }
        this(query, paginator, offset, n);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public Page<T> nextPage(@NotNull Session session) {
        Offset offset;
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        if (!this.hasNext) {
            return null;
        }
        Object query = this.query.clone();
        this.paginator.applyOffset(query, this.nextOffset);
        Pair<List<T>, Boolean> pair = this.listWithHasNext((Query<T>)query, session, this.pageSize);
        List contents = (List)pair.component1();
        boolean hasNext = (Boolean)pair.component2();
        RealPager realPager = this;
        if (hasNext) {
            DbEntity dbEntity = (DbEntity)CollectionsKt.lastOrNull((List)contents);
            if (dbEntity != null) {
                void p0;
                DbEntity dbEntity2 = dbEntity;
                Paginator<void, Q> paginator = this.paginator;
                DbEntity dbEntity3 = dbEntity2;
                RealPager realPager2 = realPager;
                boolean bl = false;
                offset = paginator.getOffset(p0);
                realPager = realPager2;
            } else {
                offset = null;
            }
        } else {
            offset = null;
        }
        realPager.nextOffset = offset;
        this.hasNext = hasNext;
        return new Page(contents, this.nextOffset);
    }

    private final Pair<List<T>, Boolean> listWithHasNext(Query<T> $this$listWithHasNext, Session session, int pageSize) {
        $this$listWithHasNext.setMaxRows(pageSize + 1);
        List<T> contents = $this$listWithHasNext.list(session);
        return contents.size() == $this$listWithHasNext.getMaxRows() ? TuplesKt.to(contents.subList(0, $this$listWithHasNext.getMaxRows() - 1), (Object)true) : TuplesKt.to(contents, (Object)false);
    }

    @Override
    public boolean hasNext() {
        return this.hasNext;
    }
}

