/*
 * Decompiled with CFR 0.152.
 */
package misk.database;

import com.github.dockerjava.api.DockerClient;
import com.github.dockerjava.api.async.ResultCallback;
import com.github.dockerjava.api.model.Container;
import com.github.dockerjava.api.model.ExposedPort;
import com.github.dockerjava.api.model.Frame;
import com.github.dockerjava.api.model.Ports;
import com.github.dockerjava.core.async.ResultCallbackTemplate;
import com.squareup.moshi.Moshi;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import misk.backoff.Backoff;
import misk.backoff.DontRetryException;
import misk.backoff.ExponentialBackoff;
import misk.backoff.RetriesKt;
import misk.database.CockroachCluster;
import misk.database.DatabaseServer;
import misk.database.DockerCockroachCluster;
import misk.database.StartDatabaseServiceKt;
import misk.jdbc.DataSourceConfig;
import misk.jdbc.DataSourceType;
import misk.jdbc.JdbcExtensionsKt;
import misk.resources.ResourceLoader;
import mu.KLogger;
import mu.KotlinLogging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\b\u0018\u0000 )2\u00020\u0001:\u0002)*B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\b\u0010\"\u001a\u00020#H\u0002J\b\u0010$\u001a\u00020#H\u0002J\b\u0010%\u001a\u00020#H\u0016J\b\u0010&\u001a\u00020#H\u0016J\b\u0010'\u001a\u00020#H\u0016J\b\u0010(\u001a\u00020#H\u0002R\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0016\u0010\u001e\u001a\n\u0018\u00010\u001fj\u0004\u0018\u0001` X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lmisk/database/DockerCockroachCluster;", "Lmisk/database/DatabaseServer;", "name", "", "moshi", "Lcom/squareup/moshi/Moshi;", "resourceLoader", "Lmisk/resources/ResourceLoader;", "config", "Lmisk/jdbc/DataSourceConfig;", "docker", "Lcom/github/dockerjava/api/DockerClient;", "(Ljava/lang/String;Lcom/squareup/moshi/Moshi;Lmisk/resources/ResourceLoader;Lmisk/jdbc/DataSourceConfig;Lcom/github/dockerjava/api/DockerClient;)V", "cluster", "Lmisk/database/CockroachCluster;", "getCluster", "()Lmisk/database/CockroachCluster;", "getConfig", "()Lmisk/jdbc/DataSourceConfig;", "containerId", "getDocker", "()Lcom/github/dockerjava/api/DockerClient;", "isRunning", "", "getMoshi", "()Lcom/squareup/moshi/Moshi;", "getName", "()Ljava/lang/String;", "getResourceLoader", "()Lmisk/resources/ResourceLoader;", "startupFailure", "Ljava/lang/Exception;", "Lkotlin/Exception;", "stopContainerOnExit", "createDatabase", "", "doStart", "pullImage", "start", "stop", "waitUntilHealthy", "Companion", "LogContainerResultCallback", "misk-jdbc"})
public final class DockerCockroachCluster
implements DatabaseServer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String name;
    @NotNull
    private final Moshi moshi;
    @NotNull
    private final ResourceLoader resourceLoader;
    @NotNull
    private final DataSourceConfig config;
    @NotNull
    private final DockerClient docker;
    @NotNull
    private final CockroachCluster cluster;
    @Nullable
    private String containerId;
    private boolean isRunning;
    private boolean stopContainerOnExit;
    @Nullable
    private Exception startupFailure;
    @NotNull
    private static final KLogger logger = KotlinLogging.INSTANCE.logger((Function0)Companion.logger.1.INSTANCE);
    @NotNull
    public static final String SHA = "67f0547f1a989ebd119e5cbf903c8537556f574da20182454c036da63ea67c7d";
    @NotNull
    public static final String IMAGE = "cockroachdb/cockroach@sha256:67f0547f1a989ebd119e5cbf903c8537556f574da20182454c036da63ea67c7d";
    @NotNull
    public static final String CONTAINER_NAME = "misk-cockroach-testing";
    @NotNull
    private static final AtomicBoolean imagePulled = new AtomicBoolean();

    public DockerCockroachCluster(@NotNull String name, @NotNull Moshi moshi, @NotNull ResourceLoader resourceLoader, @NotNull DataSourceConfig config, @NotNull DockerClient docker) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)moshi, (String)"moshi");
        Intrinsics.checkNotNullParameter((Object)resourceLoader, (String)"resourceLoader");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)docker, (String)"docker");
        this.name = name;
        this.moshi = moshi;
        this.resourceLoader = resourceLoader;
        this.config = config;
        this.docker = docker;
        this.stopContainerOnExit = true;
        this.cluster = new CockroachCluster(this.name, this.config);
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    @NotNull
    public final Moshi getMoshi() {
        return this.moshi;
    }

    @NotNull
    public final ResourceLoader getResourceLoader() {
        return this.resourceLoader;
    }

    @NotNull
    public final DataSourceConfig getConfig() {
        return this.config;
    }

    @NotNull
    public final DockerClient getDocker() {
        return this.docker;
    }

    @NotNull
    public final CockroachCluster getCluster() {
        return this.cluster;
    }

    @Override
    public void start() {
        Exception startupFailure = this.startupFailure;
        if (startupFailure != null) {
            throw startupFailure;
        }
        if (this.isRunning) {
            return;
        }
        this.isRunning = true;
        try {
            this.doStart();
        }
        catch (Exception e) {
            this.startupFailure = e;
            throw e;
        }
    }

    @Override
    public void pullImage() {
        Companion.pullImage();
    }

    private final void doStart() {
        ExposedPort httpPort = ExposedPort.tcp((int)this.cluster.getInternalHttpPort());
        if (this.cluster.getConfig().getType() == DataSourceType.COCKROACHDB && this.cluster.getConfig().getPort() != null) {
            Integer n = this.cluster.getConfig().getPort();
            int n2 = this.cluster.getPostgresPort();
            if (n == null || n != n2) {
                throw new RuntimeException("Config port " + this.cluster.getConfig().getPort() + " has to match Cockroach Docker container: " + this.cluster.getPostgresPort());
            }
        }
        ExposedPort postgresPort = ExposedPort.tcp((int)this.cluster.getPostgresPort());
        Ports ports = new Ports();
        ports.bind(httpPort, Ports.Binding.bindPort((int)this.cluster.getExternalHttpPort()));
        ports.bind(postgresPort, Ports.Binding.bindPort((int)postgresPort.getPort()));
        Object[] objectArray = new String[]{"start-single-node", "--insecure"};
        Object[] cmd = objectArray;
        String containerName = CONTAINER_NAME;
        Object object = this.docker.listContainersCmd().withNameFilter((Collection)CollectionsKt.listOf((Object)containerName)).withLimit(Integer.valueOf(1)).exec();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"exec(...)");
        Container runningContainer = (Container)CollectionsKt.firstOrNull((List)((List)object));
        if (runningContainer != null) {
            if (!Intrinsics.areEqual((Object)runningContainer.getState(), (Object)"running")) {
                logger.info("Existing Cockroach cluster named " + containerName + " found in state " + runningContainer.getState() + ", force removing and restarting");
                this.docker.removeContainerCmd(runningContainer.getId()).withForce(Boolean.valueOf(true)).exec();
            } else {
                logger.info("Using existing Cockroach cluster named " + containerName);
                this.stopContainerOnExit = false;
                this.containerId = runningContainer.getId();
            }
        }
        if (this.containerId == null) {
            logger.info("Starting Cockroach cluster with command: " + ArraysKt.joinToString$default((Object[])cmd, (CharSequence)" ", null, null, (int)0, null, null, (int)62, null));
            ExposedPort[] exposedPortArray = new ExposedPort[]{httpPort, postgresPort};
            String string = this.docker.createContainerCmd(IMAGE).withCmd(ArraysKt.toList((Object[])cmd)).withExposedPorts(exposedPortArray).withPortBindings(ports).withTty(Boolean.valueOf(true)).withName(containerName).exec().getId();
            Intrinsics.checkNotNull((Object)string);
            String string2 = this.containerId = string;
            Intrinsics.checkNotNull((Object)string2);
            String containerId = string2;
            this.docker.startContainerCmd(containerId).exec();
            ((LogContainerResultCallback)this.docker.logContainerCmd(containerId).withStdErr(Boolean.valueOf(true)).withStdOut(Boolean.valueOf(true)).withFollowStream(Boolean.valueOf(true)).withSince(Integer.valueOf(0)).exec((ResultCallback)new LogContainerResultCallback())).awaitStarted();
        }
        logger.info("Started Cockroach with container id " + this.containerId);
        this.waitUntilHealthy();
        this.createDatabase();
    }

    private final void waitUntilHealthy() {
        try {
            Duration duration = Duration.ofSeconds(1L);
            Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"ofSeconds(...)");
            Duration duration2 = Duration.ofSeconds(5L);
            Intrinsics.checkNotNullExpressionValue((Object)duration2, (String)"ofSeconds(...)");
            RetriesKt.retry$default((int)20, (Backoff)((Backoff)new ExponentialBackoff(duration, duration2)), null, (Function1)((Function1)new Function1<Integer, Unit>(this){
                final /* synthetic */ DockerCockroachCluster this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public final void invoke(int it) {
                    AutoCloseable autoCloseable = this.this$0.getCluster().openConnection();
                    Throwable throwable = null;
                    try {
                        Connection c = (Connection)autoCloseable;
                        boolean bl = false;
                        ResultSet resultSet = c.createStatement().executeQuery("SELECT 1");
                        Intrinsics.checkNotNullExpressionValue((Object)resultSet, (String)"executeQuery(...)");
                        int result = JdbcExtensionsKt.uniqueInt(resultSet);
                        if (!(result == 1)) {
                            String string = "Check failed.";
                            throw new IllegalStateException(string.toString());
                        }
                        Unit unit = Unit.INSTANCE;
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
                    }
                }
            }), (int)4, null);
        }
        catch (DontRetryException e) {
            throw new Exception(e.getMessage());
        }
        catch (Exception e) {
            throw new Exception("Cockroach cluster failed to start up in time", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void createDatabase() {
        AutoCloseable autoCloseable = this.cluster.openConnection();
        Throwable throwable = null;
        try {
            int[] nArray;
            Connection c = (Connection)autoCloseable;
            boolean bl = false;
            AutoCloseable autoCloseable2 = c.createStatement();
            Throwable throwable2 = null;
            try {
                Object object;
                Statement statement = (Statement)autoCloseable2;
                boolean bl2 = false;
                try {
                    statement.addBatch("CREATE DATABASE " + this.config.getDatabase());
                    object = statement.executeBatch();
                }
                catch (SQLException e) {
                    String string = e.getMessage();
                    Intrinsics.checkNotNull((Object)string);
                    if (!StringsKt.contains$default((CharSequence)string, (CharSequence)"already exists", (boolean)false, (int)2, null)) {
                        throw e;
                    }
                    object = Unit.INSTANCE;
                }
                nArray = object;
            }
            catch (Throwable throwable3) {
                throwable2 = throwable3;
                throw throwable3;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable2, (Throwable)throwable2);
            }
            int[] nArray2 = nArray;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }

    @Override
    public void stop() {
        logger.info("Leaving Cockroach docker container running in the background. If you need to kill it because you messed up migrations or something use:\n\tdocker kill misk-cockroach-testing");
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\r\u001a\u00020\u000eR\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u000f"}, d2={"Lmisk/database/DockerCockroachCluster$Companion;", "", "()V", "CONTAINER_NAME", "", "IMAGE", "SHA", "imagePulled", "Ljava/util/concurrent/atomic/AtomicBoolean;", "logger", "Lmu/KLogger;", "getLogger", "()Lmu/KLogger;", "pullImage", "", "misk-jdbc"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final KLogger getLogger() {
            return logger;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void pullImage() {
            if (imagePulled.get()) {
                return;
            }
            Companion companion = this;
            synchronized (companion) {
                boolean bl = false;
                if (imagePulled.get()) {
                    return;
                }
                if (StartDatabaseServiceKt.runCommand("docker images --digests | grep -q 67f0547f1a989ebd119e5cbf903c8537556f574da20182454c036da63ea67c7d || docker pull cockroachdb/cockroach@sha256:67f0547f1a989ebd119e5cbf903c8537556f574da20182454c036da63ea67c7d") != 0) {
                    Companion.getLogger().warn("Failed to pull Cockroach docker image. Proceeding regardless.");
                }
                imagePulled.set(true);
                Unit unit = Unit.INSTANCE;
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0002H\u0016\u00a8\u0006\u0007"}, d2={"Lmisk/database/DockerCockroachCluster$LogContainerResultCallback;", "Lcom/github/dockerjava/core/async/ResultCallbackTemplate;", "Lcom/github/dockerjava/api/model/Frame;", "()V", "onNext", "", "item", "misk-jdbc"})
    public static final class LogContainerResultCallback
    extends ResultCallbackTemplate<LogContainerResultCallback, Frame> {
        public void onNext(@NotNull Frame item) {
            Intrinsics.checkNotNullParameter((Object)item, (String)"item");
            KLogger kLogger = Companion.getLogger();
            byte[] byArray = item.getPayload();
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getPayload(...)");
            byte[] byArray2 = byArray;
            kLogger.info(((Object)StringsKt.trim((CharSequence)new String(byArray2, Charsets.UTF_8))).toString());
        }
    }
}

