/*
 * Decompiled with CFR 0.152.
 */
package misk.database;

import com.github.dockerjava.api.DockerClient;
import com.github.dockerjava.api.async.ResultCallback;
import com.github.dockerjava.api.command.CreateContainerCmd;
import com.github.dockerjava.api.command.ExecCreateCmdResponse;
import com.github.dockerjava.api.model.Bind;
import com.github.dockerjava.api.model.Container;
import com.github.dockerjava.api.model.ExposedPort;
import com.github.dockerjava.api.model.Frame;
import com.github.dockerjava.api.model.Ports;
import com.github.dockerjava.api.model.Volume;
import com.github.dockerjava.core.DefaultDockerClientConfig;
import com.github.dockerjava.core.DockerClientConfig;
import com.github.dockerjava.core.DockerClientImpl;
import com.github.dockerjava.core.async.ResultCallbackTemplate;
import com.github.dockerjava.httpclient5.ApacheDockerHttpClient;
import com.github.dockerjava.transport.DockerHttpClient;
import com.github.dockerjava.transport.SSLConfig;
import com.squareup.moshi.Moshi;
import java.lang.annotation.Annotation;
import java.sql.Connection;
import java.sql.ResultSet;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import misk.backoff.Backoff;
import misk.backoff.DontRetryException;
import misk.backoff.ExponentialBackoff;
import misk.backoff.RetriesKt;
import misk.database.DatabaseServer;
import misk.database.DockerVitessCluster;
import misk.database.Keyspace;
import misk.database.StartDatabaseServiceKt;
import misk.database.VitessCluster;
import misk.jdbc.DataSourceConfig;
import misk.jdbc.DataSourceType;
import misk.jdbc.JdbcExtensionsKt;
import misk.resources.ResourceLoader;
import mu.KLogger;
import mu.KotlinLogging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import wisp.moshi.MoshiBuildKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u0000\n\u0002\b\u0007\u0018\u0000 22\u00020\u0001:\u000223B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u0016\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00030\"2\u0006\u0010#\u001a\u00020$H\u0002J\b\u0010%\u001a\u00020\u0003H\u0002J\b\u0010&\u001a\u00020'H\u0002J\b\u0010(\u001a\u00020'H\u0002J\b\u0010)\u001a\u00020'H\u0016J\"\u0010*\u001a\u0004\u0018\u00010\u00032\u0006\u0010+\u001a\u00020\u00032\u0006\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020-H\u0002J\b\u0010/\u001a\u00020'H\u0016J\b\u00100\u001a\u00020'H\u0016J\b\u00101\u001a\u00020'H\u0002J\f\u0010\u0002\u001a\u00020\u0003*\u00020$H\u0002R\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0016\u0010\u001e\u001a\n\u0018\u00010\u001fj\u0004\u0018\u0001` X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00064"}, d2={"Lmisk/database/DockerVitessCluster;", "Lmisk/database/DatabaseServer;", "name", "", "moshi", "Lcom/squareup/moshi/Moshi;", "resourceLoader", "Lmisk/resources/ResourceLoader;", "config", "Lmisk/jdbc/DataSourceConfig;", "docker", "Lcom/github/dockerjava/api/DockerClient;", "(Ljava/lang/String;Lcom/squareup/moshi/Moshi;Lmisk/resources/ResourceLoader;Lmisk/jdbc/DataSourceConfig;Lcom/github/dockerjava/api/DockerClient;)V", "cluster", "Lmisk/database/VitessCluster;", "getCluster", "()Lmisk/database/VitessCluster;", "getConfig", "()Lmisk/jdbc/DataSourceConfig;", "containerId", "getDocker", "()Lcom/github/dockerjava/api/DockerClient;", "isRunning", "", "getMoshi", "()Lcom/squareup/moshi/Moshi;", "getName", "()Ljava/lang/String;", "getResourceLoader", "()Lmisk/resources/ResourceLoader;", "startupFailure", "Ljava/lang/Exception;", "Lkotlin/Exception;", "containerMismatches", "", "container", "Lcom/github/dockerjava/api/model/Container;", "containerName", "doStart", "", "grantExternalAccessToDbaUser", "pullImage", "shouldMatch", "description", "actual", "", "expected", "start", "stop", "waitUntilHealthy", "Companion", "LogContainerResultCallback", "misk-jdbc"})
@SourceDebugExtension(value={"SMAP\nDockerVitessCluster.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DockerVitessCluster.kt\nmisk/database/DockerVitessCluster\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,479:1\n1549#2:480\n1620#2,3:481\n1549#2:484\n1620#2,3:485\n1360#2:488\n1446#2,2:489\n766#2:491\n857#2,2:492\n1448#2,3:494\n1855#2,2:497\n*S KotlinDebug\n*F\n+ 1 DockerVitessCluster.kt\nmisk/database/DockerVitessCluster\n*L\n272#1:480\n272#1:481,3\n273#1:484\n273#1:485,3\n318#1:488\n318#1:489,2\n319#1:491\n319#1:492,2\n318#1:494,3\n326#1:497,2\n*E\n"})
public final class DockerVitessCluster
implements DatabaseServer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String name;
    @NotNull
    private final Moshi moshi;
    @NotNull
    private final ResourceLoader resourceLoader;
    @NotNull
    private final DataSourceConfig config;
    @NotNull
    private final DockerClient docker;
    @NotNull
    private final VitessCluster cluster;
    @Nullable
    private String containerId;
    private boolean isRunning;
    @Nullable
    private Exception startupFailure;
    @NotNull
    private static final KLogger logger = KotlinLogging.INSTANCE.logger((Function0)Companion.logger.1.INSTANCE);
    @NotNull
    public static final String VITESS_SHA = "5ab282b99cd5f8d6a8a6f60f0b956f2905ffa3db84ba9aabac7df6425516b3fe";
    @NotNull
    public static final String VITESS_IMAGE = "vitess/base@sha256:5ab282b99cd5f8d6a8a6f60f0b956f2905ffa3db84ba9aabac7df6425516b3fe";
    @NotNull
    public static final String CONTAINER_NAME_PREFIX = "misk-vitess-testing";
    @NotNull
    private static final AtomicBoolean imagePulled = new AtomicBoolean();

    public DockerVitessCluster(@NotNull String name, @NotNull Moshi moshi, @NotNull ResourceLoader resourceLoader, @NotNull DataSourceConfig config, @NotNull DockerClient docker) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)moshi, (String)"moshi");
        Intrinsics.checkNotNullParameter((Object)resourceLoader, (String)"resourceLoader");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)docker, (String)"docker");
        this.name = name;
        this.moshi = moshi;
        this.resourceLoader = resourceLoader;
        this.config = config;
        this.docker = docker;
        this.cluster = new VitessCluster(this.name, this.resourceLoader, this.config, this.moshi);
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    @NotNull
    public final Moshi getMoshi() {
        return this.moshi;
    }

    @NotNull
    public final ResourceLoader getResourceLoader() {
        return this.resourceLoader;
    }

    @NotNull
    public final DataSourceConfig getConfig() {
        return this.config;
    }

    @NotNull
    public final DockerClient getDocker() {
        return this.docker;
    }

    @NotNull
    public final VitessCluster getCluster() {
        return this.cluster;
    }

    @Override
    public void start() {
        Exception startupFailure = this.startupFailure;
        if (startupFailure != null) {
            throw startupFailure;
        }
        if (this.isRunning) {
            return;
        }
        this.isRunning = true;
        try {
            this.doStart();
        }
        catch (Exception e) {
            this.startupFailure = e;
            throw e;
        }
    }

    @Override
    public void pullImage() {
        Companion.pullImage();
    }

    /*
     * WARNING - void declaration
     */
    private final void doStart() {
        void $this$flatMapTo$iv$iv;
        void $this$mapTo$iv$iv;
        Collection collection;
        void $this$mapTo$iv$iv2;
        Map<String, Keyspace> keyspaces = this.cluster.keyspaces();
        Iterable $this$map$iv = keyspaces.keySet();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void it;
            String string = (String)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it);
        }
        String keyspacesArg = CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)",", null, null, (int)0, null, null, (int)62, null);
        Iterable $this$map$iv2 = keyspaces.values();
        boolean $i$f$map2 = false;
        destination$iv$iv = $this$map$iv2;
        Collection destination$iv$iv22 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Keyspace bl = (Keyspace)item$iv$iv;
            collection = destination$iv$iv22;
            boolean bl2 = false;
            collection.add(it.shardCount());
        }
        String shardCounts = CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv22), (CharSequence)",", null, null, (int)0, null, null, (int)62, null);
        Volume schemaVolume = new Volume("/vt/src/vitess.io/vitess/schema");
        Volume confVolume = new Volume("/vt/src/vitess.io/vitess/config/miskcnf");
        ExposedPort httpPort = ExposedPort.tcp((int)this.cluster.getHttpPort());
        if (this.cluster.getConfig().getType() == DataSourceType.VITESS_MYSQL && this.cluster.getConfig().getPort() != null) {
            Integer n = this.cluster.getConfig().getPort();
            int destination$iv$iv22 = this.cluster.getVtgateMysqlPort();
            if (n == null || n != destination$iv$iv22) {
                throw new RuntimeException("Config port " + this.cluster.getConfig().getPort() + " has to match Vitess Docker container: " + this.cluster.getGrpcPort());
            }
        }
        ExposedPort grpcPort = ExposedPort.tcp((int)this.cluster.getGrpcPort());
        ExposedPort mysqlPort = ExposedPort.tcp((int)this.cluster.getMysqlPort());
        ExposedPort vtgateMysqlPort = ExposedPort.tcp((int)this.cluster.getVtgateMysqlPort());
        Ports ports = new Ports();
        ports.bind(grpcPort, Ports.Binding.bindPort((int)grpcPort.getPort()));
        ports.bind(httpPort, Ports.Binding.bindPort((int)httpPort.getPort()));
        ports.bind(mysqlPort, Ports.Binding.bindPort((int)mysqlPort.getPort()));
        ports.bind(vtgateMysqlPort, Ports.Binding.bindPort((int)vtgateMysqlPort.getPort()));
        Object[] bl2 = new String[10];
        bl2[0] = "/vt/bin/vttestserver";
        bl2[1] = "-alsologtostderr";
        bl2[2] = "-port=" + httpPort.getPort();
        bl2[3] = "-mysql_bind_host=0.0.0.0";
        bl2[4] = "-data_dir=/vt/vtdataroot";
        bl2[5] = "-schema_dir=schema";
        bl2[6] = "-queryserver-config-transaction-timeout=" + Duration.ofHours(24L).toMillis();
        Object[] objectArray = new String[]{"/vt/src/vitess.io/vitess/config/mycnf/rbr.cnf", "/vt/src/vitess.io/vitess/config/miskcnf/misk.cnf"};
        bl2[7] = "-extra_my_cnf=" + CollectionsKt.joinToString$default((Iterable)CollectionsKt.listOf((Object[])objectArray), (CharSequence)":", null, null, (int)0, null, null, (int)62, null);
        bl2[8] = "-keyspaces=" + keyspacesArg;
        bl2[9] = "-num_shards=" + shardCounts;
        Object[] cmd = bl2;
        objectArray = new String[]{"docker-vitess-testing", CONTAINER_NAME_PREFIX};
        List prefixes = CollectionsKt.listOf((Object[])objectArray);
        List allContainers = (List)this.docker.listContainersCmd().withShowAll(Boolean.valueOf(true)).exec();
        Iterable $this$flatMap$iv = prefixes;
        boolean $i$f$flatMap = false;
        Iterable iterable2 = $this$flatMap$iv;
        Collection destination$iv$iv3 = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            void $this$filterTo$iv$iv;
            String prefix = (String)element$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)allContainers);
            Iterable $this$filter$iv = allContainers;
            boolean $i$f$filter = false;
            Iterable iterable3 = $this$filter$iv;
            Collection destination$iv$iv4 = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv2 : $this$filterTo$iv$iv) {
                Container container = (Container)element$iv$iv2;
                boolean bl3 = false;
                Intrinsics.checkNotNull((Object)container);
                if (!StringsKt.startsWith$default((String)this.name(container), (String)prefix, (boolean)false, (int)2, null)) continue;
                destination$iv$iv4.add(element$iv$iv2);
            }
            Iterable list$iv$iv = (List)destination$iv$iv4;
            CollectionsKt.addAll((Collection)destination$iv$iv3, (Iterable)list$iv$iv);
        }
        List vitessContainers = (List)destination$iv$iv3;
        Container matchingContainer = null;
        Iterable $this$forEach$iv = vitessContainers;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Container container = (Container)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)container);
            List<String> mismatches = this.containerMismatches(container);
            if (!mismatches.isEmpty()) {
                logger.info((Function0)new Function0<Object>(this, container, mismatches){
                    final /* synthetic */ DockerVitessCluster this$0;
                    final /* synthetic */ Container $container;
                    final /* synthetic */ List<String> $mismatches;
                    {
                        this.this$0 = $receiver;
                        this.$container = $container;
                        this.$mismatches = $mismatches;
                        super(0);
                    }

                    @Nullable
                    public final Object invoke() {
                        Container container = this.$container;
                        Intrinsics.checkNotNullExpressionValue((Object)container, (String)"$container");
                        return "Vitess container named " + DockerVitessCluster.access$name(this.this$0, container) + " does not match our requirements, force removing and starting a new one: " + CollectionsKt.joinToString$default((Iterable)this.$mismatches, (CharSequence)", ", null, null, (int)0, null, null, (int)62, null);
                    }
                });
                this.docker.removeContainerCmd(container.getId()).withForce(Boolean.valueOf(true)).exec();
                continue;
            }
            matchingContainer = container;
        }
        Container container = matchingContainer;
        String string = this.containerId = container != null ? container.getId() : null;
        if (this.containerId == null) {
            logger.info((Function0)new Function0<Object>((String[])cmd){
                final /* synthetic */ String[] $cmd;
                {
                    this.$cmd = $cmd;
                    super(0);
                }

                @Nullable
                public final Object invoke() {
                    return "Starting Vitess cluster with command: " + ArraysKt.joinToString$default((Object[])this.$cmd, (CharSequence)" ", null, null, (int)0, null, null, (int)62, null);
                }
            });
            Volume[] volumeArray = new Volume[]{schemaVolume, confVolume};
            CreateContainerCmd createContainerCmd = this.docker.createContainerCmd(VITESS_IMAGE).withCmd(ArraysKt.toList((Object[])cmd)).withVolumes(volumeArray);
            volumeArray = new Bind[]{new Bind(((Object)this.cluster.getSchemaDir().toAbsolutePath()).toString(), schemaVolume), new Bind(((Object)this.cluster.getConfigDir().toAbsolutePath()).toString(), confVolume)};
            CreateContainerCmd createContainerCmd2 = createContainerCmd.withBinds((Bind[])volumeArray);
            volumeArray = new ExposedPort[]{httpPort, grpcPort, mysqlPort, vtgateMysqlPort};
            String string2 = createContainerCmd2.withExposedPorts((ExposedPort[])volumeArray).withPortBindings(ports).withTty(Boolean.valueOf(true)).withName(this.containerName()).exec().getId();
            Intrinsics.checkNotNull((Object)string2);
            String containerId = string2;
            this.docker.startContainerCmd(containerId).exec();
            this.containerId = containerId;
            logger.info("Started Vitess with container id " + containerId);
        } else {
            logger.info("Using existing Vitess cluster " + this.containerId);
        }
        String string3 = this.containerId;
        Intrinsics.checkNotNull((Object)string3);
        ((LogContainerResultCallback)this.docker.logContainerCmd(string3).withStdErr(Boolean.valueOf(true)).withStdOut(Boolean.valueOf(true)).withFollowStream(Boolean.valueOf(true)).withSince(Integer.valueOf(0)).exec((ResultCallback)new LogContainerResultCallback())).awaitStarted();
        this.waitUntilHealthy();
        this.grantExternalAccessToDbaUser();
    }

    private final String containerName() {
        return "misk-vitess-testing-" + this.cluster.getName();
    }

    private final List<String> containerMismatches(Container container) {
        Object[] objectArray = new String[3];
        objectArray[0] = this.shouldMatch("container name", this.name(container), this.containerName());
        String string = container.getState();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getState(...)");
        objectArray[1] = this.shouldMatch("container state", string, "running");
        String string2 = container.getImage();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getImage(...)");
        objectArray[2] = this.shouldMatch("container image", string2, VITESS_IMAGE);
        return CollectionsKt.listOfNotNull((Object[])objectArray);
    }

    private final String shouldMatch(String description, Object actual, Object expected) {
        return !Intrinsics.areEqual((Object)expected, (Object)actual) ? description + " \"" + actual + "\" does not match \"" + expected + "\"" : null;
    }

    private final String name(Container $this$name) {
        String string;
        String[] stringArray = $this$name.getNames();
        Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"getNames(...)");
        String name = (String)ArraysKt.single((Object[])stringArray);
        Intrinsics.checkNotNull((Object)name);
        if (StringsKt.startsWith$default((String)name, (String)"/", (boolean)false, (int)2, null)) {
            String string2 = name.substring(1);
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
        } else {
            string = name;
        }
        return string;
    }

    private final void waitUntilHealthy() {
        try {
            Duration duration = Duration.ofSeconds(1L);
            Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"ofSeconds(...)");
            Duration duration2 = Duration.ofSeconds(5L);
            Intrinsics.checkNotNullExpressionValue((Object)duration2, (String)"ofSeconds(...)");
            RetriesKt.retry$default((int)20, (Backoff)((Backoff)new ExponentialBackoff(duration, duration2)), null, (Function1)((Function1)new Function1<Integer, Unit>(this){
                final /* synthetic */ DockerVitessCluster this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public final void invoke(int it) {
                    AutoCloseable autoCloseable = this.this$0.getCluster().openVtgateConnection();
                    Throwable throwable = null;
                    try {
                        Connection c = (Connection)autoCloseable;
                        boolean bl = false;
                        try {
                            ResultSet resultSet = c.createStatement().executeQuery("SELECT 1 FROM dual");
                            Intrinsics.checkNotNullExpressionValue((Object)resultSet, (String)"executeQuery(...)");
                            int result = JdbcExtensionsKt.uniqueInt(resultSet);
                            if (!(result == 1)) {
                                String string = "Check failed.";
                                throw new IllegalStateException(string.toString());
                            }
                        }
                        catch (Exception e) {
                            String message;
                            String string = message = e.getMessage();
                            boolean bl2 = string != null ? StringsKt.contains$default((CharSequence)string, (CharSequence)"table dual not found", (boolean)false, (int)2, null) : false;
                            if (bl2) {
                                throw new DontRetryException("Something is wrong with your vschema and unfortunately vtcombo does not currently have good error reporting on this. Please inspect the logs or your vschema to see if you can find the error.");
                            }
                            throw e;
                        }
                        Unit unit = Unit.INSTANCE;
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
                    }
                }
            }), (int)4, null);
        }
        catch (DontRetryException e) {
            throw new Exception(e.getMessage());
        }
        catch (Exception e) {
            throw new Exception("Vitess cluster failed to start up in time", e);
        }
    }

    private final void grantExternalAccessToDbaUser() {
        Integer exitCode;
        String string = this.containerId;
        Intrinsics.checkNotNull((Object)string);
        String[] stringArray = new String[]{"mysql", "-S", "/vt/vtdataroot/vt_0000000001/mysql.sock", "-u", "root", "mysql", "-e", "grant all on *.* to 'vt_dba'@'%'; grant REPLICATION CLIENT, REPLICATION SLAVE on *.* to 'vt_app'@'%'"};
        ExecCreateCmdResponse exec = (ExecCreateCmdResponse)this.docker.execCreateCmd(string).withAttachStderr(Boolean.valueOf(true)).withAttachStdout(Boolean.valueOf(true)).withCmd(stringArray).exec();
        ((LogContainerResultCallback)this.docker.execStartCmd(exec.getId()).exec((ResultCallback)new LogContainerResultCallback())).awaitCompletion();
        Integer n = exitCode = this.docker.inspectExecCmd(exec.getId()).exec().getExitCode();
        if (n == null || n != 0) {
            throw new RuntimeException("Command failed, see log for details");
        }
    }

    @Override
    public void stop() {
    }

    public static final /* synthetic */ String access$name(DockerVitessCluster $this, Container $receiver) {
        return $this.name($receiver);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u001b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\r\u001a\u00020\u000eJ\u001e\u0010\u000f\u001a\u00020\u000e2\u000e\u0010\u0010\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00120\u00112\u0006\u0010\u0013\u001a\u00020\u0014R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0015"}, d2={"Lmisk/database/DockerVitessCluster$Companion;", "", "()V", "CONTAINER_NAME_PREFIX", "", "VITESS_IMAGE", "VITESS_SHA", "imagePulled", "Ljava/util/concurrent/atomic/AtomicBoolean;", "logger", "Lmu/KLogger;", "getLogger", "()Lmu/KLogger;", "pullImage", "", "startVitessDaemon", "qualifier", "Lkotlin/reflect/KClass;", "", "config", "Lmisk/jdbc/DataSourceConfig;", "misk-jdbc"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final KLogger getLogger() {
            return logger;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void pullImage() {
            if (imagePulled.get()) {
                return;
            }
            Companion companion = this;
            synchronized (companion) {
                boolean bl = false;
                if (imagePulled.get()) {
                    return;
                }
                if (StartDatabaseServiceKt.runCommand("docker images --digests | grep -q 5ab282b99cd5f8d6a8a6f60f0b956f2905ffa3db84ba9aabac7df6425516b3fe || docker pull vitess/base@sha256:5ab282b99cd5f8d6a8a6f60f0b956f2905ffa3db84ba9aabac7df6425516b3fe") != 0) {
                    Companion.getLogger().warn("Failed to pull Vitess docker image. Proceeding regardless.");
                }
                imagePulled.set(true);
                Unit unit = Unit.INSTANCE;
            }
        }

        public final void startVitessDaemon(@NotNull KClass<? extends Annotation> qualifier, @NotNull DataSourceConfig config) {
            Intrinsics.checkNotNullParameter(qualifier, (String)"qualifier");
            Intrinsics.checkNotNullParameter((Object)config, (String)"config");
            DefaultDockerClientConfig defaultDockerClientConfig = DefaultDockerClientConfig.createDefaultConfigBuilder().build();
            ApacheDockerHttpClient httpClient = new ApacheDockerHttpClient.Builder().dockerHost(defaultDockerClientConfig.getDockerHost()).sslConfig((SSLConfig)defaultDockerClientConfig.getSSLConfig()).maxConnections(100).connectionTimeout(Duration.ofSeconds(60L)).responseTimeout(Duration.ofSeconds(120L)).build();
            DockerClient dockerClient = DockerClientImpl.getInstance((DockerClientConfig)((DockerClientConfig)defaultDockerClientConfig), (DockerHttpClient)((DockerHttpClient)httpClient));
            Intrinsics.checkNotNullExpressionValue((Object)dockerClient, (String)"getInstance(...)");
            DockerClient docker = dockerClient;
            Moshi moshi = MoshiBuildKt.getDefaultKotlinMoshi();
            String string = qualifier.getSimpleName();
            Intrinsics.checkNotNull((Object)string);
            String string2 = string;
            ResourceLoader resourceLoader = ResourceLoader.Companion.getSYSTEM();
            DockerVitessCluster dockerCluster = new DockerVitessCluster(string2, moshi, resourceLoader, config, docker);
            Runtime.getRuntime().addShutdownHook(new Thread(() -> Companion.startVitessDaemon$lambda$1(dockerCluster)));
            dockerCluster.start();
        }

        private static final void startVitessDaemon$lambda$1(DockerVitessCluster $dockerCluster) {
            Intrinsics.checkNotNullParameter((Object)$dockerCluster, (String)"$dockerCluster");
            $dockerCluster.stop();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0002H\u0016\u00a8\u0006\u0007"}, d2={"Lmisk/database/DockerVitessCluster$LogContainerResultCallback;", "Lcom/github/dockerjava/core/async/ResultCallbackTemplate;", "Lcom/github/dockerjava/api/model/Frame;", "()V", "onNext", "", "item", "misk-jdbc"})
    public static final class LogContainerResultCallback
    extends ResultCallbackTemplate<LogContainerResultCallback, Frame> {
        public void onNext(@NotNull Frame item) {
            Intrinsics.checkNotNullParameter((Object)item, (String)"item");
            KLogger kLogger = Companion.getLogger();
            byte[] byArray = item.getPayload();
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getPayload(...)");
            byte[] byArray2 = byArray;
            kLogger.info(((Object)StringsKt.trim((CharSequence)new String(byArray2, Charsets.UTF_8))).toString());
        }
    }
}

