/*
 * Decompiled with CFR 0.152.
 */
package misk.database;

import com.github.dockerjava.api.DockerClient;
import com.github.dockerjava.core.DefaultDockerClientConfig;
import com.github.dockerjava.core.DockerClientConfig;
import com.github.dockerjava.core.DockerClientImpl;
import com.github.dockerjava.httpclient5.ApacheDockerHttpClient;
import com.github.dockerjava.transport.DockerHttpClient;
import com.github.dockerjava.transport.SSLConfig;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.cache.RemovalNotification;
import com.google.common.util.concurrent.AbstractIdleService;
import com.squareup.moshi.Moshi;
import java.lang.annotation.Annotation;
import java.time.Duration;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KClass;
import misk.database.DatabaseServer;
import misk.database.DockerCockroachCluster;
import misk.database.DockerPostgresServer;
import misk.database.DockerTidbCluster;
import misk.database.DockerVitessCluster;
import misk.database.StartDatabaseService;
import misk.jdbc.DataSourceConfig;
import misk.jdbc.DataSourceType;
import misk.resources.ResourceLoader;
import mu.KLogger;
import mu.KotlinLogging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import wisp.deployment.Deployment;
import wisp.moshi.MoshiBuildKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u001b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u0000 \"2\u00020\u0001:\u0002!\"B%\u0012\u000e\u0010\u0002\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0012\u0010\u0019\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0007\u001a\u00020\u001aH\u0002J\u0006\u0010\u001b\u001a\u00020\u0000J\b\u0010\u001c\u001a\u00020\u001dH\u0002J\b\u0010\u001e\u001a\u00020\u001fH\u0014J\b\u0010 \u001a\u00020\u001fH\u0014R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\n\u001a\n \f*\u0004\u0018\u00010\u000b0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000f\u001a\n \f*\u0004\u0018\u00010\u00100\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0002\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018\u00a8\u0006#"}, d2={"Lmisk/database/StartDatabaseService;", "Lcom/google/common/util/concurrent/AbstractIdleService;", "qualifier", "Lkotlin/reflect/KClass;", "", "deployment", "Lwisp/deployment/Deployment;", "config", "Lmisk/jdbc/DataSourceConfig;", "(Lkotlin/reflect/KClass;Lwisp/deployment/Deployment;Lmisk/jdbc/DataSourceConfig;)V", "defaultDockerClientConfig", "Lcom/github/dockerjava/core/DefaultDockerClientConfig;", "kotlin.jvm.PlatformType", "docker", "Lcom/github/dockerjava/api/DockerClient;", "httpClient", "Lcom/github/dockerjava/httpclient5/ApacheDockerHttpClient;", "moshi", "Lcom/squareup/moshi/Moshi;", "server", "Lmisk/database/DatabaseServer;", "getServer", "()Lmisk/database/DatabaseServer;", "setServer", "(Lmisk/database/DatabaseServer;)V", "createDatabaseServer", "Lmisk/database/StartDatabaseService$CacheKey;", "init", "shouldStartServer", "", "shutDown", "", "startUp", "CacheKey", "Companion", "misk-jdbc"})
public final class StartDatabaseService
extends AbstractIdleService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final KClass<? extends Annotation> qualifier;
    @NotNull
    private final Deployment deployment;
    @NotNull
    private final DataSourceConfig config;
    @Nullable
    private DatabaseServer server;
    private final DefaultDockerClientConfig defaultDockerClientConfig;
    private final ApacheDockerHttpClient httpClient;
    @NotNull
    private final DockerClient docker;
    @NotNull
    private final Moshi moshi;
    @NotNull
    private static final KLogger logger = KotlinLogging.INSTANCE.logger((Function0)Companion.logger.1.INSTANCE);
    public static LoadingCache<CacheKey, Optional<DatabaseServer>> servers;

    public StartDatabaseService(@NotNull KClass<? extends Annotation> qualifier, @NotNull Deployment deployment, @NotNull DataSourceConfig config) {
        Intrinsics.checkNotNullParameter(qualifier, (String)"qualifier");
        Intrinsics.checkNotNullParameter((Object)deployment, (String)"deployment");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        this.qualifier = qualifier;
        this.deployment = deployment;
        this.config = config;
        this.defaultDockerClientConfig = DefaultDockerClientConfig.createDefaultConfigBuilder().build();
        this.httpClient = new ApacheDockerHttpClient.Builder().dockerHost(this.defaultDockerClientConfig.getDockerHost()).sslConfig((SSLConfig)this.defaultDockerClientConfig.getSSLConfig()).maxConnections(100).connectionTimeout(Duration.ofSeconds(60L)).responseTimeout(Duration.ofSeconds(120L)).build();
        DockerClient dockerClient = DockerClientImpl.getInstance((DockerClientConfig)((DockerClientConfig)this.defaultDockerClientConfig), (DockerHttpClient)((DockerHttpClient)this.httpClient));
        Intrinsics.checkNotNullExpressionValue((Object)dockerClient, (String)"getInstance(...)");
        this.docker = dockerClient;
        this.moshi = MoshiBuildKt.getDefaultKotlinMoshi();
    }

    @Nullable
    public final DatabaseServer getServer() {
        return this.server;
    }

    public final void setServer(@Nullable DatabaseServer databaseServer) {
        this.server = databaseServer;
    }

    @NotNull
    public final StartDatabaseService init() {
        block1: {
            LoadingCache loadingCache = CacheBuilder.newBuilder().removalListener(arg_0 -> StartDatabaseService.init$lambda$0(init.1.INSTANCE, arg_0)).build(CacheLoader.from(arg_0 -> StartDatabaseService.init$lambda$2(this, arg_0)));
            Intrinsics.checkNotNullExpressionValue((Object)loadingCache, (String)"build(...)");
            Companion.setServers((LoadingCache<CacheKey, Optional<DatabaseServer>>)loadingCache);
            Runtime.getRuntime().addShutdownHook(new Thread(StartDatabaseService::init$lambda$3));
            if (!this.shouldStartServer()) break block1;
            String string = this.qualifier.getSimpleName();
            Intrinsics.checkNotNull((Object)string);
            String name = string;
            DatabaseServer databaseServer = this.server = (DatabaseServer)((Optional)Companion.getServers().get((Object)new CacheKey(name, this.config, this.deployment))).orElse(null);
            if (databaseServer != null) {
                databaseServer.pullImage();
            }
        }
        return this;
    }

    protected void startUp() {
        block0: {
            DatabaseServer databaseServer = this.server;
            if (databaseServer == null) break block0;
            databaseServer.start();
        }
    }

    protected void shutDown() {
    }

    private final boolean shouldStartServer() {
        return this.deployment.isTest() || this.deployment.isLocalDevelopment();
    }

    private final DatabaseServer createDatabaseServer(CacheKey config) {
        DatabaseServer databaseServer;
        switch (WhenMappings.$EnumSwitchMapping$0[config.getConfig().getType().ordinal()]) {
            case 1: {
                String string = config.getName();
                DataSourceConfig dataSourceConfig = config.getConfig();
                ResourceLoader resourceLoader = ResourceLoader.Companion.getSYSTEM();
                Moshi moshi = this.moshi;
                DockerClient dockerClient = this.docker;
                databaseServer = new DockerVitessCluster(string, moshi, resourceLoader, dataSourceConfig, dockerClient);
                break;
            }
            case 2: {
                String string = config.getName();
                DataSourceConfig dataSourceConfig = config.getConfig();
                ResourceLoader resourceLoader = ResourceLoader.Companion.getSYSTEM();
                Moshi moshi = this.moshi;
                DockerClient dockerClient = this.docker;
                databaseServer = new DockerCockroachCluster(string, moshi, resourceLoader, dataSourceConfig, dockerClient);
                break;
            }
            case 3: {
                databaseServer = new DockerTidbCluster(this.moshi, ResourceLoader.Companion.getSYSTEM(), config.getConfig(), this.docker);
                break;
            }
            case 4: {
                databaseServer = new DockerPostgresServer(config.getConfig(), this.docker);
                break;
            }
            default: {
                databaseServer = null;
            }
        }
        return databaseServer;
    }

    private static final void init$lambda$0(Function1 $tmp0, RemovalNotification notification) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke((Object)notification);
    }

    private static final Optional init$lambda$2(StartDatabaseService this$0, CacheKey config) {
        DatabaseServer databaseServer;
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        CacheKey cacheKey = config;
        if (cacheKey != null) {
            CacheKey it = cacheKey;
            boolean bl = false;
            databaseServer = this$0.createDatabaseServer(it);
        } else {
            databaseServer = null;
        }
        return Optional.ofNullable(databaseServer);
    }

    private static final void init$lambda$3() {
        Companion.getServers().invalidateAll();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0007H\u00c6\u0003J'\u0010\u0012\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001J\t\u0010\u0018\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0019"}, d2={"Lmisk/database/StartDatabaseService$CacheKey;", "", "name", "", "config", "Lmisk/jdbc/DataSourceConfig;", "deployment", "Lwisp/deployment/Deployment;", "(Ljava/lang/String;Lmisk/jdbc/DataSourceConfig;Lwisp/deployment/Deployment;)V", "getConfig", "()Lmisk/jdbc/DataSourceConfig;", "getDeployment", "()Lwisp/deployment/Deployment;", "getName", "()Ljava/lang/String;", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "misk-jdbc"})
    public static final class CacheKey {
        @NotNull
        private final String name;
        @NotNull
        private final DataSourceConfig config;
        @NotNull
        private final Deployment deployment;

        public CacheKey(@NotNull String name, @NotNull DataSourceConfig config, @NotNull Deployment deployment) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)config, (String)"config");
            Intrinsics.checkNotNullParameter((Object)deployment, (String)"deployment");
            this.name = name;
            this.config = config;
            this.deployment = deployment;
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        @NotNull
        public final DataSourceConfig getConfig() {
            return this.config;
        }

        @NotNull
        public final Deployment getDeployment() {
            return this.deployment;
        }

        @NotNull
        public final String component1() {
            return this.name;
        }

        @NotNull
        public final DataSourceConfig component2() {
            return this.config;
        }

        @NotNull
        public final Deployment component3() {
            return this.deployment;
        }

        @NotNull
        public final CacheKey copy(@NotNull String name, @NotNull DataSourceConfig config, @NotNull Deployment deployment) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)config, (String)"config");
            Intrinsics.checkNotNullParameter((Object)deployment, (String)"deployment");
            return new CacheKey(name, config, deployment);
        }

        public static /* synthetic */ CacheKey copy$default(CacheKey cacheKey, String string, DataSourceConfig dataSourceConfig, Deployment deployment, int n, Object object) {
            if ((n & 1) != 0) {
                string = cacheKey.name;
            }
            if ((n & 2) != 0) {
                dataSourceConfig = cacheKey.config;
            }
            if ((n & 4) != 0) {
                deployment = cacheKey.deployment;
            }
            return cacheKey.copy(string, dataSourceConfig, deployment);
        }

        @NotNull
        public String toString() {
            return "CacheKey(name=" + this.name + ", config=" + this.config + ", deployment=" + this.deployment + ")";
        }

        public int hashCode() {
            int result = this.name.hashCode();
            result = result * 31 + this.config.hashCode();
            result = result * 31 + this.deployment.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof CacheKey)) {
                return false;
            }
            CacheKey cacheKey = (CacheKey)other;
            if (!Intrinsics.areEqual((Object)this.name, (Object)cacheKey.name)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.config, (Object)cacheKey.config)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.deployment, (Object)cacheKey.deployment);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R,\u0010\u0007\u001a\u0014\u0012\u0004\u0012\u00020\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n0\bX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0010"}, d2={"Lmisk/database/StartDatabaseService$Companion;", "", "()V", "logger", "Lmu/KLogger;", "getLogger", "()Lmu/KLogger;", "servers", "Lcom/google/common/cache/LoadingCache;", "Lmisk/database/StartDatabaseService$CacheKey;", "Ljava/util/Optional;", "Lmisk/database/DatabaseServer;", "getServers", "()Lcom/google/common/cache/LoadingCache;", "setServers", "(Lcom/google/common/cache/LoadingCache;)V", "misk-jdbc"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final KLogger getLogger() {
            return logger;
        }

        @NotNull
        public final LoadingCache<CacheKey, Optional<DatabaseServer>> getServers() {
            LoadingCache<CacheKey, Optional<DatabaseServer>> loadingCache = servers;
            if (loadingCache != null) {
                return loadingCache;
            }
            Intrinsics.throwUninitializedPropertyAccessException((String)"servers");
            return null;
        }

        public final void setServers(@NotNull LoadingCache<CacheKey, Optional<DatabaseServer>> loadingCache) {
            Intrinsics.checkNotNullParameter(loadingCache, (String)"<set-?>");
            servers = loadingCache;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[DataSourceType.values().length];
            try {
                nArray[DataSourceType.VITESS_MYSQL.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DataSourceType.COCKROACHDB.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DataSourceType.TIDB.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DataSourceType.POSTGRESQL.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

