/*
 * Decompiled with CFR 0.152.
 */
package misk.database;

import com.zaxxer.hikari.util.DriverDataSource;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.sql.Connection;
import java.util.Properties;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.concurrent.ThreadsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import misk.jdbc.DataSourceConfig;
import misk.resources.ResourceLoader;
import org.jetbrains.annotations.NotNull;
import wisp.deployment.DeploymentKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0015\u001a\u00020\u0016H\u0002J\u0006\u0010\u0017\u001a\u00020\u0018R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u000eX\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\u000eX\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0010R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\u0019"}, d2={"Lmisk/database/TidbCluster;", "", "resourceLoader", "Lmisk/resources/ResourceLoader;", "config", "Lmisk/jdbc/DataSourceConfig;", "(Lmisk/resources/ResourceLoader;Lmisk/jdbc/DataSourceConfig;)V", "getConfig", "()Lmisk/jdbc/DataSourceConfig;", "configDir", "Ljava/nio/file/Path;", "getConfigDir", "()Ljava/nio/file/Path;", "httpPort", "", "getHttpPort", "()I", "mysqlPort", "getMysqlPort", "getResourceLoader", "()Lmisk/resources/ResourceLoader;", "dataSource", "Lcom/zaxxer/hikari/util/DriverDataSource;", "openConnection", "Ljava/sql/Connection;", "misk-jdbc"})
public final class TidbCluster {
    @NotNull
    private final ResourceLoader resourceLoader;
    @NotNull
    private final DataSourceConfig config;
    private final int httpPort;
    private final int mysqlPort;
    @NotNull
    private final Path configDir;

    public TidbCluster(@NotNull ResourceLoader resourceLoader, @NotNull DataSourceConfig config) {
        Intrinsics.checkNotNullParameter((Object)resourceLoader, (String)"resourceLoader");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        this.resourceLoader = resourceLoader;
        this.config = config;
        this.httpPort = 10080;
        this.mysqlPort = 4000;
        Path path = Paths.get("/tmp/tidb_conf_" + System.currentTimeMillis(), new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
        this.configDir = path;
        Files.createDirectories(this.configDir, new FileAttribute[0]);
        this.resourceLoader.copyTo("classpath:/misk/tidb", this.configDir);
        Runtime.getRuntime().addShutdownHook(ThreadsKt.thread$default((boolean)false, (boolean)false, null, null, (int)0, (Function0)((Function0)new Function0<Unit>(){

            public final void invoke() {
                File file = this.getConfigDir().toFile();
                Intrinsics.checkNotNullExpressionValue((Object)file, (String)"toFile(...)");
                FilesKt.deleteRecursively((File)file);
            }
        }), (int)30, null));
    }

    @NotNull
    public final ResourceLoader getResourceLoader() {
        return this.resourceLoader;
    }

    @NotNull
    public final DataSourceConfig getConfig() {
        return this.config;
    }

    public final int getHttpPort() {
        return this.httpPort;
    }

    public final int getMysqlPort() {
        return this.mysqlPort;
    }

    @NotNull
    public final Path getConfigDir() {
        return this.configDir;
    }

    @NotNull
    public final Connection openConnection() {
        Connection connection = this.dataSource().getConnection();
        Intrinsics.checkNotNullExpressionValue((Object)connection, (String)"getConnection(...)");
        return connection;
    }

    private final DriverDataSource dataSource() {
        String jdbcUrl = this.config.withDefaults().buildJdbcUrl(DeploymentKt.getTESTING());
        return new DriverDataSource(jdbcUrl, this.config.getType().getDriverClassName(), new Properties(), this.config.getUsername(), this.config.getPassword());
    }
}

