/*
 * Decompiled with CFR 0.152.
 */
package misk.jdbc;

import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0002\u0010\u0000\n\u0002\b\u0005\b\u0080\b\u0018\u0000 \u001a2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\u001aB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0011\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u0000H\u0096\u0002J\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u0013\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0014\u001a\u00020\u00152\b\u0010\u0010\u001a\u0004\u0018\u00010\u0016H\u00d6\u0003J\t\u0010\u0017\u001a\u00020\u0003H\u00d6\u0001J\u0006\u0010\u0018\u001a\u00020\u0005J\t\u0010\u0019\u001a\u00020\u0005H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\b\"\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u001b"}, d2={"Lmisk/jdbc/NamedspacedMigration;", "", "version", "", "namespace", "", "(ILjava/lang/String;)V", "getNamespace", "()Ljava/lang/String;", "path", "getPath", "setPath", "(Ljava/lang/String;)V", "getVersion", "()I", "compareTo", "other", "component1", "component2", "copy", "equals", "", "", "hashCode", "toNamespacedVersion", "toString", "Companion", "misk-jdbc"})
public final class NamedspacedMigration
implements Comparable<NamedspacedMigration> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int version;
    @NotNull
    private final String namespace;
    @NotNull
    private String path;
    @NotNull
    private static final String NAMESPACE_SEPARATOR = "/";

    public NamedspacedMigration(int version, @NotNull String namespace) {
        Intrinsics.checkNotNullParameter((Object)namespace, (String)"namespace");
        this.version = version;
        this.namespace = namespace;
        this.path = "";
    }

    public /* synthetic */ NamedspacedMigration(int n, String string, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            string = "";
        }
        this(n, string);
    }

    public final int getVersion() {
        return this.version;
    }

    @NotNull
    public final String getNamespace() {
        return this.namespace;
    }

    @NotNull
    public final String getPath() {
        return this.path;
    }

    public final void setPath(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.path = string;
    }

    @Override
    public int compareTo(@NotNull NamedspacedMigration other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return Intrinsics.areEqual((Object)this.namespace, (Object)other.namespace) ? Intrinsics.compare((int)this.version, (int)other.version) : this.namespace.compareTo(other.namespace);
    }

    @NotNull
    public final String toNamespacedVersion() {
        return this.namespace + this.version;
    }

    public final int component1() {
        return this.version;
    }

    @NotNull
    public final String component2() {
        return this.namespace;
    }

    @NotNull
    public final NamedspacedMigration copy(int version, @NotNull String namespace) {
        Intrinsics.checkNotNullParameter((Object)namespace, (String)"namespace");
        return new NamedspacedMigration(version, namespace);
    }

    public static /* synthetic */ NamedspacedMigration copy$default(NamedspacedMigration namedspacedMigration, int n, String string, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = namedspacedMigration.version;
        }
        if ((n2 & 2) != 0) {
            string = namedspacedMigration.namespace;
        }
        return namedspacedMigration.copy(n, string);
    }

    @NotNull
    public String toString() {
        return "NamedspacedMigration(version=" + this.version + ", namespace=" + this.namespace + ")";
    }

    public int hashCode() {
        int result = Integer.hashCode(this.version);
        result = result * 31 + this.namespace.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof NamedspacedMigration)) {
            return false;
        }
        NamedspacedMigration namedspacedMigration = (NamedspacedMigration)other;
        if (this.version != namedspacedMigration.version) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.namespace, (Object)namedspacedMigration.namespace);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0004J\u001e\u0010\b\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lmisk/jdbc/NamedspacedMigration$Companion;", "", "()V", "NAMESPACE_SEPARATOR", "", "fromNamespacedVersion", "Lmisk/jdbc/NamedspacedMigration;", "namespacedVersion", "fromResourcePath", "resource", "migrationsResource", "migrationPattern", "misk-jdbc"})
    @SourceDebugExtension(value={"SMAP\nSchemaMigrator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SchemaMigrator.kt\nmisk/jdbc/NamedspacedMigration$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,326:1\n1#2:327\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final NamedspacedMigration fromNamespacedVersion(@NotNull String namespacedVersion) {
            NamedspacedMigration namedspacedMigration;
            Intrinsics.checkNotNullParameter((Object)namespacedVersion, (String)"namespacedVersion");
            if (StringsKt.toIntOrNull((String)namespacedVersion) != null) {
                namedspacedMigration = new NamedspacedMigration(Integer.parseInt(namespacedVersion), null, 2, null);
            } else {
                String[] stringArray = new String[]{NamedspacedMigration.NAMESPACE_SEPARATOR};
                List items = StringsKt.split$default((CharSequence)namespacedVersion, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
                int version = Integer.parseInt((String)CollectionsKt.last((List)items));
                String namespace = CollectionsKt.joinToString$default((Iterable)CollectionsKt.dropLast((List)items, (int)1), (CharSequence)NamedspacedMigration.NAMESPACE_SEPARATOR, null, null, (int)0, null, null, (int)62, null) + NamedspacedMigration.NAMESPACE_SEPARATOR;
                namedspacedMigration = new NamedspacedMigration(version, namespace);
            }
            return namedspacedMigration;
        }

        @NotNull
        public final NamedspacedMigration fromResourcePath(@NotNull String resource, @NotNull String migrationsResource, @NotNull String migrationPattern) {
            Intrinsics.checkNotNullParameter((Object)resource, (String)"resource");
            Intrinsics.checkNotNullParameter((Object)migrationsResource, (String)"migrationsResource");
            Intrinsics.checkNotNullParameter((Object)migrationPattern, (String)"migrationPattern");
            Matcher matcher = Pattern.compile(migrationPattern).matcher(resource);
            if (!matcher.matches()) {
                boolean $i$a$-require-NamedspacedMigration$Companion$fromResourcePath$22 = false;
                String $i$a$-require-NamedspacedMigration$Companion$fromResourcePath$22 = "unexpected resource: " + resource;
                throw new IllegalArgumentException($i$a$-require-NamedspacedMigration$Companion$fromResourcePath$22.toString());
            }
            String string = matcher.group(1);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"group(...)");
            String cleanNamespace = StringsKt.removePrefix((String)StringsKt.removePrefix((String)string, (CharSequence)migrationsResource), (CharSequence)NamedspacedMigration.NAMESPACE_SEPARATOR);
            String string2 = matcher.group(2);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"group(...)");
            NamedspacedMigration namedspacedMigration = new NamedspacedMigration(Integer.parseInt(string2), cleanNamespace);
            namedspacedMigration.setPath(resource);
            return namedspacedMigration;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

