/*
 * Decompiled with CFR 0.152.
 */
package misk.jdbc;

import com.google.common.util.concurrent.AbstractIdleService;
import com.zaxxer.hikari.util.DriverDataSource;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import misk.backoff.Backoff;
import misk.backoff.ExponentialBackoff;
import misk.backoff.RetriesKt;
import misk.jdbc.DataSourceConfig;
import misk.jdbc.DataSourceType;
import misk.jdbc.JdbcExtensionsKt;
import misk.jdbc.PingDatabaseService;
import misk.jdbc.PingDatabaseServiceKt;
import org.jetbrains.annotations.NotNull;
import wisp.deployment.Deployment;

@Singleton
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0017\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\rH\u0002J\b\u0010\u000e\u001a\u00020\bH\u0014J\b\u0010\u000f\u001a\u00020\bH\u0014J\u0014\u0010\u0010\u001a\n \u0012*\u0004\u0018\u00010\u00110\u0011*\u00020\nH\u0002J\u0018\u0010\u0013\u001a\u00020\r*\u00060\u0014j\u0002`\u00152\u0006\u0010\f\u001a\u00020\rH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lmisk/jdbc/PingDatabaseService;", "Lcom/google/common/util/concurrent/AbstractIdleService;", "config", "Lmisk/jdbc/DataSourceConfig;", "deployment", "Lwisp/deployment/Deployment;", "(Lmisk/jdbc/DataSourceConfig;Lwisp/deployment/Deployment;)V", "connectToDataSource", "", "dataSource", "Lcom/zaxxer/hikari/util/DriverDataSource;", "createDataSource", "jdbcUrl", "", "shutDown", "startUp", "connect", "Ljava/sql/Connection;", "kotlin.jvm.PlatformType", "describe", "Ljava/lang/Exception;", "Lkotlin/Exception;", "misk-jdbc"})
public final class PingDatabaseService
extends AbstractIdleService {
    @NotNull
    private final DataSourceConfig config;
    @NotNull
    private final Deployment deployment;

    @Inject
    public PingDatabaseService(@NotNull DataSourceConfig config, @NotNull Deployment deployment) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)deployment, (String)"deployment");
        this.config = config;
        this.deployment = deployment;
    }

    protected void startUp() {
        String jdbcUrl = this.config.buildJdbcUrl(this.deployment);
        DriverDataSource dataSource = this.createDataSource(jdbcUrl);
        Duration duration = Duration.ofMillis(20L);
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"ofMillis(...)");
        Duration duration2 = Duration.ofMillis(1000L);
        Intrinsics.checkNotNullExpressionValue((Object)duration2, (String)"ofMillis(...)");
        RetriesKt.retry$default((int)10, (Backoff)((Backoff)new ExponentialBackoff(duration, duration2)), null, (Function1)((Function1)new Function1<Integer, Unit>(this, dataSource, jdbcUrl){
            final /* synthetic */ PingDatabaseService this$0;
            final /* synthetic */ DriverDataSource $dataSource;
            final /* synthetic */ String $jdbcUrl;
            {
                this.this$0 = $receiver;
                this.$dataSource = $dataSource;
                this.$jdbcUrl = $jdbcUrl;
                super(1);
            }

            public final void invoke(int it) {
                try {
                    PingDatabaseService.access$connectToDataSource(this.this$0, this.$dataSource);
                }
                catch (Exception e) {
                    if (PingDatabaseService.access$getConfig$p(this.this$0).getType() == DataSourceType.VITESS_MYSQL && Intrinsics.areEqual((Object)PingDatabaseService.access$getConfig$p(this.this$0).getDatabase(), (Object)"@master")) {
                        PingDatabaseServiceKt.access$getLogger$p().warn("ping master database unsuccessful, trying to ping the replica");
                        DriverDataSource replicaDataSource = PingDatabaseService.access$createDataSource(this.this$0, PingDatabaseService.access$getConfig$p(this.this$0).asReplica().buildJdbcUrl(PingDatabaseService.access$getDeployment$p(this.this$0)));
                        PingDatabaseService.access$connectToDataSource(this.this$0, replicaDataSource);
                    }
                    PingDatabaseServiceKt.access$getLogger$p().error((Throwable)e, (Function0)startUp.1.INSTANCE);
                    throw new RuntimeException(PingDatabaseService.access$describe(this.this$0, e, this.$jdbcUrl), e);
                }
            }
        }), (int)4, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void connectToDataSource(DriverDataSource dataSource) {
        dataSource.setLoginTimeout((int)(this.config.getConnection_timeout().toMillis() / (long)1000));
        AutoCloseable autoCloseable = this.connect(dataSource);
        Throwable throwable = null;
        try {
            Connection c = (Connection)autoCloseable;
            boolean bl = false;
            AutoCloseable autoCloseable2 = c.createStatement();
            Object object = null;
            try {
                Statement s22 = (Statement)autoCloseable2;
                boolean bl2 = false;
                ResultSet resultSet = s22.executeQuery("SELECT 1");
                Intrinsics.checkNotNullExpressionValue((Object)resultSet, (String)"executeQuery(...)");
                int s22 = JdbcExtensionsKt.uniqueInt(resultSet);
            }
            catch (Throwable s22) {
                object = s22;
                throw s22;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable2, (Throwable)object);
            }
            if (!(s22 == 1)) {
                object = "Check failed.";
                throw new IllegalStateException(object.toString());
            }
            if (this.config.getType().isVitess()) {
                List list;
                autoCloseable2 = c.createStatement();
                object = null;
                try {
                    Statement s = (Statement)autoCloseable2;
                    boolean bl3 = false;
                    ResultSet resultSet = s.executeQuery("SHOW VITESS_SHARDS");
                    Intrinsics.checkNotNullExpressionValue((Object)resultSet, (String)"executeQuery(...)");
                    list = JdbcExtensionsKt.map(resultSet, connectToDataSource.1.2.1.INSTANCE);
                }
                catch (Throwable throwable2) {
                    object = throwable2;
                    throw throwable2;
                }
                finally {
                    AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable2, (Throwable)object);
                }
                if (!(!((Collection)list).isEmpty())) {
                    object = "Check failed.";
                    throw new IllegalStateException(object.toString());
                }
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable3) {
            throwable = throwable3;
            throw throwable3;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }

    private final DriverDataSource createDataSource(String jdbcUrl) {
        return new DriverDataSource(jdbcUrl, this.config.getType().getDriverClassName(), new Properties(), this.config.getUsername(), this.config.getPassword());
    }

    private final Connection connect(DriverDataSource $this$connect) {
        return $this$connect.getConnection();
    }

    private final String describe(Exception $this$describe, String jdbcUrl) {
        String string = $this$describe.getMessage();
        return (string != null ? StringsKt.contains$default((CharSequence)string, (CharSequence)"table dual not found", (boolean)false, (int)2, null) : false) ? "Something is wrong with your vschema and unfortunately vtcombo does not currently have good error reporting on this. Please do an ocular inspection." : "Problem pinging url " + jdbcUrl;
    }

    protected void shutDown() {
    }

    public static final /* synthetic */ void access$connectToDataSource(PingDatabaseService $this, DriverDataSource dataSource) {
        $this.connectToDataSource(dataSource);
    }

    public static final /* synthetic */ DataSourceConfig access$getConfig$p(PingDatabaseService $this) {
        return $this.config;
    }

    public static final /* synthetic */ DriverDataSource access$createDataSource(PingDatabaseService $this, String jdbcUrl) {
        return $this.createDataSource(jdbcUrl);
    }

    public static final /* synthetic */ Deployment access$getDeployment$p(PingDatabaseService $this) {
        return $this.deployment;
    }

    public static final /* synthetic */ String access$describe(PingDatabaseService $this, Exception $receiver, String jdbcUrl) {
        return $this.describe($receiver, jdbcUrl);
    }
}

