/*
 * Decompiled with CFR 0.152.
 */
package misk.jdbc;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Stopwatch;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableList;
import java.lang.annotation.Annotation;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import misk.jdbc.DataSourceConfig;
import misk.jdbc.DataSourceConnector;
import misk.jdbc.DataSourceService;
import misk.jdbc.MigrationState;
import misk.jdbc.NamedspacedMigration;
import misk.jdbc.SchemaMigrator;
import misk.jdbc.SchemaMigratorKt;
import misk.jdbc.ShardMigrationState;
import misk.resources.ResourceLoader;
import misk.vitess.ConnectionExtensionsKt;
import misk.vitess.Keyspace;
import misk.vitess.Shard;
import misk.vitess.ShardsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u001b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B5\u0012\u000e\u0010\u0002\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\u0006\u0010\u0017\u001a\u00020\u0011J\u001c\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015J\u0014\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\u0006\u0010\u001d\u001a\u00020\u001eJ\u0016\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u001b0 2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015J\u0006\u0010\"\u001a\u00020\u0019J\u0015\u0010\"\u001a\u00020#2\u0006\u0010\u0017\u001a\u00020\u0011H\u0001\u00a2\u0006\u0002\b$R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0002\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\u000e\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00110\u00100\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006%"}, d2={"Lmisk/jdbc/SchemaMigrator;", "", "qualifier", "Lkotlin/reflect/KClass;", "", "resourceLoader", "Lmisk/resources/ResourceLoader;", "dataSourceConfig", "Lmisk/jdbc/DataSourceConfig;", "dataSourceService", "Lmisk/jdbc/DataSourceService;", "connector", "Lmisk/jdbc/DataSourceConnector;", "(Lkotlin/reflect/KClass;Lmisk/resources/ResourceLoader;Lmisk/jdbc/DataSourceConfig;Lmisk/jdbc/DataSourceService;Lmisk/jdbc/DataSourceConnector;)V", "shards", "Lcom/google/common/base/Supplier;", "", "Lmisk/vitess/Shard;", "getShards", "()Lcom/google/common/base/Supplier;", "appliedMigrations", "Ljava/util/SortedSet;", "Lmisk/jdbc/NamedspacedMigration;", "shard", "applyAll", "Lmisk/jdbc/MigrationState;", "author", "", "availableMigrations", "keyspace", "Lmisk/vitess/Keyspace;", "getMigrationsResources", "", "initialize", "requireAll", "Lmisk/jdbc/ShardMigrationState;", "requireAll$misk_jdbc", "misk-jdbc"})
@SourceDebugExtension(value={"SMAP\nSchemaMigrator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SchemaMigrator.kt\nmisk/jdbc/SchemaMigrator\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,326:1\n766#2:327\n857#2,2:328\n766#2:330\n857#2:331\n2624#2,3:332\n858#2:335\n1549#2:336\n1620#2,3:337\n1855#2,2:340\n766#2:342\n857#2,2:343\n1726#2,3:346\n1446#2,5:349\n1#3:345\n*S KotlinDebug\n*F\n+ 1 SchemaMigrator.kt\nmisk/jdbc/SchemaMigrator\n*L\n130#1:327\n130#1:328,2\n131#1:330\n131#1:331\n132#1:332,3\n131#1:335\n135#1:336\n135#1:337,3\n142#1:340,2\n152#1:342\n152#1:343,2\n160#1:346,3\n164#1:349,5\n*E\n"})
public final class SchemaMigrator {
    @NotNull
    private final KClass<? extends Annotation> qualifier;
    @NotNull
    private final ResourceLoader resourceLoader;
    @NotNull
    private final DataSourceConfig dataSourceConfig;
    @NotNull
    private final DataSourceService dataSourceService;
    @NotNull
    private final DataSourceConnector connector;
    @NotNull
    private final Supplier<Set<Shard>> shards;

    public SchemaMigrator(@NotNull KClass<? extends Annotation> qualifier, @NotNull ResourceLoader resourceLoader, @NotNull DataSourceConfig dataSourceConfig, @NotNull DataSourceService dataSourceService, @NotNull DataSourceConnector connector) {
        Intrinsics.checkNotNullParameter(qualifier, (String)"qualifier");
        Intrinsics.checkNotNullParameter((Object)resourceLoader, (String)"resourceLoader");
        Intrinsics.checkNotNullParameter((Object)dataSourceConfig, (String)"dataSourceConfig");
        Intrinsics.checkNotNullParameter((Object)dataSourceService, (String)"dataSourceService");
        Intrinsics.checkNotNullParameter((Object)connector, (String)"connector");
        this.qualifier = qualifier;
        this.resourceLoader = resourceLoader;
        this.dataSourceConfig = dataSourceConfig;
        this.dataSourceService = dataSourceService;
        this.connector = connector;
        this.shards = ShardsKt.shards(this.dataSourceService);
    }

    @NotNull
    public final Supplier<Set<Shard>> getShards() {
        return this.shards;
    }

    private final List<String> getMigrationsResources(Keyspace keyspace) {
        DataSourceConfig config = this.connector.config();
        ImmutableList.Builder migrationsResources = ImmutableList.builder();
        if (config.getMigrations_resource() != null) {
            migrationsResources.add((Object)config.getMigrations_resource());
        }
        if (config.getMigrations_resources() != null) {
            migrationsResources.addAll((Iterable)config.getMigrations_resources());
        }
        if (config.getVitess_schema_resource_root() != null) {
            migrationsResources.add((Object)(config.getVitess_schema_resource_root() + "/" + keyspace.getName()));
        }
        ImmutableList immutableList = migrationsResources.build();
        Intrinsics.checkNotNullExpressionValue((Object)immutableList, (String)"build(...)");
        return (List)immutableList;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final SortedSet<NamedspacedMigration> availableMigrations(@NotNull Keyspace keyspace) {
        void $this$filterTo$iv$iv;
        Iterator iterator;
        Intrinsics.checkNotNullParameter((Object)keyspace, (String)"keyspace");
        List migrations = new ArrayList();
        for (String migrationsResource : this.getMigrationsResources(keyspace)) {
            void $this$mapTo$iv$iv;
            Iterator $this$map$iv;
            String resource;
            String it;
            Object element$iv$iv;
            Object $this$filterTo$iv$iv2;
            Iterable $this$filter$iv;
            Iterable iterable = this.resourceLoader.walk(migrationsResource);
            boolean $i$f$filter = false;
            void var8_15 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            iterator = $this$filterTo$iv$iv2.iterator();
            while (iterator.hasNext()) {
                element$iv$iv = iterator.next();
                it = (String)element$iv$iv;
                boolean bl = false;
                if (!StringsKt.endsWith$default((String)it, (String)".sql", (boolean)false, (int)2, null)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            $i$f$filter = false;
            $this$filterTo$iv$iv2 = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            $i$f$filterTo = false;
            iterator = $this$filterTo$iv$iv2.iterator();
            while (iterator.hasNext()) {
                boolean bl;
                block13: {
                    element$iv$iv = iterator.next();
                    resource = (String)element$iv$iv;
                    boolean bl2 = false;
                    List<String> list = this.connector.config().getMigrations_resources_exclusion();
                    if (list != null) {
                        Iterable $this$none$iv = list;
                        boolean $i$f$none = false;
                        if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                            bl = true;
                        } else {
                            for (Object element$iv : $this$none$iv) {
                                String excludedResource = (String)element$iv;
                                boolean bl3 = false;
                                if (!StringsKt.contains$default((CharSequence)resource, (CharSequence)excludedResource, (boolean)false, (int)2, null)) continue;
                                bl = false;
                                break block13;
                            }
                            bl = true;
                        }
                    } else {
                        bl = true;
                    }
                }
                if (!bl) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$map = false;
            $this$filterTo$iv$iv2 = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                resource = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(NamedspacedMigration.Companion.fromResourcePath(it, migrationsResource, this.connector.config().getMigrations_resources_regex()));
            }
            List migrationsFound = (List)destination$iv$iv;
            migrations.addAll(migrationsFound);
        }
        TreeMap migrationMap = new TreeMap();
        Iterable $this$forEach$iv = migrations;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            NamedspacedMigration it = (NamedspacedMigration)element$iv;
            boolean bl = false;
            List previousValue = (List)migrationMap.get(it);
            if (previousValue == null) {
                Object item$iv$iv;
                iterator = migrationMap;
                item$iv$iv = new NamedspacedMigration[]{it};
                item$iv$iv = CollectionsKt.mutableListOf((Object[])item$iv$iv);
                iterator.put(it, item$iv$iv);
                continue;
            }
            previousValue.add(it);
        }
        Collection collection = migrationMap.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
        Iterable $this$filter$iv = collection;
        boolean $i$f$filter = false;
        Iterable element$iv = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            List it = (List)element$iv$iv;
            boolean bl = false;
            if (!(it.size() > 1)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List duplicates = (List)destination$iv$iv;
        if (!duplicates.isEmpty()) {
            boolean bl = false;
            String string = "Duplicate migrations found " + duplicates;
            throw new IllegalArgumentException(string.toString());
        }
        NavigableSet navigableSet = migrationMap.navigableKeySet();
        Intrinsics.checkNotNullExpressionValue(navigableSet, (String)"navigableKeySet(...)");
        return navigableSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @NotNull
    public final SortedSet<NamedspacedMigration> initialize() {
        void var3_3;
        void $this$flatMapTo$iv;
        boolean noMigrations;
        Iterable $this$all$iv;
        block12: {
            boolean bl;
            Object object = this.shards.get();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
            $this$all$iv = (Iterable)object;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    Shard shard = (Shard)element$iv;
                    boolean bl2 = false;
                    if (this.getMigrationsResources(shard.getKeyspace()).isEmpty()) continue;
                    bl = false;
                    break block12;
                }
                bl = noMigrations = true;
            }
        }
        if (noMigrations) {
            return SetsKt.sortedSetOf((Object[])new NamedspacedMigration[0]);
        }
        Object object = this.shards.get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        $this$all$iv = (Iterable)object;
        Collection destination$iv = new TreeSet();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv : $this$flatMapTo$iv) {
            Shard shard = (Shard)element$iv;
            boolean bl = false;
            try {
                SortedSet<NamedspacedMigration> result = this.appliedMigrations(shard);
                SchemaMigratorKt.access$getLogger$p().info((Function0)new Function0<Object>(this, result){
                    final /* synthetic */ SchemaMigrator this$0;
                    final /* synthetic */ SortedSet<NamedspacedMigration> $result;
                    {
                        this.this$0 = $receiver;
                        this.$result = $result;
                        super(0);
                    }

                    @Nullable
                    public final Object invoke() {
                        return SchemaMigrator.access$getQualifier$p(this.this$0).getSimpleName() + " has " + this.$result.size() + " migrations applied; latest is " + CollectionsKt.lastOrNull((Iterable)this.$result);
                    }
                });
                return result;
            }
            catch (SQLException e) {
                TreeSet treeSet;
                AutoCloseable autoCloseable = this.dataSourceService.getDataSource().getConnection();
                Throwable throwable = null;
                try {
                    Connection it = (Connection)autoCloseable;
                    boolean bl3 = false;
                    Intrinsics.checkNotNull((Object)it);
                    ConnectionExtensionsKt.target(it, shard, initialize.1.2.1.INSTANCE);
                    treeSet = SetsKt.sortedSetOf((Object[])new NamedspacedMigration[0]);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
                }
                Iterable list$iv = treeSet;
                CollectionsKt.addAll((Collection)destination$iv, (Iterable)list$iv);
            }
        }
        return (SortedSet)var3_3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final SortedSet<NamedspacedMigration> appliedMigrations(@NotNull Shard shard) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)shard, (String)"shard");
        Function1 listMigrations2 = appliedMigrations.listMigrations.1.INSTANCE;
        if (this.dataSourceConfig.getType().isVitess()) {
            AutoCloseable autoCloseable = this.dataSourceService.getDataSource().getConnection();
            Throwable throwable = null;
            try {
                Object it = (Connection)autoCloseable;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)it);
                it = (SortedSet)ConnectionExtensionsKt.failSafeRead((Connection)it, shard, listMigrations2);
                object = it;
            }
            catch (Throwable it) {
                throwable = it;
                throw it;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
            }
        }
        AutoCloseable autoCloseable = this.dataSourceService.getDataSource().getConnection();
        Throwable throwable = null;
        try {
            Connection it = (Connection)autoCloseable;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            SortedSet sortedSet = (SortedSet)listMigrations2.invoke((Object)it);
            object = sortedSet;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final MigrationState applyAll(@NotNull String author, @NotNull SortedSet<NamedspacedMigration> appliedMigrations2) {
        Intrinsics.checkNotNullParameter((Object)author, (String)"author");
        Intrinsics.checkNotNullParameter(appliedMigrations2, (String)"appliedMigrations");
        CharSequence charSequence = author;
        if (!new Regex("\\w+").matches(charSequence)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        Map result = new LinkedHashMap();
        for (Shard shard : (Set)this.shards.get()) {
            SortedSet<NamedspacedMigration> availableMigrations = this.availableMigrations(shard.getKeyspace());
            ShardMigrationState shardMigrationState = new ShardMigrationState(availableMigrations, appliedMigrations2);
            for (NamedspacedMigration migration : shardMigrationState.missingMigrations()) {
                String migrationSql = this.resourceLoader.utf8(migration.getPath());
                Stopwatch stopwatch = Stopwatch.createStarted();
                AutoCloseable autoCloseable = this.dataSourceService.getDataSource().getConnection();
                Throwable throwable = null;
                try {
                    Connection it = (Connection)autoCloseable;
                    boolean bl = false;
                    Intrinsics.checkNotNull((Object)it);
                    ConnectionExtensionsKt.target(it, shard, (Function1)new Function1<Connection, Unit>(migrationSql, migration, author){
                        final /* synthetic */ String $migrationSql;
                        final /* synthetic */ NamedspacedMigration $migration;
                        final /* synthetic */ String $author;
                        {
                            this.$migrationSql = $migrationSql;
                            this.$migration = $migration;
                            this.$author = $author;
                            super(1);
                        }

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public final void invoke(@NotNull Connection c) {
                            Object object;
                            Intrinsics.checkNotNullParameter((Object)c, (String)"c");
                            AutoCloseable autoCloseable = c.createStatement();
                            Object object2 = this.$migrationSql;
                            Object object3 = null;
                            try {
                                Statement migrationStatement = (Statement)autoCloseable;
                                boolean bl = false;
                                migrationStatement.addBatch((String)object2);
                                object = migrationStatement.executeBatch();
                            }
                            catch (Throwable throwable) {
                                object3 = throwable;
                                throw throwable;
                            }
                            finally {
                                AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)object3);
                            }
                            autoCloseable = c.prepareStatement("INSERT INTO schema_version (version, installed_by) VALUES (?, ?);\n");
                            object2 = this.$migration;
                            object3 = this.$author;
                            object = null;
                            try {
                                PreparedStatement schemaVersion = (PreparedStatement)autoCloseable;
                                boolean bl = false;
                                schemaVersion.setString(1, ((NamedspacedMigration)object2).toNamespacedVersion());
                                schemaVersion.setString(2, (String)object3);
                                int n = schemaVersion.executeUpdate();
                            }
                            catch (Throwable throwable) {
                                object = throwable;
                                throw throwable;
                            }
                            finally {
                                AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)object);
                            }
                            c.commit();
                        }
                    });
                    SchemaMigratorKt.access$getLogger$p().info((Function0)new Function0<Object>(this, migration, stopwatch){
                        final /* synthetic */ SchemaMigrator this$0;
                        final /* synthetic */ NamedspacedMigration $migration;
                        final /* synthetic */ Stopwatch $stopwatch;
                        {
                            this.this$0 = $receiver;
                            this.$migration = $migration;
                            this.$stopwatch = $stopwatch;
                            super(0);
                        }

                        @Nullable
                        public final Object invoke() {
                            return SchemaMigrator.access$getQualifier$p(this.this$0).getSimpleName() + " applied " + this.$migration + " in " + this.$stopwatch;
                        }
                    });
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
                }
            }
            result.put(shard, new ShardMigrationState(availableMigrations, new TreeSet(SetsKt.plus((Set)appliedMigrations2, (Iterable)availableMigrations))));
        }
        return new MigrationState(result);
    }

    @NotNull
    public final MigrationState requireAll() {
        try {
            Map result = new LinkedHashMap();
            for (Shard it : (Set)this.shards.get()) {
                result.put(it, this.requireAll$misk_jdbc(it));
            }
            return new MigrationState(result);
        }
        catch (SQLException e) {
            throw new IllegalStateException(this.qualifier.getSimpleName() + " is not ready", e);
        }
    }

    @VisibleForTesting
    @NotNull
    public final ShardMigrationState requireAll$misk_jdbc(@NotNull Shard shard) {
        Intrinsics.checkNotNullParameter((Object)shard, (String)"shard");
        SortedSet<NamedspacedMigration> availableMigrations = this.availableMigrations(shard.getKeyspace());
        SortedSet<NamedspacedMigration> appliedMigrations2 = this.appliedMigrations(shard);
        ShardMigrationState state = new ShardMigrationState(availableMigrations, appliedMigrations2);
        Set<NamedspacedMigration> missingMigrations = state.missingMigrations();
        if (!missingMigrations.isEmpty()) {
            boolean bl = false;
            Object shardMessage = !Intrinsics.areEqual((Object)shard, (Object)Shard.Companion.getSINGLE_SHARD()) ? " shard " + shard : "";
            Set qualifiedAppliedMigrations = SetsKt.minus((Set)availableMigrations, (Iterable)missingMigrations);
            String string = StringsKt.trimMargin$default((String)("\n          |" + this.qualifier.getSimpleName() + (String)shardMessage + " has applied migrations:\n          |  " + CollectionsKt.joinToString$default((Iterable)qualifiedAppliedMigrations, (CharSequence)"\n  ", null, null, (int)0, null, (Function1)requireAll.1.1.INSTANCE, (int)30, null) + "\n\t        |" + this.qualifier.getSimpleName() + (String)shardMessage + " is missing migrations:\n          |  " + CollectionsKt.joinToString$default((Iterable)missingMigrations, (CharSequence)"\n  ", null, null, (int)0, null, (Function1)requireAll.1.2.INSTANCE, (int)30, null) + "\n          "), null, (int)1, null);
            throw new IllegalStateException(string.toString());
        }
        return state;
    }

    public static final /* synthetic */ KClass access$getQualifier$p(SchemaMigrator $this) {
        return $this.qualifier;
    }
}

