/*
 * Decompiled with CFR 0.152.
 */
package misk.jdbc;

import com.google.common.util.concurrent.AbstractIdleService;
import com.google.common.util.concurrent.Service;
import com.google.inject.Provider;
import java.lang.annotation.Annotation;
import java.time.Duration;
import java.util.SortedSet;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KClass;
import misk.backoff.Backoff;
import misk.backoff.ExponentialBackoff;
import misk.backoff.RetriesKt;
import misk.healthchecks.HealthCheck;
import misk.healthchecks.HealthStatus;
import misk.jdbc.DataSourceConnector;
import misk.jdbc.DataSourceType;
import misk.jdbc.DatabaseReadyService;
import misk.jdbc.MigrationState;
import misk.jdbc.NamedspacedMigration;
import misk.jdbc.SchemaMigrator;
import org.jetbrains.annotations.NotNull;
import wisp.deployment.Deployment;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u001b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B;\b\u0000\u0012\u000e\u0010\u0004\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u0012\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\n\u00a2\u0006\u0002\u0010\u000eJ\b\u0010\u0011\u001a\u00020\u0012H\u0014J\b\u0010\u0013\u001a\u00020\u0012H\u0014J\b\u0010\u0014\u001a\u00020\u0015H\u0016R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082.\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0004\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lmisk/jdbc/SchemaMigratorService;", "Lcom/google/common/util/concurrent/AbstractIdleService;", "Lmisk/healthchecks/HealthCheck;", "Lmisk/jdbc/DatabaseReadyService;", "qualifier", "Lkotlin/reflect/KClass;", "", "deployment", "Lwisp/deployment/Deployment;", "schemaMigratorProvider", "Lcom/google/inject/Provider;", "Lmisk/jdbc/SchemaMigrator;", "connectorProvider", "Lmisk/jdbc/DataSourceConnector;", "(Lkotlin/reflect/KClass;Lwisp/deployment/Deployment;Lcom/google/inject/Provider;Lcom/google/inject/Provider;)V", "migrationState", "Lmisk/jdbc/MigrationState;", "shutDown", "", "startUp", "status", "Lmisk/healthchecks/HealthStatus;", "misk-jdbc"})
public final class SchemaMigratorService
extends AbstractIdleService
implements HealthCheck,
DatabaseReadyService {
    @NotNull
    private final KClass<? extends Annotation> qualifier;
    @NotNull
    private final Deployment deployment;
    @NotNull
    private final Provider<SchemaMigrator> schemaMigratorProvider;
    @NotNull
    private final Provider<DataSourceConnector> connectorProvider;
    private MigrationState migrationState;

    public SchemaMigratorService(@NotNull KClass<? extends Annotation> qualifier, @NotNull Deployment deployment, @NotNull Provider<SchemaMigrator> schemaMigratorProvider, @NotNull Provider<DataSourceConnector> connectorProvider) {
        Intrinsics.checkNotNullParameter(qualifier, (String)"qualifier");
        Intrinsics.checkNotNullParameter((Object)deployment, (String)"deployment");
        Intrinsics.checkNotNullParameter(schemaMigratorProvider, (String)"schemaMigratorProvider");
        Intrinsics.checkNotNullParameter(connectorProvider, (String)"connectorProvider");
        this.qualifier = qualifier;
        this.deployment = deployment;
        this.schemaMigratorProvider = schemaMigratorProvider;
        this.connectorProvider = connectorProvider;
    }

    protected void startUp() {
        SchemaMigrator schemaMigrator = (SchemaMigrator)this.schemaMigratorProvider.get();
        DataSourceConnector connector = (DataSourceConnector)this.connectorProvider.get();
        if (this.deployment.isTest() || this.deployment.isLocalDevelopment()) {
            DataSourceType type = connector.config().getType();
            if (type != DataSourceType.VITESS_MYSQL) {
                Duration duration = Duration.ofMillis(100L);
                Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"ofMillis(...)");
                Duration duration2 = Duration.ofSeconds(5L);
                Intrinsics.checkNotNullExpressionValue((Object)duration2, (String)"ofSeconds(...)");
                RetriesKt.retry$default((int)10, (Backoff)((Backoff)new ExponentialBackoff(duration, duration2)), null, (Function1)((Function1)new Function1<Integer, Unit>(schemaMigrator, this){
                    final /* synthetic */ SchemaMigrator $schemaMigrator;
                    final /* synthetic */ SchemaMigratorService this$0;
                    {
                        this.$schemaMigrator = $schemaMigrator;
                        this.this$0 = $receiver;
                        super(1);
                    }

                    public final void invoke(int it) {
                        SortedSet<NamedspacedMigration> appliedMigrations2 = this.$schemaMigrator.initialize();
                        SchemaMigratorService.access$setMigrationState$p(this.this$0, this.$schemaMigrator.applyAll("SchemaMigratorService", appliedMigrations2));
                    }
                }), (int)4, null);
            } else {
                this.migrationState = new MigrationState(MapsKt.emptyMap());
            }
        } else {
            this.migrationState = schemaMigrator.requireAll();
        }
    }

    protected void shutDown() {
    }

    @NotNull
    public HealthStatus status() {
        Service.State state = this.state();
        if (state != Service.State.RUNNING) {
            String[] stringArray = new String[]{"SchemaMigratorService: " + this.qualifier.getSimpleName() + " is " + state};
            return HealthStatus.Companion.unhealthy(stringArray);
        }
        String[] stringArray = new String[1];
        String string = this.qualifier.getSimpleName();
        MigrationState migrationState = this.migrationState;
        if (migrationState == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"migrationState");
            migrationState = null;
        }
        stringArray[0] = "SchemaMigratorService: " + string + " is migrated: " + migrationState;
        return HealthStatus.Companion.healthy(stringArray);
    }

    public static final /* synthetic */ void access$setMigrationState$p(SchemaMigratorService $this, MigrationState migrationState) {
        $this.migrationState = migrationState;
    }
}

