/*
 * Decompiled with CFR 0.152.
 */
package misk.jdbc;

import io.opentracing.Span;
import io.opentracing.SpanContext;
import io.opentracing.Tracer;
import io.opentracing.propagation.Format;
import javax.sql.DataSource;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import misk.jdbc.DataSourceConfig;
import misk.jdbc.DataSourceDecorator;
import misk.jdbc.DataSourceType;
import misk.jdbc.StringBuilderCarrier;
import net.ttddyy.dsproxy.support.ProxyDataSource;
import net.ttddyy.dsproxy.support.ProxyDataSourceBuilder;
import net.ttddyy.dsproxy.transform.QueryTransformer;
import net.ttddyy.dsproxy.transform.TransformInfo;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0017\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rH\u0016J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0012\u0010\u0013\u001a\u00020\u00102\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0016R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0013\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0016"}, d2={"Lmisk/jdbc/SpanInjector;", "Lnet/ttddyy/dsproxy/transform/QueryTransformer;", "Lmisk/jdbc/DataSourceDecorator;", "tracer", "Lio/opentracing/Tracer;", "config", "Lmisk/jdbc/DataSourceConfig;", "(Lio/opentracing/Tracer;Lmisk/jdbc/DataSourceConfig;)V", "getConfig", "()Lmisk/jdbc/DataSourceConfig;", "getTracer", "()Lio/opentracing/Tracer;", "decorate", "Ljavax/sql/DataSource;", "dataSource", "getContextString", "", "activeSpan", "Lio/opentracing/SpanContext;", "transformQuery", "transformInfo", "Lnet/ttddyy/dsproxy/transform/TransformInfo;", "misk-jdbc"})
public final class SpanInjector
implements QueryTransformer,
DataSourceDecorator {
    @Nullable
    private final Tracer tracer;
    @NotNull
    private final DataSourceConfig config;

    public SpanInjector(@Nullable Tracer tracer, @NotNull DataSourceConfig config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        this.tracer = tracer;
        this.config = config;
    }

    @Nullable
    public final Tracer getTracer() {
        return this.tracer;
    }

    @NotNull
    public final DataSourceConfig getConfig() {
        return this.config;
    }

    @Override
    @NotNull
    public DataSource decorate(@NotNull DataSource dataSource) {
        Intrinsics.checkNotNullParameter((Object)dataSource, (String)"dataSource");
        if (this.config.getType() != DataSourceType.VITESS_MYSQL || this.tracer == null) {
            return dataSource;
        }
        ProxyDataSource proxyDataSource = new ProxyDataSourceBuilder(dataSource).queryTransformer((QueryTransformer)this).build();
        Intrinsics.checkNotNullExpressionValue((Object)proxyDataSource, (String)"build(...)");
        return (DataSource)proxyDataSource;
    }

    @NotNull
    public String transformQuery(@Nullable TransformInfo transformInfo) {
        Tracer tracer = this.tracer;
        Object object = tracer != null ? tracer.activeSpan() : null;
        if (object == null) {
            TransformInfo transformInfo2 = transformInfo;
            String string = transformInfo2 != null ? transformInfo2.getQuery() : null;
            Intrinsics.checkNotNull((Object)string);
            return string;
        }
        Span activeSpan = object;
        SpanContext spanContext = activeSpan.context();
        Intrinsics.checkNotNullExpressionValue((Object)spanContext, (String)"context(...)");
        String string = this.getContextString(spanContext);
        TransformInfo transformInfo3 = transformInfo;
        String string2 = transformInfo3 != null ? transformInfo3.getQuery() : null;
        Intrinsics.checkNotNull((Object)string2);
        return "/*VT_SPAN_CONTEXT=" + string + "*/" + string2;
    }

    private final String getContextString(SpanContext activeSpan) {
        StringBuilderCarrier carrier = new StringBuilderCarrier();
        Tracer tracer = this.tracer;
        Intrinsics.checkNotNull((Object)tracer);
        tracer.inject(activeSpan, Format.Builtin.TEXT_MAP, (Object)carrier);
        return carrier.toString();
    }
}

