/*
 * Decompiled with CFR 0.152.
 */
package misk.vitess;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLRecoverableException;
import java.sql.Statement;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.internal.Intrinsics;
import misk.jdbc.DataSourceService;
import misk.jdbc.JdbcExtensionsKt;
import misk.vitess.Shard;
import misk.vitess.ShardsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000\u0016\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u001a\u0010\u0000\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u0005\u00a8\u0006\u0006"}, d2={"shards", "Lcom/google/common/base/Supplier;", "", "Lmisk/vitess/Shard;", "dataSourceService", "Lmisk/jdbc/DataSourceService;", "misk-jdbc"})
public final class ShardsKt {
    @NotNull
    public static final Supplier<Set<Shard>> shards(@NotNull DataSourceService dataSourceService) {
        Intrinsics.checkNotNullParameter((Object)dataSourceService, (String)"dataSourceService");
        Supplier supplier = Suppliers.memoizeWithExpiration(() -> ShardsKt.shards$lambda$2(dataSourceService), (long)5L, (TimeUnit)TimeUnit.MINUTES);
        Intrinsics.checkNotNullExpressionValue((Object)supplier, (String)"memoizeWithExpiration(...)");
        return supplier;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Set shards$lambda$2(DataSourceService $dataSourceService) {
        Set set;
        Intrinsics.checkNotNullParameter((Object)$dataSourceService, (String)"$dataSourceService");
        if (!$dataSourceService.config().getType().isVitess()) {
            set = (Set)Shard.Companion.getSINGLE_SHARD_SET();
        } else {
            AutoCloseable autoCloseable = $dataSourceService.getDataSource().getConnection();
            Throwable throwable = null;
            try {
                Set set2;
                Connection connection = (Connection)autoCloseable;
                boolean bl = false;
                AutoCloseable autoCloseable2 = connection.createStatement();
                Throwable throwable2 = null;
                try {
                    Statement s = (Statement)autoCloseable2;
                    boolean bl2 = false;
                    ResultSet resultSet = s.executeQuery("SHOW VITESS_SHARDS");
                    Intrinsics.checkNotNullExpressionValue((Object)resultSet, (String)"executeQuery(...)");
                    Set shards2 = CollectionsKt.toSet((Iterable)JdbcExtensionsKt.map(resultSet, shards.1.1.1.shards.1.INSTANCE));
                    if (shards2.isEmpty()) {
                        throw new SQLRecoverableException("Failed to load list of shards");
                    }
                    set2 = shards2;
                }
                catch (Throwable throwable3) {
                    throwable2 = throwable3;
                    throw throwable3;
                }
                finally {
                    AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable2, (Throwable)throwable2);
                }
                Set set3 = set2;
                set = set3;
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
            }
        }
        return set;
    }
}

