/*
 * Decompiled with CFR 0.152.
 */
package misk.vitess;

import com.google.common.base.Preconditions;
import com.google.common.primitives.Longs;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.util.Arrays;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import okio.ByteString;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u000e\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\nR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lmisk/vitess/VitessHash;", "", "()V", "NULL_KEY", "Ljavax/crypto/spec/SecretKeySpec;", "NULL_SALT", "Ljavax/crypto/spec/IvParameterSpec;", "TRIPLE_DES", "", "fromKeyspaceId", "", "keyspaceId", "Lokio/ByteString;", "toKeyspaceId", "id", "misk-jdbc"})
public final class VitessHash {
    @NotNull
    public static final VitessHash INSTANCE = new VitessHash();
    @NotNull
    private static final SecretKeySpec NULL_KEY = new SecretKeySpec(new byte[24], "DESede");
    @NotNull
    private static final IvParameterSpec NULL_SALT = new IvParameterSpec(new byte[8]);
    @NotNull
    private static final String TRIPLE_DES = "DESede/CBC/NoPadding";

    private VitessHash() {
    }

    @NotNull
    public final ByteString toKeyspaceId(long id) {
        try {
            Cipher tripleDes = Cipher.getInstance(TRIPLE_DES);
            Preconditions.checkState((tripleDes.getBlockSize() == 8 ? 1 : 0) != 0);
            tripleDes.init(1, (Key)NULL_KEY, NULL_SALT);
            byte[] byArray = tripleDes.doFinal(Longs.toByteArray((long)id));
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"doFinal(...)");
            byte[] byArray2 = byArray;
            return ByteString.Companion.of(Arrays.copyOf(byArray2, byArray2.length));
        }
        catch (GeneralSecurityException e) {
            throw new AssertionError("Should be fine", e);
        }
    }

    public final long fromKeyspaceId(@NotNull ByteString keyspaceId) {
        Intrinsics.checkNotNullParameter((Object)keyspaceId, (String)"keyspaceId");
        try {
            Cipher tripleDes = Cipher.getInstance(TRIPLE_DES);
            Preconditions.checkState((tripleDes.getBlockSize() == 8 ? 1 : 0) != 0);
            tripleDes.init(2, (Key)NULL_KEY, NULL_SALT);
            byte[] plaintextBlock = tripleDes.doFinal(keyspaceId.toByteArray());
            Preconditions.checkState((plaintextBlock.length == 8 ? 1 : 0) != 0);
            return Longs.fromByteArray((byte[])plaintextBlock);
        }
        catch (GeneralSecurityException e) {
            throw new AssertionError("Should be fine", e);
        }
    }
}

