/*
 * Decompiled with CFR 0.152.
 */
package misk.database;

import com.github.dockerjava.api.DockerClient;
import com.github.dockerjava.api.async.ResultCallback;
import com.github.dockerjava.api.command.CreateContainerCmd;
import com.github.dockerjava.api.model.Bind;
import com.github.dockerjava.api.model.Container;
import com.github.dockerjava.api.model.ExposedPort;
import com.github.dockerjava.api.model.Frame;
import com.github.dockerjava.api.model.Ports;
import com.github.dockerjava.api.model.Volume;
import com.github.dockerjava.core.async.ResultCallbackTemplate;
import com.squareup.moshi.Moshi;
import java.sql.Connection;
import java.sql.ResultSet;
import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import misk.backoff.Backoff;
import misk.backoff.DontRetryException;
import misk.backoff.ExponentialBackoff;
import misk.backoff.RetriesKt;
import misk.database.DatabaseServer;
import misk.database.DockerTidbCluster;
import misk.database.StartDatabaseServiceKt;
import misk.database.TidbCluster;
import misk.jdbc.DataSourceConfig;
import misk.jdbc.DataSourceType;
import misk.jdbc.JdbcExtensionsKt;
import misk.resources.ResourceLoader;
import mu.KLogger;
import mu.KotlinLogging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0002\b\b\u0018\u0000 02\u00020\u0001:\u000201B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0016\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00120 2\u0006\u0010!\u001a\u00020\"H\u0002J\b\u0010#\u001a\u00020\u0012H\u0002J\b\u0010$\u001a\u00020%H\u0002J\b\u0010&\u001a\u00020%H\u0016J\"\u0010'\u001a\u0004\u0018\u00010\u00122\u0006\u0010(\u001a\u00020\u00122\u0006\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020*H\u0002J\b\u0010,\u001a\u00020%H\u0016J\b\u0010-\u001a\u00020%H\u0016J\b\u0010.\u001a\u00020%H\u0002J\f\u0010/\u001a\u00020\u0012*\u00020\"H\u0002R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0016\u0010\u001b\u001a\n\u0018\u00010\u001cj\u0004\u0018\u0001`\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00062"}, d2={"Lmisk/database/DockerTidbCluster;", "Lmisk/database/DatabaseServer;", "moshi", "Lcom/squareup/moshi/Moshi;", "resourceLoader", "Lmisk/resources/ResourceLoader;", "config", "Lmisk/jdbc/DataSourceConfig;", "docker", "Lcom/github/dockerjava/api/DockerClient;", "(Lcom/squareup/moshi/Moshi;Lmisk/resources/ResourceLoader;Lmisk/jdbc/DataSourceConfig;Lcom/github/dockerjava/api/DockerClient;)V", "cluster", "Lmisk/database/TidbCluster;", "getCluster", "()Lmisk/database/TidbCluster;", "getConfig", "()Lmisk/jdbc/DataSourceConfig;", "containerId", "", "getDocker", "()Lcom/github/dockerjava/api/DockerClient;", "isRunning", "", "getMoshi", "()Lcom/squareup/moshi/Moshi;", "getResourceLoader", "()Lmisk/resources/ResourceLoader;", "startupFailure", "Ljava/lang/Exception;", "Lkotlin/Exception;", "stopContainerOnExit", "containerMismatches", "", "container", "Lcom/github/dockerjava/api/model/Container;", "containerName", "doStart", "", "pullImage", "shouldMatch", "description", "actual", "", "expected", "start", "stop", "waitUntilHealthy", "name", "Companion", "LogContainerResultCallback", "misk-jdbc"})
public final class DockerTidbCluster
implements DatabaseServer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Moshi moshi;
    @NotNull
    private final ResourceLoader resourceLoader;
    @NotNull
    private final DataSourceConfig config;
    @NotNull
    private final DockerClient docker;
    @NotNull
    private final TidbCluster cluster;
    @Nullable
    private String containerId;
    private boolean isRunning;
    private boolean stopContainerOnExit;
    @Nullable
    private Exception startupFailure;
    @NotNull
    private static final KLogger logger = KotlinLogging.INSTANCE.logger((Function0)Companion.logger.1.INSTANCE);
    @NotNull
    public static final String SHA = "431e8e71d3a02134297b4370abbb40b0bd2bc5aec0c42f12e4d4e03943b50910";
    @NotNull
    public static final String IMAGE = "pingcap/tidb@sha256:431e8e71d3a02134297b4370abbb40b0bd2bc5aec0c42f12e4d4e03943b50910";
    @NotNull
    public static final String CONTAINER_NAME = "misk-tidb-testing";
    @NotNull
    private static final AtomicBoolean imagePulled = new AtomicBoolean();

    public DockerTidbCluster(@NotNull Moshi moshi, @NotNull ResourceLoader resourceLoader, @NotNull DataSourceConfig config, @NotNull DockerClient docker) {
        Intrinsics.checkNotNullParameter((Object)moshi, (String)"moshi");
        Intrinsics.checkNotNullParameter((Object)resourceLoader, (String)"resourceLoader");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)docker, (String)"docker");
        this.moshi = moshi;
        this.resourceLoader = resourceLoader;
        this.config = config;
        this.docker = docker;
        this.cluster = new TidbCluster(this.resourceLoader, this.config);
        this.stopContainerOnExit = true;
    }

    @NotNull
    public final Moshi getMoshi() {
        return this.moshi;
    }

    @NotNull
    public final ResourceLoader getResourceLoader() {
        return this.resourceLoader;
    }

    @NotNull
    public final DataSourceConfig getConfig() {
        return this.config;
    }

    @NotNull
    public final DockerClient getDocker() {
        return this.docker;
    }

    @NotNull
    public final TidbCluster getCluster() {
        return this.cluster;
    }

    @Override
    public void start() {
        Exception startupFailure = this.startupFailure;
        if (startupFailure != null) {
            throw startupFailure;
        }
        if (this.isRunning) {
            return;
        }
        this.isRunning = true;
        try {
            this.doStart();
        }
        catch (Exception e) {
            this.startupFailure = e;
            throw e;
        }
    }

    @Override
    public void pullImage() {
        Companion.pullImage();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void doStart() {
        Volume[] mismatches;
        if (this.cluster.getConfig().getType() == DataSourceType.TIDB && this.cluster.getConfig().getPort() != null) {
            Integer n = this.cluster.getConfig().getPort();
            int n2 = this.cluster.getMysqlPort();
            if (n == null || n != n2) {
                throw new RuntimeException("Config port " + this.cluster.getConfig().getPort() + " has to match Tidb Docker container: " + this.cluster.getMysqlPort());
            }
        }
        Volume confVolume = new Volume("/etc/tidb");
        Object[] objectArray = new String[]{"-config=/etc/tidb/tidb.toml", "-config-strict"};
        Object[] cmd = objectArray;
        ExposedPort httpPort = ExposedPort.tcp((int)this.cluster.getHttpPort());
        ExposedPort mysqlPort = ExposedPort.tcp((int)this.cluster.getMysqlPort());
        Ports ports = new Ports();
        ports.bind(mysqlPort, Ports.Binding.bindPort((int)mysqlPort.getPort()));
        ports.bind(httpPort, Ports.Binding.bindPort((int)httpPort.getPort()));
        Container matchingContainer = null;
        Object object = this.docker.listContainersCmd().withNameFilter((Collection)CollectionsKt.listOf((Object)this.containerName())).withLimit(Integer.valueOf(1)).exec();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"exec(...)");
        Container runningContainer = (Container)CollectionsKt.firstOrNull((List)((List)object));
        if (runningContainer != null) {
            mismatches = this.containerMismatches(runningContainer);
            if (!mismatches.isEmpty()) {
                logger.info((Function0)new Function0<Object>(this, runningContainer, mismatches){
                    final /* synthetic */ DockerTidbCluster this$0;
                    final /* synthetic */ Container $runningContainer;
                    final /* synthetic */ List<String> $mismatches;
                    {
                        this.this$0 = $receiver;
                        this.$runningContainer = $runningContainer;
                        this.$mismatches = $mismatches;
                        super(0);
                    }

                    @Nullable
                    public final Object invoke() {
                        return "container named " + DockerTidbCluster.access$name(this.this$0, this.$runningContainer) + " does not match our requirements, force removing and starting a new one: " + CollectionsKt.joinToString$default((Iterable)this.$mismatches, (CharSequence)", ", null, null, (int)0, null, null, (int)62, null);
                    }
                });
                this.docker.removeContainerCmd(runningContainer.getId()).withForce(Boolean.valueOf(true)).exec();
            } else {
                matchingContainer = runningContainer;
            }
        }
        Container container = matchingContainer;
        String string = this.containerId = container != null ? container.getId() : null;
        if (this.containerId == null) {
            logger.info("Starting TiDB cluster");
            this.stopContainerOnExit = true;
            mismatches = new Volume[]{confVolume};
            CreateContainerCmd createContainerCmd = this.docker.createContainerCmd(IMAGE).withCmd(ArraysKt.toList((Object[])cmd)).withVolumes(mismatches);
            mismatches = new Bind[]{new Bind(((Object)this.cluster.getConfigDir().toAbsolutePath()).toString(), confVolume)};
            CreateContainerCmd createContainerCmd2 = createContainerCmd.withBinds((Bind[])mismatches);
            mismatches = new ExposedPort[]{mysqlPort, httpPort};
            String string2 = createContainerCmd2.withExposedPorts((ExposedPort[])mismatches).withPortBindings(ports).withTty(Boolean.valueOf(true)).withName(this.containerName()).exec().getId();
            Intrinsics.checkNotNull((Object)string2);
            String string3 = this.containerId = string2;
            Intrinsics.checkNotNull((Object)string3);
            String containerId = string3;
            this.docker.startContainerCmd(containerId).exec();
            ((LogContainerResultCallback)this.docker.logContainerCmd(containerId).withStdErr(Boolean.valueOf(true)).withStdOut(Boolean.valueOf(true)).withFollowStream(Boolean.valueOf(true)).withSince(Integer.valueOf(0)).exec((ResultCallback)new LogContainerResultCallback())).awaitStarted();
        }
        logger.info("Started TiDB with container id " + this.containerId);
        this.waitUntilHealthy();
        AutoCloseable autoCloseable = this.cluster.openConnection();
        Throwable throwable = null;
        try {
            Connection c = (Connection)autoCloseable;
            boolean bl = false;
            int n = c.createStatement().executeUpdate("SET GLOBAL time_zone = '+00:00'");
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }

    private final String containerName() {
        return CONTAINER_NAME;
    }

    private final List<String> containerMismatches(Container container) {
        Object[] objectArray = new String[3];
        objectArray[0] = this.shouldMatch("container name", this.name(container), this.containerName());
        String string = container.getState();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getState(...)");
        objectArray[1] = this.shouldMatch("container state", string, "running");
        String string2 = container.getImage();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getImage(...)");
        objectArray[2] = this.shouldMatch("container image", string2, IMAGE);
        return CollectionsKt.listOfNotNull((Object[])objectArray);
    }

    private final String shouldMatch(String description, Object actual, Object expected) {
        return !Intrinsics.areEqual((Object)expected, (Object)actual) ? description + " \"" + actual + "\" does not match \"" + expected + "\"" : null;
    }

    private final String name(Container $this$name) {
        String string;
        String[] stringArray = $this$name.getNames();
        Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"getNames(...)");
        String name = (String)ArraysKt.single((Object[])stringArray);
        Intrinsics.checkNotNull((Object)name);
        if (StringsKt.startsWith$default((String)name, (String)"/", (boolean)false, (int)2, null)) {
            String string2 = name.substring(1);
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
        } else {
            string = name;
        }
        return string;
    }

    private final void waitUntilHealthy() {
        try {
            Duration duration = Duration.ofSeconds(1L);
            Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"ofSeconds(...)");
            Duration duration2 = Duration.ofSeconds(5L);
            Intrinsics.checkNotNullExpressionValue((Object)duration2, (String)"ofSeconds(...)");
            RetriesKt.retry$default((int)20, (Backoff)((Backoff)new ExponentialBackoff(duration, duration2)), null, (Function1)((Function1)new Function1<Integer, Unit>(this){
                final /* synthetic */ DockerTidbCluster this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public final void invoke(int it) {
                    AutoCloseable autoCloseable = this.this$0.getCluster().openConnection();
                    Throwable throwable = null;
                    try {
                        Connection c = (Connection)autoCloseable;
                        boolean bl = false;
                        ResultSet resultSet = c.createStatement().executeQuery("SELECT 1");
                        Intrinsics.checkNotNullExpressionValue((Object)resultSet, (String)"executeQuery(...)");
                        int result = JdbcExtensionsKt.uniqueInt(resultSet);
                        if (!(result == 1)) {
                            String string = "Check failed.";
                            throw new IllegalStateException(string.toString());
                        }
                        Unit unit = Unit.INSTANCE;
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
                    }
                }
            }), (int)4, null);
        }
        catch (DontRetryException e) {
            throw new Exception(e.getMessage());
        }
        catch (Exception e) {
            throw new Exception("TiDB cluster failed to start up in time", e);
        }
    }

    @Override
    public void stop() {
        if (this.stopContainerOnExit) {
            logger.info("Stopping container because I started it, if you want to leave tidb running in the background run:\n\tdocker run -d -p 4000:4000 -p 10080:10080 pingcap/tidb@sha256:431e8e71d3a02134297b4370abbb40b0bd2bc5aec0c42f12e4d4e03943b50910");
            String containerId = this.containerId;
            if (containerId != null) {
                this.docker.killContainerCmd(containerId);
            }
        }
    }

    public static final /* synthetic */ String access$name(DockerTidbCluster $this, Container $receiver) {
        return $this.name($receiver);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\r\u001a\u00020\u000eR\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u000f"}, d2={"Lmisk/database/DockerTidbCluster$Companion;", "", "()V", "CONTAINER_NAME", "", "IMAGE", "SHA", "imagePulled", "Ljava/util/concurrent/atomic/AtomicBoolean;", "logger", "Lmu/KLogger;", "getLogger", "()Lmu/KLogger;", "pullImage", "", "misk-jdbc"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final KLogger getLogger() {
            return logger;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void pullImage() {
            if (imagePulled.get()) {
                return;
            }
            Companion companion = this;
            synchronized (companion) {
                boolean bl = false;
                if (imagePulled.get()) {
                    return;
                }
                if (StartDatabaseServiceKt.runCommand("docker images --digests | grep -q 431e8e71d3a02134297b4370abbb40b0bd2bc5aec0c42f12e4d4e03943b50910 || docker pull pingcap/tidb@sha256:431e8e71d3a02134297b4370abbb40b0bd2bc5aec0c42f12e4d4e03943b50910") != 0) {
                    Companion.getLogger().warn("Failed to pull TiDB docker image. Proceeding regardless.");
                }
                imagePulled.set(true);
                Unit unit = Unit.INSTANCE;
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0002H\u0016\u00a8\u0006\u0007"}, d2={"Lmisk/database/DockerTidbCluster$LogContainerResultCallback;", "Lcom/github/dockerjava/core/async/ResultCallbackTemplate;", "Lcom/github/dockerjava/api/model/Frame;", "()V", "onNext", "", "item", "misk-jdbc"})
    public static final class LogContainerResultCallback
    extends ResultCallbackTemplate<LogContainerResultCallback, Frame> {
        public void onNext(@NotNull Frame item) {
            Intrinsics.checkNotNullParameter((Object)item, (String)"item");
            KLogger kLogger = Companion.getLogger();
            byte[] byArray = item.getPayload();
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getPayload(...)");
            byte[] byArray2 = byArray;
            kLogger.info(((Object)StringsKt.trim((CharSequence)new String(byArray2, Charsets.UTF_8))).toString());
        }
    }
}

