/*
 * Decompiled with CFR 0.152.
 */
package misk.jdbc;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import misk.config.Redact;
import misk.jdbc.DataSourceType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import wisp.deployment.Deployment;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010$\n\u0002\b.\n\u0002\u0018\u0002\n\u0002\b,\b\u0086\b\u0018\u00002\u00020\u0001B\u008b\u0003\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u0005\u0012\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\u0005\u0012\n\b\u0003\u0010\n\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u000b\u001a\u00020\u0007\u0012\b\b\u0002\u0010\f\u001a\u00020\r\u0012\b\b\u0002\u0010\u000e\u001a\u00020\r\u0012\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\r\u0012\b\b\u0002\u0010\u0010\u001a\u00020\r\u0012\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\r\u0012\n\b\u0002\u0010\u0012\u001a\u0004\u0018\u00010\u0005\u0012\u0010\b\u0002\u0010\u0013\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u0014\u0012\u0010\b\u0002\u0010\u0015\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u0014\u0012\b\b\u0002\u0010\u0016\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0017\u001a\u0004\u0018\u00010\u0005\u0012\n\b\u0002\u0010\u0018\u001a\u0004\u0018\u00010\u0005\u0012\n\b\u0003\u0010\u0019\u001a\u0004\u0018\u00010\u0005\u0012\n\b\u0002\u0010\u001a\u001a\u0004\u0018\u00010\u0005\u0012\n\b\u0003\u0010\u001b\u001a\u0004\u0018\u00010\u0005\u0012\n\b\u0002\u0010\u001c\u001a\u0004\u0018\u00010\u0005\u0012\n\b\u0002\u0010\u001d\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u001e\u001a\u00020\u001f\u0012\u000e\b\u0002\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00050\u0014\u0012\n\b\u0002\u0010!\u001a\u0004\u0018\u00010\u0005\u0012\n\b\u0002\u0010\"\u001a\u0004\u0018\u00010\u0005\u0012\n\b\u0002\u0010#\u001a\u0004\u0018\u00010\u0007\u0012\b\b\u0002\u0010$\u001a\u00020\u001f\u0012\b\b\u0002\u0010%\u001a\u00020\u001f\u0012\u0014\b\u0002\u0010&\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010'\u0012\b\b\u0002\u0010(\u001a\u00020\u001f\u00a2\u0006\u0002\u0010)J\u0006\u0010S\u001a\u00020\u0000J\u000e\u0010T\u001a\u00020\u00052\u0006\u0010U\u001a\u00020VJ\u0006\u0010W\u001a\u00020\u001fJ\t\u0010X\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010Y\u001a\u0004\u0018\u00010\rH\u00c6\u0003J\t\u0010Z\u001a\u00020\rH\u00c6\u0003J\u000b\u0010[\u001a\u0004\u0018\u00010\rH\u00c6\u0003J\u000b\u0010\\\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\u0011\u0010]\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u0014H\u00c6\u0003J\u0011\u0010^\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u0014H\u00c6\u0003J\t\u0010_\u001a\u00020\u0005H\u00c6\u0003J\u000b\u0010`\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\u000b\u0010a\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\u000b\u0010b\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\u000b\u0010c\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\u000b\u0010d\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\u000b\u0010e\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\u000b\u0010f\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\u000b\u0010g\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\t\u0010h\u001a\u00020\u001fH\u00c6\u0003J\u000f\u0010i\u001a\b\u0012\u0004\u0012\u00020\u00050\u0014H\u00c6\u0003J\u000b\u0010j\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\u000b\u0010k\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\u0010\u0010l\u001a\u0004\u0018\u00010\u0007H\u00c6\u0003\u00a2\u0006\u0002\u0010<J\t\u0010m\u001a\u00020\u001fH\u00c6\u0003J\u0010\u0010n\u001a\u0004\u0018\u00010\u0007H\u00c6\u0003\u00a2\u0006\u0002\u0010<J\t\u0010o\u001a\u00020\u001fH\u00c6\u0003J\u0015\u0010p\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010'H\u00c6\u0003J\t\u0010q\u001a\u00020\u001fH\u00c6\u0003J\u000b\u0010r\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\u000b\u0010s\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\u000b\u0010t\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\t\u0010u\u001a\u00020\u0007H\u00c6\u0003J\t\u0010v\u001a\u00020\rH\u00c6\u0003J\t\u0010w\u001a\u00020\rH\u00c6\u0003J\u0094\u0003\u0010x\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u00072\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u00052\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\u00052\n\b\u0003\u0010\n\u001a\u0004\u0018\u00010\u00052\b\b\u0002\u0010\u000b\u001a\u00020\u00072\b\b\u0002\u0010\f\u001a\u00020\r2\b\b\u0002\u0010\u000e\u001a\u00020\r2\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\r2\b\b\u0002\u0010\u0010\u001a\u00020\r2\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\r2\n\b\u0002\u0010\u0012\u001a\u0004\u0018\u00010\u00052\u0010\b\u0002\u0010\u0013\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u00142\u0010\b\u0002\u0010\u0015\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u00142\b\b\u0002\u0010\u0016\u001a\u00020\u00052\n\b\u0002\u0010\u0017\u001a\u0004\u0018\u00010\u00052\n\b\u0002\u0010\u0018\u001a\u0004\u0018\u00010\u00052\n\b\u0003\u0010\u0019\u001a\u0004\u0018\u00010\u00052\n\b\u0002\u0010\u001a\u001a\u0004\u0018\u00010\u00052\n\b\u0003\u0010\u001b\u001a\u0004\u0018\u00010\u00052\n\b\u0002\u0010\u001c\u001a\u0004\u0018\u00010\u00052\n\b\u0002\u0010\u001d\u001a\u0004\u0018\u00010\u00052\b\b\u0002\u0010\u001e\u001a\u00020\u001f2\u000e\b\u0002\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00050\u00142\n\b\u0002\u0010!\u001a\u0004\u0018\u00010\u00052\n\b\u0002\u0010\"\u001a\u0004\u0018\u00010\u00052\n\b\u0002\u0010#\u001a\u0004\u0018\u00010\u00072\b\b\u0002\u0010$\u001a\u00020\u001f2\b\b\u0002\u0010%\u001a\u00020\u001f2\u0014\b\u0002\u0010&\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010'2\b\b\u0002\u0010(\u001a\u00020\u001fH\u00c6\u0001\u00a2\u0006\u0002\u0010yJ\u0013\u0010z\u001a\u00020\u001f2\b\u0010{\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\u001e\u0010|\u001a\u0004\u0018\u00010\u00052\b\u0010}\u001a\u0004\u0018\u00010\u00052\b\u0010~\u001a\u0004\u0018\u00010\u0005H\u0002J\t\u0010\u007f\u001a\u00020\u0007H\u00d6\u0001J\n\u0010\u0080\u0001\u001a\u00020\u0005H\u00d6\u0001J\u0007\u0010\u0081\u0001\u001a\u00020\u0000R\u0011\u0010%\u001a\u00020\u001f\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010+R\u0013\u0010\u001b\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b,\u0010-R\u0013\u0010\u001d\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b.\u0010-R\u0013\u0010\u001a\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b/\u0010-R\u0013\u0010\u000f\u001a\u0004\u0018\u00010\r\u00a2\u0006\b\n\u0000\u001a\u0004\b0\u00101R\u0011\u0010\u0010\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b2\u00101R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b3\u00101R\u0013\u0010\b\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b4\u0010-R\u0017\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00050\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b5\u00106R\u0011\u0010\u000b\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b7\u00108R\u0013\u0010\"\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b9\u0010-R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b:\u0010-R\u0015\u0010#\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\n\n\u0002\u0010=\u001a\u0004\b;\u0010<R\u001d\u0010&\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010'\u00a2\u0006\b\n\u0000\u001a\u0004\b>\u0010?R\u0013\u0010\u0012\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b@\u0010-R\u0019\u0010\u0013\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\bA\u00106R\u0019\u0010\u0015\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\bB\u00106R\u0011\u0010\u0016\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\bC\u0010-R\u0011\u0010(\u001a\u00020\u001f\u00a2\u0006\b\n\u0000\u001a\u0004\bD\u0010+R\u0013\u0010\n\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\bE\u0010-R\u0015\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\n\n\u0002\u0010=\u001a\u0004\bF\u0010<R\u0013\u0010\u0011\u001a\u0004\u0018\u00010\r\u00a2\u0006\b\n\u0000\u001a\u0004\bG\u00101R\u0013\u0010!\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\bH\u0010-R\u0013\u0010\u0019\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\bI\u0010-R\u0013\u0010\u001c\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\bJ\u0010-R\u0013\u0010\u0018\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\bK\u0010-R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\bL\u0010MR\u0011\u0010$\u001a\u00020\u001f\u00a2\u0006\b\n\u0000\u001a\u0004\bN\u0010+R\u0013\u0010\t\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\bO\u0010-R\u0011\u0010\u000e\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\bP\u00101R\u0011\u0010\u001e\u001a\u00020\u001f\u00a2\u0006\b\n\u0000\u001a\u0004\bQ\u0010+R\u0013\u0010\u0017\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\bR\u0010-\u00a8\u0006\u0082\u0001"}, d2={"Lmisk/jdbc/DataSourceConfig;", "", "type", "Lmisk/jdbc/DataSourceType;", "host", "", "port", "", "database", "username", "password", "fixed_pool_size", "connection_timeout", "Ljava/time/Duration;", "validation_timeout", "connection_idle_timeout", "connection_max_lifetime", "query_timeout", "migrations_resource", "migrations_resources", "", "migrations_resources_exclusion", "migrations_resources_regex", "vitess_schema_resource_root", "trust_certificate_key_store_url", "trust_certificate_key_store_password", "client_certificate_key_store_url", "client_certificate_key_store_password", "trust_certificate_key_store_path", "client_certificate_key_store_path", "verify_server_identity", "", "enabledTlsProtocols", "show_sql", "generate_hibernate_stats", "jdbc_statement_batch_size", "use_fixed_pool_size", "allow_public_key_retrieval", "jdbc_url_query_parameters", "", "mysql_enforce_writable_connections", "(Lmisk/jdbc/DataSourceType;Ljava/lang/String;Ljava/lang/Integer;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;ILjava/time/Duration;Ljava/time/Duration;Ljava/time/Duration;Ljava/time/Duration;Ljava/time/Duration;Ljava/lang/String;Ljava/util/List;Ljava/util/List;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;ZLjava/util/List;Ljava/lang/String;Ljava/lang/String;Ljava/lang/Integer;ZZLjava/util/Map;Z)V", "getAllow_public_key_retrieval", "()Z", "getClient_certificate_key_store_password", "()Ljava/lang/String;", "getClient_certificate_key_store_path", "getClient_certificate_key_store_url", "getConnection_idle_timeout", "()Ljava/time/Duration;", "getConnection_max_lifetime", "getConnection_timeout", "getDatabase", "getEnabledTlsProtocols", "()Ljava/util/List;", "getFixed_pool_size", "()I", "getGenerate_hibernate_stats", "getHost", "getJdbc_statement_batch_size", "()Ljava/lang/Integer;", "Ljava/lang/Integer;", "getJdbc_url_query_parameters", "()Ljava/util/Map;", "getMigrations_resource", "getMigrations_resources", "getMigrations_resources_exclusion", "getMigrations_resources_regex", "getMysql_enforce_writable_connections", "getPassword", "getPort", "getQuery_timeout", "getShow_sql", "getTrust_certificate_key_store_password", "getTrust_certificate_key_store_path", "getTrust_certificate_key_store_url", "getType", "()Lmisk/jdbc/DataSourceType;", "getUse_fixed_pool_size", "getUsername", "getValidation_timeout", "getVerify_server_identity", "getVitess_schema_resource_root", "asReplica", "buildJdbcUrl", "deployment", "Lwisp/deployment/Deployment;", "canRecoverOnReplica", "component1", "component10", "component11", "component12", "component13", "component14", "component15", "component16", "component17", "component18", "component19", "component2", "component20", "component21", "component22", "component23", "component24", "component25", "component26", "component27", "component28", "component29", "component3", "component30", "component31", "component32", "component4", "component5", "component6", "component7", "component8", "component9", "copy", "(Lmisk/jdbc/DataSourceType;Ljava/lang/String;Ljava/lang/Integer;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;ILjava/time/Duration;Ljava/time/Duration;Ljava/time/Duration;Ljava/time/Duration;Ljava/time/Duration;Ljava/lang/String;Ljava/util/List;Ljava/util/List;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;ZLjava/util/List;Ljava/lang/String;Ljava/lang/String;Ljava/lang/Integer;ZZLjava/util/Map;Z)Lmisk/jdbc/DataSourceConfig;", "equals", "other", "getStorePath", "url", "path", "hashCode", "toString", "withDefaults", "misk-jdbc"})
@SourceDebugExtension(value={"SMAP\nDataSourceConfig.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DataSourceConfig.kt\nmisk/jdbc/DataSourceConfig\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 FileReadWrite.kt\nkotlin/io/FilesKt__FileReadWriteKt\n+ 4 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,351:1\n1#2:352\n1#2:355\n230#3,2:353\n1247#4,2:356\n1855#5,2:358\n*S KotlinDebug\n*F\n+ 1 DataSourceConfig.kt\nmisk/jdbc/DataSourceConfig\n*L\n120#1:355\n120#1:353,2\n121#1:356,2\n261#1:358,2\n*E\n"})
public final class DataSourceConfig {
    @NotNull
    private final DataSourceType type;
    @Nullable
    private final String host;
    @Nullable
    private final Integer port;
    @Nullable
    private final String database;
    @Nullable
    private final String username;
    @Nullable
    private final String password;
    private final int fixed_pool_size;
    @NotNull
    private final Duration connection_timeout;
    @NotNull
    private final Duration validation_timeout;
    @Nullable
    private final Duration connection_idle_timeout;
    @NotNull
    private final Duration connection_max_lifetime;
    @Nullable
    private final Duration query_timeout;
    @Nullable
    private final String migrations_resource;
    @Nullable
    private final List<String> migrations_resources;
    @Nullable
    private final List<String> migrations_resources_exclusion;
    @NotNull
    private final String migrations_resources_regex;
    @Nullable
    private final String vitess_schema_resource_root;
    @Nullable
    private final String trust_certificate_key_store_url;
    @Nullable
    private final String trust_certificate_key_store_password;
    @Nullable
    private final String client_certificate_key_store_url;
    @Nullable
    private final String client_certificate_key_store_password;
    @Nullable
    private final String trust_certificate_key_store_path;
    @Nullable
    private final String client_certificate_key_store_path;
    private final boolean verify_server_identity;
    @NotNull
    private final List<String> enabledTlsProtocols;
    @Nullable
    private final String show_sql;
    @Nullable
    private final String generate_hibernate_stats;
    @Nullable
    private final Integer jdbc_statement_batch_size;
    private final boolean use_fixed_pool_size;
    private final boolean allow_public_key_retrieval;
    @NotNull
    private final Map<String, Object> jdbc_url_query_parameters;
    private final boolean mysql_enforce_writable_connections;

    @JvmOverloads
    public DataSourceConfig(@NotNull DataSourceType type, @Nullable String host, @Nullable Integer port, @Nullable String database, @Nullable String username, @Redact @Nullable String password, int fixed_pool_size, @NotNull Duration connection_timeout, @NotNull Duration validation_timeout, @Nullable Duration connection_idle_timeout, @NotNull Duration connection_max_lifetime, @Nullable Duration query_timeout, @Nullable String migrations_resource, @Nullable List<String> migrations_resources, @Nullable List<String> migrations_resources_exclusion, @NotNull String migrations_resources_regex, @Nullable String vitess_schema_resource_root, @Nullable String trust_certificate_key_store_url, @Redact @Nullable String trust_certificate_key_store_password, @Nullable String client_certificate_key_store_url, @Redact @Nullable String client_certificate_key_store_password, @Nullable String trust_certificate_key_store_path, @Nullable String client_certificate_key_store_path, boolean verify_server_identity, @NotNull List<String> enabledTlsProtocols, @Nullable String show_sql, @Nullable String generate_hibernate_stats, @Nullable Integer jdbc_statement_batch_size, boolean use_fixed_pool_size, boolean allow_public_key_retrieval, @NotNull Map<String, ? extends Object> jdbc_url_query_parameters, boolean mysql_enforce_writable_connections) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        Intrinsics.checkNotNullParameter((Object)connection_timeout, (String)"connection_timeout");
        Intrinsics.checkNotNullParameter((Object)validation_timeout, (String)"validation_timeout");
        Intrinsics.checkNotNullParameter((Object)connection_max_lifetime, (String)"connection_max_lifetime");
        Intrinsics.checkNotNullParameter((Object)migrations_resources_regex, (String)"migrations_resources_regex");
        Intrinsics.checkNotNullParameter(enabledTlsProtocols, (String)"enabledTlsProtocols");
        Intrinsics.checkNotNullParameter(jdbc_url_query_parameters, (String)"jdbc_url_query_parameters");
        this.type = type;
        this.host = host;
        this.port = port;
        this.database = database;
        this.username = username;
        this.password = password;
        this.fixed_pool_size = fixed_pool_size;
        this.connection_timeout = connection_timeout;
        this.validation_timeout = validation_timeout;
        this.connection_idle_timeout = connection_idle_timeout;
        this.connection_max_lifetime = connection_max_lifetime;
        this.query_timeout = query_timeout;
        this.migrations_resource = migrations_resource;
        this.migrations_resources = migrations_resources;
        this.migrations_resources_exclusion = migrations_resources_exclusion;
        this.migrations_resources_regex = migrations_resources_regex;
        this.vitess_schema_resource_root = vitess_schema_resource_root;
        this.trust_certificate_key_store_url = trust_certificate_key_store_url;
        this.trust_certificate_key_store_password = trust_certificate_key_store_password;
        this.client_certificate_key_store_url = client_certificate_key_store_url;
        this.client_certificate_key_store_password = client_certificate_key_store_password;
        this.trust_certificate_key_store_path = trust_certificate_key_store_path;
        this.client_certificate_key_store_path = client_certificate_key_store_path;
        this.verify_server_identity = verify_server_identity;
        this.enabledTlsProtocols = enabledTlsProtocols;
        this.show_sql = show_sql;
        this.generate_hibernate_stats = generate_hibernate_stats;
        this.jdbc_statement_batch_size = jdbc_statement_batch_size;
        this.use_fixed_pool_size = use_fixed_pool_size;
        this.allow_public_key_retrieval = allow_public_key_retrieval;
        this.jdbc_url_query_parameters = jdbc_url_query_parameters;
        this.mysql_enforce_writable_connections = mysql_enforce_writable_connections;
    }

    public /* synthetic */ DataSourceConfig(DataSourceType dataSourceType, String string, Integer n, String string2, String string3, String string4, int n2, Duration duration, Duration duration2, Duration duration3, Duration duration4, Duration duration5, String string5, List list, List list2, String string6, String string7, String string8, String string9, String string10, String string11, String string12, String string13, boolean bl, List list3, String string14, String string15, Integer n3, boolean bl2, boolean bl3, Map map, boolean bl4, int n4, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n4 & 2) != 0) {
            string = null;
        }
        if ((n4 & 4) != 0) {
            n = null;
        }
        if ((n4 & 8) != 0) {
            string2 = null;
        }
        if ((n4 & 0x10) != 0) {
            string3 = null;
        }
        if ((n4 & 0x20) != 0) {
            string4 = null;
        }
        if ((n4 & 0x40) != 0) {
            n2 = 10;
        }
        if ((n4 & 0x80) != 0) {
            Duration duration6 = Duration.ofSeconds(10L);
            Intrinsics.checkNotNullExpressionValue((Object)duration6, (String)"ofSeconds(...)");
            duration = duration6;
        }
        if ((n4 & 0x100) != 0) {
            Duration duration7 = Duration.ofSeconds(3L);
            Intrinsics.checkNotNullExpressionValue((Object)duration7, (String)"ofSeconds(...)");
            duration2 = duration7;
        }
        if ((n4 & 0x200) != 0) {
            duration3 = null;
        }
        if ((n4 & 0x400) != 0) {
            Duration duration8 = Duration.ofMinutes(1L);
            Intrinsics.checkNotNullExpressionValue((Object)duration8, (String)"ofMinutes(...)");
            duration4 = duration8;
        }
        if ((n4 & 0x800) != 0) {
            duration5 = Duration.ofMinutes(1L);
        }
        if ((n4 & 0x1000) != 0) {
            string5 = null;
        }
        if ((n4 & 0x2000) != 0) {
            list = null;
        }
        if ((n4 & 0x4000) != 0) {
            list2 = null;
        }
        if ((n4 & 0x8000) != 0) {
            string6 = "(^|.*/)v(\\d+)__[^/]+\\.sql";
        }
        if ((n4 & 0x10000) != 0) {
            string7 = null;
        }
        if ((n4 & 0x20000) != 0) {
            string8 = null;
        }
        if ((n4 & 0x40000) != 0) {
            string9 = null;
        }
        if ((n4 & 0x80000) != 0) {
            string10 = null;
        }
        if ((n4 & 0x100000) != 0) {
            string11 = null;
        }
        if ((n4 & 0x200000) != 0) {
            string12 = null;
        }
        if ((n4 & 0x400000) != 0) {
            string13 = null;
        }
        if ((n4 & 0x800000) != 0) {
            bl = false;
        }
        if ((n4 & 0x1000000) != 0) {
            Object[] objectArray = new String[]{"TLSv1.2", "TLSv1.3"};
            list3 = CollectionsKt.listOf((Object[])objectArray);
        }
        if ((n4 & 0x2000000) != 0) {
            string14 = "false";
        }
        if ((n4 & 0x4000000) != 0) {
            string15 = "false";
        }
        if ((n4 & 0x8000000) != 0) {
            n3 = null;
        }
        if ((n4 & 0x10000000) != 0) {
            bl2 = false;
        }
        if ((n4 & 0x20000000) != 0) {
            bl3 = false;
        }
        if ((n4 & 0x40000000) != 0) {
            map = MapsKt.emptyMap();
        }
        if ((n4 & Integer.MIN_VALUE) != 0) {
            bl4 = false;
        }
        this(dataSourceType, string, n, string2, string3, string4, n2, duration, duration2, duration3, duration4, duration5, string5, list, list2, string6, string7, string8, string9, string10, string11, string12, string13, bl, list3, string14, string15, n3, bl2, bl3, map, bl4);
    }

    @NotNull
    public final DataSourceType getType() {
        return this.type;
    }

    @Nullable
    public final String getHost() {
        return this.host;
    }

    @Nullable
    public final Integer getPort() {
        return this.port;
    }

    @Nullable
    public final String getDatabase() {
        return this.database;
    }

    @Nullable
    public final String getUsername() {
        return this.username;
    }

    @Nullable
    public final String getPassword() {
        return this.password;
    }

    public final int getFixed_pool_size() {
        return this.fixed_pool_size;
    }

    @NotNull
    public final Duration getConnection_timeout() {
        return this.connection_timeout;
    }

    @NotNull
    public final Duration getValidation_timeout() {
        return this.validation_timeout;
    }

    @Nullable
    public final Duration getConnection_idle_timeout() {
        return this.connection_idle_timeout;
    }

    @NotNull
    public final Duration getConnection_max_lifetime() {
        return this.connection_max_lifetime;
    }

    @Nullable
    public final Duration getQuery_timeout() {
        return this.query_timeout;
    }

    @Nullable
    public final String getMigrations_resource() {
        return this.migrations_resource;
    }

    @Nullable
    public final List<String> getMigrations_resources() {
        return this.migrations_resources;
    }

    @Nullable
    public final List<String> getMigrations_resources_exclusion() {
        return this.migrations_resources_exclusion;
    }

    @NotNull
    public final String getMigrations_resources_regex() {
        return this.migrations_resources_regex;
    }

    @Nullable
    public final String getVitess_schema_resource_root() {
        return this.vitess_schema_resource_root;
    }

    @Nullable
    public final String getTrust_certificate_key_store_url() {
        return this.trust_certificate_key_store_url;
    }

    @Nullable
    public final String getTrust_certificate_key_store_password() {
        return this.trust_certificate_key_store_password;
    }

    @Nullable
    public final String getClient_certificate_key_store_url() {
        return this.client_certificate_key_store_url;
    }

    @Nullable
    public final String getClient_certificate_key_store_password() {
        return this.client_certificate_key_store_password;
    }

    @Nullable
    public final String getTrust_certificate_key_store_path() {
        return this.trust_certificate_key_store_path;
    }

    @Nullable
    public final String getClient_certificate_key_store_path() {
        return this.client_certificate_key_store_path;
    }

    public final boolean getVerify_server_identity() {
        return this.verify_server_identity;
    }

    @NotNull
    public final List<String> getEnabledTlsProtocols() {
        return this.enabledTlsProtocols;
    }

    @Nullable
    public final String getShow_sql() {
        return this.show_sql;
    }

    @Nullable
    public final String getGenerate_hibernate_stats() {
        return this.generate_hibernate_stats;
    }

    @Nullable
    public final Integer getJdbc_statement_batch_size() {
        return this.jdbc_statement_batch_size;
    }

    public final boolean getUse_fixed_pool_size() {
        return this.use_fixed_pool_size;
    }

    public final boolean getAllow_public_key_retrieval() {
        return this.allow_public_key_retrieval;
    }

    @NotNull
    public final Map<String, Object> getJdbc_url_query_parameters() {
        return this.jdbc_url_query_parameters;
    }

    public final boolean getMysql_enforce_writable_connections() {
        return this.mysql_enforce_writable_connections;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final DataSourceConfig withDefaults() {
        DataSourceConfig dataSourceConfig;
        boolean isRunningInDocker;
        boolean bl;
        Object object;
        File file;
        File it = file = new File("/proc/1/cgroup");
        boolean bl2 = false;
        File file2 = it.exists() ? file : null;
        if (file2 != null) {
            File $this$useLines_u24default$iv = file2;
            Charset charset$iv = Charsets.UTF_8;
            boolean $i$f$useLines = false;
            object = $this$useLines_u24default$iv;
            int n = 8192;
            Object object2 = object;
            object = (object2 = (Reader)new InputStreamReader((InputStream)new FileInputStream((File)object2), charset$iv)) instanceof BufferedReader ? (BufferedReader)object2 : new BufferedReader((Reader)object2, n);
            Throwable throwable = null;
            try {
                boolean bl3;
                block26: {
                    BufferedReader it$iv = (BufferedReader)object;
                    boolean bl4 = false;
                    Sequence lines = TextStreamsKt.lineSequence((BufferedReader)it$iv);
                    boolean bl5 = false;
                    Sequence $this$any$iv = lines;
                    boolean $i$f$any = false;
                    for (Object element$iv : $this$any$iv) {
                        String it2 = (String)element$iv;
                        boolean bl6 = false;
                        if (!StringsKt.contains$default((CharSequence)it2, (CharSequence)"/docker", (boolean)false, (int)2, null)) continue;
                        bl3 = true;
                        break block26;
                    }
                    bl3 = false;
                }
                boolean bl7 = bl3;
                bl = bl7;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
            }
        }
        bl = false;
        String server_hostname = (isRunningInDocker = bl) ? "host.docker.internal" : "127.0.0.1";
        switch (WhenMappings.$EnumSwitchMapping$0[this.type.ordinal()]) {
            case 1: {
                String string;
                String string2;
                String string3;
                Integer n = this.port;
                int n2 = n != null ? n : 3306;
                String string4 = this.host;
                if (string4 == null) {
                    string4 = string3 = System.getenv("MYSQL_HOST");
                }
                if (string4 == null) {
                    string3 = string2 = "127.0.0.1";
                }
                if ((string = this.database) == null) {
                    string = "";
                }
                object = string;
                dataSourceConfig = DataSourceConfig.copy$default(this, null, string2, n2, (String)object, null, null, 0, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, false, null, null, null, null, false, false, null, false, -15, null);
                break;
            }
            case 2: {
                String string;
                String string5;
                Integer n = this.port;
                int n2 = n != null ? n : 4000;
                String string6 = this.host;
                if (string6 == null) {
                    string6 = string5 = server_hostname;
                }
                if ((string = this.database) == null) {
                    string = "";
                }
                object = string;
                dataSourceConfig = DataSourceConfig.copy$default(this, null, string5, n2, (String)object, null, null, 0, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, false, null, null, null, null, false, false, null, false, -15, null);
                break;
            }
            case 3: {
                String string;
                String string7;
                Integer n = this.port;
                int n2 = n != null ? n : 27003;
                String string8 = this.host;
                if (string8 == null) {
                    string8 = string7 = server_hostname;
                }
                if ((string = this.database) == null) {
                    string = "@master";
                }
                object = string;
                dataSourceConfig = DataSourceConfig.copy$default(this, null, string7, n2, (String)object, null, null, 0, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, false, null, null, null, null, false, false, null, false, -15, null);
                break;
            }
            case 4: {
                dataSourceConfig = this;
                break;
            }
            case 5: {
                String string;
                String string9;
                Integer n = this.port;
                int n2 = n != null ? n : 26257;
                String string10 = this.host;
                if (string10 == null) {
                    string10 = string9 = server_hostname;
                }
                if ((string = this.database) == null) {
                    string = "";
                }
                object = string;
                dataSourceConfig = DataSourceConfig.copy$default(this, null, string9, n2, (String)object, "root", null, 0, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, false, null, null, null, null, false, false, null, false, -31, null);
                break;
            }
            case 6: {
                String string;
                String string11;
                Integer n = this.port;
                int n2 = n != null ? n : 5432;
                String string12 = this.host;
                if (string12 == null) {
                    string12 = string11 = server_hostname;
                }
                if ((string = this.database) == null) {
                    string = "";
                }
                object = string;
                dataSourceConfig = DataSourceConfig.copy$default(this, null, string11, n2, (String)object, null, null, 0, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, false, null, null, null, null, false, false, null, false, -15, null);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return dataSourceConfig;
    }

    @NotNull
    public final String buildJdbcUrl(@NotNull Deployment deployment) {
        String string;
        Intrinsics.checkNotNullParameter((Object)deployment, (String)"deployment");
        DataSourceConfig config = this.withDefaults();
        CharSequence charSequence = config.client_certificate_key_store_path;
        if (!(charSequence == null || StringsKt.isBlank((CharSequence)charSequence) || (charSequence = (CharSequence)config.client_certificate_key_store_url) == null || StringsKt.isBlank((CharSequence)charSequence))) {
            boolean $i$a$-require-DataSourceConfig$buildJdbcUrl$52 = false;
            String $i$a$-require-DataSourceConfig$buildJdbcUrl$52 = "can optionally set client_certificate_key_store_path or client_certificate_key_store_url, but not both";
            throw new IllegalArgumentException($i$a$-require-DataSourceConfig$buildJdbcUrl$52.toString());
        }
        charSequence = config.trust_certificate_key_store_path;
        if (!(charSequence == null || StringsKt.isBlank((CharSequence)charSequence) || (charSequence = (CharSequence)config.trust_certificate_key_store_url) == null || StringsKt.isBlank((CharSequence)charSequence))) {
            boolean bl = false;
            String string2 = "can optionally set trust_certificate_key_store_path or trust_certificate_key_store_url, but not both";
            throw new IllegalArgumentException(string2.toString());
        }
        switch (WhenMappings.$EnumSwitchMapping$0[this.type.ordinal()]) {
            case 1: 
            case 2: 
            case 3: {
                CharSequence charSequence2;
                Object queryParams = null;
                queryParams = "?useLegacyDatetimeCode=false";
                if (deployment.isTest() || deployment.isLocalDevelopment()) {
                    queryParams = queryParams + "&createDatabaseIfNotExist=true";
                }
                queryParams = queryParams + "&connectTimeout=" + config.connection_timeout.toMillis();
                if (config.query_timeout != null) {
                    queryParams = queryParams + "&socketTimeout=" + config.query_timeout.toMillis();
                }
                if (this.type == DataSourceType.VITESS_MYSQL) {
                    queryParams = queryParams + "&useServerPrepStmts=false";
                    queryParams = queryParams + "&useUnicode=true";
                    queryParams = queryParams + "&jdbcCompliantTruncation=false";
                }
                String trustStoreUrl = !((charSequence2 = (CharSequence)config.trust_certificate_key_store_path) == null || StringsKt.isBlank((CharSequence)charSequence2)) ? "file://" + config.trust_certificate_key_store_path : (!((charSequence2 = (CharSequence)config.trust_certificate_key_store_url) == null || StringsKt.isBlank((CharSequence)charSequence2)) ? config.trust_certificate_key_store_url : null);
                CharSequence charSequence3 = config.client_certificate_key_store_path;
                String certStoreUrl = !(charSequence3 == null || StringsKt.isBlank((CharSequence)charSequence3)) ? "file://" + config.client_certificate_key_store_path : (!((charSequence3 = (CharSequence)config.client_certificate_key_store_url) == null || StringsKt.isBlank((CharSequence)charSequence3)) ? config.client_certificate_key_store_url : null);
                boolean useSSL = false;
                CharSequence charSequence4 = trustStoreUrl;
                if (!(charSequence4 == null || StringsKt.isBlank((CharSequence)charSequence4))) {
                    charSequence4 = config.trust_certificate_key_store_password;
                    if (!(!(charSequence4 == null || StringsKt.isBlank((CharSequence)charSequence4)))) {
                        boolean $i$a$-require-DataSourceConfig$buildJdbcUrl$62 = false;
                        String $i$a$-require-DataSourceConfig$buildJdbcUrl$62 = "must provide a trust_certificate_key_store_password";
                        throw new IllegalArgumentException($i$a$-require-DataSourceConfig$buildJdbcUrl$62.toString());
                    }
                    queryParams = queryParams + "&trustCertificateKeyStoreUrl=" + trustStoreUrl;
                    queryParams = queryParams + "&trustCertificateKeyStorePassword=" + config.trust_certificate_key_store_password;
                    useSSL = true;
                }
                if (!((charSequence4 = (CharSequence)certStoreUrl) == null || StringsKt.isBlank((CharSequence)charSequence4))) {
                    charSequence4 = config.client_certificate_key_store_password;
                    if (!(!(charSequence4 == null || StringsKt.isBlank((CharSequence)charSequence4)))) {
                        boolean $i$a$-require-DataSourceConfig$buildJdbcUrl$72 = false;
                        String $i$a$-require-DataSourceConfig$buildJdbcUrl$72 = "must provide a client_certificate_key_store_password if client_certificate_key_store_url or client_certificate_key_store_path is set";
                        throw new IllegalArgumentException($i$a$-require-DataSourceConfig$buildJdbcUrl$72.toString());
                    }
                    queryParams = queryParams + "&clientCertificateKeyStoreUrl=" + certStoreUrl;
                    queryParams = queryParams + "&clientCertificateKeyStorePassword=" + config.client_certificate_key_store_password;
                    useSSL = true;
                }
                String sslMode = useSSL && this.verify_server_identity ? "VERIFY_IDENTITY" : (useSSL ? "VERIFY_CA" : "PREFERRED");
                queryParams = queryParams + "&sslMode=" + sslMode;
                if (!((Collection)this.enabledTlsProtocols).isEmpty()) {
                    queryParams = queryParams + "&enabledTLSProtocols=" + CollectionsKt.joinToString$default((Iterable)this.enabledTlsProtocols, (CharSequence)",", null, null, (int)0, null, null, (int)62, null);
                }
                if (this.allow_public_key_retrieval) {
                    queryParams = queryParams + "&allowPublicKeyRetrieval=true";
                }
                Iterable $this$forEach$iv = this.jdbc_url_query_parameters.entrySet();
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    Map.Entry entry = (Map.Entry)element$iv;
                    boolean bl = false;
                    String key = (String)entry.getKey();
                    Object value = entry.getValue();
                    queryParams = queryParams + "&" + key + "=" + value;
                }
                string = "jdbc:tracing:mysql://" + config.host + ":" + config.port + "/" + config.database + queryParams;
                break;
            }
            case 4: {
                String string3 = this.database;
                Intrinsics.checkNotNull((Object)string3);
                string = "jdbc:hsqldb:mem:" + string3 + ";sql.syntax_mys=true";
                break;
            }
            case 5: 
            case 6: {
                String params = "ssl=false&user=" + config.username;
                if (deployment.isTest() || deployment.isLocalDevelopment()) {
                    params = params + "&createDatabaseIfNotExist=true";
                }
                string = "jdbc:postgresql://" + config.host + ":" + config.port + "/" + config.database + "?" + params;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return string;
    }

    private final String getStorePath(String url, String path) {
        String pathToUse = null;
        Object object = (String[])url;
        if (!(object == null || StringsKt.isBlank((CharSequence)object))) {
            object = new String[]{"file://"};
            pathToUse = (String)CollectionsKt.last((List)StringsKt.split$default((CharSequence)url, (String[])object, (boolean)false, (int)0, (int)6, null));
        } else {
            object = path;
            if (!(object == null || StringsKt.isBlank((CharSequence)object))) {
                pathToUse = path;
            }
        }
        return pathToUse;
    }

    @NotNull
    public final DataSourceConfig asReplica() {
        if (this.type == DataSourceType.COCKROACHDB || this.type == DataSourceType.TIDB) {
            return this;
        }
        if (this.type != DataSourceType.VITESS_MYSQL) {
            throw new Exception("Replica database config only available for VITESS_MYSQL type");
        }
        return new DataSourceConfig(this.type, this.host, this.port, "@replica", this.username, this.password, this.fixed_pool_size, this.connection_timeout, this.validation_timeout, this.connection_idle_timeout, this.connection_max_lifetime, this.query_timeout, this.migrations_resource, this.migrations_resources, this.migrations_resources_exclusion, this.migrations_resources_regex, this.vitess_schema_resource_root, this.trust_certificate_key_store_url, this.trust_certificate_key_store_password, this.client_certificate_key_store_url, this.client_certificate_key_store_password, this.trust_certificate_key_store_path, this.client_certificate_key_store_path, this.verify_server_identity, this.enabledTlsProtocols, this.show_sql, this.generate_hibernate_stats, null, false, false, null, false, -134217728, null);
    }

    public final boolean canRecoverOnReplica() {
        DataSourceType[] dataSourceTypeArray = new DataSourceType[]{DataSourceType.COCKROACHDB, DataSourceType.TIDB, DataSourceType.VITESS_MYSQL};
        return CollectionsKt.listOf((Object[])dataSourceTypeArray).contains((Object)this.type);
    }

    @NotNull
    public final DataSourceType component1() {
        return this.type;
    }

    @Nullable
    public final String component2() {
        return this.host;
    }

    @Nullable
    public final Integer component3() {
        return this.port;
    }

    @Nullable
    public final String component4() {
        return this.database;
    }

    @Nullable
    public final String component5() {
        return this.username;
    }

    @Nullable
    public final String component6() {
        return this.password;
    }

    public final int component7() {
        return this.fixed_pool_size;
    }

    @NotNull
    public final Duration component8() {
        return this.connection_timeout;
    }

    @NotNull
    public final Duration component9() {
        return this.validation_timeout;
    }

    @Nullable
    public final Duration component10() {
        return this.connection_idle_timeout;
    }

    @NotNull
    public final Duration component11() {
        return this.connection_max_lifetime;
    }

    @Nullable
    public final Duration component12() {
        return this.query_timeout;
    }

    @Nullable
    public final String component13() {
        return this.migrations_resource;
    }

    @Nullable
    public final List<String> component14() {
        return this.migrations_resources;
    }

    @Nullable
    public final List<String> component15() {
        return this.migrations_resources_exclusion;
    }

    @NotNull
    public final String component16() {
        return this.migrations_resources_regex;
    }

    @Nullable
    public final String component17() {
        return this.vitess_schema_resource_root;
    }

    @Nullable
    public final String component18() {
        return this.trust_certificate_key_store_url;
    }

    @Nullable
    public final String component19() {
        return this.trust_certificate_key_store_password;
    }

    @Nullable
    public final String component20() {
        return this.client_certificate_key_store_url;
    }

    @Nullable
    public final String component21() {
        return this.client_certificate_key_store_password;
    }

    @Nullable
    public final String component22() {
        return this.trust_certificate_key_store_path;
    }

    @Nullable
    public final String component23() {
        return this.client_certificate_key_store_path;
    }

    public final boolean component24() {
        return this.verify_server_identity;
    }

    @NotNull
    public final List<String> component25() {
        return this.enabledTlsProtocols;
    }

    @Nullable
    public final String component26() {
        return this.show_sql;
    }

    @Nullable
    public final String component27() {
        return this.generate_hibernate_stats;
    }

    @Nullable
    public final Integer component28() {
        return this.jdbc_statement_batch_size;
    }

    public final boolean component29() {
        return this.use_fixed_pool_size;
    }

    public final boolean component30() {
        return this.allow_public_key_retrieval;
    }

    @NotNull
    public final Map<String, Object> component31() {
        return this.jdbc_url_query_parameters;
    }

    public final boolean component32() {
        return this.mysql_enforce_writable_connections;
    }

    @NotNull
    public final DataSourceConfig copy(@NotNull DataSourceType type, @Nullable String host, @Nullable Integer port, @Nullable String database, @Nullable String username, @Redact @Nullable String password, int fixed_pool_size, @NotNull Duration connection_timeout, @NotNull Duration validation_timeout, @Nullable Duration connection_idle_timeout, @NotNull Duration connection_max_lifetime, @Nullable Duration query_timeout, @Nullable String migrations_resource, @Nullable List<String> migrations_resources, @Nullable List<String> migrations_resources_exclusion, @NotNull String migrations_resources_regex, @Nullable String vitess_schema_resource_root, @Nullable String trust_certificate_key_store_url, @Redact @Nullable String trust_certificate_key_store_password, @Nullable String client_certificate_key_store_url, @Redact @Nullable String client_certificate_key_store_password, @Nullable String trust_certificate_key_store_path, @Nullable String client_certificate_key_store_path, boolean verify_server_identity, @NotNull List<String> enabledTlsProtocols, @Nullable String show_sql, @Nullable String generate_hibernate_stats, @Nullable Integer jdbc_statement_batch_size, boolean use_fixed_pool_size, boolean allow_public_key_retrieval, @NotNull Map<String, ? extends Object> jdbc_url_query_parameters, boolean mysql_enforce_writable_connections) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        Intrinsics.checkNotNullParameter((Object)connection_timeout, (String)"connection_timeout");
        Intrinsics.checkNotNullParameter((Object)validation_timeout, (String)"validation_timeout");
        Intrinsics.checkNotNullParameter((Object)connection_max_lifetime, (String)"connection_max_lifetime");
        Intrinsics.checkNotNullParameter((Object)migrations_resources_regex, (String)"migrations_resources_regex");
        Intrinsics.checkNotNullParameter(enabledTlsProtocols, (String)"enabledTlsProtocols");
        Intrinsics.checkNotNullParameter(jdbc_url_query_parameters, (String)"jdbc_url_query_parameters");
        return new DataSourceConfig(type, host, port, database, username, password, fixed_pool_size, connection_timeout, validation_timeout, connection_idle_timeout, connection_max_lifetime, query_timeout, migrations_resource, migrations_resources, migrations_resources_exclusion, migrations_resources_regex, vitess_schema_resource_root, trust_certificate_key_store_url, trust_certificate_key_store_password, client_certificate_key_store_url, client_certificate_key_store_password, trust_certificate_key_store_path, client_certificate_key_store_path, verify_server_identity, enabledTlsProtocols, show_sql, generate_hibernate_stats, jdbc_statement_batch_size, use_fixed_pool_size, allow_public_key_retrieval, jdbc_url_query_parameters, mysql_enforce_writable_connections);
    }

    public static /* synthetic */ DataSourceConfig copy$default(DataSourceConfig dataSourceConfig, DataSourceType dataSourceType, String string, Integer n, String string2, String string3, String string4, int n2, Duration duration, Duration duration2, Duration duration3, Duration duration4, Duration duration5, String string5, List list, List list2, String string6, String string7, String string8, String string9, String string10, String string11, String string12, String string13, boolean bl, List list3, String string14, String string15, Integer n3, boolean bl2, boolean bl3, Map map, boolean bl4, int n4, Object object) {
        if ((n4 & 1) != 0) {
            dataSourceType = dataSourceConfig.type;
        }
        if ((n4 & 2) != 0) {
            string = dataSourceConfig.host;
        }
        if ((n4 & 4) != 0) {
            n = dataSourceConfig.port;
        }
        if ((n4 & 8) != 0) {
            string2 = dataSourceConfig.database;
        }
        if ((n4 & 0x10) != 0) {
            string3 = dataSourceConfig.username;
        }
        if ((n4 & 0x20) != 0) {
            string4 = dataSourceConfig.password;
        }
        if ((n4 & 0x40) != 0) {
            n2 = dataSourceConfig.fixed_pool_size;
        }
        if ((n4 & 0x80) != 0) {
            duration = dataSourceConfig.connection_timeout;
        }
        if ((n4 & 0x100) != 0) {
            duration2 = dataSourceConfig.validation_timeout;
        }
        if ((n4 & 0x200) != 0) {
            duration3 = dataSourceConfig.connection_idle_timeout;
        }
        if ((n4 & 0x400) != 0) {
            duration4 = dataSourceConfig.connection_max_lifetime;
        }
        if ((n4 & 0x800) != 0) {
            duration5 = dataSourceConfig.query_timeout;
        }
        if ((n4 & 0x1000) != 0) {
            string5 = dataSourceConfig.migrations_resource;
        }
        if ((n4 & 0x2000) != 0) {
            list = dataSourceConfig.migrations_resources;
        }
        if ((n4 & 0x4000) != 0) {
            list2 = dataSourceConfig.migrations_resources_exclusion;
        }
        if ((n4 & 0x8000) != 0) {
            string6 = dataSourceConfig.migrations_resources_regex;
        }
        if ((n4 & 0x10000) != 0) {
            string7 = dataSourceConfig.vitess_schema_resource_root;
        }
        if ((n4 & 0x20000) != 0) {
            string8 = dataSourceConfig.trust_certificate_key_store_url;
        }
        if ((n4 & 0x40000) != 0) {
            string9 = dataSourceConfig.trust_certificate_key_store_password;
        }
        if ((n4 & 0x80000) != 0) {
            string10 = dataSourceConfig.client_certificate_key_store_url;
        }
        if ((n4 & 0x100000) != 0) {
            string11 = dataSourceConfig.client_certificate_key_store_password;
        }
        if ((n4 & 0x200000) != 0) {
            string12 = dataSourceConfig.trust_certificate_key_store_path;
        }
        if ((n4 & 0x400000) != 0) {
            string13 = dataSourceConfig.client_certificate_key_store_path;
        }
        if ((n4 & 0x800000) != 0) {
            bl = dataSourceConfig.verify_server_identity;
        }
        if ((n4 & 0x1000000) != 0) {
            list3 = dataSourceConfig.enabledTlsProtocols;
        }
        if ((n4 & 0x2000000) != 0) {
            string14 = dataSourceConfig.show_sql;
        }
        if ((n4 & 0x4000000) != 0) {
            string15 = dataSourceConfig.generate_hibernate_stats;
        }
        if ((n4 & 0x8000000) != 0) {
            n3 = dataSourceConfig.jdbc_statement_batch_size;
        }
        if ((n4 & 0x10000000) != 0) {
            bl2 = dataSourceConfig.use_fixed_pool_size;
        }
        if ((n4 & 0x20000000) != 0) {
            bl3 = dataSourceConfig.allow_public_key_retrieval;
        }
        if ((n4 & 0x40000000) != 0) {
            map = dataSourceConfig.jdbc_url_query_parameters;
        }
        if ((n4 & Integer.MIN_VALUE) != 0) {
            bl4 = dataSourceConfig.mysql_enforce_writable_connections;
        }
        return dataSourceConfig.copy(dataSourceType, string, n, string2, string3, string4, n2, duration, duration2, duration3, duration4, duration5, string5, list, list2, string6, string7, string8, string9, string10, string11, string12, string13, bl, list3, string14, string15, n3, bl2, bl3, map, bl4);
    }

    @NotNull
    public String toString() {
        return "DataSourceConfig(type=" + this.type + ", host=" + this.host + ", port=" + this.port + ", database=" + this.database + ", username=" + this.username + ", password=" + this.password + ", fixed_pool_size=" + this.fixed_pool_size + ", connection_timeout=" + this.connection_timeout + ", validation_timeout=" + this.validation_timeout + ", connection_idle_timeout=" + this.connection_idle_timeout + ", connection_max_lifetime=" + this.connection_max_lifetime + ", query_timeout=" + this.query_timeout + ", migrations_resource=" + this.migrations_resource + ", migrations_resources=" + this.migrations_resources + ", migrations_resources_exclusion=" + this.migrations_resources_exclusion + ", migrations_resources_regex=" + this.migrations_resources_regex + ", vitess_schema_resource_root=" + this.vitess_schema_resource_root + ", trust_certificate_key_store_url=" + this.trust_certificate_key_store_url + ", trust_certificate_key_store_password=" + this.trust_certificate_key_store_password + ", client_certificate_key_store_url=" + this.client_certificate_key_store_url + ", client_certificate_key_store_password=" + this.client_certificate_key_store_password + ", trust_certificate_key_store_path=" + this.trust_certificate_key_store_path + ", client_certificate_key_store_path=" + this.client_certificate_key_store_path + ", verify_server_identity=" + this.verify_server_identity + ", enabledTlsProtocols=" + this.enabledTlsProtocols + ", show_sql=" + this.show_sql + ", generate_hibernate_stats=" + this.generate_hibernate_stats + ", jdbc_statement_batch_size=" + this.jdbc_statement_batch_size + ", use_fixed_pool_size=" + this.use_fixed_pool_size + ", allow_public_key_retrieval=" + this.allow_public_key_retrieval + ", jdbc_url_query_parameters=" + this.jdbc_url_query_parameters + ", mysql_enforce_writable_connections=" + this.mysql_enforce_writable_connections + ")";
    }

    public int hashCode() {
        int result = this.type.hashCode();
        result = result * 31 + (this.host == null ? 0 : this.host.hashCode());
        result = result * 31 + (this.port == null ? 0 : ((Object)this.port).hashCode());
        result = result * 31 + (this.database == null ? 0 : this.database.hashCode());
        result = result * 31 + (this.username == null ? 0 : this.username.hashCode());
        result = result * 31 + (this.password == null ? 0 : this.password.hashCode());
        result = result * 31 + Integer.hashCode(this.fixed_pool_size);
        result = result * 31 + this.connection_timeout.hashCode();
        result = result * 31 + this.validation_timeout.hashCode();
        result = result * 31 + (this.connection_idle_timeout == null ? 0 : this.connection_idle_timeout.hashCode());
        result = result * 31 + this.connection_max_lifetime.hashCode();
        result = result * 31 + (this.query_timeout == null ? 0 : this.query_timeout.hashCode());
        result = result * 31 + (this.migrations_resource == null ? 0 : this.migrations_resource.hashCode());
        result = result * 31 + (this.migrations_resources == null ? 0 : ((Object)this.migrations_resources).hashCode());
        result = result * 31 + (this.migrations_resources_exclusion == null ? 0 : ((Object)this.migrations_resources_exclusion).hashCode());
        result = result * 31 + this.migrations_resources_regex.hashCode();
        result = result * 31 + (this.vitess_schema_resource_root == null ? 0 : this.vitess_schema_resource_root.hashCode());
        result = result * 31 + (this.trust_certificate_key_store_url == null ? 0 : this.trust_certificate_key_store_url.hashCode());
        result = result * 31 + (this.trust_certificate_key_store_password == null ? 0 : this.trust_certificate_key_store_password.hashCode());
        result = result * 31 + (this.client_certificate_key_store_url == null ? 0 : this.client_certificate_key_store_url.hashCode());
        result = result * 31 + (this.client_certificate_key_store_password == null ? 0 : this.client_certificate_key_store_password.hashCode());
        result = result * 31 + (this.trust_certificate_key_store_path == null ? 0 : this.trust_certificate_key_store_path.hashCode());
        result = result * 31 + (this.client_certificate_key_store_path == null ? 0 : this.client_certificate_key_store_path.hashCode());
        result = result * 31 + Boolean.hashCode(this.verify_server_identity);
        result = result * 31 + ((Object)this.enabledTlsProtocols).hashCode();
        result = result * 31 + (this.show_sql == null ? 0 : this.show_sql.hashCode());
        result = result * 31 + (this.generate_hibernate_stats == null ? 0 : this.generate_hibernate_stats.hashCode());
        result = result * 31 + (this.jdbc_statement_batch_size == null ? 0 : ((Object)this.jdbc_statement_batch_size).hashCode());
        result = result * 31 + Boolean.hashCode(this.use_fixed_pool_size);
        result = result * 31 + Boolean.hashCode(this.allow_public_key_retrieval);
        result = result * 31 + ((Object)this.jdbc_url_query_parameters).hashCode();
        result = result * 31 + Boolean.hashCode(this.mysql_enforce_writable_connections);
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof DataSourceConfig)) {
            return false;
        }
        DataSourceConfig dataSourceConfig = (DataSourceConfig)other;
        if (this.type != dataSourceConfig.type) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.host, (Object)dataSourceConfig.host)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.port, (Object)dataSourceConfig.port)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.database, (Object)dataSourceConfig.database)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.username, (Object)dataSourceConfig.username)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.password, (Object)dataSourceConfig.password)) {
            return false;
        }
        if (this.fixed_pool_size != dataSourceConfig.fixed_pool_size) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.connection_timeout, (Object)dataSourceConfig.connection_timeout)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.validation_timeout, (Object)dataSourceConfig.validation_timeout)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.connection_idle_timeout, (Object)dataSourceConfig.connection_idle_timeout)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.connection_max_lifetime, (Object)dataSourceConfig.connection_max_lifetime)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.query_timeout, (Object)dataSourceConfig.query_timeout)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.migrations_resource, (Object)dataSourceConfig.migrations_resource)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.migrations_resources, dataSourceConfig.migrations_resources)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.migrations_resources_exclusion, dataSourceConfig.migrations_resources_exclusion)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.migrations_resources_regex, (Object)dataSourceConfig.migrations_resources_regex)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.vitess_schema_resource_root, (Object)dataSourceConfig.vitess_schema_resource_root)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.trust_certificate_key_store_url, (Object)dataSourceConfig.trust_certificate_key_store_url)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.trust_certificate_key_store_password, (Object)dataSourceConfig.trust_certificate_key_store_password)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.client_certificate_key_store_url, (Object)dataSourceConfig.client_certificate_key_store_url)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.client_certificate_key_store_password, (Object)dataSourceConfig.client_certificate_key_store_password)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.trust_certificate_key_store_path, (Object)dataSourceConfig.trust_certificate_key_store_path)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.client_certificate_key_store_path, (Object)dataSourceConfig.client_certificate_key_store_path)) {
            return false;
        }
        if (this.verify_server_identity != dataSourceConfig.verify_server_identity) {
            return false;
        }
        if (!Intrinsics.areEqual(this.enabledTlsProtocols, dataSourceConfig.enabledTlsProtocols)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.show_sql, (Object)dataSourceConfig.show_sql)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.generate_hibernate_stats, (Object)dataSourceConfig.generate_hibernate_stats)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.jdbc_statement_batch_size, (Object)dataSourceConfig.jdbc_statement_batch_size)) {
            return false;
        }
        if (this.use_fixed_pool_size != dataSourceConfig.use_fixed_pool_size) {
            return false;
        }
        if (this.allow_public_key_retrieval != dataSourceConfig.allow_public_key_retrieval) {
            return false;
        }
        if (!Intrinsics.areEqual(this.jdbc_url_query_parameters, dataSourceConfig.jdbc_url_query_parameters)) {
            return false;
        }
        return this.mysql_enforce_writable_connections == dataSourceConfig.mysql_enforce_writable_connections;
    }

    @JvmOverloads
    public DataSourceConfig(@NotNull DataSourceType type, @Nullable String host, @Nullable Integer port, @Nullable String database, @Nullable String username, @Redact @Nullable String password, int fixed_pool_size, @NotNull Duration connection_timeout, @NotNull Duration validation_timeout, @Nullable Duration connection_idle_timeout, @NotNull Duration connection_max_lifetime, @Nullable Duration query_timeout, @Nullable String migrations_resource, @Nullable List<String> migrations_resources, @Nullable List<String> migrations_resources_exclusion, @NotNull String migrations_resources_regex, @Nullable String vitess_schema_resource_root, @Nullable String trust_certificate_key_store_url, @Redact @Nullable String trust_certificate_key_store_password, @Nullable String client_certificate_key_store_url, @Redact @Nullable String client_certificate_key_store_password, @Nullable String trust_certificate_key_store_path, @Nullable String client_certificate_key_store_path, boolean verify_server_identity, @NotNull List<String> enabledTlsProtocols, @Nullable String show_sql, @Nullable String generate_hibernate_stats, @Nullable Integer jdbc_statement_batch_size, boolean use_fixed_pool_size, boolean allow_public_key_retrieval, @NotNull Map<String, ? extends Object> jdbc_url_query_parameters) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        Intrinsics.checkNotNullParameter((Object)connection_timeout, (String)"connection_timeout");
        Intrinsics.checkNotNullParameter((Object)validation_timeout, (String)"validation_timeout");
        Intrinsics.checkNotNullParameter((Object)connection_max_lifetime, (String)"connection_max_lifetime");
        Intrinsics.checkNotNullParameter((Object)migrations_resources_regex, (String)"migrations_resources_regex");
        Intrinsics.checkNotNullParameter(enabledTlsProtocols, (String)"enabledTlsProtocols");
        Intrinsics.checkNotNullParameter(jdbc_url_query_parameters, (String)"jdbc_url_query_parameters");
        this(type, host, port, database, username, password, fixed_pool_size, connection_timeout, validation_timeout, connection_idle_timeout, connection_max_lifetime, query_timeout, migrations_resource, migrations_resources, migrations_resources_exclusion, migrations_resources_regex, vitess_schema_resource_root, trust_certificate_key_store_url, trust_certificate_key_store_password, client_certificate_key_store_url, client_certificate_key_store_password, trust_certificate_key_store_path, client_certificate_key_store_path, verify_server_identity, enabledTlsProtocols, show_sql, generate_hibernate_stats, jdbc_statement_batch_size, use_fixed_pool_size, allow_public_key_retrieval, jdbc_url_query_parameters, false, Integer.MIN_VALUE, null);
    }

    @JvmOverloads
    public DataSourceConfig(@NotNull DataSourceType type, @Nullable String host, @Nullable Integer port, @Nullable String database, @Nullable String username, @Redact @Nullable String password, int fixed_pool_size, @NotNull Duration connection_timeout, @NotNull Duration validation_timeout, @Nullable Duration connection_idle_timeout, @NotNull Duration connection_max_lifetime, @Nullable Duration query_timeout, @Nullable String migrations_resource, @Nullable List<String> migrations_resources, @Nullable List<String> migrations_resources_exclusion, @NotNull String migrations_resources_regex, @Nullable String vitess_schema_resource_root, @Nullable String trust_certificate_key_store_url, @Redact @Nullable String trust_certificate_key_store_password, @Nullable String client_certificate_key_store_url, @Redact @Nullable String client_certificate_key_store_password, @Nullable String trust_certificate_key_store_path, @Nullable String client_certificate_key_store_path, boolean verify_server_identity, @NotNull List<String> enabledTlsProtocols, @Nullable String show_sql, @Nullable String generate_hibernate_stats, @Nullable Integer jdbc_statement_batch_size, boolean use_fixed_pool_size, boolean allow_public_key_retrieval) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        Intrinsics.checkNotNullParameter((Object)connection_timeout, (String)"connection_timeout");
        Intrinsics.checkNotNullParameter((Object)validation_timeout, (String)"validation_timeout");
        Intrinsics.checkNotNullParameter((Object)connection_max_lifetime, (String)"connection_max_lifetime");
        Intrinsics.checkNotNullParameter((Object)migrations_resources_regex, (String)"migrations_resources_regex");
        Intrinsics.checkNotNullParameter(enabledTlsProtocols, (String)"enabledTlsProtocols");
        this(type, host, port, database, username, password, fixed_pool_size, connection_timeout, validation_timeout, connection_idle_timeout, connection_max_lifetime, query_timeout, migrations_resource, migrations_resources, migrations_resources_exclusion, migrations_resources_regex, vitess_schema_resource_root, trust_certificate_key_store_url, trust_certificate_key_store_password, client_certificate_key_store_url, client_certificate_key_store_password, trust_certificate_key_store_path, client_certificate_key_store_path, verify_server_identity, enabledTlsProtocols, show_sql, generate_hibernate_stats, jdbc_statement_batch_size, use_fixed_pool_size, allow_public_key_retrieval, null, false, -1073741824, null);
    }

    @JvmOverloads
    public DataSourceConfig(@NotNull DataSourceType type, @Nullable String host, @Nullable Integer port, @Nullable String database, @Nullable String username, @Redact @Nullable String password, int fixed_pool_size, @NotNull Duration connection_timeout, @NotNull Duration validation_timeout, @Nullable Duration connection_idle_timeout, @NotNull Duration connection_max_lifetime, @Nullable Duration query_timeout, @Nullable String migrations_resource, @Nullable List<String> migrations_resources, @Nullable List<String> migrations_resources_exclusion, @NotNull String migrations_resources_regex, @Nullable String vitess_schema_resource_root, @Nullable String trust_certificate_key_store_url, @Redact @Nullable String trust_certificate_key_store_password, @Nullable String client_certificate_key_store_url, @Redact @Nullable String client_certificate_key_store_password, @Nullable String trust_certificate_key_store_path, @Nullable String client_certificate_key_store_path, boolean verify_server_identity, @NotNull List<String> enabledTlsProtocols, @Nullable String show_sql, @Nullable String generate_hibernate_stats, @Nullable Integer jdbc_statement_batch_size, boolean use_fixed_pool_size) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        Intrinsics.checkNotNullParameter((Object)connection_timeout, (String)"connection_timeout");
        Intrinsics.checkNotNullParameter((Object)validation_timeout, (String)"validation_timeout");
        Intrinsics.checkNotNullParameter((Object)connection_max_lifetime, (String)"connection_max_lifetime");
        Intrinsics.checkNotNullParameter((Object)migrations_resources_regex, (String)"migrations_resources_regex");
        Intrinsics.checkNotNullParameter(enabledTlsProtocols, (String)"enabledTlsProtocols");
        this(type, host, port, database, username, password, fixed_pool_size, connection_timeout, validation_timeout, connection_idle_timeout, connection_max_lifetime, query_timeout, migrations_resource, migrations_resources, migrations_resources_exclusion, migrations_resources_regex, vitess_schema_resource_root, trust_certificate_key_store_url, trust_certificate_key_store_password, client_certificate_key_store_url, client_certificate_key_store_password, trust_certificate_key_store_path, client_certificate_key_store_path, verify_server_identity, enabledTlsProtocols, show_sql, generate_hibernate_stats, jdbc_statement_batch_size, use_fixed_pool_size, false, null, false, -536870912, null);
    }

    @JvmOverloads
    public DataSourceConfig(@NotNull DataSourceType type, @Nullable String host, @Nullable Integer port, @Nullable String database, @Nullable String username, @Redact @Nullable String password, int fixed_pool_size, @NotNull Duration connection_timeout, @NotNull Duration validation_timeout, @Nullable Duration connection_idle_timeout, @NotNull Duration connection_max_lifetime, @Nullable Duration query_timeout, @Nullable String migrations_resource, @Nullable List<String> migrations_resources, @Nullable List<String> migrations_resources_exclusion, @NotNull String migrations_resources_regex, @Nullable String vitess_schema_resource_root, @Nullable String trust_certificate_key_store_url, @Redact @Nullable String trust_certificate_key_store_password, @Nullable String client_certificate_key_store_url, @Redact @Nullable String client_certificate_key_store_password, @Nullable String trust_certificate_key_store_path, @Nullable String client_certificate_key_store_path, boolean verify_server_identity, @NotNull List<String> enabledTlsProtocols, @Nullable String show_sql, @Nullable String generate_hibernate_stats, @Nullable Integer jdbc_statement_batch_size) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        Intrinsics.checkNotNullParameter((Object)connection_timeout, (String)"connection_timeout");
        Intrinsics.checkNotNullParameter((Object)validation_timeout, (String)"validation_timeout");
        Intrinsics.checkNotNullParameter((Object)connection_max_lifetime, (String)"connection_max_lifetime");
        Intrinsics.checkNotNullParameter((Object)migrations_resources_regex, (String)"migrations_resources_regex");
        Intrinsics.checkNotNullParameter(enabledTlsProtocols, (String)"enabledTlsProtocols");
        this(type, host, port, database, username, password, fixed_pool_size, connection_timeout, validation_timeout, connection_idle_timeout, connection_max_lifetime, query_timeout, migrations_resource, migrations_resources, migrations_resources_exclusion, migrations_resources_regex, vitess_schema_resource_root, trust_certificate_key_store_url, trust_certificate_key_store_password, client_certificate_key_store_url, client_certificate_key_store_password, trust_certificate_key_store_path, client_certificate_key_store_path, verify_server_identity, enabledTlsProtocols, show_sql, generate_hibernate_stats, jdbc_statement_batch_size, false, false, null, false, -268435456, null);
    }

    @JvmOverloads
    public DataSourceConfig(@NotNull DataSourceType type, @Nullable String host, @Nullable Integer port, @Nullable String database, @Nullable String username, @Redact @Nullable String password, int fixed_pool_size, @NotNull Duration connection_timeout, @NotNull Duration validation_timeout, @Nullable Duration connection_idle_timeout, @NotNull Duration connection_max_lifetime, @Nullable Duration query_timeout, @Nullable String migrations_resource, @Nullable List<String> migrations_resources, @Nullable List<String> migrations_resources_exclusion, @NotNull String migrations_resources_regex, @Nullable String vitess_schema_resource_root, @Nullable String trust_certificate_key_store_url, @Redact @Nullable String trust_certificate_key_store_password, @Nullable String client_certificate_key_store_url, @Redact @Nullable String client_certificate_key_store_password, @Nullable String trust_certificate_key_store_path, @Nullable String client_certificate_key_store_path, boolean verify_server_identity, @NotNull List<String> enabledTlsProtocols, @Nullable String show_sql, @Nullable String generate_hibernate_stats) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        Intrinsics.checkNotNullParameter((Object)connection_timeout, (String)"connection_timeout");
        Intrinsics.checkNotNullParameter((Object)validation_timeout, (String)"validation_timeout");
        Intrinsics.checkNotNullParameter((Object)connection_max_lifetime, (String)"connection_max_lifetime");
        Intrinsics.checkNotNullParameter((Object)migrations_resources_regex, (String)"migrations_resources_regex");
        Intrinsics.checkNotNullParameter(enabledTlsProtocols, (String)"enabledTlsProtocols");
        this(type, host, port, database, username, password, fixed_pool_size, connection_timeout, validation_timeout, connection_idle_timeout, connection_max_lifetime, query_timeout, migrations_resource, migrations_resources, migrations_resources_exclusion, migrations_resources_regex, vitess_schema_resource_root, trust_certificate_key_store_url, trust_certificate_key_store_password, client_certificate_key_store_url, client_certificate_key_store_password, trust_certificate_key_store_path, client_certificate_key_store_path, verify_server_identity, enabledTlsProtocols, show_sql, generate_hibernate_stats, null, false, false, null, false, -134217728, null);
    }

    @JvmOverloads
    public DataSourceConfig(@NotNull DataSourceType type, @Nullable String host, @Nullable Integer port, @Nullable String database, @Nullable String username, @Redact @Nullable String password, int fixed_pool_size, @NotNull Duration connection_timeout, @NotNull Duration validation_timeout, @Nullable Duration connection_idle_timeout, @NotNull Duration connection_max_lifetime, @Nullable Duration query_timeout, @Nullable String migrations_resource, @Nullable List<String> migrations_resources, @Nullable List<String> migrations_resources_exclusion, @NotNull String migrations_resources_regex, @Nullable String vitess_schema_resource_root, @Nullable String trust_certificate_key_store_url, @Redact @Nullable String trust_certificate_key_store_password, @Nullable String client_certificate_key_store_url, @Redact @Nullable String client_certificate_key_store_password, @Nullable String trust_certificate_key_store_path, @Nullable String client_certificate_key_store_path, boolean verify_server_identity, @NotNull List<String> enabledTlsProtocols, @Nullable String show_sql) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        Intrinsics.checkNotNullParameter((Object)connection_timeout, (String)"connection_timeout");
        Intrinsics.checkNotNullParameter((Object)validation_timeout, (String)"validation_timeout");
        Intrinsics.checkNotNullParameter((Object)connection_max_lifetime, (String)"connection_max_lifetime");
        Intrinsics.checkNotNullParameter((Object)migrations_resources_regex, (String)"migrations_resources_regex");
        Intrinsics.checkNotNullParameter(enabledTlsProtocols, (String)"enabledTlsProtocols");
        this(type, host, port, database, username, password, fixed_pool_size, connection_timeout, validation_timeout, connection_idle_timeout, connection_max_lifetime, query_timeout, migrations_resource, migrations_resources, migrations_resources_exclusion, migrations_resources_regex, vitess_schema_resource_root, trust_certificate_key_store_url, trust_certificate_key_store_password, client_certificate_key_store_url, client_certificate_key_store_password, trust_certificate_key_store_path, client_certificate_key_store_path, verify_server_identity, enabledTlsProtocols, show_sql, null, null, false, false, null, false, -67108864, null);
    }

    @JvmOverloads
    public DataSourceConfig(@NotNull DataSourceType type, @Nullable String host, @Nullable Integer port, @Nullable String database, @Nullable String username, @Redact @Nullable String password, int fixed_pool_size, @NotNull Duration connection_timeout, @NotNull Duration validation_timeout, @Nullable Duration connection_idle_timeout, @NotNull Duration connection_max_lifetime, @Nullable Duration query_timeout, @Nullable String migrations_resource, @Nullable List<String> migrations_resources, @Nullable List<String> migrations_resources_exclusion, @NotNull String migrations_resources_regex, @Nullable String vitess_schema_resource_root, @Nullable String trust_certificate_key_store_url, @Redact @Nullable String trust_certificate_key_store_password, @Nullable String client_certificate_key_store_url, @Redact @Nullable String client_certificate_key_store_password, @Nullable String trust_certificate_key_store_path, @Nullable String client_certificate_key_store_path, boolean verify_server_identity, @NotNull List<String> enabledTlsProtocols) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        Intrinsics.checkNotNullParameter((Object)connection_timeout, (String)"connection_timeout");
        Intrinsics.checkNotNullParameter((Object)validation_timeout, (String)"validation_timeout");
        Intrinsics.checkNotNullParameter((Object)connection_max_lifetime, (String)"connection_max_lifetime");
        Intrinsics.checkNotNullParameter((Object)migrations_resources_regex, (String)"migrations_resources_regex");
        Intrinsics.checkNotNullParameter(enabledTlsProtocols, (String)"enabledTlsProtocols");
        this(type, host, port, database, username, password, fixed_pool_size, connection_timeout, validation_timeout, connection_idle_timeout, connection_max_lifetime, query_timeout, migrations_resource, migrations_resources, migrations_resources_exclusion, migrations_resources_regex, vitess_schema_resource_root, trust_certificate_key_store_url, trust_certificate_key_store_password, client_certificate_key_store_url, client_certificate_key_store_password, trust_certificate_key_store_path, client_certificate_key_store_path, verify_server_identity, enabledTlsProtocols, null, null, null, false, false, null, false, -33554432, null);
    }

    @JvmOverloads
    public DataSourceConfig(@NotNull DataSourceType type, @Nullable String host, @Nullable Integer port, @Nullable String database, @Nullable String username, @Redact @Nullable String password, int fixed_pool_size, @NotNull Duration connection_timeout, @NotNull Duration validation_timeout, @Nullable Duration connection_idle_timeout, @NotNull Duration connection_max_lifetime, @Nullable Duration query_timeout, @Nullable String migrations_resource, @Nullable List<String> migrations_resources, @Nullable List<String> migrations_resources_exclusion, @NotNull String migrations_resources_regex, @Nullable String vitess_schema_resource_root, @Nullable String trust_certificate_key_store_url, @Redact @Nullable String trust_certificate_key_store_password, @Nullable String client_certificate_key_store_url, @Redact @Nullable String client_certificate_key_store_password, @Nullable String trust_certificate_key_store_path, @Nullable String client_certificate_key_store_path, boolean verify_server_identity) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        Intrinsics.checkNotNullParameter((Object)connection_timeout, (String)"connection_timeout");
        Intrinsics.checkNotNullParameter((Object)validation_timeout, (String)"validation_timeout");
        Intrinsics.checkNotNullParameter((Object)connection_max_lifetime, (String)"connection_max_lifetime");
        Intrinsics.checkNotNullParameter((Object)migrations_resources_regex, (String)"migrations_resources_regex");
        this(type, host, port, database, username, password, fixed_pool_size, connection_timeout, validation_timeout, connection_idle_timeout, connection_max_lifetime, query_timeout, migrations_resource, migrations_resources, migrations_resources_exclusion, migrations_resources_regex, vitess_schema_resource_root, trust_certificate_key_store_url, trust_certificate_key_store_password, client_certificate_key_store_url, client_certificate_key_store_password, trust_certificate_key_store_path, client_certificate_key_store_path, verify_server_identity, null, null, null, null, false, false, null, false, -16777216, null);
    }

    @JvmOverloads
    public DataSourceConfig(@NotNull DataSourceType type, @Nullable String host, @Nullable Integer port, @Nullable String database, @Nullable String username, @Redact @Nullable String password, int fixed_pool_size, @NotNull Duration connection_timeout, @NotNull Duration validation_timeout, @Nullable Duration connection_idle_timeout, @NotNull Duration connection_max_lifetime, @Nullable Duration query_timeout, @Nullable String migrations_resource, @Nullable List<String> migrations_resources, @Nullable List<String> migrations_resources_exclusion, @NotNull String migrations_resources_regex, @Nullable String vitess_schema_resource_root, @Nullable String trust_certificate_key_store_url, @Redact @Nullable String trust_certificate_key_store_password, @Nullable String client_certificate_key_store_url, @Redact @Nullable String client_certificate_key_store_password, @Nullable String trust_certificate_key_store_path, @Nullable String client_certificate_key_store_path) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        Intrinsics.checkNotNullParameter((Object)connection_timeout, (String)"connection_timeout");
        Intrinsics.checkNotNullParameter((Object)validation_timeout, (String)"validation_timeout");
        Intrinsics.checkNotNullParameter((Object)connection_max_lifetime, (String)"connection_max_lifetime");
        Intrinsics.checkNotNullParameter((Object)migrations_resources_regex, (String)"migrations_resources_regex");
        this(type, host, port, database, username, password, fixed_pool_size, connection_timeout, validation_timeout, connection_idle_timeout, connection_max_lifetime, query_timeout, migrations_resource, migrations_resources, migrations_resources_exclusion, migrations_resources_regex, vitess_schema_resource_root, trust_certificate_key_store_url, trust_certificate_key_store_password, client_certificate_key_store_url, client_certificate_key_store_password, trust_certificate_key_store_path, client_certificate_key_store_path, false, null, null, null, null, false, false, null, false, -8388608, null);
    }

    @JvmOverloads
    public DataSourceConfig(@NotNull DataSourceType type, @Nullable String host, @Nullable Integer port, @Nullable String database, @Nullable String username, @Redact @Nullable String password, int fixed_pool_size, @NotNull Duration connection_timeout, @NotNull Duration validation_timeout, @Nullable Duration connection_idle_timeout, @NotNull Duration connection_max_lifetime, @Nullable Duration query_timeout, @Nullable String migrations_resource, @Nullable List<String> migrations_resources, @Nullable List<String> migrations_resources_exclusion, @NotNull String migrations_resources_regex, @Nullable String vitess_schema_resource_root, @Nullable String trust_certificate_key_store_url, @Redact @Nullable String trust_certificate_key_store_password, @Nullable String client_certificate_key_store_url, @Redact @Nullable String client_certificate_key_store_password, @Nullable String trust_certificate_key_store_path) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        Intrinsics.checkNotNullParameter((Object)connection_timeout, (String)"connection_timeout");
        Intrinsics.checkNotNullParameter((Object)validation_timeout, (String)"validation_timeout");
        Intrinsics.checkNotNullParameter((Object)connection_max_lifetime, (String)"connection_max_lifetime");
        Intrinsics.checkNotNullParameter((Object)migrations_resources_regex, (String)"migrations_resources_regex");
        this(type, host, port, database, username, password, fixed_pool_size, connection_timeout, validation_timeout, connection_idle_timeout, connection_max_lifetime, query_timeout, migrations_resource, migrations_resources, migrations_resources_exclusion, migrations_resources_regex, vitess_schema_resource_root, trust_certificate_key_store_url, trust_certificate_key_store_password, client_certificate_key_store_url, client_certificate_key_store_password, trust_certificate_key_store_path, null, false, null, null, null, null, false, false, null, false, -4194304, null);
    }

    @JvmOverloads
    public DataSourceConfig(@NotNull DataSourceType type, @Nullable String host, @Nullable Integer port, @Nullable String database, @Nullable String username, @Redact @Nullable String password, int fixed_pool_size, @NotNull Duration connection_timeout, @NotNull Duration validation_timeout, @Nullable Duration connection_idle_timeout, @NotNull Duration connection_max_lifetime, @Nullable Duration query_timeout, @Nullable String migrations_resource, @Nullable List<String> migrations_resources, @Nullable List<String> migrations_resources_exclusion, @NotNull String migrations_resources_regex, @Nullable String vitess_schema_resource_root, @Nullable String trust_certificate_key_store_url, @Redact @Nullable String trust_certificate_key_store_password, @Nullable String client_certificate_key_store_url, @Redact @Nullable String client_certificate_key_store_password) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        Intrinsics.checkNotNullParameter((Object)connection_timeout, (String)"connection_timeout");
        Intrinsics.checkNotNullParameter((Object)validation_timeout, (String)"validation_timeout");
        Intrinsics.checkNotNullParameter((Object)connection_max_lifetime, (String)"connection_max_lifetime");
        Intrinsics.checkNotNullParameter((Object)migrations_resources_regex, (String)"migrations_resources_regex");
        this(type, host, port, database, username, password, fixed_pool_size, connection_timeout, validation_timeout, connection_idle_timeout, connection_max_lifetime, query_timeout, migrations_resource, migrations_resources, migrations_resources_exclusion, migrations_resources_regex, vitess_schema_resource_root, trust_certificate_key_store_url, trust_certificate_key_store_password, client_certificate_key_store_url, client_certificate_key_store_password, null, null, false, null, null, null, null, false, false, null, false, -2097152, null);
    }

    @JvmOverloads
    public DataSourceConfig(@NotNull DataSourceType type, @Nullable String host, @Nullable Integer port, @Nullable String database, @Nullable String username, @Redact @Nullable String password, int fixed_pool_size, @NotNull Duration connection_timeout, @NotNull Duration validation_timeout, @Nullable Duration connection_idle_timeout, @NotNull Duration connection_max_lifetime, @Nullable Duration query_timeout, @Nullable String migrations_resource, @Nullable List<String> migrations_resources, @Nullable List<String> migrations_resources_exclusion, @NotNull String migrations_resources_regex, @Nullable String vitess_schema_resource_root, @Nullable String trust_certificate_key_store_url, @Redact @Nullable String trust_certificate_key_store_password, @Nullable String client_certificate_key_store_url) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        Intrinsics.checkNotNullParameter((Object)connection_timeout, (String)"connection_timeout");
        Intrinsics.checkNotNullParameter((Object)validation_timeout, (String)"validation_timeout");
        Intrinsics.checkNotNullParameter((Object)connection_max_lifetime, (String)"connection_max_lifetime");
        Intrinsics.checkNotNullParameter((Object)migrations_resources_regex, (String)"migrations_resources_regex");
        this(type, host, port, database, username, password, fixed_pool_size, connection_timeout, validation_timeout, connection_idle_timeout, connection_max_lifetime, query_timeout, migrations_resource, migrations_resources, migrations_resources_exclusion, migrations_resources_regex, vitess_schema_resource_root, trust_certificate_key_store_url, trust_certificate_key_store_password, client_certificate_key_store_url, null, null, null, false, null, null, null, null, false, false, null, false, -1048576, null);
    }

    @JvmOverloads
    public DataSourceConfig(@NotNull DataSourceType type, @Nullable String host, @Nullable Integer port, @Nullable String database, @Nullable String username, @Redact @Nullable String password, int fixed_pool_size, @NotNull Duration connection_timeout, @NotNull Duration validation_timeout, @Nullable Duration connection_idle_timeout, @NotNull Duration connection_max_lifetime, @Nullable Duration query_timeout, @Nullable String migrations_resource, @Nullable List<String> migrations_resources, @Nullable List<String> migrations_resources_exclusion, @NotNull String migrations_resources_regex, @Nullable String vitess_schema_resource_root, @Nullable String trust_certificate_key_store_url, @Redact @Nullable String trust_certificate_key_store_password) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        Intrinsics.checkNotNullParameter((Object)connection_timeout, (String)"connection_timeout");
        Intrinsics.checkNotNullParameter((Object)validation_timeout, (String)"validation_timeout");
        Intrinsics.checkNotNullParameter((Object)connection_max_lifetime, (String)"connection_max_lifetime");
        Intrinsics.checkNotNullParameter((Object)migrations_resources_regex, (String)"migrations_resources_regex");
        this(type, host, port, database, username, password, fixed_pool_size, connection_timeout, validation_timeout, connection_idle_timeout, connection_max_lifetime, query_timeout, migrations_resource, migrations_resources, migrations_resources_exclusion, migrations_resources_regex, vitess_schema_resource_root, trust_certificate_key_store_url, trust_certificate_key_store_password, null, null, null, null, false, null, null, null, null, false, false, null, false, -524288, null);
    }

    @JvmOverloads
    public DataSourceConfig(@NotNull DataSourceType type, @Nullable String host, @Nullable Integer port, @Nullable String database, @Nullable String username, @Redact @Nullable String password, int fixed_pool_size, @NotNull Duration connection_timeout, @NotNull Duration validation_timeout, @Nullable Duration connection_idle_timeout, @NotNull Duration connection_max_lifetime, @Nullable Duration query_timeout, @Nullable String migrations_resource, @Nullable List<String> migrations_resources, @Nullable List<String> migrations_resources_exclusion, @NotNull String migrations_resources_regex, @Nullable String vitess_schema_resource_root, @Nullable String trust_certificate_key_store_url) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        Intrinsics.checkNotNullParameter((Object)connection_timeout, (String)"connection_timeout");
        Intrinsics.checkNotNullParameter((Object)validation_timeout, (String)"validation_timeout");
        Intrinsics.checkNotNullParameter((Object)connection_max_lifetime, (String)"connection_max_lifetime");
        Intrinsics.checkNotNullParameter((Object)migrations_resources_regex, (String)"migrations_resources_regex");
        this(type, host, port, database, username, password, fixed_pool_size, connection_timeout, validation_timeout, connection_idle_timeout, connection_max_lifetime, query_timeout, migrations_resource, migrations_resources, migrations_resources_exclusion, migrations_resources_regex, vitess_schema_resource_root, trust_certificate_key_store_url, null, null, null, null, null, false, null, null, null, null, false, false, null, false, -262144, null);
    }

    @JvmOverloads
    public DataSourceConfig(@NotNull DataSourceType type, @Nullable String host, @Nullable Integer port, @Nullable String database, @Nullable String username, @Redact @Nullable String password, int fixed_pool_size, @NotNull Duration connection_timeout, @NotNull Duration validation_timeout, @Nullable Duration connection_idle_timeout, @NotNull Duration connection_max_lifetime, @Nullable Duration query_timeout, @Nullable String migrations_resource, @Nullable List<String> migrations_resources, @Nullable List<String> migrations_resources_exclusion, @NotNull String migrations_resources_regex, @Nullable String vitess_schema_resource_root) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        Intrinsics.checkNotNullParameter((Object)connection_timeout, (String)"connection_timeout");
        Intrinsics.checkNotNullParameter((Object)validation_timeout, (String)"validation_timeout");
        Intrinsics.checkNotNullParameter((Object)connection_max_lifetime, (String)"connection_max_lifetime");
        Intrinsics.checkNotNullParameter((Object)migrations_resources_regex, (String)"migrations_resources_regex");
        this(type, host, port, database, username, password, fixed_pool_size, connection_timeout, validation_timeout, connection_idle_timeout, connection_max_lifetime, query_timeout, migrations_resource, migrations_resources, migrations_resources_exclusion, migrations_resources_regex, vitess_schema_resource_root, null, null, null, null, null, null, false, null, null, null, null, false, false, null, false, -131072, null);
    }

    @JvmOverloads
    public DataSourceConfig(@NotNull DataSourceType type, @Nullable String host, @Nullable Integer port, @Nullable String database, @Nullable String username, @Redact @Nullable String password, int fixed_pool_size, @NotNull Duration connection_timeout, @NotNull Duration validation_timeout, @Nullable Duration connection_idle_timeout, @NotNull Duration connection_max_lifetime, @Nullable Duration query_timeout, @Nullable String migrations_resource, @Nullable List<String> migrations_resources, @Nullable List<String> migrations_resources_exclusion, @NotNull String migrations_resources_regex) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        Intrinsics.checkNotNullParameter((Object)connection_timeout, (String)"connection_timeout");
        Intrinsics.checkNotNullParameter((Object)validation_timeout, (String)"validation_timeout");
        Intrinsics.checkNotNullParameter((Object)connection_max_lifetime, (String)"connection_max_lifetime");
        Intrinsics.checkNotNullParameter((Object)migrations_resources_regex, (String)"migrations_resources_regex");
        this(type, host, port, database, username, password, fixed_pool_size, connection_timeout, validation_timeout, connection_idle_timeout, connection_max_lifetime, query_timeout, migrations_resource, migrations_resources, migrations_resources_exclusion, migrations_resources_regex, null, null, null, null, null, null, null, false, null, null, null, null, false, false, null, false, -65536, null);
    }

    @JvmOverloads
    public DataSourceConfig(@NotNull DataSourceType type, @Nullable String host, @Nullable Integer port, @Nullable String database, @Nullable String username, @Redact @Nullable String password, int fixed_pool_size, @NotNull Duration connection_timeout, @NotNull Duration validation_timeout, @Nullable Duration connection_idle_timeout, @NotNull Duration connection_max_lifetime, @Nullable Duration query_timeout, @Nullable String migrations_resource, @Nullable List<String> migrations_resources, @Nullable List<String> migrations_resources_exclusion) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        Intrinsics.checkNotNullParameter((Object)connection_timeout, (String)"connection_timeout");
        Intrinsics.checkNotNullParameter((Object)validation_timeout, (String)"validation_timeout");
        Intrinsics.checkNotNullParameter((Object)connection_max_lifetime, (String)"connection_max_lifetime");
        this(type, host, port, database, username, password, fixed_pool_size, connection_timeout, validation_timeout, connection_idle_timeout, connection_max_lifetime, query_timeout, migrations_resource, migrations_resources, migrations_resources_exclusion, null, null, null, null, null, null, null, null, false, null, null, null, null, false, false, null, false, Short.MIN_VALUE, null);
    }

    @JvmOverloads
    public DataSourceConfig(@NotNull DataSourceType type, @Nullable String host, @Nullable Integer port, @Nullable String database, @Nullable String username, @Redact @Nullable String password, int fixed_pool_size, @NotNull Duration connection_timeout, @NotNull Duration validation_timeout, @Nullable Duration connection_idle_timeout, @NotNull Duration connection_max_lifetime, @Nullable Duration query_timeout, @Nullable String migrations_resource, @Nullable List<String> migrations_resources) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        Intrinsics.checkNotNullParameter((Object)connection_timeout, (String)"connection_timeout");
        Intrinsics.checkNotNullParameter((Object)validation_timeout, (String)"validation_timeout");
        Intrinsics.checkNotNullParameter((Object)connection_max_lifetime, (String)"connection_max_lifetime");
        this(type, host, port, database, username, password, fixed_pool_size, connection_timeout, validation_timeout, connection_idle_timeout, connection_max_lifetime, query_timeout, migrations_resource, migrations_resources, null, null, null, null, null, null, null, null, null, false, null, null, null, null, false, false, null, false, -16384, null);
    }

    @JvmOverloads
    public DataSourceConfig(@NotNull DataSourceType type, @Nullable String host, @Nullable Integer port, @Nullable String database, @Nullable String username, @Redact @Nullable String password, int fixed_pool_size, @NotNull Duration connection_timeout, @NotNull Duration validation_timeout, @Nullable Duration connection_idle_timeout, @NotNull Duration connection_max_lifetime, @Nullable Duration query_timeout, @Nullable String migrations_resource) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        Intrinsics.checkNotNullParameter((Object)connection_timeout, (String)"connection_timeout");
        Intrinsics.checkNotNullParameter((Object)validation_timeout, (String)"validation_timeout");
        Intrinsics.checkNotNullParameter((Object)connection_max_lifetime, (String)"connection_max_lifetime");
        this(type, host, port, database, username, password, fixed_pool_size, connection_timeout, validation_timeout, connection_idle_timeout, connection_max_lifetime, query_timeout, migrations_resource, null, null, null, null, null, null, null, null, null, null, false, null, null, null, null, false, false, null, false, -8192, null);
    }

    @JvmOverloads
    public DataSourceConfig(@NotNull DataSourceType type, @Nullable String host, @Nullable Integer port, @Nullable String database, @Nullable String username, @Redact @Nullable String password, int fixed_pool_size, @NotNull Duration connection_timeout, @NotNull Duration validation_timeout, @Nullable Duration connection_idle_timeout, @NotNull Duration connection_max_lifetime, @Nullable Duration query_timeout) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        Intrinsics.checkNotNullParameter((Object)connection_timeout, (String)"connection_timeout");
        Intrinsics.checkNotNullParameter((Object)validation_timeout, (String)"validation_timeout");
        Intrinsics.checkNotNullParameter((Object)connection_max_lifetime, (String)"connection_max_lifetime");
        this(type, host, port, database, username, password, fixed_pool_size, connection_timeout, validation_timeout, connection_idle_timeout, connection_max_lifetime, query_timeout, null, null, null, null, null, null, null, null, null, null, null, false, null, null, null, null, false, false, null, false, -4096, null);
    }

    @JvmOverloads
    public DataSourceConfig(@NotNull DataSourceType type, @Nullable String host, @Nullable Integer port, @Nullable String database, @Nullable String username, @Redact @Nullable String password, int fixed_pool_size, @NotNull Duration connection_timeout, @NotNull Duration validation_timeout, @Nullable Duration connection_idle_timeout, @NotNull Duration connection_max_lifetime) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        Intrinsics.checkNotNullParameter((Object)connection_timeout, (String)"connection_timeout");
        Intrinsics.checkNotNullParameter((Object)validation_timeout, (String)"validation_timeout");
        Intrinsics.checkNotNullParameter((Object)connection_max_lifetime, (String)"connection_max_lifetime");
        this(type, host, port, database, username, password, fixed_pool_size, connection_timeout, validation_timeout, connection_idle_timeout, connection_max_lifetime, null, null, null, null, null, null, null, null, null, null, null, null, false, null, null, null, null, false, false, null, false, -2048, null);
    }

    @JvmOverloads
    public DataSourceConfig(@NotNull DataSourceType type, @Nullable String host, @Nullable Integer port, @Nullable String database, @Nullable String username, @Redact @Nullable String password, int fixed_pool_size, @NotNull Duration connection_timeout, @NotNull Duration validation_timeout, @Nullable Duration connection_idle_timeout) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        Intrinsics.checkNotNullParameter((Object)connection_timeout, (String)"connection_timeout");
        Intrinsics.checkNotNullParameter((Object)validation_timeout, (String)"validation_timeout");
        this(type, host, port, database, username, password, fixed_pool_size, connection_timeout, validation_timeout, connection_idle_timeout, null, null, null, null, null, null, null, null, null, null, null, null, null, false, null, null, null, null, false, false, null, false, -1024, null);
    }

    @JvmOverloads
    public DataSourceConfig(@NotNull DataSourceType type, @Nullable String host, @Nullable Integer port, @Nullable String database, @Nullable String username, @Redact @Nullable String password, int fixed_pool_size, @NotNull Duration connection_timeout, @NotNull Duration validation_timeout) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        Intrinsics.checkNotNullParameter((Object)connection_timeout, (String)"connection_timeout");
        Intrinsics.checkNotNullParameter((Object)validation_timeout, (String)"validation_timeout");
        this(type, host, port, database, username, password, fixed_pool_size, connection_timeout, validation_timeout, null, null, null, null, null, null, null, null, null, null, null, null, null, null, false, null, null, null, null, false, false, null, false, -512, null);
    }

    @JvmOverloads
    public DataSourceConfig(@NotNull DataSourceType type, @Nullable String host, @Nullable Integer port, @Nullable String database, @Nullable String username, @Redact @Nullable String password, int fixed_pool_size, @NotNull Duration connection_timeout) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        Intrinsics.checkNotNullParameter((Object)connection_timeout, (String)"connection_timeout");
        this(type, host, port, database, username, password, fixed_pool_size, connection_timeout, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, false, null, null, null, null, false, false, null, false, -256, null);
    }

    @JvmOverloads
    public DataSourceConfig(@NotNull DataSourceType type, @Nullable String host, @Nullable Integer port, @Nullable String database, @Nullable String username, @Redact @Nullable String password, int fixed_pool_size) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        this(type, host, port, database, username, password, fixed_pool_size, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, false, null, null, null, null, false, false, null, false, -128, null);
    }

    @JvmOverloads
    public DataSourceConfig(@NotNull DataSourceType type, @Nullable String host, @Nullable Integer port, @Nullable String database, @Nullable String username, @Redact @Nullable String password) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        this(type, host, port, database, username, password, 0, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, false, null, null, null, null, false, false, null, false, -64, null);
    }

    @JvmOverloads
    public DataSourceConfig(@NotNull DataSourceType type, @Nullable String host, @Nullable Integer port, @Nullable String database, @Nullable String username) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        this(type, host, port, database, username, null, 0, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, false, null, null, null, null, false, false, null, false, -32, null);
    }

    @JvmOverloads
    public DataSourceConfig(@NotNull DataSourceType type, @Nullable String host, @Nullable Integer port, @Nullable String database) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        this(type, host, port, database, null, null, 0, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, false, null, null, null, null, false, false, null, false, -16, null);
    }

    @JvmOverloads
    public DataSourceConfig(@NotNull DataSourceType type, @Nullable String host, @Nullable Integer port) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        this(type, host, port, null, null, null, 0, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, false, null, null, null, null, false, false, null, false, -8, null);
    }

    @JvmOverloads
    public DataSourceConfig(@NotNull DataSourceType type, @Nullable String host) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        this(type, host, null, null, null, null, 0, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, false, null, null, null, null, false, false, null, false, -4, null);
    }

    @JvmOverloads
    public DataSourceConfig(@NotNull DataSourceType type) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        this(type, null, null, null, null, null, 0, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, false, null, null, null, null, false, false, null, false, -2, null);
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[DataSourceType.values().length];
            try {
                nArray[DataSourceType.MYSQL.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DataSourceType.TIDB.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DataSourceType.VITESS_MYSQL.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DataSourceType.HSQLDB.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DataSourceType.COCKROACHDB.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DataSourceType.POSTGRESQL.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

