/*
 * Decompiled with CFR 0.152.
 */
package misk.vitess;

import com.google.common.base.Strings;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Range;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import misk.vitess.Keyspace;
import misk.vitess.ShardKt;
import misk.vitess.VitessHash;
import okio.ByteString;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0005\b\u0086\b\u0018\u0000 \u001c2\u00020\u0001:\u0002\u001c\u001dB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0005H\u00c6\u0003J\u0011\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\nH\u0086\u0002J\u001d\u0010\u0015\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0016\u001a\u00020\u00132\b\u0010\u0017\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0018\u001a\u00020\u0019H\u00d6\u0001J\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\n0\tJ\u000e\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0002J\b\u0010\u001b\u001a\u00020\u0005H\u0016RJ\u0010\u0007\u001a>\u0012\u0018\u0012\u0016\u0012\u0004\u0012\u00020\n \u000b*\n\u0012\u0004\u0012\u00020\n\u0018\u00010\t0\t \u000b*\u001e\u0012\u0018\u0012\u0016\u0012\u0004\u0012\u00020\n \u000b*\n\u0012\u0004\u0012\u00020\n\u0018\u00010\t0\t\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001e"}, d2={"Lmisk/vitess/Shard;", "", "keyspace", "Lmisk/vitess/Keyspace;", "name", "", "(Lmisk/vitess/Keyspace;Ljava/lang/String;)V", "keyRange", "Lcom/google/common/base/Supplier;", "Lcom/google/common/collect/Range;", "Lmisk/vitess/Shard$Key;", "kotlin.jvm.PlatformType", "getKeyspace", "()Lmisk/vitess/Keyspace;", "getName", "()Ljava/lang/String;", "component1", "component2", "contains", "", "keyspaceId", "copy", "equals", "other", "hashCode", "", "toKeyRange", "toString", "Companion", "Key", "misk-jdbc"})
public final class Shard {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Keyspace keyspace;
    @NotNull
    private final String name;
    private final transient Supplier<Range<Key>> keyRange;
    @NotNull
    public static final String SINGLE_SHARD_ID = "0";
    public static final int MAX_LENGTH = 8;
    @NotNull
    private static final Keyspace SINGLE_KEYSPACE = new Keyspace("keyspace");
    @NotNull
    private static final Shard SINGLE_SHARD = new Shard(SINGLE_KEYSPACE, "0");
    private static final ImmutableSet<Shard> SINGLE_SHARD_SET = ImmutableSet.of((Object)SINGLE_SHARD);

    public Shard(@NotNull Keyspace keyspace, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)keyspace, (String)"keyspace");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.keyspace = keyspace;
        this.name = name;
        ShardKt.checkValidShardIdentifier(this.name);
        this.keyRange = Suppliers.memoize(() -> Shard.keyRange$lambda$0(this));
    }

    @NotNull
    public final Keyspace getKeyspace() {
        return this.keyspace;
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    @NotNull
    public String toString() {
        return this.keyspace.getName() + "/" + this.name;
    }

    @NotNull
    public final Range<Key> keyRange() {
        Object object = this.keyRange.get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        return (Range)object;
    }

    private final Range<Key> toKeyRange() {
        if (this.name.equals(SINGLE_SHARD_ID)) {
            Range range = Range.all();
            Intrinsics.checkNotNullExpressionValue((Object)range, (String)"all(...)");
            return range;
        }
        String[] stringArray = new String[]{"-"};
        List list = StringsKt.split$default((CharSequence)this.name, (String[])stringArray, (boolean)false, (int)2, (int)2, null);
        String lower = (String)list.get(0);
        String upper = (String)list.get(1);
        if (((CharSequence)lower).length() == 0 && ((CharSequence)upper).length() == 0) {
            Range range = Range.all();
            Intrinsics.checkNotNullExpressionValue((Object)range, (String)"all(...)");
            return range;
        }
        if (((CharSequence)lower).length() == 0) {
            Range range = Range.lessThan((Comparable)new Key(upper));
            Intrinsics.checkNotNullExpressionValue((Object)range, (String)"lessThan(...)");
            return range;
        }
        if (((CharSequence)upper).length() == 0) {
            Range range = Range.atLeast((Comparable)new Key(lower));
            Intrinsics.checkNotNullExpressionValue((Object)range, (String)"atLeast(...)");
            return range;
        }
        Range range = Range.closedOpen((Comparable)new Key(lower), (Comparable)new Key(upper));
        Intrinsics.checkNotNullExpressionValue((Object)range, (String)"closedOpen(...)");
        return range;
    }

    public final boolean contains(@NotNull Key keyspaceId) {
        Intrinsics.checkNotNullParameter((Object)keyspaceId, (String)"keyspaceId");
        return this.keyRange().contains((Comparable)keyspaceId);
    }

    @NotNull
    public final Keyspace component1() {
        return this.keyspace;
    }

    @NotNull
    public final String component2() {
        return this.name;
    }

    @NotNull
    public final Shard copy(@NotNull Keyspace keyspace, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)keyspace, (String)"keyspace");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return new Shard(keyspace, name);
    }

    public static /* synthetic */ Shard copy$default(Shard shard, Keyspace keyspace, String string, int n, Object object) {
        if ((n & 1) != 0) {
            keyspace = shard.keyspace;
        }
        if ((n & 2) != 0) {
            string = shard.name;
        }
        return shard.copy(keyspace, string);
    }

    public int hashCode() {
        int result = this.keyspace.hashCode();
        result = result * 31 + this.name.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Shard)) {
            return false;
        }
        Shard shard = (Shard)other;
        if (!Intrinsics.areEqual((Object)this.keyspace, (Object)shard.keyspace)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.name, (Object)shard.name);
    }

    private static final Range keyRange$lambda$0(Shard this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        return this$0.toKeyRange();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0014\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\u000eR\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u000eX\u0086T\u00a2\u0006\u0002\n\u0000R5\u0010\u000f\u001a&\u0012\f\u0012\n \u0011*\u0004\u0018\u00010\n0\n \u0011*\u0012\u0012\f\u0012\n \u0011*\u0004\u0018\u00010\n0\n\u0018\u00010\u00100\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0016"}, d2={"Lmisk/vitess/Shard$Companion;", "", "()V", "MAX_LENGTH", "", "SINGLE_KEYSPACE", "Lmisk/vitess/Keyspace;", "getSINGLE_KEYSPACE", "()Lmisk/vitess/Keyspace;", "SINGLE_SHARD", "Lmisk/vitess/Shard;", "getSINGLE_SHARD", "()Lmisk/vitess/Shard;", "SINGLE_SHARD_ID", "", "SINGLE_SHARD_SET", "Lcom/google/common/collect/ImmutableSet;", "kotlin.jvm.PlatformType", "getSINGLE_SHARD_SET", "()Lcom/google/common/collect/ImmutableSet;", "parse", "string", "misk-jdbc"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Keyspace getSINGLE_KEYSPACE() {
            return SINGLE_KEYSPACE;
        }

        @NotNull
        public final Shard getSINGLE_SHARD() {
            return SINGLE_SHARD;
        }

        public final ImmutableSet<Shard> getSINGLE_SHARD_SET() {
            return SINGLE_SHARD_SET;
        }

        @NotNull
        public final Shard parse(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"string");
            char[] cArray = new char[]{'/', ':'};
            List list = StringsKt.split$default((CharSequence)string, (char[])cArray, (boolean)false, (int)2, (int)2, null);
            String keyspace = (String)list.get(0);
            String shard = (String)list.get(1);
            return new Shard(new Keyspace(keyspace), shard);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\u0010\u0000\n\u0002\b\u0004\b\u0086\b\u0018\u0000 \u00142\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\u0014B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\r\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0011\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0000H\u0096\u0002J\t\u0010\r\u001a\u00020\u0006H\u00c6\u0003J\u0013\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0005\u001a\u00020\u0006H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\f\u001a\u0004\u0018\u00010\u0011H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u000bH\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0015"}, d2={"Lmisk/vitess/Shard$Key;", "", "hex", "", "(Ljava/lang/String;)V", "bytes", "Lokio/ByteString;", "(Lokio/ByteString;)V", "getBytes", "()Lokio/ByteString;", "compareTo", "", "other", "component1", "copy", "equals", "", "", "hashCode", "toString", "Companion", "misk-jdbc"})
    public static final class Key
    implements Comparable<Key> {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final ByteString bytes;

        public Key(@NotNull ByteString bytes) {
            Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
            this.bytes = bytes;
            if (!(this.bytes.size() <= 8)) {
                boolean bl = false;
                String string = this.bytes.hex() + " is longer than the supported max length 8";
                throw new IllegalStateException(string.toString());
            }
        }

        @NotNull
        public final ByteString getBytes() {
            return this.bytes;
        }

        @Override
        public int compareTo(@NotNull Key other) {
            Intrinsics.checkNotNullParameter((Object)other, (String)"other");
            return this.bytes.compareTo(other.bytes);
        }

        public Key(@NotNull String hex) {
            Intrinsics.checkNotNullParameter((Object)hex, (String)"hex");
            String string = Strings.padEnd((String)hex, (int)8, (char)'0');
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"padEnd(...)");
            this(ByteString.Companion.decodeHex(string));
        }

        @NotNull
        public final ByteString component1() {
            return this.bytes;
        }

        @NotNull
        public final Key copy(@NotNull ByteString bytes) {
            Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
            return new Key(bytes);
        }

        public static /* synthetic */ Key copy$default(Key key, ByteString byteString, int n, Object object) {
            if ((n & 1) != 0) {
                byteString = key.bytes;
            }
            return key.copy(byteString);
        }

        @NotNull
        public String toString() {
            return "Key(bytes=" + this.bytes + ")";
        }

        public int hashCode() {
            return this.bytes.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Key)) {
                return false;
            }
            Key key = (Key)other;
            return Intrinsics.areEqual((Object)this.bytes, (Object)key.bytes);
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lmisk/vitess/Shard$Key$Companion;", "", "()V", "hash", "Lmisk/vitess/Shard$Key;", "id", "", "misk-jdbc"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final Key hash(long id) {
                return new Key(VitessHash.INSTANCE.toKeyspaceId(id));
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

