/*
 * Decompiled with CFR 0.152.
 */
package misk.database;

import com.zaxxer.hikari.util.DriverDataSource;
import java.sql.Connection;
import java.util.Properties;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import misk.jdbc.DataSourceConfig;
import org.jetbrains.annotations.NotNull;
import wisp.deployment.DeploymentKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0013\u001a\u00020\u0014H\u0002J\u0006\u0010\u0015\u001a\u00020\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\nX\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\nX\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\nX\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\f\u00a8\u0006\u0017"}, d2={"Lmisk/database/CockroachCluster;", "", "name", "", "config", "Lmisk/jdbc/DataSourceConfig;", "(Ljava/lang/String;Lmisk/jdbc/DataSourceConfig;)V", "getConfig", "()Lmisk/jdbc/DataSourceConfig;", "externalHttpPort", "", "getExternalHttpPort", "()I", "internalHttpPort", "getInternalHttpPort", "getName", "()Ljava/lang/String;", "postgresPort", "getPostgresPort", "dataSource", "Lcom/zaxxer/hikari/util/DriverDataSource;", "openConnection", "Ljava/sql/Connection;", "misk-jdbc"})
public final class CockroachCluster {
    @NotNull
    private final String name;
    @NotNull
    private final DataSourceConfig config;
    private final int externalHttpPort;
    private final int internalHttpPort;
    private final int postgresPort;

    public CockroachCluster(@NotNull String name, @NotNull DataSourceConfig config) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        this.name = name;
        this.config = config;
        this.externalHttpPort = 26258;
        this.internalHttpPort = 8080;
        this.postgresPort = 26257;
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    @NotNull
    public final DataSourceConfig getConfig() {
        return this.config;
    }

    @NotNull
    public final Connection openConnection() {
        Connection connection = this.dataSource().getConnection();
        Intrinsics.checkNotNullExpressionValue((Object)connection, (String)"getConnection(...)");
        return connection;
    }

    private final DriverDataSource dataSource() {
        String jdbcUrl = this.config.withDefaults().buildJdbcUrl(DeploymentKt.getTESTING());
        return new DriverDataSource(jdbcUrl, this.config.getType().getDriverClassName(), new Properties(), this.config.getUsername(), this.config.getPassword());
    }

    public final int getExternalHttpPort() {
        return this.externalHttpPort;
    }

    public final int getInternalHttpPort() {
        return this.internalHttpPort;
    }

    public final int getPostgresPort() {
        return this.postgresPort;
    }
}

