/*
 * Decompiled with CFR 0.152.
 */
package misk.database;

import com.github.dockerjava.api.DockerClient;
import com.github.dockerjava.api.async.ResultCallback;
import com.github.dockerjava.api.command.CreateContainerCmd;
import com.github.dockerjava.api.model.Container;
import com.github.dockerjava.api.model.ExposedPort;
import com.github.dockerjava.api.model.Frame;
import com.github.dockerjava.api.model.Ports;
import com.github.dockerjava.core.async.ResultCallbackTemplate;
import com.zaxxer.hikari.util.DriverDataSource;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import misk.backoff.Backoff;
import misk.backoff.DontRetryException;
import misk.backoff.ExponentialBackoff;
import misk.backoff.RetriesKt;
import misk.database.DatabaseServer;
import misk.database.DockerPostgresServer;
import misk.database.StartDatabaseServiceKt;
import misk.jdbc.DataSourceConfig;
import mu.KLogger;
import mu.KotlinLogging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import wisp.deployment.DeploymentKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\t\u0018\u0000 \u001c2\u00020\u0001:\u0003\u001c\u001d\u001eB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0015\u001a\u00020\u0016H\u0002J\b\u0010\u0017\u001a\u00020\u0016H\u0002J\b\u0010\u0018\u001a\u00020\u0016H\u0016J\b\u0010\u0019\u001a\u00020\u0016H\u0016J\b\u0010\u001a\u001a\u00020\u0016H\u0016J\b\u0010\u001b\u001a\u00020\u0016H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0011\u001a\n\u0018\u00010\u0012j\u0004\u0018\u0001`\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lmisk/database/DockerPostgresServer;", "Lmisk/database/DatabaseServer;", "config", "Lmisk/jdbc/DataSourceConfig;", "docker", "Lcom/github/dockerjava/api/DockerClient;", "(Lmisk/jdbc/DataSourceConfig;Lcom/github/dockerjava/api/DockerClient;)V", "getConfig", "()Lmisk/jdbc/DataSourceConfig;", "containerId", "", "getDocker", "()Lcom/github/dockerjava/api/DockerClient;", "isRunning", "", "server", "Lmisk/database/DockerPostgresServer$PostgresServer;", "startupFailure", "Ljava/lang/Exception;", "Lkotlin/Exception;", "stopContainerOnExit", "createDatabase", "", "doStart", "pullImage", "start", "stop", "waitUntilHealthy", "Companion", "LogContainerResultCallback", "PostgresServer", "misk-jdbc"})
public final class DockerPostgresServer
implements DatabaseServer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final DataSourceConfig config;
    @NotNull
    private final DockerClient docker;
    @NotNull
    private final PostgresServer server;
    @Nullable
    private String containerId;
    private boolean isRunning;
    private boolean stopContainerOnExit;
    @Nullable
    private Exception startupFailure;
    @NotNull
    private static final KLogger logger = KotlinLogging.INSTANCE.logger((Function0)Companion.logger.1.INSTANCE);
    @NotNull
    public static final String SHA = "7421834e2eae283f829d3face39acba2e8ffbe24be756f7cabdfe778e7bfec57";
    @NotNull
    public static final String IMAGE = "postgres@sha256:7421834e2eae283f829d3face39acba2e8ffbe24be756f7cabdfe778e7bfec57";
    @NotNull
    public static final String CONTAINER_NAME = "misk-postgres-testing";
    @NotNull
    private static final AtomicBoolean imagePulled = new AtomicBoolean();

    public DockerPostgresServer(@NotNull DataSourceConfig config, @NotNull DockerClient docker) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)docker, (String)"docker");
        this.config = config;
        this.docker = docker;
        this.stopContainerOnExit = true;
        this.server = new PostgresServer(this.config);
    }

    @NotNull
    public final DataSourceConfig getConfig() {
        return this.config;
    }

    @NotNull
    public final DockerClient getDocker() {
        return this.docker;
    }

    @Override
    public void start() {
        Exception startupFailure = this.startupFailure;
        if (startupFailure != null) {
            throw startupFailure;
        }
        if (this.isRunning) {
            return;
        }
        this.isRunning = true;
        try {
            this.doStart();
        }
        catch (Exception e) {
            this.startupFailure = e;
            throw e;
        }
    }

    @Override
    public void pullImage() {
        Companion.pullImage();
    }

    private final void doStart() {
        ExposedPort postgresPort = ExposedPort.tcp((int)this.server.getPostgresPort());
        Ports ports = new Ports();
        ports.bind(postgresPort, Ports.Binding.bindPort((int)postgresPort.getPort()));
        String containerName = CONTAINER_NAME;
        Object object = this.docker.listContainersCmd().withNameFilter((Collection)CollectionsKt.listOf((Object)containerName)).withLimit(Integer.valueOf(1)).exec();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"exec(...)");
        Container runningContainer = (Container)CollectionsKt.firstOrNull((List)((List)object));
        if (runningContainer != null) {
            if (!Intrinsics.areEqual((Object)runningContainer.getState(), (Object)"running")) {
                logger.info("Existing Postgres named " + containerName + " found in state " + runningContainer.getState() + ", force removing and restarting");
                this.docker.removeContainerCmd(runningContainer.getId()).withForce(Boolean.valueOf(true)).exec();
            } else {
                logger.info("Using existing Postgres container named " + containerName);
                this.stopContainerOnExit = false;
                this.containerId = runningContainer.getId();
            }
        }
        if (this.containerId == null) {
            logger.info("Starting Postgres with command");
            String[] stringArray = new String[]{"POSTGRES_PASSWORD=password"};
            CreateContainerCmd createContainerCmd = this.docker.createContainerCmd(IMAGE).withEnv(stringArray);
            stringArray = new String[]{"-d postgres"};
            CreateContainerCmd createContainerCmd2 = createContainerCmd.withCmd(stringArray);
            stringArray = new ExposedPort[]{postgresPort};
            String string = createContainerCmd2.withExposedPorts((ExposedPort[])stringArray).withPortBindings(ports).withTty(Boolean.valueOf(true)).withName(containerName).exec().getId();
            Intrinsics.checkNotNull((Object)string);
            String string2 = this.containerId = string;
            Intrinsics.checkNotNull((Object)string2);
            String containerId = string2;
            this.docker.startContainerCmd(containerId).exec();
            ((LogContainerResultCallback)this.docker.logContainerCmd(containerId).withStdErr(Boolean.valueOf(true)).withStdOut(Boolean.valueOf(true)).withFollowStream(Boolean.valueOf(true)).withSince(Integer.valueOf(0)).exec((ResultCallback)new LogContainerResultCallback())).awaitStarted();
        }
        logger.info("Started Postgres with container id " + this.containerId);
        this.waitUntilHealthy();
        this.createDatabase();
    }

    private final void waitUntilHealthy() {
        try {
            Duration duration = Duration.ofSeconds(1L);
            Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"ofSeconds(...)");
            Duration duration2 = Duration.ofSeconds(5L);
            Intrinsics.checkNotNullExpressionValue((Object)duration2, (String)"ofSeconds(...)");
            RetriesKt.retry$default((int)20, (Backoff)((Backoff)new ExponentialBackoff(duration, duration2)), null, (Function1)((Function1)new Function1<Integer, Unit>(this){
                final /* synthetic */ DockerPostgresServer this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public final void invoke(int it) {
                    AutoCloseable autoCloseable = DockerPostgresServer.access$getServer$p(this.this$0).openConnection();
                    Throwable throwable = null;
                    try {
                        Connection c = (Connection)autoCloseable;
                        boolean bl = false;
                        ResultSet resultSet = c.createStatement().executeQuery("SELECT COUNT(*) as count FROM pg_catalog.pg_database");
                        resultSet.next();
                        if (!(resultSet.getInt("count") > 0)) {
                            String string = "Check failed.";
                            throw new IllegalStateException(string.toString());
                        }
                        Unit unit = Unit.INSTANCE;
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
                    }
                }
            }), (int)4, null);
        }
        catch (DontRetryException e) {
            throw new Exception(e.getMessage());
        }
        catch (Exception e) {
            throw new Exception("Postgres server failed to start up in time", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void createDatabase() {
        AutoCloseable autoCloseable = this.server.openConnection();
        Throwable throwable = null;
        try {
            Connection c = (Connection)autoCloseable;
            boolean bl = false;
            Statement statement = c.createStatement();
            ResultSet databaseCountResultSet = statement.executeQuery("SELECT COUNT(*) as count FROM pg_catalog.pg_database WHERE datname = '" + this.config.getDatabase() + "'");
            databaseCountResultSet.next();
            if (databaseCountResultSet.getInt("count") == 0) {
                statement.addBatch("CREATE DATABASE " + this.config.getDatabase());
                statement.executeBatch();
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }

    @Override
    public void stop() {
        logger.info("Leaving Postgres docker container running in the background. If you need to kill it because you messed up migrations or something use:\n\tdocker kill misk-postgres-testing");
    }

    public static final /* synthetic */ PostgresServer access$getServer$p(DockerPostgresServer $this) {
        return $this.server;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\r\u001a\u00020\u000eR\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u000f"}, d2={"Lmisk/database/DockerPostgresServer$Companion;", "", "()V", "CONTAINER_NAME", "", "IMAGE", "SHA", "imagePulled", "Ljava/util/concurrent/atomic/AtomicBoolean;", "logger", "Lmu/KLogger;", "getLogger", "()Lmu/KLogger;", "pullImage", "", "misk-jdbc"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final KLogger getLogger() {
            return logger;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void pullImage() {
            if (imagePulled.get()) {
                return;
            }
            Companion companion = this;
            synchronized (companion) {
                boolean bl = false;
                if (imagePulled.get()) {
                    return;
                }
                if (StartDatabaseServiceKt.runCommand("docker images --digests | grep -q 7421834e2eae283f829d3face39acba2e8ffbe24be756f7cabdfe778e7bfec57 || docker pull postgres@sha256:7421834e2eae283f829d3face39acba2e8ffbe24be756f7cabdfe778e7bfec57") != 0) {
                    Companion.getLogger().warn("Failed to pull Postgres docker image. Proceeding regardless.");
                }
                imagePulled.set(true);
                Unit unit = Unit.INSTANCE;
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0002H\u0016\u00a8\u0006\u0007"}, d2={"Lmisk/database/DockerPostgresServer$LogContainerResultCallback;", "Lcom/github/dockerjava/core/async/ResultCallbackTemplate;", "Lcom/github/dockerjava/api/model/Frame;", "()V", "onNext", "", "item", "misk-jdbc"})
    public static final class LogContainerResultCallback
    extends ResultCallbackTemplate<LogContainerResultCallback, Frame> {
        public void onNext(@NotNull Frame item) {
            Intrinsics.checkNotNullParameter((Object)item, (String)"item");
            KLogger kLogger = Companion.getLogger();
            byte[] byArray = item.getPayload();
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getPayload(...)");
            byte[] byArray2 = byArray;
            kLogger.info(((Object)StringsKt.trim((CharSequence)new String(byArray2, Charsets.UTF_8))).toString());
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u000b\u001a\u00020\fH\u0002J\u0006\u0010\r\u001a\u00020\u000eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\bX\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000f"}, d2={"Lmisk/database/DockerPostgresServer$PostgresServer;", "", "config", "Lmisk/jdbc/DataSourceConfig;", "(Lmisk/jdbc/DataSourceConfig;)V", "getConfig", "()Lmisk/jdbc/DataSourceConfig;", "postgresPort", "", "getPostgresPort", "()I", "dataSource", "Lcom/zaxxer/hikari/util/DriverDataSource;", "openConnection", "Ljava/sql/Connection;", "misk-jdbc"})
    private static final class PostgresServer {
        @NotNull
        private final DataSourceConfig config;
        private final int postgresPort;

        public PostgresServer(@NotNull DataSourceConfig config) {
            Intrinsics.checkNotNullParameter((Object)config, (String)"config");
            this.config = config;
            this.postgresPort = 5432;
        }

        @NotNull
        public final DataSourceConfig getConfig() {
            return this.config;
        }

        @NotNull
        public final Connection openConnection() {
            Connection connection = this.dataSource().getConnection();
            Intrinsics.checkNotNullExpressionValue((Object)connection, (String)"getConnection(...)");
            return connection;
        }

        private final DriverDataSource dataSource() {
            String jdbcUrl = DataSourceConfig.copy$default(this.config.withDefaults(), null, null, null, "postgres", null, null, 0, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, false, null, null, null, null, false, false, null, false, -9, 1, null).buildJdbcUrl(DeploymentKt.getTESTING());
            return new DriverDataSource(jdbcUrl, this.config.getType().getDriverClassName(), new Properties(), this.config.getUsername(), this.config.getPassword());
        }

        public final int getPostgresPort() {
            return this.postgresPort;
        }
    }
}

