/*
 * Decompiled with CFR 0.152.
 */
package misk.database;

import com.squareup.moshi.JsonAdapter;
import com.squareup.moshi.Moshi;
import com.zaxxer.hikari.util.DriverDataSource;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.concurrent.ThreadsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import misk.database.Keyspace;
import misk.jdbc.DataSourceConfig;
import misk.jdbc.DataSourceType;
import misk.resources.ResourceLoader;
import okio.Okio;
import okio.Source;
import org.jetbrains.annotations.NotNull;
import wisp.deployment.DeploymentKt;
import wisp.moshi.MoshiBuildKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B)\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\b\u0010'\u001a\u00020(H\u0002J\u0012\u0010)\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00190*J\b\u0010+\u001a\u00020\u0007H\u0002J\b\u0010,\u001a\u00020(H\u0002J\u000e\u0010-\u001a\n \u001a*\u0004\u0018\u00010.0.J\u000e\u0010/\u001a\n \u001a*\u0004\u0018\u00010.0.R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\u0012X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0015\u001a\u00020\u0012X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0014R\u001f\u0010\u0017\u001a\u0010\u0012\f\u0012\n \u001a*\u0004\u0018\u00010\u00190\u00190\u0018\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0014\u0010\u001f\u001a\u00020\u0012X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\u0014R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R\u0011\u0010#\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010\u0010R\u0014\u0010%\u001a\u00020\u0012X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010\u0014\u00a8\u00060"}, d2={"Lmisk/database/VitessCluster;", "", "name", "", "resourceLoader", "Lmisk/resources/ResourceLoader;", "config", "Lmisk/jdbc/DataSourceConfig;", "moshi", "Lcom/squareup/moshi/Moshi;", "(Ljava/lang/String;Lmisk/resources/ResourceLoader;Lmisk/jdbc/DataSourceConfig;Lcom/squareup/moshi/Moshi;)V", "getConfig", "()Lmisk/jdbc/DataSourceConfig;", "configDir", "Ljava/nio/file/Path;", "getConfigDir", "()Ljava/nio/file/Path;", "grpcPort", "", "getGrpcPort", "()I", "httpPort", "getHttpPort", "keyspaceAdapter", "Lcom/squareup/moshi/JsonAdapter;", "Lmisk/database/Keyspace;", "kotlin.jvm.PlatformType", "getKeyspaceAdapter", "()Lcom/squareup/moshi/JsonAdapter;", "getMoshi", "()Lcom/squareup/moshi/Moshi;", "mysqlPort", "getMysqlPort", "getName", "()Ljava/lang/String;", "schemaDir", "getSchemaDir", "vtgateMysqlPort", "getVtgateMysqlPort", "dataSource", "Lcom/zaxxer/hikari/util/DriverDataSource;", "keyspaces", "", "mysqlConfig", "mysqlDataSource", "openMysqlConnection", "Ljava/sql/Connection;", "openVtgateConnection", "misk-jdbc"})
@SourceDebugExtension(value={"SMAP\nDockerVitessCluster.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DockerVitessCluster.kt\nmisk/database/VitessCluster\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 MoshiExtensions.kt\nmisk/moshi/MoshiExtensionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 FileReadWrite.kt\nkotlin/io/FilesKt__FileReadWriteKt\n+ 6 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,479:1\n1747#2,3:480\n766#2:484\n857#2,2:485\n1208#2,2:487\n1238#2,2:489\n1241#2:492\n5#3:483\n1#4:491\n1#4:495\n230#5,2:493\n1247#6,2:496\n*S KotlinDebug\n*F\n+ 1 DockerVitessCluster.kt\nmisk/database/VitessCluster\n*L\n60#1:480,3\n92#1:484\n92#1:485,2\n93#1:487,2\n93#1:489,2\n93#1:492\n88#1:483\n121#1:495\n121#1:493,2\n122#1:496,2\n*E\n"})
public final class VitessCluster {
    @NotNull
    private final String name;
    @NotNull
    private final DataSourceConfig config;
    @NotNull
    private final Moshi moshi;
    @NotNull
    private final Path schemaDir;
    @NotNull
    private final Path configDir;
    @NotNull
    private final JsonAdapter<Keyspace> keyspaceAdapter;
    private final int httpPort;
    private final int grpcPort;
    private final int mysqlPort;
    private final int vtgateMysqlPort;

    /*
     * WARNING - void declaration
     */
    @JvmOverloads
    public VitessCluster(@NotNull String name, @NotNull ResourceLoader resourceLoader, @NotNull DataSourceConfig config, @NotNull Moshi moshi) {
        boolean hasVschema;
        String root;
        block5: {
            boolean bl;
            void $this$any$iv;
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)resourceLoader, (String)"resourceLoader");
            Intrinsics.checkNotNullParameter((Object)config, (String)"config");
            Intrinsics.checkNotNullParameter((Object)moshi, (String)"moshi");
            this.name = name;
            this.config = config;
            this.moshi = moshi;
            String string = this.config.getVitess_schema_resource_root();
            if (string == null) {
                throw new IllegalStateException("vitess_schema_resource_root must be specified");
            }
            root = string;
            Iterable iterable = resourceLoader.walk(this.config.getVitess_schema_resource_root());
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String it = (String)element$iv;
                    boolean bl2 = false;
                    if (!StringsKt.endsWith$default((String)it, (String)"vschema.json", (boolean)false, (int)2, null)) continue;
                    bl = true;
                    break block5;
                }
                bl = hasVschema = false;
            }
        }
        if (!hasVschema) {
            boolean bl = false;
            String string = "schema root not valid, does not contain any vschema.json: " + this.config.getVitess_schema_resource_root();
            throw new IllegalStateException(string.toString());
        }
        Path path = Paths.get("/tmp/vitess_schema_" + System.currentTimeMillis(), new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
        this.schemaDir = path;
        Files.createDirectories(this.schemaDir, new FileAttribute[0]);
        resourceLoader.copyTo(root, this.schemaDir);
        Runtime.getRuntime().addShutdownHook(ThreadsKt.thread$default((boolean)false, (boolean)false, null, null, (int)0, (Function0)((Function0)new Function0<Unit>(){

            public final void invoke() {
                File file = this.getSchemaDir().toFile();
                Intrinsics.checkNotNullExpressionValue((Object)file, (String)"toFile(...)");
                FilesKt.deleteRecursively((File)file);
            }
        }), (int)30, null));
        Path path2 = Paths.get("/tmp/vitess_conf_" + System.currentTimeMillis(), new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"get(...)");
        this.configDir = path2;
        Files.createDirectories(this.configDir, new FileAttribute[0]);
        resourceLoader.copyTo("classpath:/misk/vitess", this.configDir);
        Runtime.getRuntime().addShutdownHook(ThreadsKt.thread$default((boolean)false, (boolean)false, null, null, (int)0, (Function0)((Function0)new Function0<Unit>(){

            public final void invoke() {
                File file = this.getConfigDir().toFile();
                Intrinsics.checkNotNullExpressionValue((Object)file, (String)"toFile(...)");
                FilesKt.deleteRecursively((File)file);
            }
        }), (int)30, null));
        Moshi $this$adapter$iv = this.moshi;
        boolean $i$f$adapter = false;
        JsonAdapter jsonAdapter = $this$adapter$iv.adapter(Keyspace.class);
        Intrinsics.checkNotNull((Object)jsonAdapter);
        this.keyspaceAdapter = jsonAdapter;
        this.httpPort = 27000;
        this.grpcPort = this.httpPort + 1;
        this.mysqlPort = this.httpPort + 2;
        this.vtgateMysqlPort = this.httpPort + 3;
    }

    public /* synthetic */ VitessCluster(String string, ResourceLoader resourceLoader, DataSourceConfig dataSourceConfig, Moshi moshi, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            moshi = MoshiBuildKt.getDefaultKotlinMoshi();
        }
        this(string, resourceLoader, dataSourceConfig, moshi);
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    @NotNull
    public final DataSourceConfig getConfig() {
        return this.config;
    }

    @NotNull
    public final Moshi getMoshi() {
        return this.moshi;
    }

    @NotNull
    public final Path getSchemaDir() {
        return this.schemaDir;
    }

    @NotNull
    public final Path getConfigDir() {
        return this.configDir;
    }

    @NotNull
    public final JsonAdapter<Keyspace> getKeyspaceAdapter() {
        return this.keyspaceAdapter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @NotNull
    public final Map<String, Keyspace> keyspaces() {
        void $this$associateByTo$iv$iv;
        void $this$filterTo$iv$iv;
        List<Path> list = Files.list(this.schemaDir).toList();
        Intrinsics.checkNotNullExpressionValue(list, (String)"toList(...)");
        Iterable $this$filter$iv = list;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Iterable destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Path it = (Path)element$iv$iv;
            boolean bl = false;
            if (!Files.isDirectory(it, new LinkOption[0])) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List keyspaceDirs = (List)destination$iv$iv;
        Iterable $this$associateBy$iv = keyspaceDirs;
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        destination$iv$iv = $this$associateBy$iv;
        Map destination$iv$iv2 = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            Keyspace keyspace;
            Path bl = (Path)element$iv$iv;
            Map map = destination$iv$iv2;
            boolean bl2 = false;
            Path it = (Path)element$iv$iv;
            String string = ((Object)it.getFileName()).toString();
            boolean bl3 = false;
            Path path = it.resolve("vschema.json");
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
            Source source = Okio.source((Path)path, (OpenOption[])new OpenOption[0]);
            Closeable closeable = (Closeable)source;
            Throwable throwable = null;
            try {
                Source it2 = (Source)closeable;
                boolean bl4 = false;
                Object object = this.keyspaceAdapter.fromJson(Okio.buffer((Source)source));
                Intrinsics.checkNotNull((Object)object);
                keyspace = (Keyspace)object;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            Keyspace keyspace2 = keyspace;
            map.put(string, keyspace2);
        }
        return destination$iv$iv2;
    }

    public final Connection openVtgateConnection() {
        return this.dataSource().getConnection();
    }

    public final Connection openMysqlConnection() {
        return this.mysqlDataSource().getConnection();
    }

    private final DriverDataSource dataSource() {
        String jdbcUrl = this.config.withDefaults().buildJdbcUrl(DeploymentKt.getTESTING());
        return new DriverDataSource(jdbcUrl, this.config.getType().getDriverClassName(), new Properties(), this.config.getUsername(), this.config.getPassword());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final DataSourceConfig mysqlConfig() {
        boolean isRunningInDocker;
        boolean bl;
        Object object;
        File it = object = new File("/proc/1/cgroup");
        boolean bl2 = false;
        File file = it.exists() ? object : null;
        if (file != null) {
            File $this$useLines_u24default$iv = file;
            Charset charset$iv = Charsets.UTF_8;
            boolean $i$f$useLines = false;
            Object object2 = $this$useLines_u24default$iv;
            int n = 8192;
            Object object3 = object2;
            object2 = (object3 = (Reader)new InputStreamReader((InputStream)new FileInputStream((File)object3), charset$iv)) instanceof BufferedReader ? (BufferedReader)object3 : new BufferedReader((Reader)object3, n);
            Throwable throwable = null;
            try {
                boolean bl3;
                block7: {
                    BufferedReader it$iv = (BufferedReader)object2;
                    boolean bl4 = false;
                    Sequence lines = TextStreamsKt.lineSequence((BufferedReader)it$iv);
                    boolean bl5 = false;
                    Sequence $this$any$iv = lines;
                    boolean $i$f$any = false;
                    for (Object element$iv : $this$any$iv) {
                        String it2 = (String)element$iv;
                        boolean bl6 = false;
                        if (!StringsKt.contains$default((CharSequence)it2, (CharSequence)"/docker", (boolean)false, (int)2, null)) continue;
                        bl3 = true;
                        break block7;
                    }
                    bl3 = false;
                }
                boolean bl7 = bl3;
                bl = bl7;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object2, (Throwable)throwable);
            }
        }
        bl = false;
        String server_hostname = (isRunningInDocker = bl) ? "host.docker.internal" : "127.0.0.1";
        object = DataSourceType.MYSQL;
        int n = this.mysqlPort;
        return new DataSourceConfig((DataSourceType)((Object)object), server_hostname, n, null, "vt_dba", null, 0, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, false, null, null, null, null, false, false, null, false, -24, 1, null);
    }

    private final DriverDataSource mysqlDataSource() {
        DataSourceConfig config = this.mysqlConfig();
        String jdbcUrl = config.buildJdbcUrl(DeploymentKt.getTESTING());
        return new DriverDataSource(jdbcUrl, config.getType().getDriverClassName(), new Properties(), config.getUsername(), config.getPassword());
    }

    public final int getHttpPort() {
        return this.httpPort;
    }

    public final int getGrpcPort() {
        return this.grpcPort;
    }

    public final int getMysqlPort() {
        return this.mysqlPort;
    }

    public final int getVtgateMysqlPort() {
        return this.vtgateMysqlPort;
    }

    @JvmOverloads
    public VitessCluster(@NotNull String name, @NotNull ResourceLoader resourceLoader, @NotNull DataSourceConfig config) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)resourceLoader, (String)"resourceLoader");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        this(name, resourceLoader, config, null, 8, null);
    }
}

