/*
 * Decompiled with CFR 0.152.
 */
package misk.jdbc;

import com.google.common.base.Stopwatch;
import com.google.common.util.concurrent.AbstractIdleService;
import com.google.inject.Provider;
import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import com.zaxxer.hikari.metrics.MetricsTrackerFactory;
import com.zaxxer.hikari.metrics.prometheus.PrometheusMetricsTrackerFactory;
import com.zaxxer.hikari.util.DriverDataSource;
import io.prometheus.client.CollectorRegistry;
import jakarta.inject.Singleton;
import java.lang.annotation.Annotation;
import java.sql.Connection;
import java.time.Duration;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.sql.DataSource;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import misk.jdbc.ConnectionDecoratingDataSource;
import misk.jdbc.DataSourceConfig;
import misk.jdbc.DataSourceConnector;
import misk.jdbc.DataSourceDecorator;
import misk.jdbc.DataSourceService;
import misk.jdbc.DataSourceType;
import misk.jdbc.DatabasePool;
import mu.KLogger;
import mu.KotlinLogging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import wisp.deployment.Deployment;

@Singleton
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u001b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\b\u0007\u0018\u0000 $2\u00020\u00012\u00020\u00022\b\u0012\u0004\u0012\u00020\u00040\u0003:\u0001$BI\b\u0007\u0012\u000e\u0010\u0005\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00070\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u0012\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\u0012\u00a2\u0006\u0002\u0010\u0013J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0015\u001a\u00020\u001dH\u0002J\b\u0010\u0015\u001a\u00020\tH\u0016J\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\b\u001a\u00020\tH\u0002J\u0010\u0010 \u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u0004H\u0002J\b\u0010!\u001a\u00020\u0004H\u0016J\b\u0010\"\u001a\u00020\u001fH\u0014J\b\u0010#\u001a\u00020\u001fH\u0014R\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\tX\u0082.\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0016\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0019\u001a\u0004\u0018\u00010\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lmisk/jdbc/DataSourceService;", "Lcom/google/common/util/concurrent/AbstractIdleService;", "Lmisk/jdbc/DataSourceConnector;", "Lcom/google/inject/Provider;", "Ljavax/sql/DataSource;", "qualifier", "Lkotlin/reflect/KClass;", "", "baseConfig", "Lmisk/jdbc/DataSourceConfig;", "deployment", "Lwisp/deployment/Deployment;", "dataSourceDecorators", "", "Lmisk/jdbc/DataSourceDecorator;", "databasePool", "Lmisk/jdbc/DatabasePool;", "collectorRegistry", "Lio/prometheus/client/CollectorRegistry;", "(Lkotlin/reflect/KClass;Lmisk/jdbc/DataSourceConfig;Lwisp/deployment/Deployment;Ljava/util/Set;Lmisk/jdbc/DatabasePool;Lio/prometheus/client/CollectorRegistry;)V", "_dataSource", "config", "dataSource", "getDataSource", "()Ljavax/sql/DataSource;", "hikariDataSource", "Lcom/zaxxer/hikari/HikariDataSource;", "buildDataSource", "Lcom/zaxxer/hikari/util/DriverDataSource;", "Lcom/zaxxer/hikari/HikariConfig;", "createDataSource", "", "decorate", "get", "shutDown", "startUp", "Companion", "misk-jdbc"})
@SourceDebugExtension(value={"SMAP\nDataSourceService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DataSourceService.kt\nmisk/jdbc/DataSourceService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Logging.kt\nwisp/logging/LoggingKt\n*L\n1#1,188:1\n1789#2,3:189\n12#3:192\n*S KotlinDebug\n*F\n+ 1 DataSourceService.kt\nmisk/jdbc/DataSourceService\n*L\n150#1:189,3\n166#1:192\n*E\n"})
public final class DataSourceService
extends AbstractIdleService
implements DataSourceConnector,
Provider<DataSource> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final KClass<? extends Annotation> qualifier;
    @NotNull
    private final DataSourceConfig baseConfig;
    @NotNull
    private final Deployment deployment;
    @NotNull
    private final Set<DataSourceDecorator> dataSourceDecorators;
    @NotNull
    private final DatabasePool databasePool;
    @Nullable
    private final CollectorRegistry collectorRegistry;
    private DataSourceConfig config;
    @Nullable
    private HikariDataSource hikariDataSource;
    @Nullable
    private DataSource _dataSource;
    @NotNull
    private static final KLogger logger;
    private static final Duration DEFAULT_CONNECTION_IDLE_TIMEOUT_OFFSET;

    @JvmOverloads
    public DataSourceService(@NotNull KClass<? extends Annotation> qualifier, @NotNull DataSourceConfig baseConfig, @NotNull Deployment deployment, @NotNull Set<? extends DataSourceDecorator> dataSourceDecorators, @NotNull DatabasePool databasePool, @Nullable CollectorRegistry collectorRegistry) {
        Intrinsics.checkNotNullParameter(qualifier, (String)"qualifier");
        Intrinsics.checkNotNullParameter((Object)baseConfig, (String)"baseConfig");
        Intrinsics.checkNotNullParameter((Object)deployment, (String)"deployment");
        Intrinsics.checkNotNullParameter(dataSourceDecorators, (String)"dataSourceDecorators");
        Intrinsics.checkNotNullParameter((Object)databasePool, (String)"databasePool");
        this.qualifier = qualifier;
        this.baseConfig = baseConfig;
        this.deployment = deployment;
        this.dataSourceDecorators = dataSourceDecorators;
        this.databasePool = databasePool;
        this.collectorRegistry = collectorRegistry;
    }

    public /* synthetic */ DataSourceService(KClass kClass, DataSourceConfig dataSourceConfig, Deployment deployment, Set set, DatabasePool databasePool, CollectorRegistry collectorRegistry, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x20) != 0) {
            collectorRegistry = null;
        }
        this((KClass<? extends Annotation>)kClass, dataSourceConfig, deployment, set, databasePool, collectorRegistry);
    }

    @NotNull
    public final DataSource getDataSource() {
        DataSource dataSource = this._dataSource;
        if (dataSource == null) {
            throw new IllegalStateException(("@" + this.qualifier.getSimpleName() + " DataSource not created: did you forget to start the service?").toString());
        }
        return dataSource;
    }

    protected void startUp() {
        Stopwatch stopwatch = Stopwatch.createStarted();
        logger.info("Starting @" + this.qualifier.getSimpleName() + " connection pool");
        if (!(this._dataSource == null)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        try {
            this.createDataSource(this.baseConfig);
        }
        catch (Exception e) {
            if (!this.baseConfig.canRecoverOnReplica()) {
                logger.error((Throwable)e, (Function0)startUp.1.INSTANCE);
                throw e;
            }
            logger.error((Throwable)e, (Function0)startUp.2.INSTANCE);
            this.createDataSource(this.baseConfig.asReplica());
        }
        logger.info("Started @" + this.qualifier.getSimpleName() + " connection pool in " + stopwatch);
    }

    private final void createDataSource(DataSourceConfig baseConfig) {
        DataSourceConfig dataSourceConfig;
        HikariConfig hikariConfig;
        block39: {
            String string;
            String string2;
            Map map;
            block41: {
                block40: {
                    DataSourceConfig dataSourceConfig2;
                    DataSourceConfig dataSourceConfig3;
                    block38: {
                        DataSourceConfig dataSourceConfig4;
                        long l;
                        DataSourceConfig dataSourceConfig5;
                        DataSourceConfig dataSourceConfig6;
                        this.config = this.databasePool.takeDatabase(baseConfig);
                        hikariConfig = new HikariConfig();
                        DataSourceConfig dataSourceConfig7 = this.config;
                        if (dataSourceConfig7 == null) {
                            Intrinsics.throwUninitializedPropertyAccessException((String)"config");
                            dataSourceConfig7 = null;
                        }
                        hikariConfig.setDriverClassName(dataSourceConfig7.getType().getDriverClassName());
                        DataSourceConfig dataSourceConfig8 = this.config;
                        if (dataSourceConfig8 == null) {
                            Intrinsics.throwUninitializedPropertyAccessException((String)"config");
                            dataSourceConfig8 = null;
                        }
                        hikariConfig.setJdbcUrl(dataSourceConfig8.buildJdbcUrl(this.deployment));
                        DataSourceConfig dataSourceConfig9 = this.config;
                        if (dataSourceConfig9 == null) {
                            Intrinsics.throwUninitializedPropertyAccessException((String)"config");
                            dataSourceConfig9 = null;
                        }
                        if (dataSourceConfig9.getUsername() != null) {
                            DataSourceConfig dataSourceConfig10 = this.config;
                            if (dataSourceConfig10 == null) {
                                Intrinsics.throwUninitializedPropertyAccessException((String)"config");
                                dataSourceConfig10 = null;
                            }
                            hikariConfig.setUsername(dataSourceConfig10.getUsername());
                        }
                        if ((dataSourceConfig6 = this.config) == null) {
                            Intrinsics.throwUninitializedPropertyAccessException((String)"config");
                            dataSourceConfig6 = null;
                        }
                        if (dataSourceConfig6.getPassword() != null) {
                            DataSourceConfig dataSourceConfig11 = this.config;
                            if (dataSourceConfig11 == null) {
                                Intrinsics.throwUninitializedPropertyAccessException((String)"config");
                                dataSourceConfig11 = null;
                            }
                            hikariConfig.setPassword(dataSourceConfig11.getPassword());
                        }
                        if ((dataSourceConfig5 = this.config) == null) {
                            Intrinsics.throwUninitializedPropertyAccessException((String)"config");
                            dataSourceConfig5 = null;
                        }
                        hikariConfig.setMinimumIdle(dataSourceConfig5.getFixed_pool_size());
                        DataSourceConfig dataSourceConfig12 = this.config;
                        if (dataSourceConfig12 == null) {
                            Intrinsics.throwUninitializedPropertyAccessException((String)"config");
                            dataSourceConfig12 = null;
                        }
                        hikariConfig.setMaximumPoolSize(dataSourceConfig12.getFixed_pool_size());
                        hikariConfig.setPoolName(this.qualifier.getSimpleName());
                        DataSourceConfig dataSourceConfig13 = this.config;
                        if (dataSourceConfig13 == null) {
                            Intrinsics.throwUninitializedPropertyAccessException((String)"config");
                            dataSourceConfig13 = null;
                        }
                        hikariConfig.setConnectionTimeout(dataSourceConfig13.getConnection_timeout().toMillis());
                        DataSourceConfig dataSourceConfig14 = this.config;
                        if (dataSourceConfig14 == null) {
                            Intrinsics.throwUninitializedPropertyAccessException((String)"config");
                            dataSourceConfig14 = null;
                        }
                        hikariConfig.setValidationTimeout(dataSourceConfig14.getValidation_timeout().toMillis());
                        DataSourceConfig dataSourceConfig15 = this.config;
                        if (dataSourceConfig15 == null) {
                            Intrinsics.throwUninitializedPropertyAccessException((String)"config");
                            dataSourceConfig15 = null;
                        }
                        Duration duration = dataSourceConfig15.getConnection_idle_timeout();
                        if (duration != null) {
                            l = duration.toMillis();
                        } else {
                            DataSourceConfig dataSourceConfig16 = this.config;
                            if (dataSourceConfig16 == null) {
                                Intrinsics.throwUninitializedPropertyAccessException((String)"config");
                                dataSourceConfig16 = null;
                            }
                            l = dataSourceConfig16.getConnection_max_lifetime().minus(DEFAULT_CONNECTION_IDLE_TIMEOUT_OFFSET).toMillis();
                        }
                        hikariConfig.setIdleTimeout(l);
                        DataSourceConfig dataSourceConfig17 = this.config;
                        if (dataSourceConfig17 == null) {
                            Intrinsics.throwUninitializedPropertyAccessException((String)"config");
                            dataSourceConfig17 = null;
                        }
                        hikariConfig.setMaxLifetime(dataSourceConfig17.getConnection_max_lifetime().toMillis());
                        DataSourceConfig dataSourceConfig18 = this.config;
                        if (dataSourceConfig18 == null) {
                            Intrinsics.throwUninitializedPropertyAccessException((String)"config");
                            dataSourceConfig18 = null;
                        }
                        hikariConfig.setKeepaliveTime(dataSourceConfig18.getKeepalive_time().toMillis());
                        DataSourceConfig dataSourceConfig19 = this.config;
                        if (dataSourceConfig19 == null) {
                            Intrinsics.throwUninitializedPropertyAccessException((String)"config");
                            dataSourceConfig19 = null;
                        }
                        if (dataSourceConfig19.getType() != DataSourceType.VITESS_MYSQL) {
                            hikariConfig.setAutoCommit(false);
                        }
                        if ((dataSourceConfig4 = this.config) == null) {
                            Intrinsics.throwUninitializedPropertyAccessException((String)"config");
                            dataSourceConfig4 = null;
                        }
                        if (dataSourceConfig4.getType() == DataSourceType.MYSQL) break block38;
                        DataSourceConfig dataSourceConfig20 = this.config;
                        if (dataSourceConfig20 == null) {
                            Intrinsics.throwUninitializedPropertyAccessException((String)"config");
                            dataSourceConfig20 = null;
                        }
                        if (dataSourceConfig20.getType() == DataSourceType.VITESS_MYSQL) break block38;
                        DataSourceConfig dataSourceConfig21 = this.config;
                        if (dataSourceConfig21 == null) {
                            Intrinsics.throwUninitializedPropertyAccessException((String)"config");
                            dataSourceConfig21 = null;
                        }
                        if (dataSourceConfig21.getType() != DataSourceType.TIDB) break block39;
                    }
                    if ((dataSourceConfig3 = this.config) == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"config");
                        dataSourceConfig3 = null;
                    }
                    if (!dataSourceConfig3.getUse_fixed_pool_size()) {
                        hikariConfig.setMinimumIdle(5);
                    }
                    if ((dataSourceConfig2 = this.config) == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"config");
                        dataSourceConfig2 = null;
                    }
                    if (dataSourceConfig2.getType() == DataSourceType.MYSQL) {
                        hikariConfig.setConnectionInitSql("SET time_zone = '+00:00'");
                    }
                    Properties properties = hikariConfig.getDataSourceProperties();
                    Intrinsics.checkNotNullExpressionValue((Object)properties, (String)"getDataSourceProperties(...)");
                    map = properties;
                    string2 = "cachePrepStmts";
                    string = "true";
                    map.put(string2, string);
                    Properties properties2 = hikariConfig.getDataSourceProperties();
                    Intrinsics.checkNotNullExpressionValue((Object)properties2, (String)"getDataSourceProperties(...)");
                    map = properties2;
                    string2 = "prepStmtCacheSize";
                    string = "250";
                    map.put(string2, string);
                    Properties properties3 = hikariConfig.getDataSourceProperties();
                    Intrinsics.checkNotNullExpressionValue((Object)properties3, (String)"getDataSourceProperties(...)");
                    map = properties3;
                    string2 = "prepStmtCacheSqlLimit";
                    string = "2048";
                    map.put(string2, string);
                    DataSourceConfig dataSourceConfig22 = this.config;
                    if (dataSourceConfig22 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"config");
                        dataSourceConfig22 = null;
                    }
                    if (dataSourceConfig22.getType() == DataSourceType.MYSQL) break block40;
                    DataSourceConfig dataSourceConfig23 = this.config;
                    if (dataSourceConfig23 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"config");
                        dataSourceConfig23 = null;
                    }
                    if (dataSourceConfig23.getType() != DataSourceType.TIDB) break block41;
                }
                Properties properties = hikariConfig.getDataSourceProperties();
                Intrinsics.checkNotNullExpressionValue((Object)properties, (String)"getDataSourceProperties(...)");
                map = properties;
                string2 = "useServerPrepStmts";
                string = "true";
                map.put(string2, string);
            }
            Properties properties = hikariConfig.getDataSourceProperties();
            Intrinsics.checkNotNullExpressionValue((Object)properties, (String)"getDataSourceProperties(...)");
            map = properties;
            string2 = "useLocalSessionState";
            string = "true";
            map.put(string2, string);
            Properties properties4 = hikariConfig.getDataSourceProperties();
            Intrinsics.checkNotNullExpressionValue((Object)properties4, (String)"getDataSourceProperties(...)");
            map = properties4;
            string2 = "rewriteBatchedStatements";
            string = "true";
            map.put(string2, string);
            Properties properties5 = hikariConfig.getDataSourceProperties();
            Intrinsics.checkNotNullExpressionValue((Object)properties5, (String)"getDataSourceProperties(...)");
            map = properties5;
            string2 = "cacheResultSetMetadata";
            string = "true";
            map.put(string2, string);
            Properties properties6 = hikariConfig.getDataSourceProperties();
            Intrinsics.checkNotNullExpressionValue((Object)properties6, (String)"getDataSourceProperties(...)");
            map = properties6;
            string2 = "cacheServerConfiguration";
            string = "true";
            map.put(string2, string);
            Properties properties7 = hikariConfig.getDataSourceProperties();
            Intrinsics.checkNotNullExpressionValue((Object)properties7, (String)"getDataSourceProperties(...)");
            map = properties7;
            string2 = "elideSetAutoCommits";
            string = "true";
            map.put(string2, string);
            Properties properties8 = hikariConfig.getDataSourceProperties();
            Intrinsics.checkNotNullExpressionValue((Object)properties8, (String)"getDataSourceProperties(...)");
            map = properties8;
            string2 = "maintainTimeStats";
            string = "false";
            map.put(string2, string);
            Properties properties9 = hikariConfig.getDataSourceProperties();
            Intrinsics.checkNotNullExpressionValue((Object)properties9, (String)"getDataSourceProperties(...)");
            map = properties9;
            string2 = "characterEncoding";
            string = "UTF-8";
            map.put(string2, string);
        }
        if ((dataSourceConfig = this.config) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"config");
            dataSourceConfig = null;
        }
        if (dataSourceConfig.getType() == DataSourceType.MYSQL) {
            DataSourceConfig dataSourceConfig24 = this.config;
            if (dataSourceConfig24 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"config");
                dataSourceConfig24 = null;
            }
            if (dataSourceConfig24.getMysql_enforce_writable_connections()) {
                DriverDataSource mysqlDataSource = this.buildDataSource(hikariConfig);
                hikariConfig.setDataSource((DataSource)new ConnectionDecoratingDataSource((Function1<? super Connection, ? extends Connection>)((Function1)createDataSource.1.INSTANCE), (DataSource)mysqlDataSource));
            }
        }
        CollectorRegistry collectorRegistry = this.collectorRegistry;
        if (collectorRegistry != null) {
            CollectorRegistry it = collectorRegistry;
            boolean bl = false;
            hikariConfig.setMetricsTrackerFactory((MetricsTrackerFactory)new PrometheusMetricsTrackerFactory(it));
        }
        HikariDataSource hikariDataSource = this.hikariDataSource = new HikariDataSource(hikariConfig);
        Intrinsics.checkNotNull((Object)hikariDataSource);
        this._dataSource = this.decorate((DataSource)hikariDataSource);
    }

    /*
     * WARNING - void declaration
     */
    private final DataSource decorate(DataSource dataSource) {
        Iterable $this$fold$iv = this.dataSourceDecorators;
        boolean $i$f$fold = false;
        DataSource accumulator$iv = dataSource;
        for (Object element$iv : $this$fold$iv) {
            void decorator;
            DataSourceDecorator dataSourceDecorator = (DataSourceDecorator)element$iv;
            DataSource ds = accumulator$iv;
            boolean bl = false;
            accumulator$iv = decorator.decorate(ds);
        }
        return accumulator$iv;
    }

    @Override
    @NotNull
    public DataSourceConfig config() {
        DataSourceConfig dataSourceConfig = this.config;
        if (dataSourceConfig == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"config");
            dataSourceConfig = null;
        }
        return dataSourceConfig;
    }

    protected void shutDown() {
        Stopwatch stopwatch = Stopwatch.createStarted();
        logger.info("Stopping @" + this.qualifier.getSimpleName() + " connection pool");
        if (!(this.hikariDataSource != null)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        HikariDataSource hikariDataSource = this.hikariDataSource;
        Intrinsics.checkNotNull((Object)hikariDataSource);
        hikariDataSource.close();
        DataSourceConfig dataSourceConfig = this.config;
        if (dataSourceConfig == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"config");
            dataSourceConfig = null;
        }
        this.databasePool.releaseDatabase(dataSourceConfig);
        logger.info("Stopped @" + this.qualifier.getSimpleName() + " connection pool in " + stopwatch);
    }

    @NotNull
    public DataSource get() {
        return this.getDataSource();
    }

    private final DriverDataSource buildDataSource(HikariConfig config) {
        String string = config.getJdbcUrl();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getJdbcUrl(...)");
        String jdbcUrl = string;
        String string2 = config.getUsername();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getUsername(...)");
        String username = string2;
        String string3 = config.getPassword();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getPassword(...)");
        String password = string3;
        String string4 = config.getDriverClassName();
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getDriverClassName(...)");
        String driverClassName = string4;
        Properties properties = config.getDataSourceProperties();
        Intrinsics.checkNotNullExpressionValue((Object)properties, (String)"getDataSourceProperties(...)");
        Properties dataSourceProperties = properties;
        return new DriverDataSource(jdbcUrl, driverClassName, dataSourceProperties, username, password);
    }

    @JvmOverloads
    public DataSourceService(@NotNull KClass<? extends Annotation> qualifier, @NotNull DataSourceConfig baseConfig, @NotNull Deployment deployment, @NotNull Set<? extends DataSourceDecorator> dataSourceDecorators, @NotNull DatabasePool databasePool) {
        Intrinsics.checkNotNullParameter(qualifier, (String)"qualifier");
        Intrinsics.checkNotNullParameter((Object)baseConfig, (String)"baseConfig");
        Intrinsics.checkNotNullParameter((Object)deployment, (String)"deployment");
        Intrinsics.checkNotNullParameter(dataSourceDecorators, (String)"dataSourceDecorators");
        Intrinsics.checkNotNullParameter((Object)databasePool, (String)"databasePool");
        this(qualifier, baseConfig, deployment, dataSourceDecorators, databasePool, null, 32, null);
    }

    static {
        boolean $i$f$getLogger = false;
        String string = Reflection.getOrCreateKotlinClass(DataSourceService.class).getQualifiedName();
        Intrinsics.checkNotNull((Object)string);
        logger = KotlinLogging.INSTANCE.logger(string);
        DEFAULT_CONNECTION_IDLE_TIMEOUT_OFFSET = Duration.ofSeconds(10L);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Lmisk/jdbc/DataSourceService$Companion;", "", "()V", "DEFAULT_CONNECTION_IDLE_TIMEOUT_OFFSET", "Ljava/time/Duration;", "kotlin.jvm.PlatformType", "logger", "Lmu/KLogger;", "getLogger", "()Lmu/KLogger;", "misk-jdbc"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final KLogger getLogger() {
            return logger;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

