/*
 * Decompiled with CFR 0.152.
 */
package misk.jdbc;

import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.Provider;
import com.google.inject.TypeLiteral;
import com.google.inject.binder.LinkedBindingBuilder;
import com.google.inject.binder.ScopedBindingBuilder;
import io.opentracing.Tracer;
import io.prometheus.client.CollectorRegistry;
import jakarta.inject.Inject;
import java.lang.annotation.Annotation;
import java.util.Set;
import javax.sql.DataSource;
import kotlin.Metadata;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import misk.ReadyService;
import misk.ServiceModule;
import misk.database.StartDatabaseService;
import misk.healthchecks.HealthCheck;
import misk.inject.GuiceKt;
import misk.inject.KAbstractModule;
import misk.jdbc.DataSourceConfig;
import misk.jdbc.DataSourceConnector;
import misk.jdbc.DataSourceDecorator;
import misk.jdbc.DataSourceService;
import misk.jdbc.DataSourceType;
import misk.jdbc.DatabasePool;
import misk.jdbc.PingDatabaseService;
import misk.jdbc.RealDatabasePool;
import misk.jdbc.RealTransacter;
import misk.jdbc.SchemaMigrator;
import misk.jdbc.SchemaMigratorService;
import misk.jdbc.SpanInjector;
import misk.jdbc.Transacter;
import misk.resources.ResourceLoader;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import wisp.deployment.Deployment;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u001b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B)\b\u0016\u0012\u000e\u0010\u0002\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tBO\b\u0007\u0012\u000e\u0010\u0002\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0010\u0010\n\u001a\f\u0012\u0006\b\u0001\u0012\u00020\u0004\u0018\u00010\u0003\u0012\b\u0010\u000b\u001a\u0004\u0018\u00010\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u0012\b\b\u0002\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ(\u0010\u0014\u001a\u00020\u00152\u000e\u0010\u0002\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u00032\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0016\u001a\u00020\rH\u0002J\b\u0010\u0017\u001a\u00020\u0015H\u0014R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0002\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u000b\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0010R\u0018\u0010\n\u001a\f\u0012\u0006\b\u0001\u0012\u00020\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lmisk/jdbc/JdbcModule;", "Lmisk/inject/KAbstractModule;", "qualifier", "Lkotlin/reflect/KClass;", "", "config", "Lmisk/jdbc/DataSourceConfig;", "databasePool", "Lmisk/jdbc/DatabasePool;", "(Lkotlin/reflect/KClass;Lmisk/jdbc/DataSourceConfig;Lmisk/jdbc/DatabasePool;)V", "readerQualifier", "readerConfig", "installHealthCheck", "", "(Lkotlin/reflect/KClass;Lmisk/jdbc/DataSourceConfig;Lkotlin/reflect/KClass;Lmisk/jdbc/DataSourceConfig;Lmisk/jdbc/DatabasePool;Z)V", "getConfig", "()Lmisk/jdbc/DataSourceConfig;", "getDatabasePool", "()Lmisk/jdbc/DatabasePool;", "getReaderConfig", "bindDataSource", "", "isWriter", "configure", "misk-jdbc"})
@SourceDebugExtension(value={"SMAP\nJdbcModule.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JdbcModule.kt\nmisk/jdbc/JdbcModule\n+ 2 ServiceModule.kt\nmisk/ServiceModuleKt\n+ 3 Guice.kt\nmisk/inject/GuiceKt\n+ 4 KAbstractModule.kt\nmisk/inject/KAbstractModule\n+ 5 ServiceModule.kt\nmisk/ServiceModule\n*L\n1#1,186:1\n156#2:187\n156#2:193\n156#2:210\n156#2:216\n96#3:188\n96#3:190\n96#3:191\n96#3:192\n90#3:207\n96#3:208\n96#3:209\n96#3:212\n96#3:213\n96#3:214\n96#3:215\n96#3:220\n61#4:189\n52#4,10:197\n121#5:194\n124#5,2:195\n121#5:211\n121#5:217\n124#5,2:218\n*S KotlinDebug\n*F\n+ 1 JdbcModule.kt\nmisk/jdbc/JdbcModule\n*L\n57#1:187\n107#1:193\n139#1:210\n165#1:216\n59#1:188\n78#1:190\n80#1:191\n93#1:192\n125#1:207\n127#1:208\n131#1:209\n146#1:212\n147#1:213\n161#1:214\n163#1:215\n172#1:220\n74#1:189\n113#1:197,10\n108#1:194\n109#1:195,2\n140#1:211\n167#1:217\n170#1:218,2\n*E\n"})
public final class JdbcModule
extends KAbstractModule {
    @NotNull
    private final KClass<? extends Annotation> qualifier;
    @Nullable
    private final KClass<? extends Annotation> readerQualifier;
    @NotNull
    private final DatabasePool databasePool;
    private final boolean installHealthCheck;
    @NotNull
    private final DataSourceConfig config;
    @Nullable
    private final DataSourceConfig readerConfig;

    @JvmOverloads
    public JdbcModule(@NotNull KClass<? extends Annotation> qualifier, @NotNull DataSourceConfig config, @Nullable KClass<? extends Annotation> readerQualifier, @Nullable DataSourceConfig readerConfig, @NotNull DatabasePool databasePool, boolean installHealthCheck) {
        Intrinsics.checkNotNullParameter(qualifier, (String)"qualifier");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)databasePool, (String)"databasePool");
        this.qualifier = qualifier;
        this.readerQualifier = readerQualifier;
        this.databasePool = databasePool;
        this.installHealthCheck = installHealthCheck;
        this.config = config.withDefaults();
        DataSourceConfig dataSourceConfig = readerConfig;
        this.readerConfig = dataSourceConfig != null ? dataSourceConfig.withDefaults() : null;
    }

    public /* synthetic */ JdbcModule(KClass kClass, DataSourceConfig dataSourceConfig, KClass kClass2, DataSourceConfig dataSourceConfig2, DatabasePool databasePool, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x10) != 0) {
            databasePool = RealDatabasePool.INSTANCE;
        }
        if ((n & 0x20) != 0) {
            bl = true;
        }
        this((KClass<? extends Annotation>)kClass, dataSourceConfig, (KClass<? extends Annotation>)kClass2, dataSourceConfig2, databasePool, bl);
    }

    @NotNull
    public final DatabasePool getDatabasePool() {
        return this.databasePool;
    }

    @NotNull
    public final DataSourceConfig getConfig() {
        return this.config;
    }

    @Nullable
    public final DataSourceConfig getReaderConfig() {
        return this.readerConfig;
    }

    public JdbcModule(@NotNull KClass<? extends Annotation> qualifier, @NotNull DataSourceConfig config, @NotNull DatabasePool databasePool) {
        Intrinsics.checkNotNullParameter(qualifier, (String)"qualifier");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)databasePool, (String)"databasePool");
        this(qualifier, config, null, null, databasePool, false, 32, null);
    }

    public /* synthetic */ JdbcModule(KClass kClass, DataSourceConfig dataSourceConfig, DatabasePool databasePool, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            databasePool = RealDatabasePool.INSTANCE;
        }
        this((KClass<? extends Annotation>)kClass, dataSourceConfig, databasePool);
    }

    /*
     * WARNING - void declaration
     */
    protected void configure() {
        void $this$iv;
        ServiceModule this_$iv;
        Key key;
        Key key2;
        Key key3;
        void this_$iv2;
        Key key4;
        if (this.readerQualifier != null && !(this.readerConfig != null)) {
            boolean $i$a$-check-JdbcModule$configure$22 = false;
            String $i$a$-check-JdbcModule$configure$22 = "Reader not configured for datasource " + this.readerQualifier;
            throw new IllegalStateException($i$a$-check-JdbcModule$configure$22.toString());
        }
        KAbstractModule qualifier$iv = this.qualifier;
        boolean $i$f$ServiceModule = false;
        this.install((Module)new ServiceModule(GuiceKt.toKey((KClass)Reflection.getOrCreateKotlinClass(StartDatabaseService.class), qualifier$iv), null, null, 6, null));
        KClass<? extends Annotation> a$iv = this.qualifier;
        boolean $i$f$keyOf = false;
        if (a$iv == null) {
            Key key5 = Key.get(StartDatabaseService.class);
            key4 = key5;
            Intrinsics.checkNotNullExpressionValue((Object)key5, (String)"get(...)");
        } else {
            Key key6 = Key.get(StartDatabaseService.class, (Class)JvmClassMappingKt.getJavaClass(a$iv));
            key4 = key6;
            Intrinsics.checkNotNullExpressionValue((Object)key6, (String)"get(...)");
        }
        ScopedBindingBuilder scopedBindingBuilder = this.bind(key4).toProvider((Provider)new Provider<StartDatabaseService>(this){
            @Inject
            public Deployment deployment;
            final /* synthetic */ JdbcModule this$0;
            {
                this.this$0 = $receiver;
            }

            @NotNull
            public final Deployment getDeployment() {
                Deployment deployment = this.deployment;
                if (deployment != null) {
                    return deployment;
                }
                Intrinsics.throwUninitializedPropertyAccessException((String)"deployment");
                return null;
            }

            public final void setDeployment(@NotNull Deployment deployment) {
                Intrinsics.checkNotNullParameter((Object)deployment, (String)"<set-?>");
                this.deployment = deployment;
            }

            @NotNull
            public StartDatabaseService get() {
                Deployment deployment = this.getDeployment();
                DataSourceConfig dataSourceConfig = this.this$0.getConfig();
                KClass kClass = JdbcModule.access$getQualifier$p(this.this$0);
                return new StartDatabaseService((KClass<? extends Annotation>)kClass, deployment, dataSourceConfig).init();
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)scopedBindingBuilder, (String)"toProvider(...)");
        GuiceKt.asSingleton((ScopedBindingBuilder)scopedBindingBuilder);
        this.bindDataSource(this.qualifier, this.config, true);
        if (this.readerQualifier != null && this.readerConfig != null) {
            this.bindDataSource(this.readerQualifier, this.readerConfig, false);
        }
        qualifier$iv = this;
        KClass<? extends Annotation> annotation$iv = this.qualifier;
        boolean $i$f$newMultibinder = false;
        KAbstractModule.access$newMultibinder((KAbstractModule)this_$iv2, (KClass)Reflection.getOrCreateKotlinClass(DataSourceDecorator.class), annotation$iv);
        Key schemaMigratorKey = GuiceKt.toKey((KClass)Reflection.getOrCreateKotlinClass(SchemaMigrator.class), this.qualifier);
        Provider schemaMigratorProvider = this.getProvider(schemaMigratorKey);
        KClass<? extends Annotation> a$iv2 = this.qualifier;
        boolean $i$f$keyOf2 = false;
        if (a$iv2 == null) {
            Key key7 = Key.get(DataSourceConnector.class);
            key3 = key7;
            Intrinsics.checkNotNullExpressionValue((Object)key7, (String)"get(...)");
        } else {
            Key key8 = Key.get(DataSourceConnector.class, (Class)JvmClassMappingKt.getJavaClass(a$iv2));
            key3 = key8;
            Intrinsics.checkNotNullExpressionValue((Object)key8, (String)"get(...)");
        }
        Provider connectorProvider = this.getProvider(key3);
        KClass<? extends Annotation> a$iv3 = this.qualifier;
        boolean $i$f$keyOf3 = false;
        if (a$iv3 == null) {
            Key key9 = Key.get(DataSourceService.class);
            key2 = key9;
            Intrinsics.checkNotNullExpressionValue((Object)key9, (String)"get(...)");
        } else {
            Key key10 = Key.get(DataSourceService.class, (Class)JvmClassMappingKt.getJavaClass(a$iv3));
            key2 = key10;
            Intrinsics.checkNotNullExpressionValue((Object)key10, (String)"get(...)");
        }
        Provider dataSourceServiceProvider = this.getProvider(key2);
        ScopedBindingBuilder scopedBindingBuilder2 = this.bind(schemaMigratorKey).toProvider((Provider)new Provider<SchemaMigrator>(this, (Provider<DataSourceService>)dataSourceServiceProvider, (Provider<DataSourceConnector>)connectorProvider){
            @Inject
            public ResourceLoader resourceLoader;
            final /* synthetic */ JdbcModule this$0;
            final /* synthetic */ Provider<DataSourceService> $dataSourceServiceProvider;
            final /* synthetic */ Provider<DataSourceConnector> $connectorProvider;
            {
                this.this$0 = $receiver;
                this.$dataSourceServiceProvider = $dataSourceServiceProvider;
                this.$connectorProvider = $connectorProvider;
            }

            @NotNull
            public final ResourceLoader getResourceLoader() {
                ResourceLoader resourceLoader = this.resourceLoader;
                if (resourceLoader != null) {
                    return resourceLoader;
                }
                Intrinsics.throwUninitializedPropertyAccessException((String)"resourceLoader");
                return null;
            }

            public final void setResourceLoader(@NotNull ResourceLoader resourceLoader) {
                Intrinsics.checkNotNullParameter((Object)resourceLoader, (String)"<set-?>");
                this.resourceLoader = resourceLoader;
            }

            @NotNull
            public SchemaMigrator get() {
                KClass kClass = JdbcModule.access$getQualifier$p(this.this$0);
                ResourceLoader resourceLoader = this.getResourceLoader();
                DataSourceConfig dataSourceConfig = this.this$0.getConfig();
                Object object = this.$dataSourceServiceProvider.get();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
                DataSourceService dataSourceService = (DataSourceService)object;
                Object object2 = this.$connectorProvider.get();
                Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"get(...)");
                return new SchemaMigrator((KClass<? extends Annotation>)kClass, resourceLoader, dataSourceConfig, dataSourceService, (DataSourceConnector)object2);
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)scopedBindingBuilder2, (String)"toProvider(...)");
        GuiceKt.asSingleton((ScopedBindingBuilder)scopedBindingBuilder2);
        KClass<? extends Annotation> a$iv4 = this.qualifier;
        boolean $i$f$keyOf4 = false;
        if (a$iv4 == null) {
            Key key11 = Key.get(SchemaMigratorService.class);
            key = key11;
            Intrinsics.checkNotNullExpressionValue((Object)key11, (String)"get(...)");
        } else {
            Key key12 = Key.get(SchemaMigratorService.class, (Class)JvmClassMappingKt.getJavaClass(a$iv4));
            key = key12;
            Intrinsics.checkNotNullExpressionValue((Object)key12, (String)"get(...)");
        }
        Key schemaMigratorServiceKey = key;
        ScopedBindingBuilder scopedBindingBuilder3 = this.bind(schemaMigratorServiceKey).toProvider((Provider)new Provider<SchemaMigratorService>(this, (Provider<SchemaMigrator>)schemaMigratorProvider, (Provider<DataSourceConnector>)connectorProvider){
            @Inject
            public Deployment deployment;
            final /* synthetic */ JdbcModule this$0;
            final /* synthetic */ Provider<SchemaMigrator> $schemaMigratorProvider;
            final /* synthetic */ Provider<DataSourceConnector> $connectorProvider;
            {
                this.this$0 = $receiver;
                this.$schemaMigratorProvider = $schemaMigratorProvider;
                this.$connectorProvider = $connectorProvider;
            }

            @NotNull
            public final Deployment getDeployment() {
                Deployment deployment = this.deployment;
                if (deployment != null) {
                    return deployment;
                }
                Intrinsics.throwUninitializedPropertyAccessException((String)"deployment");
                return null;
            }

            public final void setDeployment(@NotNull Deployment deployment) {
                Intrinsics.checkNotNullParameter((Object)deployment, (String)"<set-?>");
                this.deployment = deployment;
            }

            @NotNull
            public SchemaMigratorService get() {
                KClass kClass = JdbcModule.access$getQualifier$p(this.this$0);
                Deployment deployment = this.getDeployment();
                Provider<SchemaMigrator> provider = this.$schemaMigratorProvider;
                Intrinsics.checkNotNullExpressionValue(provider, (String)"$schemaMigratorProvider");
                Provider<DataSourceConnector> provider2 = this.$connectorProvider;
                Intrinsics.checkNotNullExpressionValue(provider2, (String)"$connectorProvider");
                return new SchemaMigratorService((KClass<? extends Annotation>)kClass, deployment, provider, provider2);
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)scopedBindingBuilder3, (String)"toProvider(...)");
        GuiceKt.asSingleton((ScopedBindingBuilder)scopedBindingBuilder3);
        ServiceModule qualifier$iv2 = this.qualifier;
        boolean $i$f$ServiceModule2 = false;
        qualifier$iv2 = new ServiceModule(GuiceKt.toKey((KClass)Reflection.getOrCreateKotlinClass(SchemaMigratorService.class), qualifier$iv2), null, null, 6, null);
        KClass<? extends Annotation> qualifier$iv3 = this.qualifier;
        boolean $i$f$dependsOn = false;
        this_$iv = this_$iv.dependsOn(GuiceKt.toKey((KClass)Reflection.getOrCreateKotlinClass(DataSourceService.class), qualifier$iv3));
        qualifier$iv3 = null;
        boolean $i$f$enhancedBy = false;
        this.install((Module)$this$iv.enhancedBy(GuiceKt.toKey((KClass)Reflection.getOrCreateKotlinClass(ReadyService.class), qualifier$iv3)));
        if (this.installHealthCheck) {
            KClass annotation$iv2 = null;
            boolean $i$f$multibind = false;
            KAbstractModule this_$iv$iv = this;
            boolean $i$f$newMultibinder2 = false;
            LinkedBindingBuilder linkedBindingBuilder = KAbstractModule.access$newMultibinder((KAbstractModule)this_$iv$iv, (KClass)Reflection.getOrCreateKotlinClass(HealthCheck.class), annotation$iv2).addBinding();
            Intrinsics.checkNotNullExpressionValue((Object)linkedBindingBuilder, (String)"addBinding(...)");
            linkedBindingBuilder.to(schemaMigratorServiceKey);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void bindDataSource(KClass<? extends Annotation> qualifier, DataSourceConfig config, boolean isWriter) {
        Key key;
        void $this$iv;
        ServiceModule serviceModule;
        void it;
        Key key2;
        Key key3;
        Key key4;
        Key key5;
        Key key6;
        Key key7;
        Key dataSourceDecoratorsKey = GuiceKt.toKey((TypeLiteral)GuiceKt.setOfType((KClass)Reflection.getOrCreateKotlinClass(DataSourceDecorator.class)), this.qualifier);
        boolean $i$f$keyOf = false;
        Key key8 = Key.get(Deployment.class);
        Intrinsics.checkNotNullExpressionValue((Object)key8, (String)"get(...)");
        Provider provider = this.getProvider(key8);
        Intrinsics.checkNotNullExpressionValue((Object)provider, (String)"getProvider(...)");
        Provider deploymentProvider = provider;
        boolean $i$f$keyOf2 = false;
        if (qualifier == null) {
            Key key9 = Key.get(DataSourceConfig.class);
            key7 = key9;
            Intrinsics.checkNotNullExpressionValue((Object)key9, (String)"get(...)");
        } else {
            Key key10 = Key.get(DataSourceConfig.class, (Class)JvmClassMappingKt.getJavaClass(qualifier));
            key7 = key10;
            Intrinsics.checkNotNullExpressionValue((Object)key10, (String)"get(...)");
        }
        this.bind(key7).toInstance((Object)config);
        if (this.installHealthCheck) {
            void this_$iv;
            Key key11;
            $i$f$keyOf = false;
            if (qualifier == null) {
                Key key12 = Key.get(PingDatabaseService.class);
                key11 = key12;
                Intrinsics.checkNotNullExpressionValue((Object)key12, (String)"get(...)");
            } else {
                Key key13 = Key.get(PingDatabaseService.class, (Class)JvmClassMappingKt.getJavaClass(qualifier));
                key11 = key13;
                Intrinsics.checkNotNullExpressionValue((Object)key13, (String)"get(...)");
            }
            ScopedBindingBuilder scopedBindingBuilder = this.bind(key11).toProvider(() -> JdbcModule.bindDataSource$lambda$1(config, deploymentProvider));
            Intrinsics.checkNotNullExpressionValue((Object)scopedBindingBuilder, (String)"toProvider(...)");
            GuiceKt.asSingleton((ScopedBindingBuilder)scopedBindingBuilder);
            boolean $i$f$ServiceModule22 = false;
            ServiceModule $i$f$ServiceModule22 = new ServiceModule(GuiceKt.toKey((KClass)Reflection.getOrCreateKotlinClass(PingDatabaseService.class), qualifier), null, null, 6, null);
            KClass<? extends Annotation> qualifier$iv = this.qualifier;
            boolean $i$f$dependsOn = false;
            this.install((Module)this_$iv.dependsOn(GuiceKt.toKey((KClass)Reflection.getOrCreateKotlinClass(StartDatabaseService.class), qualifier$iv)));
        }
        Provider dataSourceDecoratorsProvider = this.getProvider(dataSourceDecoratorsKey);
        $i$f$keyOf = false;
        if (qualifier == null) {
            Key key14 = Key.get(DataSource.class);
            key6 = key14;
            Intrinsics.checkNotNullExpressionValue((Object)key14, (String)"get(...)");
        } else {
            Key key15 = Key.get(DataSource.class, (Class)JvmClassMappingKt.getJavaClass(qualifier));
            key6 = key15;
            Intrinsics.checkNotNullExpressionValue((Object)key15, (String)"get(...)");
        }
        LinkedBindingBuilder linkedBindingBuilder = this.bind(key6);
        $i$f$keyOf = false;
        if (qualifier == null) {
            Key key16 = Key.get(DataSourceService.class);
            key5 = key16;
            Intrinsics.checkNotNullExpressionValue((Object)key16, (String)"get(...)");
        } else {
            Key key17 = Key.get(DataSourceService.class, (Class)JvmClassMappingKt.getJavaClass(qualifier));
            key5 = key17;
            Intrinsics.checkNotNullExpressionValue((Object)key17, (String)"get(...)");
        }
        linkedBindingBuilder.toProvider(key5);
        boolean $i$f$keyOf3 = false;
        if (qualifier == null) {
            Key key18 = Key.get(DataSourceService.class);
            key4 = key18;
            Intrinsics.checkNotNullExpressionValue((Object)key18, (String)"get(...)");
        } else {
            Key key19 = Key.get(DataSourceService.class, (Class)JvmClassMappingKt.getJavaClass(qualifier));
            key4 = key19;
            Intrinsics.checkNotNullExpressionValue((Object)key19, (String)"get(...)");
        }
        ScopedBindingBuilder scopedBindingBuilder = this.bind(key4).toProvider((Provider)new Provider<DataSourceService>(qualifier, config, (Provider<Deployment>)deploymentProvider, (Provider<Set<DataSourceDecorator>>)dataSourceDecoratorsProvider, this, isWriter){
            @com.google.inject.Inject(optional=true)
            @Nullable
            private CollectorRegistry registry;
            final /* synthetic */ KClass<? extends Annotation> $qualifier;
            final /* synthetic */ DataSourceConfig $config;
            final /* synthetic */ Provider<Deployment> $deploymentProvider;
            final /* synthetic */ Provider<Set<DataSourceDecorator>> $dataSourceDecoratorsProvider;
            final /* synthetic */ JdbcModule this$0;
            final /* synthetic */ boolean $isWriter;
            {
                this.$qualifier = $qualifier;
                this.$config = $config;
                this.$deploymentProvider = $deploymentProvider;
                this.$dataSourceDecoratorsProvider = $dataSourceDecoratorsProvider;
                this.this$0 = $receiver;
                this.$isWriter = $isWriter;
            }

            @Nullable
            public final CollectorRegistry getRegistry() {
                return this.registry;
            }

            public final void setRegistry(@Nullable CollectorRegistry collectorRegistry) {
                this.registry = collectorRegistry;
            }

            @NotNull
            public DataSourceService get() {
                Object object = this.$deploymentProvider.get();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
                Deployment deployment = (Deployment)object;
                Object object2 = this.$dataSourceDecoratorsProvider.get();
                Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"get(...)");
                return new DataSourceService(this.$qualifier, this.$config, deployment, (Set)object2, this.this$0.getDatabasePool(), this.$isWriter ? this.registry : null);
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)scopedBindingBuilder, (String)"toProvider(...)");
        GuiceKt.asSingleton((ScopedBindingBuilder)scopedBindingBuilder);
        $i$f$keyOf3 = false;
        if (qualifier == null) {
            Key key20 = Key.get(DataSourceService.class);
            key3 = key20;
            Intrinsics.checkNotNullExpressionValue((Object)key20, (String)"get(...)");
        } else {
            Key key21 = Key.get(DataSourceService.class, (Class)JvmClassMappingKt.getJavaClass(qualifier));
            key3 = key21;
            Intrinsics.checkNotNullExpressionValue((Object)key21, (String)"get(...)");
        }
        Provider dataSourceServiceProvider = this.getProvider(key3);
        $i$f$keyOf3 = false;
        if (qualifier == null) {
            Key key22 = Key.get(DataSourceConnector.class);
            key2 = key22;
            Intrinsics.checkNotNullExpressionValue((Object)key22, (String)"get(...)");
        } else {
            Key key23 = Key.get(DataSourceConnector.class, (Class)JvmClassMappingKt.getJavaClass(qualifier));
            key2 = key23;
            Intrinsics.checkNotNullExpressionValue((Object)key23, (String)"get(...)");
        }
        this.bind(key2).toProvider(dataSourceServiceProvider);
        boolean $i$f$ServiceModule32 = false;
        ServiceModule serviceModule2 = new ServiceModule(GuiceKt.toKey((KClass)Reflection.getOrCreateKotlinClass(DataSourceService.class), qualifier), null, null, 6, null);
        JdbcModule jdbcModule = this;
        boolean bl = false;
        if (this.installHealthCheck) {
            void this_$iv = it;
            boolean $i$f$dependsOn = false;
            serviceModule = this_$iv.dependsOn(GuiceKt.toKey((KClass)Reflection.getOrCreateKotlinClass(PingDatabaseService.class), qualifier));
        } else {
            serviceModule = it;
        }
        void $i$f$ServiceModule32 = serviceModule;
        KClass qualifier$iv = null;
        boolean $i$f$enhancedBy = false;
        jdbcModule.install((Module)$this$iv.enhancedBy(GuiceKt.toKey((KClass)Reflection.getOrCreateKotlinClass(ReadyService.class), qualifier$iv)));
        $i$f$keyOf = false;
        if (qualifier == null) {
            Key key24 = Key.get(Transacter.class);
            key = key24;
            Intrinsics.checkNotNullExpressionValue((Object)key24, (String)"get(...)");
        } else {
            Key key25 = Key.get(Transacter.class, (Class)JvmClassMappingKt.getJavaClass(qualifier));
            key = key25;
            Intrinsics.checkNotNullExpressionValue((Object)key25, (String)"get(...)");
        }
        this.bind(key).toProvider(() -> JdbcModule.bindDataSource$lambda$3(dataSourceServiceProvider));
        if (config.getType() == DataSourceType.VITESS_MYSQL) {
            Key spanInjectorDecoratorKey = GuiceKt.toKey((KClass)Reflection.getOrCreateKotlinClass(SpanInjector.class), qualifier);
            ScopedBindingBuilder scopedBindingBuilder2 = this.bind(spanInjectorDecoratorKey).toProvider((Provider)new Provider<SpanInjector>(config){
                @com.google.inject.Inject(optional=true)
                @Nullable
                private Tracer tracer;
                final /* synthetic */ DataSourceConfig $config;
                {
                    this.$config = $config;
                }

                @Nullable
                public final Tracer getTracer() {
                    return this.tracer;
                }

                public final void setTracer(@Nullable Tracer tracer) {
                    this.tracer = tracer;
                }

                @NotNull
                public SpanInjector get() {
                    return new SpanInjector(this.tracer, this.$config);
                }
            });
            Intrinsics.checkNotNullExpressionValue((Object)scopedBindingBuilder2, (String)"toProvider(...)");
            GuiceKt.asSingleton((ScopedBindingBuilder)scopedBindingBuilder2);
        }
    }

    @JvmOverloads
    public JdbcModule(@NotNull KClass<? extends Annotation> qualifier, @NotNull DataSourceConfig config, @Nullable KClass<? extends Annotation> readerQualifier, @Nullable DataSourceConfig readerConfig, @NotNull DatabasePool databasePool) {
        Intrinsics.checkNotNullParameter(qualifier, (String)"qualifier");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)databasePool, (String)"databasePool");
        this(qualifier, config, readerQualifier, readerConfig, databasePool, false, 32, null);
    }

    @JvmOverloads
    public JdbcModule(@NotNull KClass<? extends Annotation> qualifier, @NotNull DataSourceConfig config, @Nullable KClass<? extends Annotation> readerQualifier, @Nullable DataSourceConfig readerConfig) {
        Intrinsics.checkNotNullParameter(qualifier, (String)"qualifier");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        this(qualifier, config, readerQualifier, readerConfig, null, false, 48, null);
    }

    private static final PingDatabaseService bindDataSource$lambda$1(DataSourceConfig $config, Provider $deploymentProvider) {
        Intrinsics.checkNotNullParameter((Object)$config, (String)"$config");
        Intrinsics.checkNotNullParameter((Object)$deploymentProvider, (String)"$deploymentProvider");
        Object object = $deploymentProvider.get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        return new PingDatabaseService($config, (Deployment)object);
    }

    private static final Transacter bindDataSource$lambda$3(Provider $dataSourceServiceProvider) {
        Object object = $dataSourceServiceProvider.get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        return new RealTransacter((DataSourceService)object);
    }

    public static final /* synthetic */ KClass access$getQualifier$p(JdbcModule $this) {
        return $this.qualifier;
    }
}

