/*
 * Decompiled with CFR 0.152.
 */
package misk.vitess;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.RegexOption;
import misk.vitess.Destination;
import misk.vitess.Shard;
import misk.vitess.TabletType;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000H\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0001\u001a\u0012\u0010\u0003\u001a\u00020\u00042\n\u0010\u0005\u001a\u00060\u0006j\u0002`\u0007\u001a\f\u0010\b\u001a\u00020\t*\u00020\nH\u0002\u001a8\u0010\u000b\u001a\u0002H\f\"\u0004\b\u0000\u0010\f*\u00020\n2!\u0010\r\u001a\u001d\u0012\u0013\u0012\u00110\n\u00a2\u0006\f\b\u000f\u0012\b\b\u0010\u0012\u0004\b\b(\u0011\u0012\u0004\u0012\u0002H\f0\u000e\u00a2\u0006\u0002\u0010\u0012\u001a@\u0010\u000b\u001a\u0002H\f\"\u0004\b\u0000\u0010\f*\u00020\n2\u0006\u0010\u0013\u001a\u00020\u00142!\u0010\r\u001a\u001d\u0012\u0013\u0012\u00110\n\u00a2\u0006\f\b\u000f\u0012\b\b\u0010\u0012\u0004\b\b(\u0011\u0012\u0004\u0012\u0002H\f0\u000e\u00a2\u0006\u0002\u0010\u0015\u001a-\u0010\u0016\u001a\u0002H\f\"\u0004\b\u0000\u0010\f*\u00020\n2\u0006\u0010\u0017\u001a\u00020\t2\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u0002H\f0\u0019H\u0002\u00a2\u0006\u0002\u0010\u001a\u001a@\u0010\u0016\u001a\u0002H\f\"\u0004\b\u0000\u0010\f*\u00020\n2\u0006\u0010\u0013\u001a\u00020\u00142!\u0010\r\u001a\u001d\u0012\u0013\u0012\u00110\n\u00a2\u0006\f\b\u000f\u0012\b\b\u0010\u0012\u0004\b\b(\u0011\u0012\u0004\u0012\u0002H\f0\u000e\u00a2\u0006\u0002\u0010\u0015\u001a\u0014\u0010\u001b\u001a\u00020\u001c*\u00020\n2\u0006\u0010\u0017\u001a\u00020\tH\u0002\u00a8\u0006\u001d"}, d2={"getRootCause", "", "throwable", "tabletDoesNotExists", "", "e", "Ljava/lang/Exception;", "Lkotlin/Exception;", "currentTarget", "Lmisk/vitess/Destination;", "Ljava/sql/Connection;", "failSafeRead", "T", "block", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "conn", "(Ljava/sql/Connection;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "shard", "Lmisk/vitess/Shard;", "(Ljava/sql/Connection;Lmisk/vitess/Shard;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "target", "destination", "function", "Lkotlin/Function0;", "(Ljava/sql/Connection;Lmisk/vitess/Destination;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "targetDestination", "", "misk-jdbc"})
public final class ConnectionExtensionsKt {
    public static final <T> T target(@NotNull Connection $this$target, @NotNull Shard shard, @NotNull Function1<? super Connection, ? extends T> block) {
        Intrinsics.checkNotNullParameter((Object)$this$target, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)shard, (String)"shard");
        Intrinsics.checkNotNullParameter(block, (String)"block");
        return (T)(Intrinsics.areEqual((Object)shard, (Object)Shard.Companion.getSINGLE_SHARD()) ? block.invoke((Object)$this$target) : ConnectionExtensionsKt.target($this$target, ConnectionExtensionsKt.currentTarget($this$target).mergedWith(new Destination(shard)), (Function0)new Function0<T>(block, $this$target){
            final /* synthetic */ Function1<Connection, T> $block;
            final /* synthetic */ Connection $this_target;
            {
                this.$block = $block;
                this.$this_target = $receiver;
                super(0);
            }

            public final T invoke() {
                return (T)this.$block.invoke((Object)this.$this_target);
            }
        }));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final <T> T target(Connection $this$target, Destination destination, Function0<? extends T> function) {
        Destination previous = ConnectionExtensionsKt.currentTarget($this$target);
        ConnectionExtensionsKt.targetDestination($this$target, previous.mergedWith(destination));
        try {
            Object object = function.invoke();
            return (T)object;
        }
        finally {
            ConnectionExtensionsKt.targetDestination($this$target, previous);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void targetDestination(Connection $this$targetDestination, Destination destination) {
        AutoCloseable autoCloseable = $this$targetDestination.createStatement();
        Throwable throwable = null;
        try {
            Statement statement = (Statement)autoCloseable;
            boolean bl = false;
            String catalog = destination.isBlank() ? "@master" : destination.toString();
            $this$targetDestination.setCatalog(catalog);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }

    private static final Destination currentTarget(Connection $this$currentTarget) {
        String string = $this$currentTarget.getCatalog();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getCatalog(...)");
        return Destination.Companion.parse(string);
    }

    public static final <T> T failSafeRead(@NotNull Connection $this$failSafeRead, @NotNull Function1<? super Connection, ? extends T> block) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)$this$failSafeRead, (String)"<this>");
        Intrinsics.checkNotNullParameter(block, (String)"block");
        try {
            object = block.invoke((Object)$this$failSafeRead);
        }
        catch (SQLException e) {
            if (!ConnectionExtensionsKt.tabletDoesNotExists(e)) {
                throw e;
            }
            object = ConnectionExtensionsKt.target($this$failSafeRead, new Destination(TabletType.REPLICA), (Function0)new Function0<T>(block, $this$failSafeRead){
                final /* synthetic */ Function1<Connection, T> $block;
                final /* synthetic */ Connection $this_failSafeRead;
                {
                    this.$block = $block;
                    this.$this_failSafeRead = $receiver;
                    super(0);
                }

                public final T invoke() {
                    return (T)this.$block.invoke((Object)this.$this_failSafeRead);
                }
            });
        }
        return (T)object;
    }

    public static final <T> T failSafeRead(@NotNull Connection $this$failSafeRead, @NotNull Shard shard, @NotNull Function1<? super Connection, ? extends T> block) {
        Intrinsics.checkNotNullParameter((Object)$this$failSafeRead, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)shard, (String)"shard");
        Intrinsics.checkNotNullParameter(block, (String)"block");
        return ConnectionExtensionsKt.failSafeRead($this$failSafeRead, (Function1)new Function1<Connection, T>(shard, block){
            final /* synthetic */ Shard $shard;
            final /* synthetic */ Function1<Connection, T> $block;
            {
                this.$shard = $shard;
                this.$block = $block;
                super(1);
            }

            public final T invoke(@NotNull Connection it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return ConnectionExtensionsKt.target(it, this.$shard, (Function1)new Function1<Connection, T>(this.$block){
                    final /* synthetic */ Function1<Connection, T> $block;
                    {
                        this.$block = $block;
                        super(1);
                    }

                    public final T invoke(@NotNull Connection it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        return (T)this.$block.invoke((Object)it);
                    }
                });
            }
        });
    }

    public static final boolean tabletDoesNotExists(@NotNull Exception e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Throwable rootCause = ConnectionExtensionsKt.getRootCause(e);
        Regex noMasterTabletRegex = new Regex(".*target:.*master.*no valid tablet:.*", RegexOption.IGNORE_CASE);
        boolean isSQLException = rootCause instanceof SQLException;
        String string = rootCause.getMessage();
        Intrinsics.checkNotNull((Object)string);
        boolean isNoMasterTablet = noMasterTabletRegex.matches((CharSequence)string);
        return isSQLException && isNoMasterTablet;
    }

    @NotNull
    public static final Throwable getRootCause(@NotNull Throwable throwable) {
        Intrinsics.checkNotNullParameter((Object)throwable, (String)"throwable");
        Throwable rootCause = throwable;
        while (rootCause.getCause() != null && !Intrinsics.areEqual((Object)rootCause.getCause(), (Object)rootCause)) {
            Intrinsics.checkNotNull((Object)rootCause.getCause());
        }
        return rootCause;
    }
}

