/*
 * Decompiled with CFR 0.152.
 */
package misk.jooq;

import com.google.common.util.concurrent.Service;
import com.google.inject.Provider;
import java.lang.annotation.Annotation;
import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.time.temporal.Temporal;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import misk.healthchecks.HealthCheck;
import misk.healthchecks.HealthStatus;
import misk.jooq.JooqHealthCheck;
import misk.jooq.JooqTransacter;
import mu.KLogger;
import mu.KotlinLogging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u001b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB;\u0012\u000e\u0010\u0002\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0003\u0012\u000e\u0010\u0005\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00070\u0006\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u0006\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\b\u0010\r\u001a\u00020\u000eH\u0016R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0002\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lmisk/jooq/JooqHealthCheck;", "Lmisk/healthchecks/HealthCheck;", "qualifier", "Lkotlin/reflect/KClass;", "", "dataSourceProvider", "Lcom/google/inject/Provider;", "Lcom/google/common/util/concurrent/Service;", "jooqTransacterProvider", "Lmisk/jooq/JooqTransacter;", "clock", "Ljava/time/Clock;", "(Lkotlin/reflect/KClass;Lcom/google/inject/Provider;Lcom/google/inject/Provider;Ljava/time/Clock;)V", "status", "Lmisk/healthchecks/HealthStatus;", "Companion", "misk-jooq"})
@SourceDebugExtension(value={"SMAP\nJooqHealthCheck.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JooqHealthCheck.kt\nmisk/jooq/JooqHealthCheck\n+ 2 Logging.kt\nwisp/logging/LoggingKt\n*L\n1#1,62:1\n12#2:63\n*S KotlinDebug\n*F\n+ 1 JooqHealthCheck.kt\nmisk/jooq/JooqHealthCheck\n*L\n57#1:63\n*E\n"})
public final class JooqHealthCheck
implements HealthCheck {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final KClass<? extends Annotation> qualifier;
    @NotNull
    private final Provider<? extends Service> dataSourceProvider;
    @NotNull
    private final Provider<JooqTransacter> jooqTransacterProvider;
    @NotNull
    private final Clock clock;
    @NotNull
    private static final KLogger log;
    @NotNull
    private static final Duration CLOCK_SKEW_WARN_THRESHOLD;
    @NotNull
    private static final Duration CLOCK_SKEW_UNHEALTHY_THRESHOLD;

    public JooqHealthCheck(@NotNull KClass<? extends Annotation> qualifier, @NotNull Provider<? extends Service> dataSourceProvider, @NotNull Provider<JooqTransacter> jooqTransacterProvider, @NotNull Clock clock) {
        Intrinsics.checkNotNullParameter(qualifier, (String)"qualifier");
        Intrinsics.checkNotNullParameter(dataSourceProvider, (String)"dataSourceProvider");
        Intrinsics.checkNotNullParameter(jooqTransacterProvider, (String)"jooqTransacterProvider");
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        this.qualifier = qualifier;
        this.dataSourceProvider = dataSourceProvider;
        this.jooqTransacterProvider = jooqTransacterProvider;
        this.clock = clock;
    }

    @NotNull
    public HealthStatus status() {
        HealthStatus healthStatus;
        Object jooqTransacter;
        Service.State state = ((Service)this.dataSourceProvider.get()).state();
        if (state != Service.State.RUNNING) {
            String[] stringArray = new String[]{"Jooq: " + this.qualifier.getSimpleName() + " database service is " + state};
            return HealthStatus.Companion.unhealthy(stringArray);
        }
        try {
            jooqTransacter = (JooqTransacter)this.jooqTransacterProvider.get();
            Intrinsics.checkNotNullExpressionValue((Object)jooqTransacter, (String)"jooqTransacter");
            jooqTransacter = (Instant)JooqTransacter.transaction$default((JooqTransacter)jooqTransacter, null, status.databaseInstant.1.INSTANCE, 1, null);
        }
        catch (Exception exception2) {
            log.error((Throwable)exception2, (Function0)status.databaseInstant.2.INSTANCE);
            String[] stringArray = new String[]{"Jooq: failed to query " + this.qualifier.getSimpleName() + " database"};
            return HealthStatus.Companion.unhealthy(stringArray);
        }
        Object databaseInstant2 = jooqTransacter;
        Duration delta = Duration.between(this.clock.instant(), (Temporal)databaseInstant2).abs();
        String driftMessage = "Jooq: host and " + this.qualifier.getSimpleName() + " database clocks have drifted " + delta.getSeconds() + "s apart";
        if (delta.compareTo(CLOCK_SKEW_UNHEALTHY_THRESHOLD) > 0) {
            String[] stringArray = new String[]{driftMessage};
            healthStatus = HealthStatus.Companion.unhealthy(stringArray);
        } else if (delta.compareTo(CLOCK_SKEW_WARN_THRESHOLD) > 0) {
            log.warn((Function0)new Function0<Object>(driftMessage){
                final /* synthetic */ String $driftMessage;
                {
                    this.$driftMessage = $driftMessage;
                    super(0);
                }

                @Nullable
                public final Object invoke() {
                    return this.$driftMessage;
                }
            });
            String[] stringArray = new String[]{driftMessage};
            healthStatus = HealthStatus.Companion.healthy(stringArray);
        } else {
            String[] stringArray = new String[]{"Jooq: " + this.qualifier.getSimpleName() + " database"};
            healthStatus = HealthStatus.Companion.healthy(stringArray);
        }
        return healthStatus;
    }

    static {
        boolean $i$f$getLogger = false;
        String string = Reflection.getOrCreateKotlinClass(JooqHealthCheck.class).getQualifiedName();
        Intrinsics.checkNotNull((Object)string);
        log = KotlinLogging.INSTANCE.logger(string);
        Duration duration = Duration.ofSeconds(10L);
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"ofSeconds(10)");
        CLOCK_SKEW_WARN_THRESHOLD = duration;
        Duration duration2 = Duration.ofSeconds(30L);
        Intrinsics.checkNotNullExpressionValue((Object)duration2, (String)"ofSeconds(30)");
        CLOCK_SKEW_UNHEALTHY_THRESHOLD = duration2;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\r"}, d2={"Lmisk/jooq/JooqHealthCheck$Companion;", "", "()V", "CLOCK_SKEW_UNHEALTHY_THRESHOLD", "Ljava/time/Duration;", "getCLOCK_SKEW_UNHEALTHY_THRESHOLD", "()Ljava/time/Duration;", "CLOCK_SKEW_WARN_THRESHOLD", "getCLOCK_SKEW_WARN_THRESHOLD", "log", "Lmu/KLogger;", "getLog", "()Lmu/KLogger;", "misk-jooq"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final KLogger getLog() {
            return log;
        }

        @NotNull
        public final Duration getCLOCK_SKEW_WARN_THRESHOLD() {
            return CLOCK_SKEW_WARN_THRESHOLD;
        }

        @NotNull
        public final Duration getCLOCK_SKEW_UNHEALTHY_THRESHOLD() {
            return CLOCK_SKEW_UNHEALTHY_THRESHOLD;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

