/*
 * Decompiled with CFR 0.152.
 */
package misk.jooq.listeners;

import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import misk.jooq.listeners.JooqSQLLogger;
import mu.KLogger;
import mu.KotlinLogging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jooq.Configuration;
import org.jooq.ExecuteContext;
import org.jooq.ExecuteType;
import org.jooq.Param;
import org.jooq.QueryPart;
import org.jooq.RenderContext;
import org.jooq.Result;
import org.jooq.TXTFormat;
import org.jooq.VisitContext;
import org.jooq.VisitListener;
import org.jooq.VisitListenerProvider;
import org.jooq.impl.DSL;
import org.jooq.impl.DefaultExecuteListener;
import org.jooq.impl.DefaultVisitListener;
import org.jooq.impl.DefaultVisitListenerProvider;
import org.jooq.tools.StringUtils;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\b\u0018\u0000 \u00142\u00020\u0001:\u0002\u0013\u0014B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0002J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0018\u0010\u000b\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rH\u0002J\u0010\u0010\u000f\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\u0010\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\u0011\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\u0012\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\u0015"}, d2={"Lmisk/jooq/listeners/JooqSQLLogger;", "Lorg/jooq/impl/DefaultExecuteListener;", "()V", "abbreviateBindVariables", "Lorg/jooq/Configuration;", "configuration", "exception", "", "ctx", "Lorg/jooq/ExecuteContext;", "executeEnd", "logMultiline", "comment", "", "message", "outEnd", "recordEnd", "renderEnd", "resultEnd", "BindValueAbbreviator", "Companion", "misk-jooq"})
@SourceDebugExtension(value={"SMAP\nJooqSQLLogger.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JooqSQLLogger.kt\nmisk/jooq/listeners/JooqSQLLogger\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 3 Logging.kt\nwisp/logging/LoggingKt\n*L\n1#1,126:1\n37#2,2:127\n12#3:129\n*S KotlinDebug\n*F\n+ 1 JooqSQLLogger.kt\nmisk/jooq/listeners/JooqSQLLogger\n*L\n74#1:127,2\n123#1:129\n*E\n"})
public final class JooqSQLLogger
extends DefaultExecuteListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static final int maxLength = 2000;
    @NotNull
    private static final KLogger log;

    public void renderEnd(@NotNull ExecuteContext ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Configuration configuration = ctx.configuration();
        Intrinsics.checkNotNullExpressionValue((Object)configuration, (String)"ctx.configuration()");
        Configuration configuration2 = configuration;
        String newline = Intrinsics.areEqual((Object)configuration2.settings().isRenderFormatted(), (Object)true) ? "\n" : "";
        configuration2 = this.abbreviateBindVariables(configuration2);
        String[] stringArray = ctx.batchSQL();
        Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"ctx.batchSQL()");
        String[] batchSQL = stringArray;
        if (ctx.query() != null) {
            log.info((Function0)new Function0<Object>(newline, ctx){
                final /* synthetic */ String $newline;
                final /* synthetic */ ExecuteContext $ctx;
                {
                    this.$newline = $newline;
                    this.$ctx = $ctx;
                    super(0);
                }

                @Nullable
                public final Object invoke() {
                    return "Executing query " + this.$newline + this.$ctx.sql();
                }
            });
            String string = DSL.using((Configuration)configuration2).renderInlined((QueryPart)ctx.query());
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"using(configuration).renderInlined(ctx.query())");
            String inlined = string;
            if (!Intrinsics.areEqual((Object)ctx.sql(), (Object)inlined)) {
                log.info((Function0)new Function0<Object>(newline, inlined){
                    final /* synthetic */ String $newline;
                    final /* synthetic */ String $inlined;
                    {
                        this.$newline = $newline;
                        this.$inlined = $inlined;
                        super(0);
                    }

                    @Nullable
                    public final Object invoke() {
                        return "-> with bind values " + this.$newline + this.$inlined + " ";
                    }
                });
            }
        } else if (!StringUtils.isBlank((String)ctx.sql())) {
            if (ctx.type() == ExecuteType.BATCH) {
                log.info((Function0)new Function0<Object>(newline, ctx){
                    final /* synthetic */ String $newline;
                    final /* synthetic */ ExecuteContext $ctx;
                    {
                        this.$newline = $newline;
                        this.$ctx = $ctx;
                        super(0);
                    }

                    @Nullable
                    public final Object invoke() {
                        return "Executing batch query " + this.$newline + this.$ctx.sql();
                    }
                });
            } else {
                log.info((Function0)new Function0<Object>(newline, ctx){
                    final /* synthetic */ String $newline;
                    final /* synthetic */ ExecuteContext $ctx;
                    {
                        this.$newline = $newline;
                        this.$ctx = $ctx;
                        super(0);
                    }

                    @Nullable
                    public final Object invoke() {
                        return "Executing query " + this.$newline + this.$ctx.sql();
                    }
                });
            }
        } else if (!(batchSQL.length == 0) && batchSQL[batchSQL.length - 1] != null) {
            for (String sql : batchSQL) {
                log.info((Function0)new Function0<Object>(newline, sql){
                    final /* synthetic */ String $newline;
                    final /* synthetic */ String $sql;
                    {
                        this.$newline = $newline;
                        this.$sql = $sql;
                        super(0);
                    }

                    @Nullable
                    public final Object invoke() {
                        return "Executing batch query " + this.$newline + this.$sql;
                    }
                });
            }
        }
    }

    public void recordEnd(@NotNull ExecuteContext ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
    }

    public void resultEnd(@NotNull ExecuteContext ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        if (ctx.result() != null) {
            Result result = ctx.result();
            Intrinsics.checkNotNull((Object)result);
            String string = result.format(TXTFormat.DEFAULT.maxRows(5).maxColWidth(50));
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"ctx.result()!!\n         \u2026xRows(5).maxColWidth(50))");
            this.logMultiline("Fetched result", string);
            log.info((Function0)new Function0<Object>(ctx){
                final /* synthetic */ ExecuteContext $ctx;
                {
                    this.$ctx = $ctx;
                    super(0);
                }

                @Nullable
                public final Object invoke() {
                    Result result = this.$ctx.result();
                    Intrinsics.checkNotNull((Object)result);
                    return "Fetched row(s) " + result.size();
                }
            });
        }
    }

    public void executeEnd(@NotNull ExecuteContext ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        if (ctx.rows() >= 0) {
            log.info((Function0)new Function0<Object>(ctx){
                final /* synthetic */ ExecuteContext $ctx;
                {
                    this.$ctx = $ctx;
                    super(0);
                }

                @Nullable
                public final Object invoke() {
                    return "Affected row(s) " + this.$ctx.rows();
                }
            });
        }
    }

    public void outEnd(@NotNull ExecuteContext ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
    }

    public void exception(@NotNull ExecuteContext ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        log.info((Throwable)ctx.exception(), (Function0)exception.1.INSTANCE);
    }

    /*
     * WARNING - void declaration
     */
    private final void logMultiline(String comment, String message) {
        void $this$toTypedArray$iv;
        Ref.ObjectRef commentToUse = new Ref.ObjectRef();
        commentToUse.element = comment;
        Object object = message;
        Regex regex = new Regex("\n");
        int n = 0;
        object = regex.split((CharSequence)object, n);
        boolean $i$f$toTypedArray = false;
        void thisCollection$iv = $this$toTypedArray$iv;
        for (String line : thisCollection$iv.toArray(new String[0])) {
            log.info((Function0)new Function0<Object>((Ref.ObjectRef<String>)commentToUse, line){
                final /* synthetic */ Ref.ObjectRef<String> $commentToUse;
                final /* synthetic */ String $line;
                {
                    this.$commentToUse = $commentToUse;
                    this.$line = $line;
                    super(0);
                }

                @Nullable
                public final Object invoke() {
                    return this.$commentToUse.element + " " + this.$line;
                }
            });
            commentToUse.element = "";
        }
    }

    private final Configuration abbreviateBindVariables(Configuration configuration) {
        VisitListenerProvider[] visitListenerProviderArray = configuration.visitListenerProviders();
        Intrinsics.checkNotNullExpressionValue((Object)visitListenerProviderArray, (String)"configuration.visitListenerProviders()");
        VisitListenerProvider[] oldProviders = visitListenerProviderArray;
        VisitListenerProvider[] newProviders = new VisitListenerProvider[oldProviders.length + 1];
        System.arraycopy(oldProviders, 0, newProviders, 0, oldProviders.length);
        newProviders[newProviders.length - 1] = new DefaultVisitListenerProvider((VisitListener)new BindValueAbbreviator());
        Configuration configuration2 = configuration.derive(Arrays.copyOf(newProviders, newProviders.length));
        Intrinsics.checkNotNullExpressionValue((Object)configuration2, (String)"configuration.derive(*newProviders)");
        return configuration2;
    }

    static {
        boolean $i$f$getLogger = false;
        String string = Reflection.getOrCreateKotlinClass(JooqSQLLogger.class).getQualifiedName();
        Intrinsics.checkNotNull((Object)string);
        log = KotlinLogging.INSTANCE.logger(string);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lmisk/jooq/listeners/JooqSQLLogger$BindValueAbbreviator;", "Lorg/jooq/impl/DefaultVisitListener;", "()V", "anyAbbreviations", "", "visitEnd", "", "context", "Lorg/jooq/VisitContext;", "visitStart", "misk-jooq"})
    private static final class BindValueAbbreviator
    extends DefaultVisitListener {
        private boolean anyAbbreviations;

        public void visitStart(@NotNull VisitContext context) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            if (context.renderContext() != null) {
                QueryPart queryPart = context.queryPart();
                Intrinsics.checkNotNullExpressionValue((Object)queryPart, (String)"context.queryPart()");
                QueryPart part = queryPart;
                if (part instanceof Param) {
                    Object value = ((Param)part).getValue();
                    if (value instanceof String && ((String)value).length() > 2000) {
                        this.anyAbbreviations = true;
                        context.queryPart((QueryPart)DSL.val((String)StringUtils.abbreviate((String)((String)value), (int)2000)));
                    } else if (value instanceof byte[] && ((byte[])value).length > 2000) {
                        this.anyAbbreviations = true;
                        context.queryPart((QueryPart)DSL.val((byte[])Arrays.copyOf((byte[])value, 2000)));
                    }
                }
            }
        }

        public void visitEnd(@NotNull VisitContext context) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            if (this.anyAbbreviations && context.queryPartsLength() == 1) {
                RenderContext renderContext = context.renderContext();
                Intrinsics.checkNotNull((Object)renderContext);
                renderContext.sql(" -- Bind values may have been abbreviated for DEBUG logging. Use TRACE logging for very large bind variables.");
            }
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lmisk/jooq/listeners/JooqSQLLogger$Companion;", "", "()V", "log", "Lmu/KLogger;", "getLog", "()Lmu/KLogger;", "maxLength", "", "misk-jooq"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final KLogger getLog() {
            return log;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

