/*
 * Decompiled with CFR 0.152.
 */
package misk.policy.opa;

import com.squareup.moshi.JsonAdapter;
import com.squareup.moshi.Moshi;
import com.squareup.moshi.Types;
import java.lang.reflect.Type;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import misk.policy.opa.OpaApi;
import misk.policy.opa.OpaPolicyEngine;
import misk.policy.opa.OpaRequest;
import misk.policy.opa.OpaResponse;
import misk.policy.opa.PolicyEngineException;
import misk.policy.opa.Request;
import misk.policy.opa.Response;
import okhttp3.ResponseBody;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B!\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJM\u0010\t\u001a\u0002H\n\"\b\b\u0000\u0010\u000b*\u00020\f\"\b\b\u0001\u0010\n*\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u0002H\u000b2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u0002H\u000b0\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u0002H\n0\u0012H\u0002\u00a2\u0006\u0002\u0010\u0014J-\u0010\t\u001a\u0002H\n\"\b\b\u0000\u0010\n*\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u0002H\n0\u0012H\u0002\u00a2\u0006\u0002\u0010\u0015J-\u0010\u0016\u001a\u0002H\n\"\b\b\u0000\u0010\n*\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u0002H\n0\u0012H\u0016\u00a2\u0006\u0002\u0010\u0015J5\u0010\u0017\u001a\u0002H\n\"\b\b\u0000\u0010\n*\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u0002H\n0\u0012H\u0016\u00a2\u0006\u0002\u0010\u0018JM\u0010\u0019\u001a\u0002H\n\"\b\b\u0000\u0010\u000b*\u00020\f\"\b\b\u0001\u0010\n*\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u0002H\u000b2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u0002H\u000b0\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u0002H\n0\u0012H\u0016\u00a2\u0006\u0002\u0010\u0014J;\u0010\u001a\u001a\u0002H\n\"\b\b\u0000\u0010\n*\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u0002H\n0\u00122\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001cH\u0002\u00a2\u0006\u0002\u0010\u001eJ \u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001c2\u0006\u0010\u000e\u001a\u00020\u000f2\b\b\u0002\u0010 \u001a\u00020\u000fH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lmisk/policy/opa/RealOpaPolicyEngine;", "Lmisk/policy/opa/OpaPolicyEngine;", "opaApi", "Lmisk/policy/opa/OpaApi;", "moshi", "Lcom/squareup/moshi/Moshi;", "provenance", "", "(Lmisk/policy/opa/OpaApi;Lcom/squareup/moshi/Moshi;Z)V", "evaluateInternal", "R", "T", "Lmisk/policy/opa/OpaRequest;", "Lmisk/policy/opa/OpaResponse;", "document", "", "input", "inputType", "Ljava/lang/Class;", "returnType", "(Ljava/lang/String;Lmisk/policy/opa/OpaRequest;Ljava/lang/Class;Ljava/lang/Class;)Lmisk/policy/opa/OpaResponse;", "(Ljava/lang/String;Ljava/lang/Class;)Lmisk/policy/opa/OpaResponse;", "evaluateNoInput", "evaluateRawJsonInput", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/Class;)Lmisk/policy/opa/OpaResponse;", "evaluateWithInput", "parseResponse", "response", "Lretrofit2/Response;", "Lokhttp3/ResponseBody;", "(Ljava/lang/String;Ljava/lang/Class;Lretrofit2/Response;)Lmisk/policy/opa/OpaResponse;", "queryOpa", "inputString", "misk-policy"})
public final class RealOpaPolicyEngine
implements OpaPolicyEngine {
    @NotNull
    private final OpaApi opaApi;
    @NotNull
    private final Moshi moshi;
    private final boolean provenance;

    @Inject
    public RealOpaPolicyEngine(@NotNull OpaApi opaApi, @Named(value="opa-moshi") @NotNull Moshi moshi, boolean provenance) {
        Intrinsics.checkNotNullParameter((Object)opaApi, (String)"opaApi");
        Intrinsics.checkNotNullParameter((Object)moshi, (String)"moshi");
        this.opaApi = opaApi;
        this.moshi = moshi;
        this.provenance = provenance;
    }

    @Override
    @NotNull
    public <T extends OpaRequest, R extends OpaResponse> R evaluateWithInput(@NotNull String document, @NotNull T input, @NotNull Class<T> inputType, @NotNull Class<R> returnType) {
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        Intrinsics.checkNotNullParameter(input, (String)"input");
        Intrinsics.checkNotNullParameter(inputType, (String)"inputType");
        Intrinsics.checkNotNullParameter(returnType, (String)"returnType");
        return this.evaluateInternal(document, input, inputType, returnType);
    }

    private final <T extends OpaRequest, R extends OpaResponse> R evaluateInternal(String document, T input, Class<T> inputType, Class<R> returnType) {
        if (((CharSequence)document).length() == 0) {
            throw new IllegalArgumentException("Must specify document");
        }
        Type[] typeArray = new Type[]{inputType};
        JsonAdapter inputAdapter = this.moshi.adapter((Type)Types.newParameterizedType((Type)((Type)((Object)Request.class)), (Type[])typeArray));
        String inputString = inputAdapter.toJson(new Request<T>(input));
        Intrinsics.checkNotNullExpressionValue((Object)inputString, (String)"inputString");
        retrofit2.Response<ResponseBody> response = this.queryOpa(document, inputString);
        return this.parseResponse(document, returnType, response);
    }

    @Override
    @NotNull
    public <R extends OpaResponse> R evaluateRawJsonInput(@NotNull String document, @NotNull String input, @NotNull Class<R> returnType) {
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        Intrinsics.checkNotNullParameter(returnType, (String)"returnType");
        if (((CharSequence)document).length() == 0) {
            throw new IllegalArgumentException("Must specify document");
        }
        retrofit2.Response<ResponseBody> response = this.queryOpa(document, input);
        return this.parseResponse(document, returnType, response);
    }

    @Override
    @NotNull
    public <R extends OpaResponse> R evaluateNoInput(@NotNull String document, @NotNull Class<R> returnType) {
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        Intrinsics.checkNotNullParameter(returnType, (String)"returnType");
        return this.evaluateInternal(document, returnType);
    }

    private final <R extends OpaResponse> R evaluateInternal(String document, Class<R> returnType) {
        retrofit2.Response<ResponseBody> response = this.queryOpa(document, "");
        return this.parseResponse(document, returnType, response);
    }

    private final retrofit2.Response<ResponseBody> queryOpa(String document, String inputString) {
        if (((CharSequence)document).length() == 0) {
            throw new IllegalArgumentException("Must specify document");
        }
        retrofit2.Response response = this.opaApi.queryDocument(document, inputString, this.provenance).execute();
        if (!response.isSuccessful()) {
            ResponseBody responseBody = response.errorBody();
            throw new PolicyEngineException("[" + response.code() + "]: " + (responseBody != null ? responseBody.string() : null), null, 2, null);
        }
        Intrinsics.checkNotNullExpressionValue((Object)response, (String)"response");
        return response;
    }

    static /* synthetic */ retrofit2.Response queryOpa$default(RealOpaPolicyEngine realOpaPolicyEngine, String string, String string2, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = "";
        }
        return realOpaPolicyEngine.queryOpa(string, string2);
    }

    private final <R extends OpaResponse> R parseResponse(String document, Class<R> returnType, retrofit2.Response<ResponseBody> response) {
        Response response2;
        Type[] typeArray = new Type[]{returnType};
        JsonAdapter outputAdapter = this.moshi.adapter((Type)Types.newParameterizedType((Type)((Type)((Object)Response.class)), (Type[])typeArray));
        Object object = (ResponseBody)response.body();
        if (object == null || (object = object.string()) == null) {
            throw new PolicyEngineException("OPA response body is empty", null, 2, null);
        }
        Object responseBody = object;
        try {
            Response response3 = (Response)outputAdapter.fromJson((String)responseBody);
            if (response3 == null) {
                throw new PolicyEngineException("Unmarshalled OPA response body is empty", null, 2, null);
            }
            response2 = response3;
        }
        catch (Exception e) {
            throw new PolicyEngineException("Response shape did not match", e);
        }
        Response extractedResponse = response2;
        if (extractedResponse.getResult() == null) {
            throw new PolicyEngineException("Policy document \"" + document + "\" not found.", null, 2, null);
        }
        ((OpaResponse)extractedResponse.getResult()).setProvenance(extractedResponse.getProvenance());
        return (R)((OpaResponse)extractedResponse.getResult());
    }
}

