/*
 * Decompiled with CFR 0.152.
 */
package misk.sqldelight;

import app.cash.sqldelight.Transacter;
import app.cash.sqldelight.TransactionWithReturn;
import app.cash.sqldelight.TransactionWithoutReturn;
import java.time.Duration;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import misk.backoff.ExponentialBackoff;
import misk.sqldelight.RetryingTransacter;
import misk.sqldelight.RetryingTransacterKt;
import misk.sqldelight.TransacterOptions;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000G\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002*\u0001\u0007\b&\u0018\u00002\u00020\u0001B\u0019\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\b\b\u0002\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J!\u0010\u000b\u001a\u0002H\f\"\u0004\b\u0000\u0010\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u0002H\f0\u000eH\u0002\u00a2\u0006\u0002\u0010\u000fJ)\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0017\u0010\u0014\u001a\u0013\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u00110\u0015\u00a2\u0006\u0002\b\u0017H\u0016J:\u0010\u0018\u001a\u0002H\u0019\"\u0004\b\u0000\u0010\u00192\u0006\u0010\u0012\u001a\u00020\u00132\u001d\u0010\u001a\u001a\u0019\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00190\u001b\u0012\u0004\u0012\u0002H\u00190\u0015\u00a2\u0006\u0002\b\u0017H\u0016\u00a2\u0006\u0002\u0010\u001cR\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\bR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u001d"}, d2={"Lmisk/sqldelight/RetryingTransacter;", "Lapp/cash/sqldelight/Transacter;", "delegate", "options", "Lmisk/sqldelight/TransacterOptions;", "(Lapp/cash/sqldelight/Transacter;Lmisk/sqldelight/TransacterOptions;)V", "inTransaction", "misk/sqldelight/RetryingTransacter$inTransaction$1", "Lmisk/sqldelight/RetryingTransacter$inTransaction$1;", "getOptions", "()Lmisk/sqldelight/TransacterOptions;", "retryWithWork", "T", "work", "Lkotlin/Function0;", "(Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "transaction", "", "noEnclosing", "", "body", "Lkotlin/Function1;", "Lapp/cash/sqldelight/TransactionWithoutReturn;", "Lkotlin/ExtensionFunctionType;", "transactionWithResult", "R", "bodyWithReturn", "Lapp/cash/sqldelight/TransactionWithReturn;", "(ZLkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "misk-sqldelight"})
public abstract class RetryingTransacter
implements Transacter {
    @NotNull
    private final Transacter delegate;
    @NotNull
    private final TransacterOptions options;
    @NotNull
    private final inTransaction.1 inTransaction;

    @JvmOverloads
    public RetryingTransacter(@NotNull Transacter delegate, @NotNull TransacterOptions options) {
        Intrinsics.checkNotNullParameter((Object)delegate, (String)"delegate");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        this.delegate = delegate;
        this.options = options;
        this.inTransaction = new ThreadLocal<Boolean>(){

            @NotNull
            protected Boolean initialValue() {
                return false;
            }
        };
    }

    public /* synthetic */ RetryingTransacter(Transacter transacter, TransacterOptions transacterOptions, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            transacterOptions = new TransacterOptions(0, 0L, 0L, 0L, 15, null);
        }
        this(transacter, transacterOptions);
    }

    @NotNull
    public final TransacterOptions getOptions() {
        return this.options;
    }

    public void transaction(boolean noEnclosing, @NotNull Function1<? super TransactionWithoutReturn, Unit> body) {
        Intrinsics.checkNotNullParameter(body, (String)"body");
        this.retryWithWork((Function0)new Function0<Unit>(this, noEnclosing, body){
            final /* synthetic */ RetryingTransacter this$0;
            final /* synthetic */ boolean $noEnclosing;
            final /* synthetic */ Function1<TransactionWithoutReturn, Unit> $body;
            {
                this.this$0 = $receiver;
                this.$noEnclosing = $noEnclosing;
                this.$body = $body;
                super(0);
            }

            public final void invoke() {
                RetryingTransacter.access$getDelegate$p(this.this$0).transaction(this.$noEnclosing, this.$body);
            }
        });
    }

    public <R> R transactionWithResult(boolean noEnclosing, @NotNull Function1<? super TransactionWithReturn<R>, ? extends R> bodyWithReturn) {
        Intrinsics.checkNotNullParameter(bodyWithReturn, (String)"bodyWithReturn");
        return (R)this.retryWithWork((Function0)new Function0<R>(this, noEnclosing, bodyWithReturn){
            final /* synthetic */ RetryingTransacter this$0;
            final /* synthetic */ boolean $noEnclosing;
            final /* synthetic */ Function1<TransactionWithReturn<R>, R> $bodyWithReturn;
            {
                this.this$0 = $receiver;
                this.$noEnclosing = $noEnclosing;
                this.$bodyWithReturn = $bodyWithReturn;
                super(0);
            }

            public final R invoke() {
                return (R)RetryingTransacter.access$getDelegate$p(this.this$0).transactionWithResult(this.$noEnclosing, this.$bodyWithReturn);
            }
        });
    }

    private final <T> T retryWithWork(Function0<? extends T> work) {
        boolean outermostTransaction = false;
        Object t = this.inTransaction.get();
        Intrinsics.checkNotNullExpressionValue(t, (String)"get(...)");
        if (((Boolean)t).booleanValue()) {
            outermostTransaction = false;
        } else {
            outermostTransaction = true;
            this.inTransaction.set(true);
        }
        Duration duration = Duration.ofMillis(this.options.getMinRetryDelayMillis());
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"ofMillis(...)");
        Duration duration2 = Duration.ofMillis(this.options.getMaxRetryDelayMillis());
        Intrinsics.checkNotNullExpressionValue((Object)duration2, (String)"ofMillis(...)");
        Duration duration3 = Duration.ofMillis(this.options.getRetryJitterMillis());
        Intrinsics.checkNotNullExpressionValue((Object)duration3, (String)"ofMillis(...)");
        ExponentialBackoff backoff = new ExponentialBackoff(duration, duration2, duration3);
        Ref.IntRef attempt = new Ref.IntRef();
        while (true) {
            try {
                int n = attempt.element;
                attempt.element = n + 1;
                Object result = work.invoke();
                if (attempt.element > 1) {
                    RetryingTransacterKt.access$getLogger$p().info((Function0)new Function0<Object>(attempt){
                        final /* synthetic */ Ref.IntRef $attempt;
                        {
                            this.$attempt = $attempt;
                            super(0);
                        }

                        @Nullable
                        public final Object invoke() {
                            return "retried transaction succeeded (attempt " + this.$attempt.element + ")";
                        }
                    });
                }
                if (outermostTransaction) {
                    this.inTransaction.set(false);
                }
                return (T)result;
            }
            catch (Exception e) {
                if (!RetryingTransacterKt.access$isRetryable(e) || !outermostTransaction) {
                    throw e;
                }
                if (attempt.element >= this.options.getMaxAttempts()) {
                    RetryingTransacterKt.access$getLogger$p().info((Function0)new Function0<Object>(attempt){
                        final /* synthetic */ Ref.IntRef $attempt;
                        {
                            this.$attempt = $attempt;
                            super(0);
                        }

                        @Nullable
                        public final Object invoke() {
                            return "recoverable transaction exception (attempt " + this.$attempt.element + "), no more attempts";
                        }
                    });
                    if (outermostTransaction) {
                        this.inTransaction.set(false);
                    }
                    throw e;
                }
                Duration sleepDuration = backoff.nextRetry();
                RetryingTransacterKt.access$getLogger$p().info((Throwable)e, (Function0)new Function0<Object>(attempt, sleepDuration){
                    final /* synthetic */ Ref.IntRef $attempt;
                    final /* synthetic */ Duration $sleepDuration;
                    {
                        this.$attempt = $attempt;
                        this.$sleepDuration = $sleepDuration;
                        super(0);
                    }

                    @Nullable
                    public final Object invoke() {
                        return "recoverable transaction exception (attempt " + this.$attempt.element + "), will retry after a " + this.$sleepDuration + " delay";
                    }
                });
                if (sleepDuration.isZero()) continue;
                Thread.sleep(sleepDuration.toMillis());
                continue;
            }
            break;
        }
    }

    @JvmOverloads
    public RetryingTransacter(@NotNull Transacter delegate) {
        Intrinsics.checkNotNullParameter((Object)delegate, (String)"delegate");
        this(delegate, null, 2, null);
    }

    public static final /* synthetic */ Transacter access$getDelegate$p(RetryingTransacter $this) {
        return $this.delegate;
    }
}

