/*
 * Decompiled with CFR 0.152.
 */
package misk.sqldelight;

import app.cash.sqldelight.Transacter;
import app.cash.sqldelight.TransactionWithReturn;
import app.cash.sqldelight.TransactionWithoutReturn;
import java.time.Duration;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import misk.backoff.ExponentialBackoff;
import misk.sqldelight.RetryingTransacter;
import misk.sqldelight.RetryingTransacterKt;
import misk.sqldelight.TransacterOptions;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000G\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002*\u0001\n\b&\u0018\u00002\u00020\u0001B\u001b\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\b\b\u0002\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J)\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0017\u0010\u0010\u001a\u0013\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\r0\u0011\u00a2\u0006\u0002\b\u0013H\u0016J:\u0010\u0014\u001a\u0002H\u0015\"\u0004\b\u0000\u0010\u00152\u0006\u0010\u000e\u001a\u00020\u000f2\u001d\u0010\u0016\u001a\u0019\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00150\u0017\u0012\u0004\u0012\u0002H\u00150\u0011\u00a2\u0006\u0002\b\u0013H\u0016\u00a2\u0006\u0002\u0010\u0018J!\u0010\u0019\u001a\u0002H\u001a\"\u0004\b\u0000\u0010\u001a2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u0002H\u001a0\u001cH\u0002\u00a2\u0006\u0002\u0010\u001dR\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0010\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000b\u00a8\u0006\u001e"}, d2={"Lmisk/sqldelight/RetryingTransacter;", "Lapp/cash/sqldelight/Transacter;", "delegate", "options", "Lmisk/sqldelight/TransacterOptions;", "<init>", "(Lapp/cash/sqldelight/Transacter;Lmisk/sqldelight/TransacterOptions;)V", "getOptions", "()Lmisk/sqldelight/TransacterOptions;", "inTransaction", "misk/sqldelight/RetryingTransacter$inTransaction$1", "Lmisk/sqldelight/RetryingTransacter$inTransaction$1;", "transaction", "", "noEnclosing", "", "body", "Lkotlin/Function1;", "Lapp/cash/sqldelight/TransactionWithoutReturn;", "Lkotlin/ExtensionFunctionType;", "transactionWithResult", "R", "bodyWithReturn", "Lapp/cash/sqldelight/TransactionWithReturn;", "(ZLkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "retryWithWork", "T", "work", "Lkotlin/Function0;", "(Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "misk-sqldelight"})
public abstract class RetryingTransacter
implements Transacter {
    @NotNull
    private final Transacter delegate;
    @NotNull
    private final TransacterOptions options;
    @NotNull
    private final inTransaction.1 inTransaction;

    @JvmOverloads
    public RetryingTransacter(@NotNull Transacter delegate, @NotNull TransacterOptions options) {
        Intrinsics.checkNotNullParameter((Object)delegate, (String)"delegate");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        this.delegate = delegate;
        this.options = options;
        this.inTransaction = new ThreadLocal<Boolean>(){

            protected Boolean initialValue() {
                return false;
            }
        };
    }

    public /* synthetic */ RetryingTransacter(Transacter transacter, TransacterOptions transacterOptions, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            transacterOptions = new TransacterOptions(0, 0L, 0L, 0L, 15, null);
        }
        this(transacter, transacterOptions);
    }

    @NotNull
    public final TransacterOptions getOptions() {
        return this.options;
    }

    public void transaction(boolean noEnclosing, @NotNull Function1<? super TransactionWithoutReturn, Unit> body) {
        Intrinsics.checkNotNullParameter(body, (String)"body");
        this.retryWithWork(() -> RetryingTransacter.transaction$lambda$0(this, noEnclosing, body));
    }

    public <R> R transactionWithResult(boolean noEnclosing, @NotNull Function1<? super TransactionWithReturn<R>, ? extends R> bodyWithReturn) {
        Intrinsics.checkNotNullParameter(bodyWithReturn, (String)"bodyWithReturn");
        return (R)this.retryWithWork(() -> RetryingTransacter.transactionWithResult$lambda$1(this, noEnclosing, bodyWithReturn));
    }

    private final <T> T retryWithWork(Function0<? extends T> work) {
        boolean outermostTransaction = false;
        if (((Boolean)this.inTransaction.get()).booleanValue()) {
            outermostTransaction = false;
        } else {
            outermostTransaction = true;
            this.inTransaction.set(true);
        }
        Duration duration = Duration.ofMillis(this.options.getMinRetryDelayMillis());
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"ofMillis(...)");
        Duration duration2 = Duration.ofMillis(this.options.getMaxRetryDelayMillis());
        Intrinsics.checkNotNullExpressionValue((Object)duration2, (String)"ofMillis(...)");
        Duration duration3 = Duration.ofMillis(this.options.getRetryJitterMillis());
        Intrinsics.checkNotNullExpressionValue((Object)duration3, (String)"ofMillis(...)");
        ExponentialBackoff backoff = new ExponentialBackoff(duration, duration2, duration3);
        Ref.IntRef attempt = new Ref.IntRef();
        while (true) {
            try {
                int n = attempt.element;
                attempt.element = n + 1;
                Object result = work.invoke();
                if (attempt.element > 1) {
                    RetryingTransacterKt.access$getLogger$p().info(() -> RetryingTransacter.retryWithWork$lambda$2(attempt));
                }
                if (outermostTransaction) {
                    this.inTransaction.set(false);
                }
                return (T)result;
            }
            catch (Exception e) {
                if (!RetryingTransacterKt.access$isRetryable(e) || !outermostTransaction) {
                    throw e;
                }
                if (attempt.element >= this.options.getMaxAttempts()) {
                    RetryingTransacterKt.access$getLogger$p().info(() -> RetryingTransacter.retryWithWork$lambda$3(attempt));
                    if (outermostTransaction) {
                        this.inTransaction.set(false);
                    }
                    throw e;
                }
                Duration sleepDuration = backoff.nextRetry();
                RetryingTransacterKt.access$getLogger$p().info((Throwable)e, () -> RetryingTransacter.retryWithWork$lambda$4(attempt, sleepDuration));
                if (sleepDuration.isZero()) continue;
                Thread.sleep(sleepDuration.toMillis());
                continue;
            }
            break;
        }
    }

    @JvmOverloads
    public RetryingTransacter(@NotNull Transacter delegate) {
        Intrinsics.checkNotNullParameter((Object)delegate, (String)"delegate");
        this(delegate, null, 2, null);
    }

    private static final Unit transaction$lambda$0(RetryingTransacter this$0, boolean $noEnclosing, Function1 $body) {
        this$0.delegate.transaction($noEnclosing, $body);
        return Unit.INSTANCE;
    }

    private static final Object transactionWithResult$lambda$1(RetryingTransacter this$0, boolean $noEnclosing, Function1 $bodyWithReturn) {
        return this$0.delegate.transactionWithResult($noEnclosing, $bodyWithReturn);
    }

    private static final Object retryWithWork$lambda$2(Ref.IntRef $attempt) {
        return "retried transaction succeeded (attempt " + $attempt.element + ")";
    }

    private static final Object retryWithWork$lambda$3(Ref.IntRef $attempt) {
        return "recoverable transaction exception (attempt " + $attempt.element + "), no more attempts";
    }

    private static final Object retryWithWork$lambda$4(Ref.IntRef $attempt, Duration $sleepDuration) {
        return "recoverable transaction exception (attempt " + $attempt.element + "), will retry after a " + $sleepDuration + " delay";
    }
}

