//[logging-interceptor](../../../index.md)/[okhttp3.logging](../index.md)/[LoggingEventListener](index.md)

# LoggingEventListener

[jvm]\
class [LoggingEventListener](index.md) : EventListener

An OkHttp EventListener, which logs call events. Can be applied as an event listener factory.

The format of the logs created by this class should not be considered stable and may change slightly between releases. If you need a stable logging format, use your own event listener.

## Types

| Name | Summary |
|---|---|
| [Factory](-factory/index.md) | [jvm]<br>open class [Factory](-factory/index.md)@[JvmOverloads](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.jvm/-jvm-overloads/index.html)constructor(logger: [HttpLoggingInterceptor.Logger](../-http-logging-interceptor/-logger/index.md)) : EventListener.Factory |

## Functions

| Name | Summary |
|---|---|
| [cacheConditionalHit](cache-conditional-hit.md) | [jvm]<br>open override fun [cacheConditionalHit](cache-conditional-hit.md)(call: Call, cachedResponse: Response) |
| [cacheHit](cache-hit.md) | [jvm]<br>open override fun [cacheHit](cache-hit.md)(call: Call, response: Response) |
| [cacheMiss](cache-miss.md) | [jvm]<br>open override fun [cacheMiss](cache-miss.md)(call: Call) |
| [callEnd](call-end.md) | [jvm]<br>open override fun [callEnd](call-end.md)(call: Call) |
| [callFailed](call-failed.md) | [jvm]<br>open override fun [callFailed](call-failed.md)(call: Call, ioe: [IOException](https://docs.oracle.com/javase/8/docs/api/java/io/IOException.html)) |
| [callStart](call-start.md) | [jvm]<br>open override fun [callStart](call-start.md)(call: Call) |
| [canceled](canceled.md) | [jvm]<br>open override fun [canceled](canceled.md)(call: Call) |
| [connectEnd](connect-end.md) | [jvm]<br>open override fun [connectEnd](connect-end.md)(call: Call, inetSocketAddress: [InetSocketAddress](https://docs.oracle.com/javase/8/docs/api/java/net/InetSocketAddress.html), proxy: [Proxy](https://docs.oracle.com/javase/8/docs/api/java/net/Proxy.html), protocol: Protocol?) |
| [connectFailed](connect-failed.md) | [jvm]<br>open override fun [connectFailed](connect-failed.md)(call: Call, inetSocketAddress: [InetSocketAddress](https://docs.oracle.com/javase/8/docs/api/java/net/InetSocketAddress.html), proxy: [Proxy](https://docs.oracle.com/javase/8/docs/api/java/net/Proxy.html), protocol: Protocol?, ioe: [IOException](https://docs.oracle.com/javase/8/docs/api/java/io/IOException.html)) |
| [connectionAcquired](connection-acquired.md) | [jvm]<br>open override fun [connectionAcquired](connection-acquired.md)(call: Call, connection: Connection) |
| [connectionReleased](connection-released.md) | [jvm]<br>open override fun [connectionReleased](connection-released.md)(call: Call, connection: Connection) |
| [connectStart](connect-start.md) | [jvm]<br>open override fun [connectStart](connect-start.md)(call: Call, inetSocketAddress: [InetSocketAddress](https://docs.oracle.com/javase/8/docs/api/java/net/InetSocketAddress.html), proxy: [Proxy](https://docs.oracle.com/javase/8/docs/api/java/net/Proxy.html)) |
| [dnsEnd](dns-end.md) | [jvm]<br>open override fun [dnsEnd](dns-end.md)(call: Call, domainName: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), inetAddressList: [List](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)&lt;[InetAddress](https://docs.oracle.com/javase/8/docs/api/java/net/InetAddress.html)&gt;) |
| [dnsStart](dns-start.md) | [jvm]<br>open override fun [dnsStart](dns-start.md)(call: Call, domainName: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)) |
| [proxySelectEnd](proxy-select-end.md) | [jvm]<br>open override fun [proxySelectEnd](proxy-select-end.md)(call: Call, url: HttpUrl, proxies: [List](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)&lt;[Proxy](https://docs.oracle.com/javase/8/docs/api/java/net/Proxy.html)&gt;) |
| [proxySelectStart](proxy-select-start.md) | [jvm]<br>open override fun [proxySelectStart](proxy-select-start.md)(call: Call, url: HttpUrl) |
| [requestBodyEnd](request-body-end.md) | [jvm]<br>open override fun [requestBodyEnd](request-body-end.md)(call: Call, byteCount: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)) |
| [requestBodyStart](request-body-start.md) | [jvm]<br>open override fun [requestBodyStart](request-body-start.md)(call: Call) |
| [requestFailed](request-failed.md) | [jvm]<br>open override fun [requestFailed](request-failed.md)(call: Call, ioe: [IOException](https://docs.oracle.com/javase/8/docs/api/java/io/IOException.html)) |
| [requestHeadersEnd](request-headers-end.md) | [jvm]<br>open override fun [requestHeadersEnd](request-headers-end.md)(call: Call, request: Request) |
| [requestHeadersStart](request-headers-start.md) | [jvm]<br>open override fun [requestHeadersStart](request-headers-start.md)(call: Call) |
| [responseBodyEnd](response-body-end.md) | [jvm]<br>open override fun [responseBodyEnd](response-body-end.md)(call: Call, byteCount: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)) |
| [responseBodyStart](response-body-start.md) | [jvm]<br>open override fun [responseBodyStart](response-body-start.md)(call: Call) |
| [responseFailed](response-failed.md) | [jvm]<br>open override fun [responseFailed](response-failed.md)(call: Call, ioe: [IOException](https://docs.oracle.com/javase/8/docs/api/java/io/IOException.html)) |
| [responseHeadersEnd](response-headers-end.md) | [jvm]<br>open override fun [responseHeadersEnd](response-headers-end.md)(call: Call, response: Response) |
| [responseHeadersStart](response-headers-start.md) | [jvm]<br>open override fun [responseHeadersStart](response-headers-start.md)(call: Call) |
| [satisfactionFailure](satisfaction-failure.md) | [jvm]<br>open override fun [satisfactionFailure](satisfaction-failure.md)(call: Call, response: Response) |
| [secureConnectEnd](secure-connect-end.md) | [jvm]<br>open override fun [secureConnectEnd](secure-connect-end.md)(call: Call, handshake: Handshake?) |
| [secureConnectStart](secure-connect-start.md) | [jvm]<br>open override fun [secureConnectStart](secure-connect-start.md)(call: Call) |
