//[okhttp](../../../../index.md)/[okhttp3](../../index.md)/[CacheControl](../index.md)/[Builder](index.md)

# Builder

[common]\
expect class [Builder](index.md)

Builds a Cache-Control request header.

[jvm, nonJvm]\
actual class [Builder](index.md)

## Constructors

| | |
|---|---|
| [Builder](-builder.md) | [common]<br>expect fun [Builder](-builder.md)() |

## Functions

| Name | Summary |
|---|---|
| [build](build.md) | [common, jvm, nonJvm]<br>[common]<br>expect fun [build](build.md)(): [CacheControl](../index.md)<br>[jvm, nonJvm]<br>actual fun [build](build.md)(): [CacheControl](../index.md) |
| [immutable](immutable.md) | [common, jvm, nonJvm]<br>[common]<br>expect fun [immutable](immutable.md)(): [CacheControl.Builder](index.md)<br>[jvm, nonJvm]<br>actual fun [immutable](immutable.md)(): [CacheControl.Builder](index.md) |
| [maxAge](max-age.md) | [jvm, common]<br>[jvm]<br>fun [maxAge](max-age.md)(maxAge: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html), timeUnit: [TimeUnit](https://docs.oracle.com/javase/8/docs/api/java/util/concurrent/TimeUnit.html)): [CacheControl.Builder](index.md)<br>[common]<br>expect fun [maxAge](max-age.md)(maxAge: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html), timeUnit: [DurationUnit](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.time/-duration-unit/index.html)): [CacheControl.Builder](index.md)<br>Sets the maximum age of a cached response. If the cache response's age exceeds [maxAge](max-age.md), it will not be used and a network request will be made.<br>[jvm]<br>actual fun [maxAge](max-age.md)(maxAge: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html), timeUnit: [DurationUnit](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.time/-duration-unit/index.html)): [CacheControl.Builder](index.md) |
| [maxStale](max-stale.md) | [jvm, common]<br>[jvm]<br>fun [maxStale](max-stale.md)(maxStale: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html), timeUnit: [TimeUnit](https://docs.oracle.com/javase/8/docs/api/java/util/concurrent/TimeUnit.html)): [CacheControl.Builder](index.md)<br>[common]<br>expect fun [maxStale](max-stale.md)(maxStale: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html), timeUnit: [DurationUnit](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.time/-duration-unit/index.html)): [CacheControl.Builder](index.md)<br>Accept cached responses that have exceeded their freshness lifetime by up to maxStale. If unspecified, stale cache responses will not be used.<br>[jvm]<br>actual fun [maxStale](max-stale.md)(maxStale: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html), timeUnit: [DurationUnit](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.time/-duration-unit/index.html)): [CacheControl.Builder](index.md) |
| [minFresh](min-fresh.md) | [jvm, common]<br>[jvm]<br>fun [minFresh](min-fresh.md)(minFresh: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html), timeUnit: [TimeUnit](https://docs.oracle.com/javase/8/docs/api/java/util/concurrent/TimeUnit.html)): [CacheControl.Builder](index.md)<br>[common]<br>expect fun [minFresh](min-fresh.md)(minFresh: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html), timeUnit: [DurationUnit](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.time/-duration-unit/index.html)): [CacheControl.Builder](index.md)<br>Sets the minimum number of seconds that a response will continue to be fresh for. If the response will be stale when [minFresh](min-fresh.md) have elapsed, the cached response will not be used and a network request will be made.<br>[jvm]<br>actual fun [minFresh](min-fresh.md)(minFresh: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html), timeUnit: [DurationUnit](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.time/-duration-unit/index.html)): [CacheControl.Builder](index.md) |
| [noCache](no-cache.md) | [common]<br>expect fun [noCache](no-cache.md)(): [CacheControl.Builder](index.md)<br>Don't accept an unvalidated cached response.<br>[jvm, nonJvm]<br>[jvm, nonJvm]<br>actual fun [noCache](no-cache.md)(): [CacheControl.Builder](index.md) |
| [noStore](no-store.md) | [common]<br>expect fun [noStore](no-store.md)(): [CacheControl.Builder](index.md)<br>Don't store the server's response in any cache.<br>[jvm, nonJvm]<br>[jvm, nonJvm]<br>actual fun [noStore](no-store.md)(): [CacheControl.Builder](index.md) |
| [noTransform](no-transform.md) | [common]<br>expect fun [noTransform](no-transform.md)(): [CacheControl.Builder](index.md)<br>Don't accept a transformed response.<br>[jvm, nonJvm]<br>[jvm, nonJvm]<br>actual fun [noTransform](no-transform.md)(): [CacheControl.Builder](index.md) |
| [onlyIfCached](only-if-cached.md) | [common]<br>expect fun [onlyIfCached](only-if-cached.md)(): [CacheControl.Builder](index.md)<br>Only accept the response if it is in the cache. If the response isn't cached, a 504 Unsatisfiable Request response will be returned.<br>[jvm, nonJvm]<br>[jvm, nonJvm]<br>actual fun [onlyIfCached](only-if-cached.md)(): [CacheControl.Builder](index.md) |
