//[okhttp](../../../../index.md)/[okhttp3](../../index.md)/[Cache](../index.md)/[Companion](index.md)

# Companion

[jvm]\
object [Companion](index.md)

## Functions

| Name | Summary |
|---|---|
| [hasVaryAll](has-vary-all.md) | [jvm]<br>fun [Response](../../-response/index.md).[hasVaryAll](has-vary-all.md)(): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)<br>Returns true if a Vary header contains an asterisk. Such responses cannot be cached. |
| [key](key.md) | [jvm]<br>@[JvmStatic](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.jvm/-jvm-static/index.html)<br>fun [key](key.md)(url: [HttpUrl](../../-http-url/index.md)): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html) |
| [varyHeaders](vary-headers.md) | [jvm]<br>fun [Response](../../-response/index.md).[varyHeaders](vary-headers.md)(): [Headers](../../-headers/index.md)<br>Returns the subset of the headers in this's request that impact the content of this's body. |
| [varyMatches](vary-matches.md) | [jvm]<br>fun [varyMatches](vary-matches.md)(cachedResponse: [Response](../../-response/index.md), cachedRequest: [Headers](../../-headers/index.md), newRequest: [Request](../../-request/index.md)): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)<br>Returns true if none of the Vary headers have changed between [cachedRequest](vary-matches.md) and [newRequest](vary-matches.md). |
