//[okhttp](../../../index.md)/[okhttp3](../index.md)/[HttpUrl](index.md)/[toUri](to-uri.md)

# toUri

[jvm]\

@[JvmName](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.jvm/-jvm-name/index.html)(name = "uri")

fun [toUri](to-uri.md)(): [URI](https://docs.oracle.com/javase/8/docs/api/java/net/URI.html)

Returns this URL as a [java.net.URI](https://docs.oracle.com/javase/8/docs/api/java/net/URI.html). Because URI is more strict than this class, the returned URI may be semantically different from this URL:

- 
   Characters forbidden by URI like [ and | will be escaped.
- 
   Invalid percent-encoded sequences like %xx will be encoded like %25xx.
- 
   Whitespace and control characters in the fragment will be stripped.

These differences may have a significant consequence when the URI is interpreted by a web server. For this reason the [URI class](https://docs.oracle.com/javase/8/docs/api/java/net/URI.html) and this method should be avoided.
