//[okhttp](../../../index.md)/[okhttp3](../index.md)/[RequestBody](index.md)

# RequestBody

[jvm]\
abstract class [RequestBody](index.md)

## Types

| Name | Summary |
|---|---|
| [Companion](-companion/index.md) | [jvm]<br>object [Companion](-companion/index.md) |

## Functions

| Name | Summary |
|---|---|
| [contentLength](content-length.md) | [jvm]<br>open fun [contentLength](content-length.md)(): [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)<br>Returns the number of bytes that will be written to sink in a call to [writeTo](write-to.md), or -1 if that count is unknown. |
| [contentType](content-type.md) | [jvm]<br>abstract fun [contentType](content-type.md)(): [MediaType](../-media-type/index.md)?<br>Returns the Content-Type header for this body. |
| [isDuplex](is-duplex.md) | [jvm]<br>open fun [isDuplex](is-duplex.md)(): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)<br>A duplex request body is special in how it is **transmitted** on the network and in the **API contract** between OkHttp and the application. |
| [isOneShot](is-one-shot.md) | [jvm]<br>open fun [isOneShot](is-one-shot.md)(): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)<br>Returns true if this body expects at most one call to [writeTo](write-to.md) and can be transmitted at most once. This is typically used when writing the request body is destructive and it is not possible to recreate the request body after it has been sent. |
| [writeTo](write-to.md) | [jvm]<br>abstract fun [writeTo](write-to.md)(sink: [BufferedSink](https://square.github.io/okio/2.x/okio/okio/-buffered-sink/index.html))<br>Writes the content of this request to [sink](write-to.md). |

## Inheritors

| Name |
|---|
| [FormBody](../-form-body/index.md) |
| [MultipartBody](../-multipart-body/index.md) |

## Extensions

| Name | Summary |
|---|---|
| [gzip](-companion/gzip.md) | [jvm]<br>@[JvmStatic](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.jvm/-jvm-static/index.html)<br>fun [RequestBody](index.md).[gzip](-companion/gzip.md)(): [RequestBody](index.md)<br>Returns a gzip version of the RequestBody, with compressed payload. This is not automatic as not all servers support gzip compressed requests. |
