//[okhttp](../../../../index.md)/[okhttp3](../../index.md)/[Request](../index.md)/[Builder](index.md)

# Builder

[jvm]\
open class [Builder](index.md)

## Constructors

| | |
|---|---|
| [Builder](-builder.md) | [jvm]<br>fun [Builder](-builder.md)() |

## Functions

| Name | Summary |
|---|---|
| [addHeader](add-header.md) | [jvm]<br>open fun [addHeader](add-header.md)(name: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), value: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)): [Request.Builder](index.md)<br>Adds a header with [name](add-header.md) and [value](add-header.md). Prefer this method for multiply-valued headers like "Cookie". |
| [build](build.md) | [jvm]<br>open fun [build](build.md)(): [Request](../index.md) |
| [cacheControl](cache-control.md) | [jvm]<br>open fun [cacheControl](cache-control.md)(cacheControl: [CacheControl](../../-cache-control/index.md)): [Request.Builder](index.md)<br>Sets this request's Cache-Control header, replacing any cache control headers already present. If [cacheControl](cache-control.md) doesn't define any directives, this clears this request's cache-control headers. |
| [delete](delete.md) | [jvm]<br>@[JvmOverloads](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.jvm/-jvm-overloads/index.html)<br>open fun [delete](delete.md)(body: [RequestBody](../../-request-body/index.md)? = EMPTY_REQUEST): [Request.Builder](index.md) |
| [get](get.md) | [jvm]<br>open fun [get](get.md)(): [Request.Builder](index.md) |
| [head](head.md) | [jvm]<br>open fun [head](head.md)(): [Request.Builder](index.md) |
| [header](header.md) | [jvm]<br>open fun [header](header.md)(name: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), value: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)): [Request.Builder](index.md)<br>Sets the header named [name](header.md) to [value](header.md). If this request already has any headers with that name, they are all replaced. |
| [headers](headers.md) | [jvm]<br>open fun [headers](headers.md)(headers: [Headers](../../-headers/index.md)): [Request.Builder](index.md)<br>Removes all headers on this builder and adds [headers](headers.md). |
| [method](method.md) | [jvm]<br>open fun [method](method.md)(method: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), body: [RequestBody](../../-request-body/index.md)?): [Request.Builder](index.md) |
| [patch](patch.md) | [jvm]<br>open fun [patch](patch.md)(body: [RequestBody](../../-request-body/index.md)): [Request.Builder](index.md) |
| [post](post.md) | [jvm]<br>open fun [post](post.md)(body: [RequestBody](../../-request-body/index.md)): [Request.Builder](index.md) |
| [put](put.md) | [jvm]<br>open fun [put](put.md)(body: [RequestBody](../../-request-body/index.md)): [Request.Builder](index.md) |
| [removeHeader](remove-header.md) | [jvm]<br>open fun [removeHeader](remove-header.md)(name: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)): [Request.Builder](index.md)<br>Removes all headers named [name](remove-header.md) on this builder. |
| [tag](tag.md) | [jvm]<br>open fun [tag](tag.md)(tag: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)?): [Request.Builder](index.md)<br>Attaches [tag](tag.md) to the request using Object.class as a key.<br>[jvm]<br>open fun &lt;[T](tag.md)&gt; [tag](tag.md)(type: [Class](https://docs.oracle.com/javase/8/docs/api/java/lang/Class.html)&lt;in [T](tag.md)&gt;, tag: [T](tag.md)?): [Request.Builder](index.md)<br>Attaches [tag](tag.md) to the request using [type](tag.md) as a key. Tags can be read from a request using [Request.tag](../tag.md). Use null to remove any existing tag assigned for [type](tag.md). |
| [url](url.md) | [jvm]<br>open fun [url](url.md)(url: [URL](https://docs.oracle.com/javase/8/docs/api/java/net/URL.html)): [Request.Builder](index.md)<br>open fun [url](url.md)(url: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)): [Request.Builder](index.md)<br>Sets the URL target of this request.<br>[jvm]<br>open fun [url](url.md)(url: [HttpUrl](../../-http-url/index.md)): [Request.Builder](index.md) |
