/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.otto.sample;

import android.content.Context;
import android.os.Bundle;
import android.support.v4.app.ListFragment;
import android.view.View;
import android.widget.ArrayAdapter;
import android.widget.ListAdapter;
import com.squareup.otto.Subscribe;
import com.squareup.otto.sample.BusProvider;
import com.squareup.otto.sample.LocationChangedEvent;
import com.squareup.otto.sample.LocationClearEvent;
import java.util.ArrayList;
import java.util.List;

public class LocationHistoryFragment
extends ListFragment {
    private final List<String> locationEvents = new ArrayList<String>();
    private ArrayAdapter<String> adapter;

    public void onResume() {
        super.onResume();
        BusProvider.getInstance().register((Object)this);
    }

    public void onPause() {
        super.onPause();
        BusProvider.getInstance().unregister((Object)this);
    }

    public void onViewCreated(View view, Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        this.adapter = new ArrayAdapter((Context)this.getActivity(), 17367043, this.locationEvents);
        this.setListAdapter((ListAdapter)this.adapter);
    }

    @Subscribe
    public void onLocationChanged(LocationChangedEvent event) {
        this.locationEvents.add(0, event.toString());
        if (this.adapter != null) {
            this.adapter.notifyDataSetChanged();
        }
    }

    @Subscribe
    public void onLocationCleared(LocationClearEvent event) {
        this.locationEvents.clear();
        if (this.adapter != null) {
            this.adapter.notifyDataSetChanged();
        }
    }
}

