/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.otto.sample;

import android.content.Context;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.os.AsyncTask;
import android.os.Bundle;
import android.support.v4.app.Fragment;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import com.squareup.otto.Subscribe;
import com.squareup.otto.sample.BusProvider;
import com.squareup.otto.sample.LocationChangedEvent;
import java.io.InputStream;
import java.net.URL;

public class LocationMapFragment
extends Fragment {
    private static final String URL = "https://maps.googleapis.com/maps/api/staticmap?sensor=false&size=400x400&zoom=13&center=%s,%s";
    private static DownloadTask downloadTask;
    private ImageView imageView;

    public void onResume() {
        super.onResume();
        BusProvider.getInstance().register((Object)this);
    }

    public void onPause() {
        super.onPause();
        BusProvider.getInstance().unregister((Object)this);
        if (downloadTask != null) {
            downloadTask.cancel(true);
            downloadTask = null;
        }
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        this.imageView = new ImageView((Context)this.getActivity());
        this.imageView.setScaleType(ImageView.ScaleType.CENTER_INSIDE);
        return this.imageView;
    }

    @Subscribe
    public void onLocationChanged(LocationChangedEvent event) {
        if (downloadTask != null) {
            downloadTask.cancel(true);
        }
        downloadTask = new DownloadTask();
        downloadTask.execute(new String[]{String.format(URL, Float.valueOf(event.lat), Float.valueOf(event.lon))});
    }

    @Subscribe
    public void onImageAvailable(ImageAvailableEvent event) {
        if (this.imageView != null) {
            this.imageView.setImageDrawable(event.image);
        }
    }

    private static class DownloadTask
    extends AsyncTask<String, Void, Drawable> {
        private DownloadTask() {
        }

        protected Drawable doInBackground(String ... params) {
            try {
                return BitmapDrawable.createFromStream((InputStream)new URL(params[0]).openStream(), (String)"bitmap.jpg");
            }
            catch (Exception e) {
                Log.e((String)"LocationMapFragment", (String)"Unable to download image.", (Throwable)e);
                return null;
            }
        }

        protected void onPostExecute(Drawable drawable2) {
            if (!this.isCancelled() && drawable2 != null) {
                BusProvider.getInstance().post((Object)new ImageAvailableEvent(drawable2));
            }
        }
    }

    private static class ImageAvailableEvent {
        public final Drawable image;

        ImageAvailableEvent(Drawable image) {
            this.image = image;
        }
    }
}

