[runtime](../../index.md) / [com.squareup.sqldelight.db](../index.md) / [SqlDriver](./index.md)

# SqlDriver

`interface SqlDriver : `[`Closeable`](../-closeable/index.md)

Maintains connections to an underlying SQL database and provides APIs for managing transactions
and executing SQL statements.

### Types

| Name | Summary |
|---|---|
| [Schema](-schema/index.md) | `interface Schema`<br>API for creating and migrating a SQL database. |

### Functions

| Name | Summary |
|---|---|
| [currentTransaction](current-transaction.md) | `abstract fun currentTransaction(): `[`Transacter.Transaction`](../../com.squareup.sqldelight/-transacter/-transaction/index.md)`?`<br>The currently open [Transacter.Transaction](../../com.squareup.sqldelight/-transacter/-transaction/index.md) on the database. |
| [execute](execute.md) | `abstract fun execute(identifier: `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)`?, sql: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`, parameters: `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)`, binders: (`[`SqlPreparedStatement`](../-sql-prepared-statement/index.md)`.() -> `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html)`)? = null): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html)<br>Execute a SQL statement. |
| [executeQuery](execute-query.md) | `abstract fun executeQuery(identifier: `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)`?, sql: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`, parameters: `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)`, binders: (`[`SqlPreparedStatement`](../-sql-prepared-statement/index.md)`.() -> `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html)`)? = null): `[`SqlCursor`](../-sql-cursor/index.md)<br>Execute a SQL statement and return a [SqlCursor](../-sql-cursor/index.md) that iterates the result set. |
| [newTransaction](new-transaction.md) | `abstract fun newTransaction(): `[`Transacter.Transaction`](../../com.squareup.sqldelight/-transacter/-transaction/index.md)<br>Start a new [Transacter.Transaction](../../com.squareup.sqldelight/-transacter/-transaction/index.md) on the database. |

### Inherited Functions

| Name | Summary |
|---|---|
| [close](../-closeable/close.md)<br>(js, native) | `abstract fun close(): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html)<br>Close any resources backed by this object. |

### Extension Functions

| Name | Summary |
|---|---|
| [use](../use.md)<br>(JVM, js, native) | `expect fun <T : `[`Closeable`](../-closeable/index.md)`?, R> `[`T`](../use.md#T)`.use(body: (`[`T`](../use.md#T)`) -> `[`R`](../use.md#R)`): `[`R`](../use.md#R)<br>Run [body](../use.md#com.squareup.sqldelight.db$use(com.squareup.sqldelight.db.use.T, kotlin.Function1((com.squareup.sqldelight.db.use.T, com.squareup.sqldelight.db.use.R)))/body) on [this](../use/-this-.md) and call [Closeable.close](../-closeable/close.md) before returning or throwing. |

### Inheritors

| Name | Summary |
|---|---|
| [LogSqliteDriver](../../com.squareup.sqldelight.logs/-log-sqlite-driver/index.md) | `class LogSqliteDriver : `[`SqlDriver`](./index.md) |
