[runtime](../../index.md) / [com.squareup.sqldelight](../index.md) / [Query](./index.md)

# Query

`abstract class Query<out RowType : `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`>`

A listenable, typed query generated by SQLDelight.

### Parameters

`RowType` - the type that this query can map its result set to.

### Types

| Name | Summary |
|---|---|
| [Listener](-listener/index.md) | `interface Listener`<br>An interface for listening to changes in the result set of a query. |

### Constructors

| Name | Summary |
|---|---|
| [&lt;init&gt;](-init-.md) | `Query(queries: `[`MutableList`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-mutable-list/index.html)`<`[`Query`](./index.md)`<*>>, mapper: (`[`SqlCursor`](../../com.squareup.sqldelight.db/-sql-cursor/index.md)`) -> `[`RowType`](index.md#RowType)`)`<br>A listenable, typed query generated by SQLDelight. |

### Properties

| Name | Summary |
|---|---|
| [mapper](mapper.md) | `val mapper: (`[`SqlCursor`](../../com.squareup.sqldelight.db/-sql-cursor/index.md)`) -> `[`RowType`](index.md#RowType)<br>The mapper this [Query](./index.md) was created with, which can convert a row in the SQL cursor returned by [execute](execute.md) to [RowType](index.md#RowType). |

### Functions

| Name | Summary |
|---|---|
| [addListener](add-listener.md) | `fun addListener(listener: `[`Query.Listener`](-listener/index.md)`): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html)<br>Register a listener to be notified of future changes in the result set. |
| [execute](execute.md) | `abstract fun execute(): `[`SqlCursor`](../../com.squareup.sqldelight.db/-sql-cursor/index.md)<br>Execute the underlying statement. |
| [executeAsList](execute-as-list.md) | `fun executeAsList(): `[`List`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)`<`[`RowType`](index.md#RowType)`>` |
| [executeAsOne](execute-as-one.md) | `fun executeAsOne(): `[`RowType`](index.md#RowType) |
| [executeAsOneOrNull](execute-as-one-or-null.md) | `fun executeAsOneOrNull(): `[`RowType`](index.md#RowType)`?` |
| [notifyDataChanged](notify-data-changed.md) | `fun notifyDataChanged(): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html)<br>Notify listeners that their current result set is staled. |
| [removeListener](remove-listener.md) | `fun removeListener(listener: `[`Query.Listener`](-listener/index.md)`): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html)<br>Remove a listener to no longer be notified of future changes in the result set. |
