[runtime](../../index.md) / [com.squareup.sqldelight.db](../index.md) / [SqlCursor](./index.md)

# SqlCursor

`interface SqlCursor : `[`Closeable`](../-closeable/index.md)

Represents a SQL result set which can be iterated through with [next](next.md). Initially the cursor will
not point to any row, and calling [next](next.md) once will iterate to the first row.

### Functions

| Name | Summary |
|---|---|
| [getBytes](get-bytes.md) | `abstract fun getBytes(index: `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)`): `[`ByteArray`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-byte-array/index.html)`?` |
| [getDouble](get-double.md) | `abstract fun getDouble(index: `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)`): `[`Double`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-double/index.html)`?` |
| [getLong](get-long.md) | `abstract fun getLong(index: `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)`): `[`Long`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)`?` |
| [getString](get-string.md) | `abstract fun getString(index: `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)`): `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`?` |
| [next](next.md) | `abstract fun next(): `[`Boolean`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)<br>Move to the next row in the result set. |

### Inherited Functions

| Name | Summary |
|---|---|
| [close](../-closeable/close.md)<br>(js, native) | `abstract fun close(): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html)<br>Close any resources backed by this object. |

### Extension Functions

| Name | Summary |
|---|---|
| [use](../use.md)<br>(JVM, js, native) | `expect fun <T : `[`Closeable`](../-closeable/index.md)`?, R> `[`T`](../use.md#T)`.use(body: (`[`T`](../use.md#T)`) -> `[`R`](../use.md#R)`): `[`R`](../use.md#R)<br>Run [body](../use.md#com.squareup.sqldelight.db$use(com.squareup.sqldelight.db.use.T, kotlin.Function1((com.squareup.sqldelight.db.use.T, com.squareup.sqldelight.db.use.R)))/body) on the receiver and call [Closeable.close](../-closeable/close.md) before returning or throwing. |
