[runtime](../../index.md) / [com.squareup.sqldelight](../index.md) / [Transacter](./index.md)

# Transacter

`interface Transacter`

A transaction-aware [SqlDriver](../../com.squareup.sqldelight.db/-sql-driver/index.md) wrapper which can begin a [Transaction](-transaction/index.md) on the current connection.

### Types

| Name | Summary |
|---|---|
| [Transaction](-transaction/index.md) | `abstract class Transaction : `[`TransactionCallbacks`](../-transaction-callbacks/index.md)<br>A SQL transaction. Can be created through the driver via [SqlDriver.newTransaction](../../com.squareup.sqldelight.db/-sql-driver/new-transaction.md) or through an implementation of [Transacter](./index.md) by calling [Transacter.transaction](transaction.md). |

### Functions

| Name | Summary |
|---|---|
| [transaction](transaction.md) | `abstract fun transaction(noEnclosing: `[`Boolean`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)` = false, body: `[`TransactionWithoutReturn`](../-transaction-without-return/index.md)`.() -> `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html)`): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html)<br>Starts a [Transaction](-transaction/index.md) and runs [body](transaction.md#com.squareup.sqldelight.Transacter$transaction(kotlin.Boolean, kotlin.Function1((com.squareup.sqldelight.TransactionWithoutReturn, kotlin.Unit)))/body) in that transaction. |
| [transactionWithResult](transaction-with-result.md) | `abstract fun <R> transactionWithResult(noEnclosing: `[`Boolean`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)` = false, bodyWithReturn: `[`TransactionWithReturn`](../-transaction-with-return/index.md)`<`[`R`](transaction-with-result.md#R)`>.() -> `[`R`](transaction-with-result.md#R)`): `[`R`](transaction-with-result.md#R)<br>Starts a [Transaction](-transaction/index.md) and runs [body](#) in that transaction. |

### Inheritors

| Name | Summary |
|---|---|
| [TransacterImpl](../-transacter-impl/index.md) | `abstract class TransacterImpl : `[`Transacter`](./index.md)<br>A transaction-aware [SqlDriver](../../com.squareup.sqldelight.db/-sql-driver/index.md) wrapper which can begin a [Transaction](-transaction/index.md) on the current connection. |
