[sqldelight-compiler](../../index.md) / [com.squareup.sqldelight.core.compiler.model](../index.md) / [BindableQuery](./index.md)

# BindableQuery

`abstract class BindableQuery`

### Constructors

| Name | Summary |
|---|---|
| [&lt;init&gt;](-init-.md) | `BindableQuery(identifier: PsiElement?, statement: PsiElement)` |

### Properties

| Name | Summary |
|---|---|
| [id](id.md) | `abstract val id: `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html) |

### Companion Object Properties

| Name | Summary |
|---|---|
| [queryIdMap](query-id-map.md) | `val queryIdMap: `[`ConcurrentHashMap`](https://docs.oracle.com/javase/6/docs/api/java/util/concurrent/ConcurrentHashMap.html)`<`[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`, `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)`>`<br>The query id map use to avoid string hashcode collision. Ideally this map should be per module. |

### Companion Object Functions

| Name | Summary |
|---|---|
| [getUniqueQueryIdentifier](get-unique-query-identifier.md) | `fun getUniqueQueryIdentifier(qualifiedQueryName: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`): `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)<br>Use the hashcode of qualifiedQueryName to generate the unique identifier id for queries. Detect the hashcode collision by caching the generated identifiers. Runtime exception will be thrown when collision happens. Client would need to give a different query name to avoid the collision. |

### Inheritors

| Name | Summary |
|---|---|
| [NamedExecute](../-named-execute/index.md) | `open class NamedExecute : `[`BindableQuery`](./index.md) |
| [NamedQuery](../-named-query/index.md) | `data class NamedQuery : `[`BindableQuery`](./index.md) |
