[sqldelight-compiler](../../index.md) / [com.squareup.sqldelight.core.compiler](../index.md) / [QueryGenerator](index.md) / [executeBlock](./execute-block.md)

# executeBlock

`protected fun executeBlock(): CodeBlock`

Creates the block of code that prepares [query](#) as a prepared statement and binds the
arguments to it. This code block does not make any use of class fields, and only populates a
single variable [STATEMENT_NAME](#)

val numberIndexes = createArguments(count = number.size)
val statement = database.prepareStatement("""
    |SELECT *
    |FROM player
    |WHERE number IN $numberIndexes
    """.trimMargin(), SqlPreparedStatement.Type.SELECT, 1 + (number.size - 1))
number.forEachIndexed { index, number -&gt;
    statement.bindLong(index + 2, number)
    }

