/*
 * Copyright (C) 2018 Square, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.squareup.sqldelight.db

/**
 * A type that can be closed.
 */
expect interface Closeable {
  /**
   * Close any resources backed by this object.
   */
  fun close()
}

/**
 * Run [body] on [this] and call [Closeable.close] before returning or throwing.
 */
expect inline fun <T : Closeable?, R> T.use(body: (T) -> R): R
