[runtime](../../../index.md) / [com.squareup.sqldelight](../../index.md) / [Transacter](../index.md) / [Transaction](./index.md)

# Transaction

`abstract class Transaction : `[`TransactionCallbacks`](../../-transaction-callbacks/index.md)

A SQL transaction. Can be created through the driver via [SqlDriver.newTransaction](../../../com.squareup.sqldelight.db/-sql-driver/new-transaction.md) or
through an implementation of [Transacter](../index.md) by calling [Transacter.transaction](../transaction.md).

### Constructors

| Name | Summary |
|---|---|
| [&lt;init&gt;](-init-.md) | `Transaction()`<br>A SQL transaction. Can be created through the driver via [SqlDriver.newTransaction](../../../com.squareup.sqldelight.db/-sql-driver/new-transaction.md) or through an implementation of [Transacter](../index.md) by calling [Transacter.transaction](../transaction.md). |

### Properties

| Name | Summary |
|---|---|
| [enclosingTransaction](enclosing-transaction.md) | `abstract val enclosingTransaction: `[`Transacter.Transaction`](./index.md)`?`<br>The parent transaction, if there is any. |

### Functions

| Name | Summary |
|---|---|
| [afterCommit](after-commit.md) | `open fun afterCommit(function: () -> `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html)`): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html)<br>Queues [function](after-commit.md#com.squareup.sqldelight.Transacter.Transaction$afterCommit(kotlin.Function0((kotlin.Unit)))/function) to be run after this transaction successfully commits. |
| [afterRollback](after-rollback.md) | `open fun afterRollback(function: () -> `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html)`): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html)<br>Queues [function](after-rollback.md#com.squareup.sqldelight.Transacter.Transaction$afterRollback(kotlin.Function0((kotlin.Unit)))/function) to be run after this transaction rolls back. |
| [endTransaction](end-transaction.md) | `abstract fun endTransaction(successful: `[`Boolean`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)`): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html)<br>Signal to the underlying SQL driver that this transaction should be finished. |
