/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.sqldelight.sqlite.driver;

import com.squareup.sqldelight.Transacter;
import com.squareup.sqldelight.db.SqlDatabaseConnection;
import com.squareup.sqldelight.db.SqlPreparedStatement;
import com.squareup.sqldelight.sqlite.driver.SqliteJdbcPreparedStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0015B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\b\u001a\u00020\tJ\u0018\u0010\n\u001a\u0012 \u000b*\b\u0018\u00010\u0007R\u00020\u00000\u0007R\u00020\u0000H\u0016J\f\u0010\f\u001a\u00060\u0007R\u00020\u0000H\u0016J \u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0005\u001a\f\u0012\b\u0012\u00060\u0007R\u00020\u00000\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/squareup/sqldelight/sqlite/driver/SqliteJdbcConnection;", "Lcom/squareup/sqldelight/db/SqlDatabaseConnection;", "sqliteConnection", "Ljava/sql/Connection;", "(Ljava/sql/Connection;)V", "transactions", "Ljava/lang/ThreadLocal;", "Lcom/squareup/sqldelight/sqlite/driver/SqliteJdbcConnection$Transaction;", "close", "", "currentTransaction", "kotlin.jvm.PlatformType", "newTransaction", "prepareStatement", "Lcom/squareup/sqldelight/sqlite/driver/SqliteJdbcPreparedStatement;", "sql", "", "type", "Lcom/squareup/sqldelight/db/SqlPreparedStatement$Type;", "parameters", "", "Transaction", "sqldelight-sqlite-driver"})
final class SqliteJdbcConnection
implements SqlDatabaseConnection {
    private final ThreadLocal<Transaction> transactions;
    private final Connection sqliteConnection;

    public final void close() {
        this.sqliteConnection.close();
    }

    @NotNull
    public SqliteJdbcPreparedStatement prepareStatement(@NotNull String sql, @NotNull SqlPreparedStatement.Type type, int parameters) {
        Intrinsics.checkParameterIsNotNull((Object)sql, (String)"sql");
        Intrinsics.checkParameterIsNotNull((Object)type, (String)"type");
        PreparedStatement preparedStatement = this.sqliteConnection.prepareStatement(sql);
        Intrinsics.checkExpressionValueIsNotNull((Object)preparedStatement, (String)"sqliteConnection.prepareStatement(sql)");
        return new SqliteJdbcPreparedStatement(preparedStatement);
    }

    @NotNull
    public Transaction newTransaction() {
        Transaction enclosing = this.transactions.get();
        Transaction transaction = new Transaction(enclosing);
        this.transactions.set(transaction);
        if (enclosing == null) {
            this.sqliteConnection.prepareStatement("BEGIN TRANSACTION").execute();
        }
        return transaction;
    }

    public Transaction currentTransaction() {
        return this.transactions.get();
    }

    public SqliteJdbcConnection(@NotNull Connection sqliteConnection) {
        Intrinsics.checkParameterIsNotNull((Object)sqliteConnection, (String)"sqliteConnection");
        this.sqliteConnection = sqliteConnection;
        this.transactions = new ThreadLocal();
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0018\u00010\u0000R\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0014R\u001a\u0010\u0002\u001a\b\u0018\u00010\u0000R\u00020\u0003X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000b"}, d2={"Lcom/squareup/sqldelight/sqlite/driver/SqliteJdbcConnection$Transaction;", "Lcom/squareup/sqldelight/Transacter$Transaction;", "enclosingTransaction", "Lcom/squareup/sqldelight/sqlite/driver/SqliteJdbcConnection;", "(Lcom/squareup/sqldelight/sqlite/driver/SqliteJdbcConnection;Lcom/squareup/sqldelight/sqlite/driver/SqliteJdbcConnection$Transaction;)V", "getEnclosingTransaction", "()Lcom/squareup/sqldelight/sqlite/driver/SqliteJdbcConnection$Transaction;", "endTransaction", "", "successful", "", "sqldelight-sqlite-driver"})
    private final class Transaction
    extends Transacter.Transaction {
        @Nullable
        private final Transaction enclosingTransaction;

        protected void endTransaction(boolean successful) {
            if (this.getEnclosingTransaction() == null) {
                if (successful) {
                    SqliteJdbcConnection.this.sqliteConnection.prepareStatement("END TRANSACTION").execute();
                } else {
                    SqliteJdbcConnection.this.sqliteConnection.prepareStatement("ROLLBACK TRANSACTION").execute();
                }
            }
            SqliteJdbcConnection.this.transactions.set(this.getEnclosingTransaction());
        }

        @Nullable
        protected Transaction getEnclosingTransaction() {
            return this.enclosingTransaction;
        }

        public Transaction(Transaction enclosingTransaction) {
            this.enclosingTransaction = enclosingTransaction;
        }
    }
}

