[trace-encoder](../../index.md) / [com.squareup.tracing](../index.md) / [TraceEncoder](index.md) / [&lt;init&gt;](./-init-.md)

# &lt;init&gt;

`TraceEncoder(scope: CoroutineScope, start: `[`ClockMark`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.time/-clock-mark/index.html)` = MonoClock.markNow(), ioDispatcher: CoroutineDispatcher = IO, sinkProvider: () -> BufferedSink)`

Encodes and writes [trace events](../-trace-event/index.md) to an Okio [BufferedSink](#).

### Parameters

`scope` - The [CoroutineScope](#) that defines the lifetime for the encoder. When the scope is
cancelled or fails, the sink returned from [sinkProvider](#) will be closed.

`start` - The [ClockMark](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.time/-clock-mark/index.html) to consider the beginning timestamp of the trace. All trace events'
timestamps are relative to this mark. [MonoClock](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.time/-mono-clock/index.html).[markNow](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.time/-abstract-long-clock/mark-now.html) by default.

`ioDispatcher` - The [CoroutineDispatcher](#) to use to execute all IO operations.
[IO](#) by default.

`sinkProvider` - Returns the [BufferedSink](#) to use to write trace events to. Called on a
background thread.