[trace-encoder](../../index.md) / [com.squareup.tracing](../index.md) / [TraceEncoder](./index.md)

# TraceEncoder

`class TraceEncoder : `[`Closeable`](https://docs.oracle.com/javase/8/docs/api/java/io/Closeable.html)

Encodes and writes [trace events](../-trace-event/index.md) to an Okio [BufferedSink](#).

### Parameters

`scope` - The [CoroutineScope](#) that defines the lifetime for the encoder. When the scope is
cancelled or fails, the sink returned from [sinkProvider](#) will be closed.

`start` - The [ClockMark](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.time/-clock-mark/index.html) to consider the beginning timestamp of the trace. All trace events'
timestamps are relative to this mark. [MonoClock](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.time/-mono-clock/index.html).[markNow](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.time/-abstract-long-clock/mark-now.html) by default.

`ioDispatcher` - The [CoroutineDispatcher](#) to use to execute all IO operations.
[IO](#) by default.

`sinkProvider` - Returns the [BufferedSink](#) to use to write trace events to. Called on a
background thread.

### Constructors

| Name | Summary |
|---|---|
| [&lt;init&gt;](-init-.md) | Encodes and writes [trace events](../-trace-event/index.md) to an Okio [BufferedSink](#).`TraceEncoder(scope: CoroutineScope, start: `[`ClockMark`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.time/-clock-mark/index.html)` = MonoClock.markNow(), ioDispatcher: CoroutineDispatcher = IO, sinkProvider: () -> BufferedSink)` |

### Functions

| Name | Summary |
|---|---|
| [close](close.md) | `fun close(): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html) |
| [createLogger](create-logger.md) | Allocates a new thread ID named [threadName](create-logger.md#com.squareup.tracing.TraceEncoder$createLogger(kotlin.String, kotlin.String)/threadName) and returns a [TraceLogger](../-trace-logger/index.md) that will log all events under that thread ID.`fun createLogger(processName: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)` = "", threadName: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)` = ""): `[`TraceLogger`](../-trace-logger/index.md) |
