[workflow-core](../../index.md) / [com.squareup.workflow](../index.md) / [RenderContext](./index.md)

# RenderContext

`interface RenderContext<StateT, in OutputT : `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`>`

Facilities for a [Workflow](../-workflow/index.md) to interact with other [Workflow](../-workflow/index.md)s and the outside world from inside
a `render` function.

## Handling events from the UI

While a workflow's rendering can represent whatever you need it to, it is common for the
rendering to contain the data for some part of your UI. In addition to shuttling data to the UI,
the rendering can also contain functions that the UI can call to send events to the workflow.

E.g.

```
data class Rendering(
  val radioButtonTexts: List<String>,
  val onSelected: (index: Int) -> Unit
)
```

To create populate such functions from your `render` method, you first need to define a
[WorkflowAction](../-workflow-action/index.md) to handle the event by changing state, emitting an output, or both. Then, just
pass a lambda to your rendering that instantiates the action and passes it to
[actionSink.send](../-sink/send.md).

## Performing asynchronous work

See [runningWorker](running-worker.md).

## Composing children

See [renderChild](render-child.md).

### Properties

| Name | Summary |
|---|---|
| [actionSink](action-sink.md) | Accepts a single [WorkflowAction](../-workflow-action/index.md), invokes that action by calling [WorkflowAction.apply](#) to update the current state, and optionally emits the returned output value if it is non-null.`abstract val actionSink: `[`Sink`](../-sink/index.md)`<`[`WorkflowAction`](../-workflow-action/index.md)`<StateT, OutputT>>` |

### Functions

| Name | Summary |
|---|---|
| [renderChild](render-child.md) | Ensures [child](render-child.md#com.squareup.workflow.RenderContext$renderChild(com.squareup.workflow.Workflow((com.squareup.workflow.RenderContext.renderChild.ChildPropsT, com.squareup.workflow.RenderContext.renderChild.ChildOutputT, com.squareup.workflow.RenderContext.renderChild.ChildRenderingT)), com.squareup.workflow.RenderContext.renderChild.ChildPropsT, kotlin.String, kotlin.Function1((com.squareup.workflow.RenderContext.renderChild.ChildOutputT, com.squareup.workflow.WorkflowAction((com.squareup.workflow.RenderContext.StateT, com.squareup.workflow.RenderContext.OutputT)))))/child) is running as a child of this workflow, and returns the result of its `render` method.`abstract fun <ChildPropsT, ChildOutputT : `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`, ChildRenderingT> renderChild(child: `[`Workflow`](../-workflow/index.md)`<ChildPropsT, ChildOutputT, ChildRenderingT>, props: ChildPropsT, key: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)` = "", handler: (ChildOutputT) -> `[`WorkflowAction`](../-workflow-action/index.md)`<StateT, OutputT>): ChildRenderingT` |
| [runningWorker](running-worker.md) | Ensures [worker](running-worker.md#com.squareup.workflow.RenderContext$runningWorker(com.squareup.workflow.Worker((com.squareup.workflow.RenderContext.runningWorker.T)), kotlin.String, kotlin.Function1((com.squareup.workflow.RenderContext.runningWorker.T, com.squareup.workflow.WorkflowAction((com.squareup.workflow.RenderContext.StateT, com.squareup.workflow.RenderContext.OutputT)))))/worker) is running. When the [Worker](../-worker/index.md) emits an output, [handler](running-worker.md#com.squareup.workflow.RenderContext$runningWorker(com.squareup.workflow.Worker((com.squareup.workflow.RenderContext.runningWorker.T)), kotlin.String, kotlin.Function1((com.squareup.workflow.RenderContext.runningWorker.T, com.squareup.workflow.WorkflowAction((com.squareup.workflow.RenderContext.StateT, com.squareup.workflow.RenderContext.OutputT)))))/handler) is called to determine the [WorkflowAction](../-workflow-action/index.md) to take. When the worker finishes, nothing happens (although another render pass may be triggered).`abstract fun <T> runningWorker(worker: `[`Worker`](../-worker/index.md)`<T>, key: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)` = "", handler: (T) -> `[`WorkflowAction`](../-workflow-action/index.md)`<StateT, OutputT>): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html) |

### Extension Functions

| Name | Summary |
|---|---|
| [makeEventSink](../make-event-sink.md) | Alternative to [RenderContext.actionSink](action-sink.md) that allows externally defined event types to be mapped to anonymous [WorkflowAction](../-workflow-action/index.md)s.`fun <EventT, StateT, OutputT : `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`> `[`RenderContext`](./index.md)`<StateT, OutputT>.makeEventSink(update: Updater<StateT, OutputT>.(EventT) -> `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html)`): `[`Sink`](../-sink/index.md)`<EventT>` |
| [renderChild](../render-child.md) | Convenience alias of [RenderContext.renderChild](render-child.md) for workflows that don't take props.`fun <StateT, OutputT : `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`, ChildOutputT : `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`, ChildRenderingT> `[`RenderContext`](./index.md)`<StateT, OutputT>.renderChild(child: `[`Workflow`](../-workflow/index.md)`<`[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html)`, ChildOutputT, ChildRenderingT>, key: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)` = "", handler: (ChildOutputT) -> `[`WorkflowAction`](../-workflow-action/index.md)`<StateT, OutputT>): ChildRenderingT`<br>Convenience alias of [RenderContext.renderChild](render-child.md) for workflows that don't take props or emit output.`fun <PropsT, StateT, OutputT : `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`, ChildRenderingT> `[`RenderContext`](./index.md)`<StateT, OutputT>.renderChild(child: `[`Workflow`](../-workflow/index.md)`<PropsT, `[`Nothing`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-nothing/index.html)`, ChildRenderingT>, props: PropsT, key: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)` = ""): ChildRenderingT`<br>`fun <StateT, OutputT : `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`, ChildRenderingT> `[`RenderContext`](./index.md)`<StateT, OutputT>.renderChild(child: `[`Workflow`](../-workflow/index.md)`<`[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html)`, `[`Nothing`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-nothing/index.html)`, ChildRenderingT>, key: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)` = ""): ChildRenderingT` |
| [runningWorker](../running-worker.md) | Ensures a [Worker](../-worker/index.md) that never emits anything is running. Since [worker](../running-worker.md#com.squareup.workflow$runningWorker(com.squareup.workflow.RenderContext((com.squareup.workflow.runningWorker.StateT, com.squareup.workflow.runningWorker.OutputT)), com.squareup.workflow.Worker((kotlin.Nothing)), kotlin.String)/worker) can't emit anything, it can't trigger any [WorkflowAction](../-workflow-action/index.md)s.`fun <StateT, OutputT : `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`> `[`RenderContext`](./index.md)`<StateT, OutputT>.runningWorker(worker: `[`Worker`](../-worker/index.md)`<`[`Nothing`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-nothing/index.html)`>, key: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)` = ""): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html) |
