[workflow-core](../../index.md) / [com.squareup.workflow](../index.md) / [StatefulWorkflow](./index.md)

# StatefulWorkflow

`abstract class StatefulWorkflow<in PropsT, StateT, out OutputT : `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`, out RenderingT> : `[`Workflow`](../-workflow/index.md)`<PropsT, OutputT, RenderingT>`

A composable, stateful object that can [handle events](../-render-context/action-sink.md),
[delegate to children](../-render-context/render-child.md), [subscribe](../-render-context/running-worker.md) to
arbitrary asynchronous events from the outside world, and be [saved](snapshot-state.md) to a
serialized form to be restored later.

The basic purpose of a `Workflow` is to take some [props](index.md#PropsT) and return a
[rendering](index.md#RenderingT) that serves as a public representation of its current state,
and which can be used to update that state. A rendering typically serves as a view  model,
though this is not assumed, and is not the only use case.

To that end, a workflow may keep track of internal [state](index.md#StateT),
recursively ask other workflows to render themselves, subscribe to data streams from the outside
world, and handle events both from its [renderings](../-render-context/action-sink.md) and from
workflows it's delegated to (its "children"). A `Workflow` may also emit
[output events](index.md#OutputT) up to its parent `Workflow`.

Workflows form a tree, where each workflow can have zero or more child workflows. Child workflows
are started as necessary whenever another workflow asks for them, and are cleaned up automatically
when they're no longer needed. [Props](index.md#PropsT) propagate down the tree, [outputs](index.md#OutputT) and
[renderings](index.md#RenderingT) propagate up the tree.

### Parameters

`PropsT` - Typically a data class that is used to pass configuration information or bits of
state that the workflow can always get from its parent and needn't duplicate in its own state.
May be [Unit](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html) if the workflow does not need any props data.

`StateT` - Typically a data class that contains all of the internal state for this workflow.
The state is seeded via [props](index.md#PropsT) in [initialState](initial-state.md). It can be [serialized](snapshot-state.md)
and later used to restore the workflow. **Implementations of the `Workflow`interface should not generally contain their own state directly.** They may inject objects like
instances of their child workflows, or network clients, but should not contain directly mutable
state. This is the only type parameter that a parent workflow needn't care about for its children,
and may just use star (`*`) instead of specifying it. May be [Unit](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html) if the workflow does not have
any internal state (see [StatelessWorkflow](../-stateless-workflow/index.md)).

`OutputT` - Typically a sealed class that represents "events" that this workflow can send
to its parent.
May be [Nothing](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-nothing/index.html) if the workflow doesn't need to emit anything.

`RenderingT` - The value returned to this workflow's parent during [composition](render.md).
Typically represents a "view" of this workflow's props, current state, and children's renderings.
A workflow that represents a UI component may use a view model as its rendering type.

**See Also**

[StatelessWorkflow](../-stateless-workflow/index.md)

### Constructors

| Name | Summary |
|---|---|
| [&lt;init&gt;](-init-.md) | A composable, stateful object that can [handle events](../-render-context/action-sink.md), [delegate to children](../-render-context/render-child.md), [subscribe](../-render-context/running-worker.md) to arbitrary asynchronous events from the outside world, and be [saved](snapshot-state.md) to a serialized form to be restored later.`StatefulWorkflow()` |

### Functions

| Name | Summary |
|---|---|
| [asStatefulWorkflow](as-stateful-workflow.md) | Satisfies the [Workflow](../-workflow/index.md) interface by returning `this`.`fun asStatefulWorkflow(): `[`StatefulWorkflow`](./index.md)`<PropsT, StateT, OutputT, RenderingT>` |
| [initialState](initial-state.md) | Called from [RenderContext.renderChild](../-render-context/render-child.md) when the state machine is first started, to get the initial state.`abstract fun initialState(props: PropsT, snapshot: `[`Snapshot`](../-snapshot/index.md)`?): StateT` |
| [onPropsChanged](on-props-changed.md) | Called from [RenderContext.renderChild](../-render-context/render-child.md) instead of [initialState](initial-state.md) when the workflow is already running. This allows the workflow to detect changes in props, and possibly change its state in response. This method is called eagerly: `old` and `new` might be the same value, so it is up to implementing code to perform any diffing if desired.`open fun onPropsChanged(old: PropsT, new: PropsT, state: StateT): StateT` |
| [render](render.md) | Called at least once† any time one of the following things happens:`abstract fun render(props: PropsT, state: StateT, context: `[`RenderContext`](../-render-context/index.md)`<StateT, OutputT>): RenderingT` |
| [snapshotState](snapshot-state.md) | Called whenever the state changes to generate a new [Snapshot](../-snapshot/index.md) of the state.`abstract fun snapshotState(state: StateT): `[`Snapshot`](../-snapshot/index.md) |

### Extension Functions

| Name | Summary |
|---|---|
| [action](../action.md) | Convenience to create a [WorkflowAction](../-workflow-action/index.md) with parameter types matching those of the receiving [StatefulWorkflow](./index.md). The action will invoke the given [lambda](../action.md#com.squareup.workflow$action(com.squareup.workflow.StatefulWorkflow((com.squareup.workflow.action.PropsT, com.squareup.workflow.action.StateT, com.squareup.workflow.action.OutputT, com.squareup.workflow.action.RenderingT)), kotlin.String, kotlin.Function1((com.squareup.workflow.WorkflowAction.Updater((com.squareup.workflow.action.StateT, com.squareup.workflow.action.OutputT)), kotlin.Unit)))/update) when it is [applied](#).`fun <PropsT, StateT, OutputT : `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`, RenderingT> `[`StatefulWorkflow`](./index.md)`<PropsT, StateT, OutputT, RenderingT>.action(name: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)` = "", update: Updater<StateT, OutputT>.() -> `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html)`): `[`WorkflowAction`](../-workflow-action/index.md)`<StateT, OutputT>`<br>`fun <PropsT, StateT, OutputT : `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`, RenderingT> `[`StatefulWorkflow`](./index.md)`<PropsT, StateT, OutputT, RenderingT>.action(name: () -> `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`, update: Updater<StateT, OutputT>.() -> `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html)`): `[`WorkflowAction`](../-workflow-action/index.md)`<StateT, OutputT>` |
| [mapRendering](../map-rendering.md) | Uses the given [function](../map-rendering.md#com.squareup.workflow$mapRendering(com.squareup.workflow.Workflow((com.squareup.workflow.mapRendering.PropsT, com.squareup.workflow.mapRendering.OutputT, com.squareup.workflow.mapRendering.FromRenderingT)), kotlin.Function1((com.squareup.workflow.mapRendering.FromRenderingT, com.squareup.workflow.mapRendering.ToRenderingT)))/transform) to transform a [Workflow](../-workflow/index.md) that renders [FromRenderingT](../map-rendering.md#FromRenderingT) to one renders [ToRenderingT](../map-rendering.md#ToRenderingT),`fun <PropsT, OutputT : `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`, FromRenderingT, ToRenderingT> `[`Workflow`](../-workflow/index.md)`<PropsT, OutputT, FromRenderingT>.mapRendering(transform: (FromRenderingT) -> ToRenderingT): `[`Workflow`](../-workflow/index.md)`<PropsT, OutputT, ToRenderingT>` |
