[workflow-core](../../index.md) / [com.squareup.workflow](../index.md) / [StatefulWorkflow](index.md) / [initialState](./initial-state.md)

# initialState

`abstract fun initialState(props: PropsT, snapshot: `[`Snapshot`](../-snapshot/index.md)`?): StateT`

Called from [RenderContext.renderChild](../-render-context/render-child.md) when the state machine is first started, to get the
initial state.

### Parameters

`snapshot` - If the workflow is being created fresh, OR the workflow is being restored from an empty
[Snapshot](../-snapshot/index.md), [snapshot](initial-state.md#com.squareup.workflow.StatefulWorkflow$initialState(com.squareup.workflow.StatefulWorkflow.PropsT, com.squareup.workflow.Snapshot)/snapshot) will be null. A snapshot is considered "empty" if [Snapshot.bytes](../-snapshot/bytes.md)
returns an empty `ByteString`, probably because [snapshotState](snapshot-state.md) returned [Snapshot.EMPTY](../-snapshot/-e-m-p-t-y.md).
If the workflow is being restored from a [Snapshot](../-snapshot/index.md), [snapshot](initial-state.md#com.squareup.workflow.StatefulWorkflow$initialState(com.squareup.workflow.StatefulWorkflow.PropsT, com.squareup.workflow.Snapshot)/snapshot) will be the last value
returned from [snapshotState](snapshot-state.md), and implementations that return something other than
[Snapshot.EMPTY](../-snapshot/-e-m-p-t-y.md) should create their initial state by parsing their snapshot.